/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.standalone;

import com.baselet.control.Main;
import com.baselet.generator.ClassDiagramConverter;
import com.baselet.gui.standalone.FileDrop;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FileDropListener
implements FileDrop.Listener {
    private static final Logger log = Logger.getLogger(FileDropListener.class);

    @Override
    public void filesDropped(File[] files) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                String filename = file.getCanonicalPath();
                if (this.isJavaFile(filename)) {
                    new ClassDiagramConverter().createClassDiagram(filename);
                } else {
                    Main.getInstance().doOpen(filename);
                }
            }
            catch (IOException e) {
                log.error((Object)"Cannot open file dropped");
            }
            ++n2;
        }
    }

    private boolean isJavaFile(String filename) {
        int dotPosition = filename.lastIndexOf(".");
        String extension = filename.substring(dotPosition + 1, filename.length());
        return extension.equals("class") || extension.equals("java");
    }
}

