/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.plugin.gui;

import com.baselet.control.Main;
import com.baselet.control.enums.Program;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.DrawPanel;
import com.baselet.diagram.PaletteHandler;
import com.baselet.element.old.custom.CustomElementHandler;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.pane.OwnSyntaxPane;
import com.baselet.plugin.gui.EclipseGUI;
import com.baselet.plugin.gui.EclipseGUIBuilder;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Panel;
import java.io.File;
import java.util.UUID;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.EditorPart;

public class Editor
extends EditorPart {
    private static final Logger log = Logger.getLogger(Editor.class);
    private DiagramHandler handler;
    private Panel embeddedPanel;
    private final EclipseGUIBuilder guiComponents = new EclipseGUIBuilder();
    private final UUID uuid = UUID.randomUUID();
    File diagramFile;
    private Frame mainFrame;

    public void doSave(IProgressMonitor monitor) {
        this.handler.doSave();
        monitor.done();
    }

    public void doSaveAs() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Editor.this.handler.doSaveAs(Program.getInstance().getExtension());
            }
        });
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        log.info((Object)("Call editor.init() " + this.uuid.toString()));
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.diagramFile = this.getFile(input);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Editor.this.embeddedPanel = Editor.this.guiComponents.initEclipseGui();
                }
            });
        }
        catch (Exception e) {
            throw new PartInitException("Create DiagramHandler interrupted", (Throwable)e);
        }
    }

    private File getFile(IEditorInput input) throws PartInitException {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getLocation().toFile();
        }
        if (input instanceof FileStoreEditorInput) {
            return new File(((FileStoreEditorInput)input).getURI());
        }
        throw new PartInitException("Editor input not supported.");
    }

    public boolean isDirty() {
        return this.handler.isChanged();
    }

    public void createPartControl(Composite parent) {
        this.getGui().setCurrentEditor(this);
        this.handler = new DiagramHandler(this.diagramFile);
        this.getGui().registerEditorForDiagramHandler(this, this.handler);
        this.getGui().setCurrentDiagramHandler(this.handler);
        this.getGui().open(this.handler);
        log.info((Object)("Call editor.createPartControl() " + this.uuid.toString()));
        this.mainFrame = SWT_AWT.new_Frame((Composite)new Composite(parent, 0x1000000));
        this.mainFrame.add(this.embeddedPanel);
    }

    private EclipseGUI getGui() {
        return (EclipseGUI)CurrentGui.getInstance().getGui();
    }

    public void setFocus() {
        log.info((Object)("Call editor.setFocus() " + this.uuid.toString()));
        this.getGui().setCurrentEditor(this);
        this.getGui().setCurrentDiagramHandler(this.handler);
        if (this.handler != null) {
            this.handler.getDrawPanel().getSelector().updateSelectorInformation();
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (Editor.this.guiComponents.getPalettePanel().getComponentCount() == 0) {
                    for (PaletteHandler palette : Main.getInstance().getPalettes().values()) {
                        Editor.this.guiComponents.getPalettePanel().add((Component)palette.getDrawPanel().getScrollPane(), palette.getName());
                        palette.getDrawPanel().getScrollPane().invalidate();
                    }
                }
                Editor.this.showPalette(Editor.this.getSelectedPaletteName());
                Editor.this.getGui().setValueOfZoomDisplay(Editor.this.handler.getGridSize());
                Editor.this.guiComponents.getPropertyTextPane().invalidate();
            }
        });
    }

    public DrawPanel getDiagram() {
        if (this.handler == null) {
            return null;
        }
        return this.handler.getDrawPanel();
    }

    public void dispose() {
        super.dispose();
        log.info((Object)("Call editor.dispose( )" + this.uuid.toString()));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Editor.this.guiComponents.getMailPanel().isVisible()) {
                    Editor.this.guiComponents.getMailPanel().closePanel();
                }
                Editor.this.getGui().editorRemoved(Editor.this);
            }
        });
    }

    public void setCursor(Cursor cursor) {
        this.embeddedPanel.setCursor(cursor);
    }

    public OwnSyntaxPane getPropertyPane() {
        return this.guiComponents.getPropertyTextPane();
    }

    public JTextComponent getCustomPane() {
        return this.guiComponents.getCustomPanel().getTextPane();
    }

    public void requestFocus() {
        this.embeddedPanel.requestFocus();
    }

    public Frame getMainFrame() {
        return this.mainFrame;
    }

    public void dirtyChanged() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Editor.this.firePropertyChange(257);
            }
        });
    }

    public void diagramNameChanged() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Editor.this.firePropertyChange(1);
            }
        });
    }

    public CustomElementHandler getCustomElementHandler() {
        return this.guiComponents.getCustomHandler();
    }

    public void setMailPanelEnabled(boolean enable) {
        this.guiComponents.setMailPanelEnabled(enable);
    }

    public boolean isMailPanelVisible() {
        return this.guiComponents.getMailPanel().isVisible();
    }

    public String getSelectedPaletteName() {
        return this.guiComponents.getPaletteList().getSelectedItem().toString();
    }

    public int getMainSplitLocation() {
        return this.guiComponents.getMainSplit().getDividerLocation();
    }

    public int getRightSplitLocation() {
        return this.guiComponents.getRightSplit().getDividerLocation();
    }

    public int getMailSplitLocation() {
        return this.guiComponents.getMailSplit().getDividerLocation();
    }

    public void showPalette(String paletteName) {
        this.guiComponents.setPaletteActive(paletteName);
    }

    public void setCustomPanelEnabled(boolean enable) {
        this.guiComponents.setCustomPanelEnabled(enable);
        this.setDrawPanelEnabled(!enable);
    }

    private void setDrawPanelEnabled(boolean enable) {
        this.handler.getDrawPanel().getScrollPane().setEnabled(enable);
    }

    public void focusPropertyPane() {
        this.guiComponents.getPropertyTextPane().getTextComponent().requestFocus();
    }

    public void open(final DiagramHandler handler) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Editor.this.guiComponents.setContent(handler.getDrawPanel().getScrollPane());
            }
        });
    }
}

