/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPOutputStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.zaproxy.zap.extension.api.ApiResponseConversionUtils;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.network.HttpRequestBody;
import org.zaproxy.zap.network.HttpResponseBody;

@RunWith(value=MockitoJUnitRunner.class)
public class ApiResponseConversionUtilsUnitTest {
    @Mock
    HttpMessage message;
    @Mock
    HttpRequestHeader requestHeader;
    @Mock
    HttpRequestBody requestBody;
    @Mock
    HttpResponseHeader responseHeader;
    @Mock
    HttpResponseBody responseBody;

    @Before
    public void prepareMessage() {
        BDDMockito.given((Object)this.message.getRequestHeader()).willReturn((Object)this.requestHeader);
        BDDMockito.given((Object)this.message.getRequestBody()).willReturn((Object)this.requestBody);
        BDDMockito.given((Object)this.message.getResponseHeader()).willReturn((Object)this.responseHeader);
        BDDMockito.given((Object)this.message.getResponseBody()).willReturn((Object)this.responseBody);
    }

    @Test
    public void nameOfApiResponseShouldBeConstant() {
        ApiResponseSet apiResponseSet = ApiResponseConversionUtils.httpMessageToSet(0, this.message);
        Assert.assertThat((Object)apiResponseSet.getName(), (Matcher)Matchers.is((Object)"message"));
    }

    @Test
    public void historyIdShouldBecomeIdOfApiResponse() {
        ApiResponseSet apiResponseSet = ApiResponseConversionUtils.httpMessageToSet(42, this.message);
        Assert.assertThat(apiResponseSet.getValues(), (Matcher)Matchers.hasEntry((Object)"id", (Object)"42"));
    }

    @Test
    public void propertiesFromGivenHttpMessageShouldReflectInApiResponse() {
        BDDMockito.given((Object)this.message.getCookieParamsAsString()).willReturn((Object)"testCookieParams");
        BDDMockito.given((Object)this.message.getNote()).willReturn((Object)"testNote");
        BDDMockito.given((Object)this.requestHeader.toString()).willReturn((Object)"testRequestHeader");
        BDDMockito.given((Object)this.requestBody.toString()).willReturn((Object)"testRequestBody");
        BDDMockito.given((Object)this.responseHeader.toString()).willReturn((Object)"testResponseHeader");
        ApiResponseSet apiResponseSet = ApiResponseConversionUtils.httpMessageToSet(0, this.message);
        Assert.assertThat(apiResponseSet.getValues(), (Matcher)Matchers.hasEntry((Object)"cookieParams", (Object)"testCookieParams"));
        Assert.assertThat(apiResponseSet.getValues(), (Matcher)Matchers.hasEntry((Object)"note", (Object)"testNote"));
        Assert.assertThat(apiResponseSet.getValues(), (Matcher)Matchers.hasEntry((Object)"requestHeader", (Object)this.requestHeader.toString()));
        Assert.assertThat(apiResponseSet.getValues(), (Matcher)Matchers.hasEntry((Object)"requestBody", (Object)this.requestBody.toString()));
        Assert.assertThat(apiResponseSet.getValues(), (Matcher)Matchers.hasEntry((Object)"responseHeader", (Object)this.responseHeader.toString()));
    }

    @Test
    public void compressedResponseBodyShouldBeDeflatedIntoApiResponse() throws Exception {
        BDDMockito.given((Object)this.responseHeader.getHeader("Content-Encoding")).willReturn((Object)"gzip");
        BDDMockito.given((Object)this.responseBody.getBytes()).willReturn((Object)this.gzip(new byte[]{97, 98, 99}));
        ApiResponseSet apiResponseSet = ApiResponseConversionUtils.httpMessageToSet(0, this.message);
        Assert.assertThat(apiResponseSet.getValues(), (Matcher)Matchers.hasEntry((Object)"responseBody", (Object)"abc"));
    }

    @Test
    public void brokenCompressedResponseBodyShouldBeStoredAsStringRepresentationInApiResponse() {
        BDDMockito.given((Object)this.responseHeader.getHeader("Content-Encoding")).willReturn((Object)"gzip");
        BDDMockito.given((Object)this.responseBody.getBytes()).willReturn((Object)new byte[]{0, 0, 0});
        ApiResponseSet apiResponseSet = ApiResponseConversionUtils.httpMessageToSet(0, this.message);
        Assert.assertThat(apiResponseSet.getValues(), (Matcher)Matchers.hasEntry((Object)"responseBody", (Object)this.responseBody.toString()));
    }

    private byte[] gzip(byte[] byArray) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray);
        gZIPOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

