/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiGeneratorUtils;
import org.zaproxy.zap.extension.api.ApiImplementor;

public class PythonAPIGenerator {
    private File dir;
    private boolean optional = false;
    private final String HEADER = "# Zed Attack Proxy (ZAP) and its related class files.\n#\n# ZAP is an HTTP/HTTPS proxy for assessing web application security.\n#\n# Copyright 2015 the ZAP development team\n#\n# Licensed under the Apache License, Version 2.0 (the \"License\");\n# you may not use this file except in compliance with the License.\n# You may obtain a copy of the License at\n#\n#   http://www.apache.org/licenses/LICENSE-2.0\n#\n# Unless required by applicable law or agreed to in writing, software\n# distributed under the License is distributed on an \"AS IS\" BASIS,\n# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n# See the License for the specific language governing permissions and\n# limitations under the License.\n\"\"\"\nThis file was automatically generated.\n\"\"\"\n\n";
    private final String OPTIONAL_MASSAGE = "This component is optional and therefore the API will only work if it is installed";
    private ResourceBundle msgs = ResourceBundle.getBundle("lang.Messages", Locale.ENGLISH, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));
    private static final Map<String, String> nameMap;

    public PythonAPIGenerator() {
        this.dir = new File("python/api/src/zapv2");
    }

    public PythonAPIGenerator(String string, boolean bl) {
        this.dir = new File(string);
        this.optional = bl;
    }

    public void generatePythonFiles(List<ApiImplementor> list) throws IOException {
        for (ApiImplementor apiImplementor : list) {
            this.generatePythonComponent(apiImplementor);
        }
    }

    private void generatePythonElement(ApiElement apiElement, String string, String string2, Writer writer) throws IOException {
        String string32;
        boolean bl;
        block30: {
            boolean bl2 = bl = apiElement.getMandatoryParamNames() != null && apiElement.getMandatoryParamNames().size() > 0 || apiElement.getOptionalParamNames() != null && apiElement.getOptionalParamNames().size() > 0;
            if (!bl && string2.equals("view")) {
                writer.write("    @property\n");
            }
            writer.write("    def " + PythonAPIGenerator.createFunctionName(apiElement.getName()) + "(self");
            if (apiElement.getMandatoryParamNames() != null) {
                for (String string32 : apiElement.getMandatoryParamNames()) {
                    writer.write(", " + string32.toLowerCase());
                }
            }
            if (apiElement.getOptionalParamNames() != null) {
                for (String string32 : apiElement.getOptionalParamNames()) {
                    writer.write(", " + string32.toLowerCase() + "=''");
                }
            }
            if (string2.equals("action") || string2.equals("other")) {
                writer.write(", " + API.API_KEY_PARAM + "=''");
                bl = true;
            }
            writer.write("):\n");
            Object object = apiElement.getDescriptionTag();
            if (object == null) {
                object = string + ".api." + string2 + "." + apiElement.getName();
            }
            try {
                string32 = this.msgs.getString((String)object);
                writer.write("        \"\"\"\n");
                writer.write("        " + string32 + "\n");
                if (this.optional) {
                    writer.write("        This component is optional and therefore the API will only work if it is installed\n");
                }
                writer.write("        \"\"\"\n");
            }
            catch (Exception exception) {
                System.out.println("No i18n for: " + (String)object);
                if (!this.optional) break block30;
                writer.write("        \"\"\"\n");
                writer.write("        This component is optional and therefore the API will only work if it is installed\n");
                writer.write("        \"\"\"\n");
            }
        }
        string32 = "_request";
        String string4 = "base";
        if (string2.equals("other")) {
            string32 = string32 + "_other";
            string4 = string4 + "_other";
        }
        if (string2.equals("other")) {
            writer.write("        return (");
        } else {
            writer.write("        return next(");
        }
        writer.write("self.zap." + string32 + "(self.zap." + string4 + " + '" + string + "/" + string2 + "/" + apiElement.getName() + "/'");
        if (bl) {
            writer.write(", {");
            boolean bl3 = true;
            if (apiElement.getMandatoryParamNames() != null) {
                for (String string5 : apiElement.getMandatoryParamNames()) {
                    if (bl3) {
                        bl3 = false;
                    } else {
                        writer.write(", ");
                    }
                    writer.write("'" + string5 + "' : " + string5.toLowerCase());
                }
            }
            if (apiElement.getOptionalParamNames() != null) {
                for (String string5 : apiElement.getOptionalParamNames()) {
                    if (bl3) {
                        bl3 = false;
                    } else {
                        writer.write(", ");
                    }
                    writer.write("'" + string5 + "' : " + string5.toLowerCase());
                }
            }
            if (string2.equals("action") || string2.equals("other")) {
                if (bl3) {
                    bl3 = false;
                } else {
                    writer.write(", ");
                }
                writer.write("'" + API.API_KEY_PARAM + "' : " + API.API_KEY_PARAM);
            }
            writer.write("})");
            if (!string2.equals("other")) {
                writer.write(".itervalues())");
            } else {
                writer.write(")");
            }
        } else if (!string2.equals("other")) {
            writer.write(").itervalues())");
        } else {
            writer.write(")");
        }
        writer.write("\n\n");
    }

    private void generatePythonComponent(ApiImplementor apiImplementor) throws IOException {
        File file = new File(this.dir, PythonAPIGenerator.createFileName(apiImplementor.getPrefix()));
        System.out.println("Generating " + file.getAbsolutePath());
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write("# Zed Attack Proxy (ZAP) and its related class files.\n#\n# ZAP is an HTTP/HTTPS proxy for assessing web application security.\n#\n# Copyright 2015 the ZAP development team\n#\n# Licensed under the Apache License, Version 2.0 (the \"License\");\n# you may not use this file except in compliance with the License.\n# You may obtain a copy of the License at\n#\n#   http://www.apache.org/licenses/LICENSE-2.0\n#\n# Unless required by applicable law or agreed to in writing, software\n# distributed under the License is distributed on an \"AS IS\" BASIS,\n# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n# See the License for the specific language governing permissions and\n# limitations under the License.\n\"\"\"\nThis file was automatically generated.\n\"\"\"\n\n");
            fileWriter.write("class " + PythonAPIGenerator.safeName(apiImplementor.getPrefix()) + "(object):\n\n");
            fileWriter.write("    def __init__(self, zap):\n");
            fileWriter.write("        self.zap = zap\n");
            fileWriter.write("\n");
            for (ApiElement apiElement : apiImplementor.getApiViews()) {
                this.generatePythonElement(apiElement, apiImplementor.getPrefix(), "view", fileWriter);
            }
            for (ApiElement apiElement : apiImplementor.getApiActions()) {
                this.generatePythonElement(apiElement, apiImplementor.getPrefix(), "action", fileWriter);
            }
            for (ApiElement apiElement : apiImplementor.getApiOthers()) {
                this.generatePythonElement(apiElement, apiImplementor.getPrefix(), "other", fileWriter);
            }
            fileWriter.write("\n");
        }
    }

    private static String safeName(String string) {
        if (nameMap.containsKey(string)) {
            return nameMap.get(string);
        }
        return string;
    }

    private static String createFileName(String string) {
        return PythonAPIGenerator.safeName(string) + ".py";
    }

    private static String createFunctionName(String string) {
        return PythonAPIGenerator.removeAllFullStopCharacters(PythonAPIGenerator.camelCaseToLcUnderscores(PythonAPIGenerator.safeName(string)));
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    public static String camelCaseToLcUnderscores(String string) {
        return PythonAPIGenerator.safeName(string).replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), "_").toLowerCase();
    }

    public static void main(String[] stringArray) throws Exception {
        PythonAPIGenerator pythonAPIGenerator = new PythonAPIGenerator();
        pythonAPIGenerator.generatePythonFiles(ApiGeneratorUtils.getAllImplementors());
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("break", "brk");
        nameMap = Collections.unmodifiableMap(hashMap);
    }
}

