/*
 * Copyright (c) 2010-2012 Samsung Electronics Co., Ltd.
 *		http://www.samsung.com
 *
 * EXYNOS - Power management unit definition
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_REGS_PMU_H
#define __ASM_ARCH_REGS_PMU_H __FILE__

#include <mach/map.h>

#define S5P_PMUREG(x)				(S5P_VA_PMU + (x))
#define S5P_SYSREG(x)				(S3C_VA_SYS + (x))

#define S5P_CENTRAL_SEQ_CONFIGURATION		S5P_PMUREG(0x0200)

#define S5P_CENTRAL_LOWPWR_CFG			(1 << 16)

#define S5P_CENTRAL_SEQ_OPTION			S5P_PMUREG(0x0208)

#define EXYNOS_CENTRAL_SEQ_OPTION		S5P_PMUREG(0x0208)

#define EXYNOS_SEQ_TRANSITION(_nr)		S5P_PMUREG(0x0220 + (_nr) * 4)
#define EXYNOS_SEQ_COREBLK_TRANSITION(_nr)	S5P_PMUREG(0x0260 + (_nr) * 4)

#define S5P_USE_STANDBY_WFI0			(1 << 16)
#define S5P_USE_STANDBY_WFI1			(1 << 17)
#define S5P_USE_STANDBYWFI_ISP_ARM		(1 << 18)
#define S5P_USE_STANDBY_WFE0			(1 << 24)
#define S5P_USE_STANDBY_WFE1			(1 << 25)
#define S5P_USE_STANDBYWFE_ISP_ARM		(1 << 26)

#define S5P_SWRESET				S5P_PMUREG(0x0400)
#define EXYNOS_SWRESET				S5P_PMUREG(0x0400)
#define EXYNOS5440_SWRESET			S5P_PMUREG(0x00C4)

#define S5P_WAKEUP_STAT				S5P_PMUREG(0x0600)
#define S5P_EINT_WAKEUP_MASK			S5P_PMUREG(0x0604)
#define S5P_WAKEUP_MASK				S5P_PMUREG(0x0608)

#define S5P_HDMI_PHY_CONTROL			S5P_PMUREG(0x0700)
#define S5P_HDMI_PHY_ENABLE			(1 << 0)

#define S5P_DAC_PHY_CONTROL			S5P_PMUREG(0x070C)
#define S5P_DAC_PHY_ENABLE			(1 << 0)

#define S5P_INFORM0				S5P_PMUREG(0x0800)
#define S5P_INFORM1				S5P_PMUREG(0x0804)
#define S5P_INFORM2				S5P_PMUREG(0x0808)
#define S5P_INFORM3				S5P_PMUREG(0x080C)
#define S5P_INFORM4				S5P_PMUREG(0x0810)
#define S5P_INFORM5				S5P_PMUREG(0x0814)
#define S5P_INFORM6				S5P_PMUREG(0x0818)
#define S5P_INFORM7				S5P_PMUREG(0x081C)
#define EXYNOS_PMU_SPARE0			S5P_PMUREG(0x0900)
#define EXYNOS_PMU_SPARE1			S5P_PMUREG(0x0904)
#define EXYNOS_PMU_SPARE2			S5P_PMUREG(0x0908)
#define EXYNOS_IROM_DATA0			S5P_PMUREG(0x0980)
#define EXYNOS_IROM_DATA1			S5P_PMUREG(0x0984)
#define EXYNOS_IROM_DATA2			S5P_PMUREG(0x0988)
#define EXYNOS_IROM_DATA3			S5P_PMUREG(0x098C)
#define EXYNOS_CHECK_SLEEP			0x00000BAD
#define EXYNOS_CHECK_DIDLE			0xBAD00000
#define EXYNOS_CHECK_LPA			0xABAD0000

#define EXYNOS_PMU_DEBUG			S5P_PMUREG(0x0A00)

#define S5P_ARM_CORE0_LOWPWR			S5P_PMUREG(0x1000)
#define S5P_DIS_IRQ_CORE0			S5P_PMUREG(0x1004)
#define S5P_DIS_IRQ_CENTRAL0			S5P_PMUREG(0x1008)
#define S5P_ARM_CORE1_LOWPWR			S5P_PMUREG(0x1010)
#define S5P_DIS_IRQ_CORE1			S5P_PMUREG(0x1014)
#define S5P_DIS_IRQ_CENTRAL1			S5P_PMUREG(0x1018)
#define S5P_ARM_COMMON_LOWPWR			S5P_PMUREG(0x1080)
#define S5P_L2_0_LOWPWR				S5P_PMUREG(0x10C0)
#define S5P_L2_1_LOWPWR				S5P_PMUREG(0x10C4)
#define S5P_CMU_ACLKSTOP_LOWPWR			S5P_PMUREG(0x1100)
#define S5P_CMU_SCLKSTOP_LOWPWR			S5P_PMUREG(0x1104)
#define S5P_CMU_RESET_LOWPWR			S5P_PMUREG(0x110C)
#define S5P_APLL_SYSCLK_LOWPWR			S5P_PMUREG(0x1120)
#define S5P_MPLL_SYSCLK_LOWPWR			S5P_PMUREG(0x1124)
#define S5P_VPLL_SYSCLK_LOWPWR			S5P_PMUREG(0x1128)
#define S5P_EPLL_SYSCLK_LOWPWR			S5P_PMUREG(0x112C)
#define S5P_CMU_CLKSTOP_GPS_ALIVE_LOWPWR	S5P_PMUREG(0x1138)
#define S5P_CMU_RESET_GPSALIVE_LOWPWR		S5P_PMUREG(0x113C)
#define S5P_CMU_CLKSTOP_CAM_LOWPWR		S5P_PMUREG(0x1140)
#define S5P_CMU_CLKSTOP_TV_LOWPWR		S5P_PMUREG(0x1144)
#define S5P_CMU_CLKSTOP_MFC_LOWPWR		S5P_PMUREG(0x1148)
#define S5P_CMU_CLKSTOP_G3D_LOWPWR		S5P_PMUREG(0x114C)
#define S5P_CMU_CLKSTOP_LCD0_LOWPWR		S5P_PMUREG(0x1150)
#define S5P_CMU_CLKSTOP_MAUDIO_LOWPWR		S5P_PMUREG(0x1158)
#define S5P_CMU_CLKSTOP_GPS_LOWPWR		S5P_PMUREG(0x115C)
#define S5P_CMU_RESET_CAM_LOWPWR		S5P_PMUREG(0x1160)
#define S5P_CMU_RESET_TV_LOWPWR			S5P_PMUREG(0x1164)
#define S5P_CMU_RESET_MFC_LOWPWR		S5P_PMUREG(0x1168)
#define S5P_CMU_RESET_G3D_LOWPWR		S5P_PMUREG(0x116C)
#define S5P_CMU_RESET_LCD0_LOWPWR		S5P_PMUREG(0x1170)
#define S5P_CMU_RESET_MAUDIO_LOWPWR		S5P_PMUREG(0x1178)
#define S5P_CMU_RESET_GPS_LOWPWR		S5P_PMUREG(0x117C)
#define S5P_TOP_BUS_LOWPWR			S5P_PMUREG(0x1180)
#define S5P_TOP_RETENTION_LOWPWR		S5P_PMUREG(0x1184)
#define S5P_TOP_PWR_LOWPWR			S5P_PMUREG(0x1188)
#define S5P_LOGIC_RESET_LOWPWR			S5P_PMUREG(0x11A0)
#define S5P_ONENAND_MEM_LOWPWR			S5P_PMUREG(0x11C0)
#define S5P_G2D_ACP_MEM_LOWPWR			S5P_PMUREG(0x11C8)
#define S5P_USBOTG_MEM_LOWPWR			S5P_PMUREG(0x11CC)
#define S5P_HSMMC_MEM_LOWPWR			S5P_PMUREG(0x11D0)
#define S5P_CSSYS_MEM_LOWPWR			S5P_PMUREG(0x11D4)
#define S5P_SECSS_MEM_LOWPWR			S5P_PMUREG(0x11D8)
#define S5P_PAD_RETENTION_DRAM_LOWPWR		S5P_PMUREG(0x1200)
#define S5P_PAD_RETENTION_MAUDIO_LOWPWR		S5P_PMUREG(0x1204)
#define S5P_PAD_RETENTION_GPIO_LOWPWR		S5P_PMUREG(0x1220)
#define S5P_PAD_RETENTION_UART_LOWPWR		S5P_PMUREG(0x1224)
#define S5P_PAD_RETENTION_MMCA_LOWPWR		S5P_PMUREG(0x1228)
#define S5P_PAD_RETENTION_MMCB_LOWPWR		S5P_PMUREG(0x122C)
#define S5P_PAD_RETENTION_EBIA_LOWPWR		S5P_PMUREG(0x1230)
#define S5P_PAD_RETENTION_EBIB_LOWPWR		S5P_PMUREG(0x1234)
#define S5P_PAD_RETENTION_ISOLATION_LOWPWR	S5P_PMUREG(0x1240)
#define S5P_PAD_RETENTION_ALV_SEL_LOWPWR	S5P_PMUREG(0x1260)
#define S5P_XUSBXTI_LOWPWR			S5P_PMUREG(0x1280)
#define S5P_XXTI_LOWPWR				S5P_PMUREG(0x1284)
#define S5P_EXT_REGULATOR_LOWPWR		S5P_PMUREG(0x12C0)
#define S5P_GPIO_MODE_LOWPWR			S5P_PMUREG(0x1300)
#define S5P_GPIO_MODE_MAUDIO_LOWPWR		S5P_PMUREG(0x1340)
#define S5P_CAM_LOWPWR				S5P_PMUREG(0x1380)
#define S5P_TV_LOWPWR				S5P_PMUREG(0x1384)
#define S5P_MFC_LOWPWR				S5P_PMUREG(0x1388)
#define S5P_G3D_LOWPWR				S5P_PMUREG(0x138C)
#define S5P_LCD0_LOWPWR				S5P_PMUREG(0x1390)
#define S5P_MAUDIO_LOWPWR			S5P_PMUREG(0x1398)
#define S5P_GPS_LOWPWR				S5P_PMUREG(0x139C)
#define S5P_GPS_ALIVE_LOWPWR			S5P_PMUREG(0x13A0)

#define S5P_ARM_CORE0_CONFIGURATION		S5P_PMUREG(0x2000)
#define S5P_ARM_CORE0_OPTION			S5P_PMUREG(0x2008)
#define S5P_ARM_CORE1_CONFIGURATION		S5P_PMUREG(0x2080)
#define S5P_ARM_CORE1_STATUS			S5P_PMUREG(0x2084)
#define S5P_ARM_CORE1_OPTION			S5P_PMUREG(0x2088)

#define EXYNOS_ARM_CORE0_CONFIGURATION		EXYNOS_PMUREG(0x2000)
#define EXYNOS_ARM_CORE0_STATUS			EXYNOS_PMUREG(0x2004)
#define EXYNOS_ARM_CORE0_OPTION			S5P_PMUREG(0x2008)
#define EXYNOS_ARM_CORE1_CONFIGURATION		S5P_PMUREG(0x2080)
#define EXYNOS_ARM_CORE1_STATUS			S5P_PMUREG(0x2084)
#define EXYNOS_ARM_CORE1_OPTION			S5P_PMUREG(0x2088)
#define EXYNOS_ARM_CORE_OPTION(_nr)		(EXYNOS_ARM_CORE0_OPTION \
						+ ((_nr) * 0x80))
#define EXYNOS_USE_DELAYED_RESET_ASSERTION	BIT(12)
#define EXYNOS_ARM_CORE_STATUS(_nr)		(EXYNOS_ARM_CORE0_STATUS \
						+ ((_nr) * 0x80))
#define EXYNOS_ARM_CORE_CONFIGURATION(_nr)	\
			(EXYNOS_ARM_CORE0_CONFIGURATION + ((_nr) * 0x80))
#define EXYNOS_CORE_LOCAL_PWR_EN		0x3

#define S5P_ARM_COMMON_OPTION			S5P_PMUREG(0x2408)
#define S5P_TOP_PWR_OPTION			S5P_PMUREG(0x2C48)
#define S5P_CAM_OPTION				S5P_PMUREG(0x3C08)
#define S5P_TV_OPTION				S5P_PMUREG(0x3C28)
#define S5P_MFC_OPTION				S5P_PMUREG(0x3C48)
#define S5P_G3D_OPTION				S5P_PMUREG(0x3C68)
#define S5P_LCD0_OPTION				S5P_PMUREG(0x3C88)
#define S5P_LCD1_OPTION				S5P_PMUREG(0x3CA8)
#define S5P_MAUDIO_OPTION			S5P_PMUREG(0x3CC8)
#define S5P_GPS_OPTION				S5P_PMUREG(0x3CE8)
#define S5P_GPS_ALIVE_OPTION			S5P_PMUREG(0x3D08)

#define S5P_PAD_RET_MAUDIO_OPTION		S5P_PMUREG(0x3028)
#define S5P_PAD_RET_GPIO_OPTION			S5P_PMUREG(0x3108)
#define S5P_PAD_RET_UART_OPTION			S5P_PMUREG(0x3128)
#define S5P_PAD_RET_MMCA_OPTION			S5P_PMUREG(0x3148)
#define S5P_PAD_RET_MMCB_OPTION			S5P_PMUREG(0x3168)
#define S5P_PAD_RET_EBIA_OPTION			S5P_PMUREG(0x3188)
#define S5P_PAD_RET_EBIB_OPTION			S5P_PMUREG(0x31A8)

#define S5P_PMU_CAM_CONF			S5P_PMUREG(0x3C00)
#define S5P_PMU_TV_CONF				S5P_PMUREG(0x3C20)
#define S5P_PMU_MFC_CONF			S5P_PMUREG(0x3C40)
#define S5P_PMU_G3D_CONF			S5P_PMUREG(0x3C60)
#define S5P_PMU_LCD0_CONF			S5P_PMUREG(0x3C80)
#define S5P_PMU_GPS_CONF			S5P_PMUREG(0x3CE0)

#define S5P_PMU_SATA_PHY_CONTROL_EN		0x1
#define S5P_CORE_LOCAL_PWR_EN			0x3
#define S5P_INT_LOCAL_PWR_EN			0x7

#define EXYNOS_ARM_CORE_CONFIGURATION(_nr)	\
			(EXYNOS_ARM_CORE0_CONFIGURATION + ((_nr) * 0x80))
#define EXYNOS_CORE_LOCAL_PWR_EN		0x3

#define EXYNOS_ARM_COMMON_CONFIGURATION		S5P_PMUREG(0x2500)
#define EXYNOS_ARM_COMMON_STATUS		S5P_PMUREG(0x2504)
#define EXYNOS_COMMON_CONFIGURATION(_nr)	\
			(EXYNOS_ARM_COMMON_CONFIGURATION + ((_nr) * 0x80))
#define EXYNOS_COMMON_STATUS(_nr)		\
			(EXYNOS_COMMON_CONFIGURATION(_nr) + 0x4)
#define EXYNOS_COMMON_OPTION(_nr)		\
			(EXYNOS_COMMON_CONFIGURATION(_nr) + 0x8)

#define EXYNOS_ARM_L2_CONFIGURATION		S5P_PMUREG(0x2600)
#define EXYNOS_L2_CONFIGURATION(_nr)	\
			(EXYNOS_ARM_L2_CONFIGURATION + ((_nr) * 0x80))
#define EXYNOS_L2_STATUS(_nr)		\
			(EXYNOS_L2_CONFIGURATION(_nr) + 0x4)
#define EXYNOS_L2_OPTION(_nr)		\
			(EXYNOS_L2_CONFIGURATION(_nr) + 0x8)

#define EXYNOS_L2_COMMON_PWR_EN			0x3


#define S5P_CHECK_SLEEP				0x00000BAD

#define EXYNOS_PS_HOLD_CONTROL			S5P_PMUREG(0x330C)
#define EXYNOS_PS_HOLD_EN			(1 << 31)
#define EXYNOS_PS_HOLD_OUTPUT_HIGH		(3 << 8)

/* For XXX_IP_CONFIGURATION(Power Domain) */
#define EXYNOS_INT_LOCAL_PWR_EN			0x7

/* For SYS_PWR_REG */
#define EXYNOS_SYS_PWR_CFG			(1 << 0)

/* Only for EXYNOS4210 */
#define S5P_USBDEVICE_PHY_CONTROL	S5P_PMUREG(0x0704)
#define S5P_USBDEVICE_PHY_ENABLE	(1 << 0)

#define S5P_USBHOST_PHY_CONTROL		S5P_PMUREG(0x0708)
#define S5P_USBHOST_PHY_ENABLE		(1 << 0)

#define S5P_PMU_SATA_PHY_CONTROL	S5P_PMUREG(0x0720)

#define S5P_CMU_CLKSTOP_LCD1_LOWPWR	S5P_PMUREG(0x1154)
#define S5P_CMU_RESET_LCD1_LOWPWR	S5P_PMUREG(0x1174)
#define S5P_MODIMIF_MEM_LOWPWR		S5P_PMUREG(0x11C4)
#define S5P_PCIE_MEM_LOWPWR		S5P_PMUREG(0x11E0)
#define S5P_SATA_MEM_LOWPWR		S5P_PMUREG(0x11E4)
#define S5P_LCD1_LOWPWR			S5P_PMUREG(0x1394)

#define S5P_PMU_LCD1_CONF		S5P_PMUREG(0x3CA0)

/* Only for EXYNOS4x12 */
#define S5P_ISP_ARM_LOWPWR			S5P_PMUREG(0x1050)
#define S5P_DIS_IRQ_ISP_ARM_LOCAL_LOWPWR	S5P_PMUREG(0x1054)
#define S5P_DIS_IRQ_ISP_ARM_CENTRAL_LOWPWR	S5P_PMUREG(0x1058)
#define S5P_CMU_ACLKSTOP_COREBLK_LOWPWR		S5P_PMUREG(0x1110)
#define S5P_CMU_SCLKSTOP_COREBLK_LOWPWR		S5P_PMUREG(0x1114)
#define S5P_CMU_RESET_COREBLK_LOWPWR		S5P_PMUREG(0x111C)
#define S5P_MPLLUSER_SYSCLK_LOWPWR		S5P_PMUREG(0x1130)
#define S5P_CMU_CLKSTOP_ISP_LOWPWR		S5P_PMUREG(0x1154)
#define S5P_CMU_RESET_ISP_LOWPWR		S5P_PMUREG(0x1174)
#define S5P_TOP_BUS_COREBLK_LOWPWR		S5P_PMUREG(0x1190)
#define S5P_TOP_RETENTION_COREBLK_LOWPWR	S5P_PMUREG(0x1194)
#define S5P_TOP_PWR_COREBLK_LOWPWR		S5P_PMUREG(0x1198)
#define S5P_OSCCLK_GATE_LOWPWR			S5P_PMUREG(0x11A4)
#define S5P_LOGIC_RESET_COREBLK_LOWPWR		S5P_PMUREG(0x11B0)
#define S5P_OSCCLK_GATE_COREBLK_LOWPWR		S5P_PMUREG(0x11B4)
#define S5P_HSI_MEM_LOWPWR			S5P_PMUREG(0x11C4)
#define S5P_ROTATOR_MEM_LOWPWR			S5P_PMUREG(0x11DC)
#define S5P_PAD_RETENTION_GPIO_COREBLK_LOWPWR	S5P_PMUREG(0x123C)
#define S5P_PAD_ISOLATION_COREBLK_LOWPWR	S5P_PMUREG(0x1250)
#define S5P_GPIO_MODE_COREBLK_LOWPWR		S5P_PMUREG(0x1320)
#define S5P_TOP_ASB_RESET_LOWPWR		S5P_PMUREG(0x1344)
#define S5P_TOP_ASB_ISOLATION_LOWPWR		S5P_PMUREG(0x1348)
#define S5P_ISP_LOWPWR				S5P_PMUREG(0x1394)
#define S5P_DRAM_FREQ_DOWN_LOWPWR		S5P_PMUREG(0x13B0)
#define S5P_DDRPHY_DLLOFF_LOWPWR		S5P_PMUREG(0x13B4)
#define S5P_CMU_SYSCLK_ISP_LOWPWR		S5P_PMUREG(0x13B8)
#define S5P_CMU_SYSCLK_GPS_LOWPWR		S5P_PMUREG(0x13BC)
#define S5P_LPDDR_PHY_DLL_LOCK_LOWPWR		S5P_PMUREG(0x13C0)

#define S5P_ARM_L2_0_OPTION			S5P_PMUREG(0x2608)
#define S5P_ARM_L2_1_OPTION			S5P_PMUREG(0x2628)
#define S5P_ONENAND_MEM_OPTION			S5P_PMUREG(0x2E08)
#define S5P_HSI_MEM_OPTION			S5P_PMUREG(0x2E28)
#define S5P_G2D_ACP_MEM_OPTION			S5P_PMUREG(0x2E48)
#define S5P_USBOTG_MEM_OPTION			S5P_PMUREG(0x2E68)
#define S5P_HSMMC_MEM_OPTION			S5P_PMUREG(0x2E88)
#define S5P_CSSYS_MEM_OPTION			S5P_PMUREG(0x2EA8)
#define S5P_SECSS_MEM_OPTION			S5P_PMUREG(0x2EC8)
#define S5P_ROTATOR_MEM_OPTION			S5P_PMUREG(0x2F48)

/* Only for EXYNOS4412 */
#define S5P_ARM_CORE2_LOWPWR			S5P_PMUREG(0x1020)
#define S5P_DIS_IRQ_CORE2			S5P_PMUREG(0x1024)
#define S5P_DIS_IRQ_CENTRAL2			S5P_PMUREG(0x1028)
#define S5P_ARM_CORE3_LOWPWR			S5P_PMUREG(0x1030)
#define S5P_DIS_IRQ_CORE3			S5P_PMUREG(0x1034)
#define S5P_DIS_IRQ_CENTRAL3			S5P_PMUREG(0x1038)

/* For EXYNOS5 */

#define EXYNOS5_SYS_I2C_CFG					S5P_SYSREG(0x0234)

#define EXYNOS5_AUTO_WDTRESET_DISABLE				S5P_PMUREG(0x0408)
#define EXYNOS5_MASK_WDTRESET_REQUEST				S5P_PMUREG(0x040C)

#define EXYNOS5_SYS_WDTRESET					(1 << 20)

#define EXYNOS5_ABB_INT                 S5P_PMUREG(0x0780)
#define EXYNOS5_ABB_ARM                 S5P_PMUREG(0x0784)
#define EXYNOS5_ABB_G3D                 S5P_PMUREG(0x0788)
#define EXYNOS5_ABB_MIF                 S5P_PMUREG(0x078C)
#define EXYNOS5_ABB_MEMBER(_member)     EXYNOS_##_member

#define EXYNOS5410_BB_CON0				S5P_PMUREG(0x0780)
#define EXYNOS5410_BB_CON1				S5P_PMUREG(0x0784)
#define EXYNOS5410_BB_SEL_EN				(1 << 31)
#define EXYNOS5410_BB_PMOS_EN				(1 << 7)

#define EXYNOS5_ARM_CORE0_SYS_PWR_REG				S5P_PMUREG(0x1000)
#define EXYNOS5_DIS_IRQ_ARM_CORE0_LOCAL_SYS_PWR_REG		S5P_PMUREG(0x1004)
#define EXYNOS5_DIS_IRQ_ARM_CORE0_CENTRAL_SYS_PWR_REG		S5P_PMUREG(0x1008)
#define EXYNOS5_ARM_CORE1_SYS_PWR_REG				S5P_PMUREG(0x1010)
#define EXYNOS5_DIS_IRQ_ARM_CORE1_LOCAL_SYS_PWR_REG		S5P_PMUREG(0x1014)
#define EXYNOS5_DIS_IRQ_ARM_CORE1_CENTRAL_SYS_PWR_REG		S5P_PMUREG(0x1018)
#define EXYNOS5_FSYS_ARM_SYS_PWR_REG				S5P_PMUREG(0x1040)
#define EXYNOS5_DIS_IRQ_FSYS_ARM_CENTRAL_SYS_PWR_REG		S5P_PMUREG(0x1048)
#define EXYNOS5_ISP_ARM_SYS_PWR_REG				S5P_PMUREG(0x1050)
#define EXYNOS5_DIS_IRQ_ISP_ARM_LOCAL_SYS_PWR_REG		S5P_PMUREG(0x1054)
#define EXYNOS5_DIS_IRQ_ISP_ARM_CENTRAL_SYS_PWR_REG		S5P_PMUREG(0x1058)
#define EXYNOS5_ARM_COMMON_SYS_PWR_REG				S5P_PMUREG(0x1080)
#define EXYNOS5_ARM_L2_SYS_PWR_REG				S5P_PMUREG(0x10C0)
#define EXYNOS5_CMU_ACLKSTOP_SYS_PWR_REG			S5P_PMUREG(0x1100)
#define EXYNOS5_CMU_SCLKSTOP_SYS_PWR_REG			S5P_PMUREG(0x1104)
#define EXYNOS5_CMU_RESET_SYS_PWR_REG				S5P_PMUREG(0x110C)
#define EXYNOS5_CMU_ACLKSTOP_SYSMEM_SYS_PWR_REG			S5P_PMUREG(0x1120)
#define EXYNOS5_CMU_SCLKSTOP_SYSMEM_SYS_PWR_REG			S5P_PMUREG(0x1124)
#define EXYNOS5_CMU_RESET_SYSMEM_SYS_PWR_REG			S5P_PMUREG(0x112C)
#define EXYNOS5_DRAM_FREQ_DOWN_SYS_PWR_REG			S5P_PMUREG(0x1130)
#define EXYNOS5_DDRPHY_DLLOFF_SYS_PWR_REG			S5P_PMUREG(0x1134)
#define EXYNOS5_DDRPHY_DLLLOCK_SYS_PWR_REG			S5P_PMUREG(0x1138)
#define EXYNOS5_APLL_SYSCLK_SYS_PWR_REG				S5P_PMUREG(0x1140)
#define EXYNOS5_MPLL_SYSCLK_SYS_PWR_REG				S5P_PMUREG(0x1144)
#define EXYNOS5_VPLL_SYSCLK_SYS_PWR_REG				S5P_PMUREG(0x1148)
#define EXYNOS5_EPLL_SYSCLK_SYS_PWR_REG				S5P_PMUREG(0x114C)
#define EXYNOS5_BPLL_SYSCLK_SYS_PWR_REG				S5P_PMUREG(0x1150)
#define EXYNOS5_CPLL_SYSCLK_SYS_PWR_REG				S5P_PMUREG(0x1154)
#define EXYNOS5_MPLLUSER_SYSCLK_SYS_PWR_REG			S5P_PMUREG(0x1164)
#define EXYNOS5_BPLLUSER_SYSCLK_SYS_PWR_REG			S5P_PMUREG(0x1170)
#define EXYNOS5_TOP_BUS_SYS_PWR_REG				S5P_PMUREG(0x1180)
#define EXYNOS5_TOP_RETENTION_SYS_PWR_REG			S5P_PMUREG(0x1184)
#define EXYNOS5_TOP_PWR_SYS_PWR_REG				S5P_PMUREG(0x1188)
#define EXYNOS5_TOP_BUS_SYSMEM_SYS_PWR_REG			S5P_PMUREG(0x1190)
#define EXYNOS5_TOP_RETENTION_SYSMEM_SYS_PWR_REG		S5P_PMUREG(0x1194)
#define EXYNOS5_TOP_PWR_SYSMEM_SYS_PWR_REG			S5P_PMUREG(0x1198)
#define EXYNOS5_LOGIC_RESET_SYS_PWR_REG				S5P_PMUREG(0x11A0)
#define EXYNOS5_OSCCLK_GATE_SYS_PWR_REG				S5P_PMUREG(0x11A4)
#define EXYNOS5_LOGIC_RESET_SYSMEM_SYS_PWR_REG			S5P_PMUREG(0x11B0)
#define EXYNOS5_OSCCLK_GATE_SYSMEM_SYS_PWR_REG			S5P_PMUREG(0x11B4)
#define EXYNOS5_USBOTG_MEM_SYS_PWR_REG				S5P_PMUREG(0x11C0)
#define EXYNOS5_G2D_MEM_SYS_PWR_REG				S5P_PMUREG(0x11C8)
#define EXYNOS5_USBDRD_MEM_SYS_PWR_REG				S5P_PMUREG(0x11CC)
#define EXYNOS5_SDMMC_MEM_SYS_PWR_REG				S5P_PMUREG(0x11D0)
#define EXYNOS5_CSSYS_MEM_SYS_PWR_REG				S5P_PMUREG(0x11D4)
#define EXYNOS5_SECSS_MEM_SYS_PWR_REG				S5P_PMUREG(0x11D8)
#define EXYNOS5_ROTATOR_MEM_SYS_PWR_REG				S5P_PMUREG(0x11DC)
#define EXYNOS5_INTRAM_MEM_SYS_PWR_REG				S5P_PMUREG(0x11E0)
#define EXYNOS5_INTROM_MEM_SYS_PWR_REG				S5P_PMUREG(0x11E4)
#define EXYNOS5_JPEG_MEM_SYS_PWR_REG				S5P_PMUREG(0x11E8)
#define EXYNOS5_HSI_MEM_SYS_PWR_REG				S5P_PMUREG(0x11EC)
#define EXYNOS5_MCUIOP_MEM_SYS_PWR_REG				S5P_PMUREG(0x11F4)
#define EXYNOS5_SATA_MEM_SYS_PWR_REG				S5P_PMUREG(0x11FC)
#define EXYNOS5_PAD_RETENTION_DRAM_SYS_PWR_REG			S5P_PMUREG(0x1200)
#define EXYNOS5_PAD_RETENTION_MAU_SYS_PWR_REG			S5P_PMUREG(0x1204)
#define EXYNOS5_PAD_RETENTION_EFNAND_SYS_PWR_REG		S5P_PMUREG(0x1208)
#define EXYNOS5_PAD_RETENTION_GPIO_SYS_PWR_REG			S5P_PMUREG(0x1220)
#define EXYNOS5_PAD_RETENTION_UART_SYS_PWR_REG			S5P_PMUREG(0x1224)
#define EXYNOS5_PAD_RETENTION_MMCA_SYS_PWR_REG			S5P_PMUREG(0x1228)
#define EXYNOS5_PAD_RETENTION_MMCB_SYS_PWR_REG			S5P_PMUREG(0x122C)
#define EXYNOS5_PAD_RETENTION_EBIA_SYS_PWR_REG			S5P_PMUREG(0x1230)
#define EXYNOS5_PAD_RETENTION_EBIB_SYS_PWR_REG			S5P_PMUREG(0x1234)
#define EXYNOS5_PAD_RETENTION_SPI_SYS_PWR_REG			S5P_PMUREG(0x1238)
#define EXYNOS5_PAD_RETENTION_GPIO_SYSMEM_SYS_PWR_REG		S5P_PMUREG(0x123C)
#define EXYNOS5_PAD_ISOLATION_SYS_PWR_REG			S5P_PMUREG(0x1240)
#define EXYNOS5_PAD_ISOLATION_SYSMEM_SYS_PWR_REG		S5P_PMUREG(0x1250)
#define EXYNOS5_PAD_ALV_SEL_SYS_PWR_REG				S5P_PMUREG(0x1260)
#define EXYNOS5_XUSBXTI_SYS_PWR_REG				S5P_PMUREG(0x1280)
#define EXYNOS5_XXTI_SYS_PWR_REG				S5P_PMUREG(0x1284)
#define EXYNOS5_EXT_REGULATOR_SYS_PWR_REG			S5P_PMUREG(0x12C0)
#define EXYNOS5_GPIO_MODE_SYS_PWR_REG				S5P_PMUREG(0x1300)
#define EXYNOS5_GPIO_MODE_SYSMEM_SYS_PWR_REG			S5P_PMUREG(0x1320)
#define EXYNOS5_GPIO_MODE_MAU_SYS_PWR_REG			S5P_PMUREG(0x1340)
#define EXYNOS5_TOP_ASB_RESET_SYS_PWR_REG			S5P_PMUREG(0x1344)
#define EXYNOS5_TOP_ASB_ISOLATION_SYS_PWR_REG			S5P_PMUREG(0x1348)
#define EXYNOS5_GSCL_SYS_PWR_REG				S5P_PMUREG(0x1400)
#define EXYNOS5_ISP_SYS_PWR_REG					S5P_PMUREG(0x1404)
#define EXYNOS5_MFC_SYS_PWR_REG					S5P_PMUREG(0x1408)
#define EXYNOS5_G3D_SYS_PWR_REG					S5P_PMUREG(0x140C)
#define EXYNOS5_DISP1_SYS_PWR_REG				S5P_PMUREG(0x1414)
#define EXYNOS5_MAU_SYS_PWR_REG					S5P_PMUREG(0x1418)
#define EXYNOS5_CMU_CLKSTOP_GSCL_SYS_PWR_REG			S5P_PMUREG(0x1480)
#define EXYNOS5_CMU_CLKSTOP_ISP_SYS_PWR_REG			S5P_PMUREG(0x1484)
#define EXYNOS5_CMU_CLKSTOP_MFC_SYS_PWR_REG			S5P_PMUREG(0x1488)
#define EXYNOS5_CMU_CLKSTOP_G3D_SYS_PWR_REG			S5P_PMUREG(0x148C)
#define EXYNOS5_CMU_CLKSTOP_DISP1_SYS_PWR_REG			S5P_PMUREG(0x1494)
#define EXYNOS5_CMU_CLKSTOP_MAU_SYS_PWR_REG			S5P_PMUREG(0x1498)
#define EXYNOS5_CMU_SYSCLK_GSCL_SYS_PWR_REG			S5P_PMUREG(0x14C0)
#define EXYNOS5_CMU_SYSCLK_ISP_SYS_PWR_REG			S5P_PMUREG(0x14C4)
#define EXYNOS5_CMU_SYSCLK_MFC_SYS_PWR_REG			S5P_PMUREG(0x14C8)
#define EXYNOS5_CMU_SYSCLK_G3D_SYS_PWR_REG			S5P_PMUREG(0x14CC)
#define EXYNOS5_CMU_SYSCLK_DISP1_SYS_PWR_REG			S5P_PMUREG(0x14D4)
#define EXYNOS5_CMU_SYSCLK_MAU_SYS_PWR_REG			S5P_PMUREG(0x14D8)
#define EXYNOS5_CMU_RESET_GSCL_SYS_PWR_REG			S5P_PMUREG(0x1580)
#define EXYNOS5_CMU_RESET_ISP_SYS_PWR_REG			S5P_PMUREG(0x1584)
#define EXYNOS5_CMU_RESET_MFC_SYS_PWR_REG			S5P_PMUREG(0x1588)
#define EXYNOS5_CMU_RESET_G3D_SYS_PWR_REG			S5P_PMUREG(0x158C)
#define EXYNOS5_CMU_RESET_DISP1_SYS_PWR_REG			S5P_PMUREG(0x1594)
#define EXYNOS5_CMU_RESET_MAU_SYS_PWR_REG			S5P_PMUREG(0x1598)

#define EXYNOS5_ARM_CORE0_OPTION				S5P_PMUREG(0x2008)
#define EXYNOS5_ARM_CORE1_OPTION				S5P_PMUREG(0x2088)
#define EXYNOS5_FSYS_ARM_OPTION					S5P_PMUREG(0x2208)
#define EXYNOS5_ISP_ARM_OPTION					S5P_PMUREG(0x2288)
#define EXYNOS5_ARM_COMMON_OPTION				S5P_PMUREG(0x2408)
#define EXYNOS5_ARM_L2_OPTION					S5P_PMUREG(0x2608)
#define EXYNOS5_TOP_PWR_OPTION					S5P_PMUREG(0x2C48)
#define EXYNOS5_USE_RETENTION				BIT(4)
#define EXYNOS5_TOP_PWR_SYSMEM_OPTION				S5P_PMUREG(0x2CC8)
#define EXYNOS5_JPEG_MEM_OPTION					S5P_PMUREG(0x2F48)
#define EXYNOS5_PAD_RETENTION_SPI_OPTION		S5P_PMUREG(0x31C8)
#define EXYNOS5_PAD_RETENTION_GPIO_SYSMEM_OPTION	S5P_PMUREG(0x31E8)
#define EXYNOS5_XXTI_DURATION3				S5P_PMUREG(0x343C)
#define EXYNOS5_EXT_REGULATOR_DURATION3			S5P_PMUREG(0x361C)
#define EXYNOS5_DUR_WAIT_RESET_MASK			0xFFFFF
#define EXYNOS5_DUR_WAIT_RESET_MIN			0xF
#define EXYNOS5_GSCL_CONFIGURATION			S5P_PMUREG(0x4000)
#define EXYNOS5_GSCL_STATUS					S5P_PMUREG(0x4004)
#define EXYNOS5_ISP_STATUS					S5P_PMUREG(0x4024)
#define EXYNOS5_GSCL_OPTION					S5P_PMUREG(0x4008)
#define EXYNOS5_ISP_OPTION					S5P_PMUREG(0x4028)
#define EXYNOS5_MFC_OPTION					S5P_PMUREG(0x4048)
#define EXYNOS5_G3D_CONFIGURATION				S5P_PMUREG(0x4060)
#define EXYNOS5_G3D_STATUS					S5P_PMUREG(0x4064)
#define EXYNOS5_G3D_OPTION					S5P_PMUREG(0x4068)
#define EXYNOS5_DISP1_OPTION					S5P_PMUREG(0x40A8)
#define EXYNOS5_MAU_OPTION					S5P_PMUREG(0x40C8)

#define EXYNOS5_USE_SC_FEEDBACK					(1 << 1)
#define EXYNOS5_USE_SC_COUNTER					(1 << 0)

#define EXYNOS5_MANUAL_L2RSTDISABLE_CONTROL			(1 << 2)
#define EXYNOS5_SKIP_DEACTIVATE_ACEACP_IN_PWDN			(1 << 7)

#define EXYNOS5_OPTION_USE_STANDBYWFE				(1 << 24)
#define EXYNOS5_OPTION_USE_STANDBYWFI				(1 << 16)

#define EXYNOS5_OPTION_USE_RETENTION				(1 << 4)

/* Only for EXYNOS5410 */
#define EXYNOS5410_LPI_MASK0					S5P_PMUREG(0x0004)
#define EXYNOS5410_LPI_MASK1					S5P_PMUREG(0x0008)
#define EXYNOS5410_LPI_MASK2					S5P_PMUREG(0x000C)
#define ATB_ISP_ARM						(1 << 12)
#define ATB_KFC							(1 << 13)
#define ATB_NOC							(1 << 14)

#define EXYNOS5410_ARM_INTR_SPREAD_ENABLE			S5P_PMUREG(0x0100)
#define EXYNOS5410_ARM_INTR_SPREAD_USE_STANDBYWFI		S5P_PMUREG(0x0104)
#define EXYNOS5410_UP_SCHEDULER					S5P_PMUREG(0x0120)
#define SPREAD_ENABLE						(0xF)
#define SPREAD_USE_STANDWFI					(0xF)

#define EXYNOS5410_BB_CON1				S5P_PMUREG(0x0784)
#define EXYNOS5410_BB_SEL_EN			(1 << 31)
#define EXYNOS5410_BB_PMOS_EN			(1 << 7)
#define EXYNOS5410_BB_1300X				(0X0F)

#define EXYNOS5410_ARM_CORE2_SYS_PWR_REG			S5P_PMUREG(0x1020)
#define EXYNOS5410_DIS_IRQ_ARM_CORE2_LOCAL_SYS_PWR_REG		S5P_PMUREG(0x1024)
#define EXYNOS5410_DIS_IRQ_ARM_CORE2_CENTRAL_SYS_PWR_REG	S5P_PMUREG(0x1028)
#define EXYNOS5410_ARM_CORE3_SYS_PWR_REG			S5P_PMUREG(0x1030)
#define EXYNOS5410_DIS_IRQ_ARM_CORE3_LOCAL_SYS_PWR_REG		S5P_PMUREG(0x1034)
#define EXYNOS5410_DIS_IRQ_ARM_CORE3_CENTRAL_SYS_PWR_REG	S5P_PMUREG(0x1038)
#define EXYNOS5410_KFC_CORE0_SYS_PWR_REG			S5P_PMUREG(0x1040)
#define EXYNOS5410_DIS_IRQ_KFC_CORE0_LOCAL_SYS_PWR_REG		S5P_PMUREG(0x1044)
#define EXYNOS5410_DIS_IRQ_KFC_CORE0_CENTRAL_SYS_PWR_REG	S5P_PMUREG(0x1048)
#define EXYNOS5410_KFC_CORE1_SYS_PWR_REG			S5P_PMUREG(0x1050)
#define EXYNOS5410_DIS_IRQ_KFC_CORE1_LOCAL_SYS_PWR_REG		S5P_PMUREG(0x1054)
#define EXYNOS5410_DIS_IRQ_KFC_CORE1_CENTRAL_SYS_PWR_REG	S5P_PMUREG(0x1058)
#define EXYNOS5410_KFC_CORE2_SYS_PWR_REG			S5P_PMUREG(0x1060)
#define EXYNOS5410_DIS_IRQ_KFC_CORE2_LOCAL_SYS_PWR_REG		S5P_PMUREG(0x1064)
#define EXYNOS5410_DIS_IRQ_KFC_CORE2_CENTRAL_SYS_PWR_REG	S5P_PMUREG(0x1068)
#define EXYNOS5410_KFC_CORE3_SYS_PWR_REG			S5P_PMUREG(0x1070)
#define EXYNOS5410_DIS_IRQ_KFC_CORE3_LOCAL_SYS_PWR_REG		S5P_PMUREG(0x1074)
#define EXYNOS5410_DIS_IRQ_KFC_CORE3_CENTRAL_SYS_PWR_REG	S5P_PMUREG(0x1078)
#define EXYNOS5410_ISP_ARM_SYS_PWR_REG				S5P_PMUREG(0x1090)
#define EXYNOS5410_DIS_IRQ_ISP_ARM_LOCAL_SYS_PWR_REG		S5P_PMUREG(0x1094)
#define EXYNOS5410_DIS_IRQ_ISP_ARM_CENTRAL_SYS_PWR_REG		S5P_PMUREG(0x1098)
#define EXYNOS5410_ARM_COMMON_SYS_PWR_REG			S5P_PMUREG(0x10A0)
#define EXYNOS5410_KFC_COMMON_SYS_PWR_REG			S5P_PMUREG(0x10B0)
#define EXYNOS5410_KFC_L2_SYS_PWR_REG				S5P_PMUREG(0x10D0)
#define EXYNOS5410_DPLL_SYSCLK_SYS_PWR_REG			S5P_PMUREG(0x1158)
#define EXYNOS5410_IPLL_SYSCLK_SYS_PWR_REG			S5P_PMUREG(0x115C)
#define EXYNOS5410_KPLL_SYSCLK_SYS_PWR_REG			S5P_PMUREG(0x1160)
#define EXYNOS5410_ONENANDXL_MEM_SYS_PWR			S5P_PMUREG(0x11C0)
#define EXYNOS5410_USBDEV_MEM_SYS_PWR				S5P_PMUREG(0x11CC)
#define EXYNOS5410_USBDEV1_MEM_SYS_PWR				S5P_PMUREG(0x11D0)
#define EXYNOS5410_SDMMC_MEM_SYS_PWR				S5P_PMUREG(0x11D4)
#define EXYNOS5410_CSSYS_MEM_SYS_PWR				S5P_PMUREG(0x11D8)
#define EXYNOS5410_SECSS_MEM_SYS_PWR				S5P_PMUREG(0x11DC)
#define EXYNOS5410_ROTATOR_MEM_SYS_PWR				S5P_PMUREG(0x11E0)
#define EXYNOS5410_INTRAM_MEM_SYS_PWR				S5P_PMUREG(0x11E4)
#define EXYNOS5410_INTROM_MEM_SYS_PWR				S5P_PMUREG(0x11E8)
#define EXYNOS5410_JPEG_MEM_SYS_PWR				S5P_PMUREG(0x11EC)
#define EXYNOS5410_SFMC0_MEM_SYS_PWR				S5P_PMUREG(0x11F0)
#define EXYNOS5410_SFMC1_MEM_SYS_PWR				S5P_PMUREG(0x11F4)
#define EXYNOS5410_HSI_MEM_SYS_PWR				S5P_PMUREG(0x11F8)
#define EXYNOS5410_MCUIOP_MEM_SYS_PWR				S5P_PMUREG(0x11FC)
#define EXYNOS5410_PAD_RETENTION_GPIO_SYS_PWR			S5P_PMUREG(0x1210)
#define EXYNOS5410_PAD_RETENTION_UART_SYS_PWR			S5P_PMUREG(0x1214)
#define EXYNOS5410_PAD_RETENTION_MMC0_SYS_PWR			S5P_PMUREG(0x1218)
#define EXYNOS5410_PAD_RETENTION_MMC1_SYS_PWR			S5P_PMUREG(0x121C)
#define EXYNOS5410_PAD_RETENTION_MMC2_SYS_PWR			S5P_PMUREG(0x1220)
#define EXYNOS5410_PAD_RETENTION_HSI_SYS_PWR			S5P_PMUREG(0x1224)
#define EXYNOS5410_PAD_RETENTION_EBIA_SYS_PWR			S5P_PMUREG(0x1228)
#define EXYNOS5410_PAD_RETENTION_EBIB_SYS_PWR			S5P_PMUREG(0x122C)
#define EXYNOS5410_PAD_RETENTION_SPI_SYS_PWR			S5P_PMUREG(0x1230)
#define EXYNOS5410_PAD_RETENTION_GPIO_COREBLK_SYS_PWR		S5P_PMUREG(0x1234)
#define EXYNOS5410_DISP0_SYS_PWR_REG				S5P_PMUREG(0x1410)
#define EXYNOS5410_CMU_CLKSTOP_DISP0_SYS_PWR_REG		S5P_PMUREG(0x1490)
#define EXYNOS5410_CMU_SYSCLK_DISP0_SYS_PWR_REG			S5P_PMUREG(0x14D0)
#define EXYNOS5410_CMU_RESET_DISP0_SYS_PWR			S5P_PMUREG(0x1590)
#define EXYNOS5410_LPI_NOC_MASK0				S5P_PMUREG(0x159C)
#define EXYNOS5410_LPI_NOC_MASK1				S5P_PMUREG(0x15A0)
#define EXYNOS5410_LPI_NOC_MASK2				S5P_PMUREG(0x15A4)
#define EXYNOS_ARM_CORE2_CONFIGURATION				S5P_PMUREG(0x2100)
#define EXYNOS5410_ARM_CORE2_OPTION				S5P_PMUREG(0x2108)
#define EXYNOS_ARM_CORE3_CONFIGURATION				S5P_PMUREG(0x2180)
#define EXYNOS5410_ARM_CORE3_OPTION				S5P_PMUREG(0x2188)
#define EXYNOS5410_ARM_COMMON_STATUS				S5P_PMUREG(0x2504)
#define EXYNOS5410_ARM_COMMON_OPTION				S5P_PMUREG(0x2508)
#define EXYNOS5410_KFC_COMMON_STATUS				S5P_PMUREG(0x2584)
#define EXYNOS5410_KFC_COMMON_OPTION				S5P_PMUREG(0x2588)
#define EXYNOS5410_LOGIC_RESET_DURATION3			S5P_PMUREG(0x2D1C)

#define EXYNOS5410_PAD_RET_GPIO_OPTION			S5P_PMUREG(0x30C8)
#define EXYNOS5410_PAD_RET_UART_OPTION			S5P_PMUREG(0x30E8)
#define EXYNOS5410_PAD_RET_MMCA_OPTION			S5P_PMUREG(0x3108)
#define EXYNOS5410_PAD_RET_MMCB_OPTION			S5P_PMUREG(0x3128)
#define EXYNOS5410_PAD_RET_MMCC_OPTION			S5P_PMUREG(0x3148)
#define EXYNOS5410_PAD_RET_HSI_OPTION			S5P_PMUREG(0x3168)
#define EXYNOS5410_PAD_RET_SPI_OPTION			S5P_PMUREG(0x31C8)

#define EXYNOS5410_MFC_CONFIGURATION			S5P_PMUREG(0x4060)
#define EXYNOS5410_MFC_STATUS				S5P_PMUREG(0x4064)
#define EXYNOS5410_MFC_OPTION				S5P_PMUREG(0x4068)
#define EXYNOS5410_G3D_CONFIGURATION			S5P_PMUREG(0x4080)
#define EXYNOS5410_G3D_STATUS				S5P_PMUREG(0x4084)
#define EXYNOS5410_G3D_OPTION				S5P_PMUREG(0x4088)
#define EXYNOS5410_DISP0_CONFIGURATION			S5P_PMUREG(0x40A0)
#define EXYNOS5410_DISP0_STATUS				S5P_PMUREG(0x40A4)
#define EXYNOS5410_DISP0_OPTION				S5P_PMUREG(0x40A8)
#define EXYNOS5410_DISP1_CONFIGURATION			S5P_PMUREG(0x40C0)
#define EXYNOS5410_DISP1_STATUS				S5P_PMUREG(0x40C4)
#define EXYNOS5410_DISP1_OPTION				S5P_PMUREG(0x40C8)
#define EXYNOS5410_MAU_CONFIGURATION			S5P_PMUREG(0x40E0)
#define EXYNOS5410_MAU_STATUS				S5P_PMUREG(0x40E4)
#define EXYNOS5410_MAU_OPTION				S5P_PMUREG(0x40E8)

/* For EXYNOS_CENTRAL_SEQ_OPTION */
#define EXYNOS5_USE_STANDBYWFI_ARM_CORE0		(1 << 16)
#define EXYNOS5_USE_STANDBYWFI_ARM_CORE1		(1 << 17)
#define EXYNOS5_USE_STANDBYWFE_ARM_CORE0		(1 << 24)
#define EXYNOS5_USE_STANDBYWFE_ARM_CORE1		(1 << 25)

#define EXYNOS5410_ARM_USE_STANDBY_WFI0		(1 << 4)
#define EXYNOS5410_ARM_USE_STANDBY_WFI1		(1 << 5)
#define EXYNOS5410_ARM_USE_STANDBY_WFI2		(1 << 6)
#define EXYNOS5410_ARM_USE_STANDBY_WFI3		(1 << 7)
#define EXYNOS5410_KFC_USE_STANDBY_WFI0		(1 << 8)
#define EXYNOS5410_KFC_USE_STANDBY_WFI1		(1 << 9)
#define EXYNOS5410_KFC_USE_STANDBY_WFI2		(1 << 10)
#define EXYNOS5410_KFC_USE_STANDBY_WFI3		(1 << 11)
#define EXYNOS5410_ARM_USE_STANDBY_WFE0		(1 << 16)
#define EXYNOS5410_ARM_USE_STANDBY_WFE1		(1 << 17)
#define EXYNOS5410_ARM_USE_STANDBY_WFE2		(1 << 18)
#define EXYNOS5410_ARM_USE_STANDBY_WFE3		(1 << 19)
#define EXYNOS5410_KFC_USE_STANDBY_WFE0		(1 << 20)
#define EXYNOS5410_KFC_USE_STANDBY_WFE1		(1 << 21)
#define EXYNOS5410_KFC_USE_STANDBY_WFE2		(1 << 22)
#define EXYNOS5410_KFC_USE_STANDBY_WFE3		(1 << 23)

#define EXYNOS5410_USE_STANDBY_WFI_ALL		(EXYNOS5410_ARM_USE_STANDBY_WFI0  \
						 | EXYNOS5410_ARM_USE_STANDBY_WFI1  \
						 | EXYNOS5410_ARM_USE_STANDBY_WFI2  \
						 | EXYNOS5410_ARM_USE_STANDBY_WFI3  \
						 | EXYNOS5410_KFC_USE_STANDBY_WFI0  \
						 | EXYNOS5410_KFC_USE_STANDBY_WFI1  \
						 | EXYNOS5410_KFC_USE_STANDBY_WFI2  \
						 | EXYNOS5410_KFC_USE_STANDBY_WFI3)

#define DUR_WAIT_RESET				(0xF)

/* Only for EXYNOS5250 */
#define EXYNOS5_SATA_PHY_CONTROL		S5P_PMUREG(0x0724)

#endif /* __ASM_ARCH_REGS_PMU_H */
