/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class Statement
extends ASTNode {
    public static final int NOT_COMPLAINED = 0;
    public static final int COMPLAINED_FAKE_REACHABLE = 1;
    public static final int COMPLAINED_UNREACHABLE = 2;

    protected static boolean isKnowDeadCodePattern(Expression expression) {
        if (expression instanceof UnaryExpression) {
            expression = ((UnaryExpression)expression).expression;
        }
        return expression instanceof Reference;
    }

    public abstract FlowInfo analyseCode(BlockScope var1, FlowContext var2, FlowInfo var3);

    protected void analyseArguments(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, MethodBinding methodBinding, Expression[] expressionArray) {
        block9: {
            int n;
            boolean bl;
            block10: {
                TypeBinding typeBinding;
                if (expressionArray == null) break block9;
                CompilerOptions compilerOptions = blockScope.compilerOptions();
                if (compilerOptions.sourceLevel >= 0x330000L && methodBinding.isPolymorphic()) {
                    return;
                }
                boolean bl2 = compilerOptions.sourceLevel >= 0x340000L && compilerOptions.isAnnotationBasedNullAnalysisEnabled;
                bl = methodBinding.parameterNonNullness != null;
                n = methodBinding.parameters.length;
                int n2 = -1;
                TypeBinding typeBinding2 = null;
                boolean bl3 = false;
                if ((bl2 || bl) && methodBinding.isVarargs()) {
                    n2 = n - 1;
                    if (n == expressionArray.length) {
                        typeBinding2 = methodBinding.parameters[n2];
                        TypeBinding typeBinding3 = expressionArray[n2].resolvedType;
                        if (typeBinding3 == TypeBinding.NULL || typeBinding2.dimensions() == typeBinding3.dimensions() && typeBinding3.isCompatibleWith(typeBinding2)) {
                            bl3 = true;
                        }
                    }
                    if (!bl3) {
                        --n;
                    }
                }
                if (!bl2) break block10;
                for (int i = 0; i < n; ++i) {
                    typeBinding = methodBinding.parameters[i];
                    Boolean bl4 = bl ? methodBinding.parameterNonNullness[i] : null;
                    this.analyseOneArgument18(blockScope, flowContext, flowInfo, typeBinding, expressionArray[i], bl4, methodBinding.original().parameters[i]);
                }
                if (bl3 || !(typeBinding2 instanceof ArrayBinding)) break block9;
                TypeBinding typeBinding4 = ((ArrayBinding)typeBinding2).elementsType();
                typeBinding = bl ? methodBinding.parameterNonNullness[n2] : null;
                for (int i = n; i < expressionArray.length; ++i) {
                    this.analyseOneArgument18(blockScope, flowContext, flowInfo, typeBinding4, expressionArray[i], (Boolean)((Object)typeBinding), methodBinding.original().parameters[n2]);
                }
                break block9;
            }
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    if (methodBinding.parameterNonNullness[i] != Boolean.TRUE) continue;
                    TypeBinding typeBinding = methodBinding.parameters[i];
                    Expression expression = expressionArray[i];
                    int n3 = expression.nullStatus(flowInfo, flowContext);
                    if (n3 == 4) continue;
                    flowContext.recordNullityMismatch(blockScope, expression, expression.resolvedType, typeBinding, n3);
                }
            }
        }
    }

    void analyseOneArgument18(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, TypeBinding typeBinding, Expression expression, Boolean bl, TypeBinding typeBinding2) {
        if (expression instanceof ConditionalExpression && expression.isPolyExpression()) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)expression;
            conditionalExpression.internalAnalyseOneArgument18(blockScope, flowContext, typeBinding, conditionalExpression.valueIfTrue, conditionalExpression.ifTrueNullStatus, bl, typeBinding2);
            conditionalExpression.internalAnalyseOneArgument18(blockScope, flowContext, typeBinding, conditionalExpression.valueIfFalse, conditionalExpression.ifFalseNullStatus, bl, typeBinding2);
            return;
        }
        int n = expression.nullStatus(flowInfo, flowContext);
        this.internalAnalyseOneArgument18(blockScope, flowContext, typeBinding, expression, n, bl, typeBinding2);
    }

    void internalAnalyseOneArgument18(BlockScope blockScope, FlowContext flowContext, TypeBinding typeBinding, Expression expression, int n, Boolean bl, TypeBinding typeBinding2) {
        int n2 = bl == Boolean.TRUE ? n : 0;
        NullAnnotationMatching nullAnnotationMatching = NullAnnotationMatching.analyse(typeBinding, expression.resolvedType, n);
        if (!nullAnnotationMatching.isAnyMismatch() && n2 != 0) {
            typeBinding = typeBinding2;
        }
        if (nullAnnotationMatching.isDefiniteMismatch() || n2 == 2) {
            blockScope.problemReporter().nullityMismatchingTypeAnnotation(expression, expression.resolvedType, typeBinding, nullAnnotationMatching);
        } else if (nullAnnotationMatching.isUnchecked() || (n2 & 0x10) != 0) {
            flowContext.recordNullityMismatch(blockScope, expression, expression.resolvedType, typeBinding, n);
        }
    }

    protected void checkAgainstNullTypeAnnotation(BlockScope blockScope, TypeBinding typeBinding, Expression expression, FlowContext flowContext, FlowInfo flowInfo) {
        if (expression instanceof ConditionalExpression && expression.isPolyExpression()) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)expression;
            this.internalCheckAgainstNullTypeAnnotation(blockScope, typeBinding, conditionalExpression.valueIfTrue, conditionalExpression.ifTrueNullStatus, flowContext);
            this.internalCheckAgainstNullTypeAnnotation(blockScope, typeBinding, conditionalExpression.valueIfFalse, conditionalExpression.ifFalseNullStatus, flowContext);
            return;
        }
        int n = expression.nullStatus(flowInfo, flowContext);
        this.internalCheckAgainstNullTypeAnnotation(blockScope, typeBinding, expression, n, flowContext);
    }

    private void internalCheckAgainstNullTypeAnnotation(BlockScope blockScope, TypeBinding typeBinding, Expression expression, int n, FlowContext flowContext) {
        NullAnnotationMatching nullAnnotationMatching = NullAnnotationMatching.analyse(typeBinding, expression.resolvedType, n);
        if (nullAnnotationMatching.isDefiniteMismatch()) {
            blockScope.problemReporter().nullityMismatchingTypeAnnotation(expression, expression.resolvedType, typeBinding, nullAnnotationMatching);
        } else if (nullAnnotationMatching.isUnchecked()) {
            flowContext.recordNullityMismatch(blockScope, expression, expression.resolvedType, typeBinding, n);
        }
    }

    public void branchChainTo(BranchLabel branchLabel) {
    }

    public int complainIfUnreachable(FlowInfo flowInfo, BlockScope blockScope, int n, boolean bl) {
        if ((flowInfo.reachMode() & 3) != 0) {
            if ((flowInfo.reachMode() & 1) != 0) {
                this.bits &= Integer.MAX_VALUE;
            }
            if (flowInfo == FlowInfo.DEAD_END) {
                if (n < 2) {
                    blockScope.problemReporter().unreachableCode(this);
                    if (bl) {
                        blockScope.checkUnclosedCloseables(flowInfo, null, null, null);
                    }
                }
                return 2;
            }
            if (n < 1) {
                blockScope.problemReporter().fakeReachable(this);
                if (bl) {
                    blockScope.checkUnclosedCloseables(flowInfo, null, null, null);
                }
            }
            return 1;
        }
        return n;
    }

    public void generateArguments(MethodBinding methodBinding, Expression[] expressionArray, BlockScope blockScope, CodeStream codeStream) {
        block10: {
            block9: {
                int n;
                if (!methodBinding.isVarargs()) break block9;
                TypeBinding[] typeBindingArray = methodBinding.parameters;
                int n2 = typeBindingArray.length;
                int n3 = n2 - 1;
                for (int i = 0; i < n3; ++i) {
                    expressionArray[i].generateCode(blockScope, codeStream, true);
                }
                ArrayBinding arrayBinding = (ArrayBinding)typeBindingArray[n3];
                ArrayBinding arrayBinding2 = (ArrayBinding)methodBinding.parameters[n3].erasure();
                int n4 = arrayBinding.elementsType().id;
                int n5 = n = expressionArray == null ? 0 : expressionArray.length;
                if (n > n2) {
                    codeStream.generateInlinedValue(n - n3);
                    codeStream.newArray(arrayBinding2);
                    for (int i = n3; i < n; ++i) {
                        codeStream.dup();
                        codeStream.generateInlinedValue(i - n3);
                        expressionArray[i].generateCode(blockScope, codeStream, true);
                        codeStream.arrayAtPut(n4, false);
                    }
                } else if (n == n2) {
                    TypeBinding typeBinding = expressionArray[n3].resolvedType;
                    if (typeBinding == TypeBinding.NULL || arrayBinding.dimensions() == typeBinding.dimensions() && typeBinding.isCompatibleWith(arrayBinding)) {
                        expressionArray[n3].generateCode(blockScope, codeStream, true);
                    } else {
                        codeStream.generateInlinedValue(1);
                        codeStream.newArray(arrayBinding2);
                        codeStream.dup();
                        codeStream.generateInlinedValue(0);
                        expressionArray[n3].generateCode(blockScope, codeStream, true);
                        codeStream.arrayAtPut(n4, false);
                    }
                } else {
                    codeStream.generateInlinedValue(0);
                    codeStream.newArray(arrayBinding2);
                }
                break block10;
            }
            if (expressionArray == null) break block10;
            int n = expressionArray.length;
            for (int i = 0; i < n; ++i) {
                expressionArray[i].generateCode(blockScope, codeStream, true);
            }
        }
    }

    public abstract void generateCode(BlockScope var1, CodeStream var2);

    public boolean isBoxingCompatible(TypeBinding typeBinding, TypeBinding typeBinding2, Expression expression, Scope scope) {
        if (scope.isBoxingCompatibleWith(typeBinding, typeBinding2)) {
            return true;
        }
        return typeBinding.isBaseType() && !typeBinding2.isBaseType() && !typeBinding2.isTypeVariable() && scope.compilerOptions().sourceLevel >= 0x310000L && (typeBinding2.id == 26 || typeBinding2.id == 27 || typeBinding2.id == 28) && expression.isConstantValueOfTypeAssignableToType(typeBinding, scope.environment().computeBoxingType(typeBinding2));
    }

    public boolean isEmptyBlock() {
        return false;
    }

    public boolean isValidJavaStatement() {
        return true;
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        return this.printStatement(n, stringBuffer);
    }

    public abstract StringBuffer printStatement(int var1, StringBuffer var2);

    public abstract void resolve(BlockScope var1);

    public Constant resolveCase(BlockScope blockScope, TypeBinding typeBinding, SwitchStatement switchStatement) {
        this.resolve(blockScope);
        return Constant.NotAConstant;
    }

    public TypeBinding invocationTargetType() {
        return null;
    }

    public TypeBinding expectedType() {
        return this.invocationTargetType();
    }

    public ExpressionContext getExpressionContext() {
        return ExpressionContext.VANILLA_CONTEXT;
    }

    protected MethodBinding findConstructorBinding(BlockScope blockScope, Invocation invocation, ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray) {
        MethodBinding methodBinding = blockScope.getConstructor(referenceBinding, typeBindingArray, invocation);
        Statement.resolvePolyExpressionArguments(invocation, methodBinding, typeBindingArray, blockScope);
        return methodBinding;
    }

    protected void recordExceptionsForEnclosingLambda(BlockScope blockScope, TypeBinding ... typeBindingArray) {
        MethodScope methodScope = blockScope.methodScope();
        if (methodScope != null && methodScope.referenceContext instanceof LambdaExpression) {
            LambdaExpression lambdaExpression = (LambdaExpression)methodScope.referenceContext;
            for (int i = 0; i < typeBindingArray.length; ++i) {
                lambdaExpression.throwsException(typeBindingArray[i]);
            }
        }
    }
}

