/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.DontInline;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeForm;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sun.invoke.util.Wrapper;

class LambdaForm {
    final int arity;
    final int result;
    final Name[] names;
    final String debugName;
    MemberName vmentry;
    private boolean isCompiled;
    LambdaForm[] bindCache;
    public static final int VOID_RESULT = -1;
    public static final int LAST_RESULT = -2;
    private static final ConcurrentHashMap<String, LambdaForm> PREPARED_FORMS;
    private static final boolean USE_PREDEFINED_INTERPRET_METHODS = true;
    private static final int COMPILE_THRESHOLD;
    private int invocationCounter = 0;
    static final String ALL_TYPES = "LIJFD";
    static final int INTERNED_ARGUMENT_LIMIT = 10;
    private static final Name[][] INTERNED_ARGUMENTS;
    private static final MemberName.Factory IMPL_NAMES;
    private static final Name[] CONSTANT_ZERO;

    LambdaForm(String debugName, int arity, Name[] names, int result) {
        assert (LambdaForm.namesOK(arity, names));
        this.arity = arity;
        this.result = LambdaForm.fixResult(result, names);
        this.names = (Name[])names.clone();
        this.debugName = debugName;
        this.normalize();
    }

    LambdaForm(String debugName, int arity, Name[] names) {
        this(debugName, arity, names, -2);
    }

    LambdaForm(String debugName, Name[] formals, Name[] temps, Name result) {
        this(debugName, formals.length, LambdaForm.buildNames(formals, temps, result), -2);
    }

    private static Name[] buildNames(Name[] formals, Name[] temps, Name result) {
        int arity = formals.length;
        int length = arity + temps.length + (result == null ? 0 : 1);
        Name[] names = Arrays.copyOf(formals, length);
        System.arraycopy(temps, 0, names, arity, temps.length);
        if (result != null) {
            names[length - 1] = result;
        }
        return names;
    }

    private LambdaForm(String sig) {
        assert (LambdaForm.isValidSignature(sig));
        this.arity = LambdaForm.signatureArity(sig);
        this.result = LambdaForm.signatureReturn(sig) == 'V' ? -1 : this.arity;
        this.names = LambdaForm.buildEmptyNames(this.arity, sig);
        this.debugName = "LF.zero";
        assert (this.nameRefsAreLegal());
        assert (this.isEmpty());
        assert (sig.equals(this.basicTypeSignature()));
    }

    private static Name[] buildEmptyNames(int arity, String basicTypeSignature) {
        assert (LambdaForm.isValidSignature(basicTypeSignature));
        int resultPos = arity + 1;
        if (arity < 0 || basicTypeSignature.length() != resultPos + 1) {
            throw new IllegalArgumentException("bad arity for " + basicTypeSignature);
        }
        int numRes = basicTypeSignature.charAt(resultPos) == 'V' ? 0 : 1;
        Name[] names = LambdaForm.arguments(numRes, basicTypeSignature.substring(0, arity));
        for (int i = 0; i < numRes; ++i) {
            names[arity + i] = LambdaForm.constantZero(arity + i, basicTypeSignature.charAt(resultPos + i));
        }
        return names;
    }

    private static int fixResult(int result, Name[] names) {
        if (result >= 0) {
            if (names[result].type == 'V') {
                return -1;
            }
        } else if (result == -2) {
            return names.length - 1;
        }
        return result;
    }

    private static boolean namesOK(int arity, Name[] names) {
        for (int i = 0; i < names.length; ++i) {
            Name n = names[i];
            assert (n != null) : "n is null";
            if (i < arity) {
                assert (n.isParam()) : n + " is not param at " + i;
                continue;
            }
            assert (!n.isParam()) : n + " is param at " + i;
        }
        return true;
    }

    private void normalize() {
        int i;
        Name[] oldNames = null;
        int changesStart = 0;
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            Name n = this.names[i2];
            if (n.initIndex(i2)) continue;
            if (oldNames == null) {
                oldNames = (Name[])this.names.clone();
                changesStart = i2;
            }
            this.names[i2] = n.cloneWithIndex(i2);
        }
        if (oldNames != null) {
            int startFixing = this.arity;
            if (startFixing <= changesStart) {
                startFixing = changesStart + 1;
            }
            for (int i3 = startFixing; i3 < this.names.length; ++i3) {
                Name fixed = this.names[i3].replaceNames(oldNames, this.names, changesStart, i3);
                this.names[i3] = fixed.newIndex(i3);
            }
        }
        assert (this.nameRefsAreLegal());
        int maxInterned = Math.min(this.arity, 10);
        boolean needIntern = false;
        for (i = 0; i < maxInterned; ++i) {
            Name n = this.names[i];
            Name n2 = LambdaForm.internArgument(n);
            if (n == n2) continue;
            this.names[i] = n2;
            needIntern = true;
        }
        if (needIntern) {
            for (i = this.arity; i < this.names.length; ++i) {
                this.names[i].internArguments();
            }
            assert (this.nameRefsAreLegal());
        }
    }

    private boolean nameRefsAreLegal() {
        Name n;
        int i;
        assert (this.arity >= 0 && this.arity <= this.names.length);
        assert (this.result >= -1 && this.result < this.names.length);
        for (i = 0; i < this.arity; ++i) {
            n = this.names[i];
            assert (n.index() == i) : Arrays.asList(n.index(), i);
            assert (n.isParam());
        }
        for (i = this.arity; i < this.names.length; ++i) {
            n = this.names[i];
            assert (n.index() == i);
            for (Object arg : n.arguments) {
                if (!(arg instanceof Name)) continue;
                Name n2 = (Name)arg;
                short i2 = n2.index;
                assert (0 <= i2 && i2 < this.names.length) : n.debugString() + ": 0 <= i2 && i2 < names.length: 0 <= " + i2 + " < " + this.names.length;
                assert (this.names[i2] == n2) : Arrays.asList("-1-", i, "-2-", n.debugString(), "-3-", i2, "-4-", n2.debugString(), "-5-", this.names[i2].debugString(), "-6-", this);
                assert (i2 < i);
            }
        }
        return true;
    }

    char returnType() {
        if (this.result < 0) {
            return 'V';
        }
        Name n = this.names[this.result];
        return n.type;
    }

    char parameterType(int n) {
        assert (n < this.arity);
        return this.names[n].type;
    }

    int arity() {
        return this.arity;
    }

    MethodType methodType() {
        return LambdaForm.signatureType(this.basicTypeSignature());
    }

    final String basicTypeSignature() {
        StringBuilder buf = new StringBuilder(this.arity() + 3);
        int a = this.arity();
        for (int i = 0; i < a; ++i) {
            buf.append(this.parameterType(i));
        }
        return buf.append('_').append(this.returnType()).toString();
    }

    static int signatureArity(String sig) {
        assert (LambdaForm.isValidSignature(sig));
        return sig.indexOf(95);
    }

    static char signatureReturn(String sig) {
        return sig.charAt(LambdaForm.signatureArity(sig) + 1);
    }

    static boolean isValidSignature(String sig) {
        int arity = sig.indexOf(95);
        if (arity < 0) {
            return false;
        }
        int siglen = sig.length();
        if (siglen != arity + 2) {
            return false;
        }
        for (int i = 0; i < siglen; ++i) {
            if (i == arity) continue;
            char c = sig.charAt(i);
            if (c == 'V') {
                return i == siglen - 1 && arity == siglen - 2;
            }
            if (ALL_TYPES.indexOf(c) >= 0) continue;
            return false;
        }
        return true;
    }

    static Class<?> typeClass(char t) {
        switch (t) {
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'L': {
                return Object.class;
            }
            case 'V': {
                return Void.TYPE;
            }
        }
        assert (false);
        return null;
    }

    static MethodType signatureType(String sig) {
        Class[] ptypes = new Class[LambdaForm.signatureArity(sig)];
        for (int i = 0; i < ptypes.length; ++i) {
            ptypes[i] = LambdaForm.typeClass(sig.charAt(i));
        }
        Class<?> rtype = LambdaForm.typeClass(LambdaForm.signatureReturn(sig));
        return MethodType.methodType(rtype, ptypes);
    }

    public void prepare() {
        if (COMPILE_THRESHOLD == 0) {
            this.compileToBytecode();
        }
        if (this.vmentry != null) {
            return;
        }
        LambdaForm prep = LambdaForm.getPreparedForm(this.basicTypeSignature());
        this.vmentry = prep.vmentry;
    }

    MemberName compileToBytecode() {
        MethodType invokerType = this.methodType();
        assert (this.vmentry == null || this.vmentry.getMethodType().basicType().equals((Object)invokerType));
        if (this.vmentry != null && this.isCompiled) {
            return this.vmentry;
        }
        try {
            this.vmentry = InvokerBytecodeGenerator.generateCustomizedCode(this, invokerType);
            if (MethodHandleStatics.TRACE_INTERPRETER) {
                LambdaForm.traceInterpreter("compileToBytecode", this);
            }
            this.isCompiled = true;
            return this.vmentry;
        }
        catch (Error | Exception ex) {
            throw MethodHandleStatics.newInternalError(this.toString(), ex);
        }
    }

    private static Map<String, LambdaForm> computeInitialPreparedForms() {
        HashMap<String, LambdaForm> forms = new HashMap<String, LambdaForm>();
        for (MemberName m : MemberName.getFactory().getMethods(LambdaForm.class, false, null, null, null)) {
            MethodType mt;
            if (!m.isStatic() || !m.isPackage() || (mt = m.getMethodType()).parameterCount() <= 0 || mt.parameterType(0) != MethodHandle.class || !m.getName().startsWith("interpret_")) continue;
            String sig = LambdaForm.basicTypeSignature(mt);
            assert (m.getName().equals("interpret" + sig.substring(sig.indexOf(95))));
            LambdaForm form = new LambdaForm(sig);
            form.vmentry = m;
            mt.form().setCachedLambdaForm(7, form);
            forms.put(sig, form);
        }
        return forms;
    }

    static Object interpret_L(MethodHandle mh) throws Throwable {
        Object[] av = new Object[]{mh};
        String sig = null;
        if (!$assertionsDisabled) {
            sig = "L_L";
            if (!LambdaForm.argumentTypesMatch("L_L", av)) {
                throw new AssertionError();
            }
        }
        Object res = mh.form.interpretWithArguments(av);
        assert (LambdaForm.returnTypesMatch(sig, av, res));
        return res;
    }

    static Object interpret_L(MethodHandle mh, Object x1) throws Throwable {
        Object[] av = new Object[]{mh, x1};
        String sig = null;
        if (!$assertionsDisabled) {
            sig = "LL_L";
            if (!LambdaForm.argumentTypesMatch("LL_L", av)) {
                throw new AssertionError();
            }
        }
        Object res = mh.form.interpretWithArguments(av);
        assert (LambdaForm.returnTypesMatch(sig, av, res));
        return res;
    }

    static Object interpret_L(MethodHandle mh, Object x1, Object x2) throws Throwable {
        Object[] av = new Object[]{mh, x1, x2};
        String sig = null;
        if (!$assertionsDisabled) {
            sig = "LLL_L";
            if (!LambdaForm.argumentTypesMatch("LLL_L", av)) {
                throw new AssertionError();
            }
        }
        Object res = mh.form.interpretWithArguments(av);
        assert (LambdaForm.returnTypesMatch(sig, av, res));
        return res;
    }

    private static LambdaForm getPreparedForm(String sig) {
        MethodType mtype = LambdaForm.signatureType(sig);
        LambdaForm prep = mtype.form().cachedLambdaForm(6);
        if (prep != null) {
            return prep;
        }
        assert (LambdaForm.isValidSignature(sig));
        prep = new LambdaForm(sig);
        prep.vmentry = InvokerBytecodeGenerator.generateLambdaFormInterpreterEntryPoint(sig);
        return mtype.form().setCachedLambdaForm(6, prep);
    }

    private static boolean argumentTypesMatch(String sig, Object[] av) {
        int arity = LambdaForm.signatureArity(sig);
        assert (av.length == arity) : "av.length == arity: av.length=" + av.length + ", arity=" + arity;
        assert (av[0] instanceof MethodHandle) : "av[0] not instace of MethodHandle: " + av[0];
        MethodHandle mh = (MethodHandle)av[0];
        MethodType mt = mh.type();
        assert (mt.parameterCount() == arity - 1);
        for (int i = 0; i < av.length; ++i) {
            Class<MethodHandle> pt;
            Class clazz = pt = i == 0 ? MethodHandle.class : mt.parameterType(i - 1);
            assert (LambdaForm.valueMatches(sig.charAt(i), pt, av[i]));
        }
        return true;
    }

    private static boolean valueMatches(char tc, Class<?> type, Object x) {
        if (type == Void.TYPE) {
            tc = (char)86;
        }
        assert (tc == LambdaForm.basicType(type)) : tc + " == basicType(" + type + ")=" + LambdaForm.basicType(type);
        switch (tc) {
            case 'I': {
                assert (LambdaForm.checkInt(type, x)) : "checkInt(" + type + "," + x + ")";
                break;
            }
            case 'J': {
                assert (x instanceof Long) : "instanceof Long: " + x;
                break;
            }
            case 'F': {
                assert (x instanceof Float) : "instanceof Float: " + x;
                break;
            }
            case 'D': {
                assert (x instanceof Double) : "instanceof Double: " + x;
                break;
            }
            case 'L': {
                assert (LambdaForm.checkRef(type, x)) : "checkRef(" + type + "," + x + ")";
                break;
            }
            case 'V': {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return true;
    }

    private static boolean returnTypesMatch(String sig, Object[] av, Object res) {
        MethodHandle mh = (MethodHandle)av[0];
        return LambdaForm.valueMatches(LambdaForm.signatureReturn(sig), mh.type().returnType(), res);
    }

    private static boolean checkInt(Class<?> type, Object x) {
        assert (x instanceof Integer);
        if (type == Integer.TYPE) {
            return true;
        }
        Wrapper w = Wrapper.forBasicType(type);
        assert (w.isSubwordOrInt());
        Object x1 = Wrapper.INT.wrap(w.wrap(x));
        return x.equals(x1);
    }

    private static boolean checkRef(Class<?> type, Object x) {
        assert (!type.isPrimitive());
        if (x == null) {
            return true;
        }
        if (type.isInterface()) {
            return true;
        }
        return type.isInstance(x);
    }

    @Hidden
    @DontInline
    Object interpretWithArguments(Object ... argumentValues) throws Throwable {
        if (MethodHandleStatics.TRACE_INTERPRETER) {
            return this.interpretWithArgumentsTracing(argumentValues);
        }
        this.checkInvocationCounter();
        assert (this.arityCheck(argumentValues));
        Object[] values = Arrays.copyOf(argumentValues, this.names.length);
        for (int i = argumentValues.length; i < values.length; ++i) {
            values[i] = this.interpretName(this.names[i], values);
        }
        return this.result < 0 ? null : values[this.result];
    }

    @Hidden
    @DontInline
    Object interpretName(Name name, Object[] values) throws Throwable {
        if (MethodHandleStatics.TRACE_INTERPRETER) {
            LambdaForm.traceInterpreter("| interpretName", name.debugString(), null);
        }
        Object[] arguments = Arrays.copyOf(name.arguments, name.arguments.length, Object[].class);
        for (int i = 0; i < arguments.length; ++i) {
            Object a = arguments[i];
            if (!(a instanceof Name)) continue;
            int i2 = ((Name)a).index();
            assert (this.names[i2] == a);
            a = values[i2];
            arguments[i] = a;
        }
        return name.function.invokeWithArguments(arguments);
    }

    private void checkInvocationCounter() {
        if (COMPILE_THRESHOLD != 0 && this.invocationCounter < COMPILE_THRESHOLD) {
            ++this.invocationCounter;
            if (this.invocationCounter >= COMPILE_THRESHOLD) {
                this.compileToBytecode();
            }
        }
    }

    Object interpretWithArgumentsTracing(Object ... argumentValues) throws Throwable {
        Object rval;
        LambdaForm.traceInterpreter("[ interpretWithArguments", this, argumentValues);
        if (this.invocationCounter < COMPILE_THRESHOLD) {
            int ctr = this.invocationCounter++;
            LambdaForm.traceInterpreter("| invocationCounter", ctr);
            if (this.invocationCounter >= COMPILE_THRESHOLD) {
                this.compileToBytecode();
            }
        }
        try {
            assert (this.arityCheck(argumentValues));
            Object[] values = Arrays.copyOf(argumentValues, this.names.length);
            for (int i = argumentValues.length; i < values.length; ++i) {
                values[i] = this.interpretName(this.names[i], values);
            }
            rval = this.result < 0 ? null : values[this.result];
        }
        catch (Throwable ex) {
            LambdaForm.traceInterpreter("] throw =>", ex);
            throw ex;
        }
        LambdaForm.traceInterpreter("] return =>", rval);
        return rval;
    }

    static void traceInterpreter(String event, Object obj, Object ... args) {
        if (!MethodHandleStatics.TRACE_INTERPRETER) {
            return;
        }
        System.out.println("LFI: " + event + " " + (obj != null ? obj : "") + (args != null && args.length != 0 ? Arrays.asList(args) : ""));
    }

    static void traceInterpreter(String event, Object obj) {
        LambdaForm.traceInterpreter(event, obj, null);
    }

    private boolean arityCheck(Object[] argumentValues) {
        assert (argumentValues.length == this.arity) : this.arity + "!=" + Arrays.asList(argumentValues) + ".length";
        assert (argumentValues[0] instanceof MethodHandle) : "not MH: " + argumentValues[0];
        assert (((MethodHandle)argumentValues[0]).internalForm() == this);
        return true;
    }

    private boolean isEmpty() {
        if (this.result < 0) {
            return this.names.length == this.arity;
        }
        if (this.result == this.arity && this.names.length == this.arity + 1) {
            return this.names[this.arity].isConstantZero();
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.debugName + "=Lambda(");
        for (int i = 0; i < this.names.length; ++i) {
            if (i == this.arity) {
                buf.append(")=>{");
            }
            Name n = this.names[i];
            if (i >= this.arity) {
                buf.append("\n    ");
            }
            buf.append(n);
            if (i < this.arity) {
                if (i + 1 >= this.arity) continue;
                buf.append(",");
                continue;
            }
            buf.append("=").append(n.exprString());
            buf.append(";");
        }
        buf.append(this.result < 0 ? "void" : this.names[this.result]).append("}");
        if (MethodHandleStatics.TRACE_INTERPRETER) {
            buf.append(":").append(this.basicTypeSignature());
            buf.append("/").append(this.vmentry);
        }
        return buf.toString();
    }

    LambdaForm bindImmediate(int pos, char basicType, Object value) {
        assert (pos > 0 && pos < this.arity && this.names[pos].type == basicType && Name.typesMatch(basicType, value));
        int arity2 = this.arity - 1;
        Name[] names2 = new Name[this.names.length - 1];
        int r = 0;
        int w = 0;
        while (r < this.names.length) {
            Name n = this.names[r];
            if (n.isParam()) {
                if (n.index == pos) {
                    --w;
                } else {
                    names2[w] = new Name(w, n.type);
                }
            } else {
                Object[] arguments2 = new Object[n.arguments.length];
                for (int i = 0; i < n.arguments.length; ++i) {
                    Object arg = n.arguments[i];
                    if (arg instanceof Name) {
                        short ni = ((Name)arg).index;
                        if (ni == pos) {
                            arguments2[i] = value;
                            continue;
                        }
                        if (ni < pos) {
                            arguments2[i] = names2[ni];
                            continue;
                        }
                        arguments2[i] = names2[ni - 1];
                        continue;
                    }
                    arguments2[i] = arg;
                }
                names2[w] = new Name(n.function, arguments2);
                names2[w].initIndex(w);
            }
            ++r;
            ++w;
        }
        int result2 = this.result == -1 ? -1 : this.result - 1;
        return new LambdaForm(this.debugName, arity2, names2, result2);
    }

    LambdaForm bind(int namePos, BoundMethodHandle.SpeciesData oldData) {
        Name name = this.names[namePos];
        BoundMethodHandle.SpeciesData newData = oldData.extendWithType(name.type);
        return this.bind(name, newData.getterName(this.names[0], oldData.fieldCount()), oldData, newData);
    }

    LambdaForm bind(Name name, Name binding, BoundMethodHandle.SpeciesData oldData, BoundMethodHandle.SpeciesData newData) {
        Name n;
        int i;
        int pos = name.index;
        assert (name.isParam());
        assert (!binding.isParam());
        assert (name.type == binding.type);
        assert (0 <= pos && pos < this.arity && this.names[pos] == name);
        assert (binding.function.memberDeclaringClassOrNull() == newData.clazz);
        assert (oldData.getters.length == newData.getters.length - 1);
        if (this.bindCache != null) {
            LambdaForm form = this.bindCache[pos];
            if (form != null) {
                assert (form.contains(binding)) : "form << " + form + " >> does not contain binding << " + binding + " >>";
                return form;
            }
        } else {
            this.bindCache = new LambdaForm[this.arity];
        }
        assert (this.nameRefsAreLegal());
        int arity2 = this.arity - 1;
        Name[] names2 = (Name[])this.names.clone();
        names2[pos] = binding;
        int firstOldRef = -1;
        for (i = 0; i < names2.length; ++i) {
            Name n2;
            n = this.names[i];
            if (n.function == null || n.function.memberDeclaringClassOrNull() != oldData.clazz) continue;
            MethodHandle oldGetter = n.function.resolvedHandle;
            MethodHandle newGetter = null;
            for (int j = 0; j < oldData.getters.length; ++j) {
                if (oldGetter != oldData.getters[j]) continue;
                newGetter = newData.getters[j];
            }
            if (newGetter == null) continue;
            if (firstOldRef < 0) {
                firstOldRef = i;
            }
            names2[i] = n2 = new Name(newGetter, n.arguments);
        }
        assert (firstOldRef < 0 || firstOldRef > pos);
        for (i = pos + 1; i < names2.length; ++i) {
            if (i <= arity2) continue;
            names2[i] = names2[i].replaceNames(this.names, names2, pos, i);
        }
        int insPos = pos;
        while (insPos + 1 < names2.length && (n = names2[insPos + 1]).isSiblingBindingBefore(binding)) {
            names2[insPos] = n;
            ++insPos;
        }
        names2[insPos] = binding;
        int result2 = this.result;
        if (result2 == pos) {
            result2 = insPos;
        } else if (result2 > pos && result2 <= insPos) {
            --result2;
        }
        this.bindCache[pos] = new LambdaForm(this.debugName, arity2, names2, result2);
        return this.bindCache[pos];
    }

    boolean contains(Name name) {
        int pos = name.index();
        if (pos >= 0) {
            return pos < this.names.length && name.equals(this.names[pos]);
        }
        for (int i = this.arity; i < this.names.length; ++i) {
            if (!name.equals(this.names[i])) continue;
            return true;
        }
        return false;
    }

    LambdaForm addArguments(int pos, char ... types) {
        assert (pos <= this.arity);
        int length = this.names.length;
        int inTypes = types.length;
        Name[] names2 = Arrays.copyOf(this.names, length + inTypes);
        int arity2 = this.arity + inTypes;
        int result2 = this.result;
        if (result2 >= this.arity) {
            result2 += inTypes;
        }
        int argpos = pos + 1;
        System.arraycopy(this.names, argpos, names2, argpos + inTypes, length - argpos);
        for (int i = 0; i < inTypes; ++i) {
            names2[argpos + i] = new Name(types[i]);
        }
        return new LambdaForm(this.debugName, arity2, names2, result2);
    }

    LambdaForm addArguments(int pos, List<Class<?>> types) {
        char[] basicTypes = new char[types.size()];
        for (int i = 0; i < basicTypes.length; ++i) {
            basicTypes[i] = LambdaForm.basicType(types.get(i));
        }
        return this.addArguments(pos, basicTypes);
    }

    LambdaForm permuteArguments(int skip, int[] reorder, char[] types) {
        int k;
        Name n2;
        int j;
        int pos;
        int length = this.names.length;
        int inTypes = types.length;
        int outArgs = reorder.length;
        assert (skip + outArgs == this.arity);
        assert (LambdaForm.permutedTypesMatch(reorder, types, this.names, skip));
        for (pos = 0; pos < outArgs && reorder[pos] == pos; ++pos) {
        }
        Name[] names2 = new Name[length - outArgs + inTypes];
        System.arraycopy(this.names, 0, names2, 0, skip + pos);
        int bodyLength = length - this.arity;
        System.arraycopy(this.names, skip + outArgs, names2, skip + inTypes, bodyLength);
        int arity2 = names2.length - bodyLength;
        int result2 = this.result;
        if (result2 >= 0) {
            result2 = result2 < skip + outArgs ? reorder[result2 - skip] : result2 - outArgs + inTypes;
        }
        for (j = pos; j < outArgs; ++j) {
            Name n = this.names[skip + j];
            int i = reorder[j];
            n2 = names2[skip + i];
            if (n2 == null) {
                names2[skip + i] = n2 = new Name(types[i]);
            } else assert (n2.type == types[i]);
            for (k = arity2; k < names2.length; ++k) {
                names2[k] = names2[k].replaceName(n, n2);
            }
        }
        for (int i = skip + pos; i < arity2; ++i) {
            if (names2[i] != null) continue;
            names2[i] = LambdaForm.argument(i, types[i - skip]);
        }
        for (j = this.arity; j < this.names.length; ++j) {
            Name n = this.names[j];
            int i = j - this.arity + arity2;
            n2 = names2[i];
            if (n == n2) continue;
            for (k = i + 1; k < names2.length; ++k) {
                names2[k] = names2[k].replaceName(n, n2);
            }
        }
        return new LambdaForm(this.debugName, arity2, names2, result2);
    }

    static boolean permutedTypesMatch(int[] reorder, char[] types, Name[] names, int skip) {
        int inTypes = types.length;
        int outArgs = reorder.length;
        for (int i = 0; i < outArgs; ++i) {
            assert (names[skip + i].isParam());
            assert (names[skip + i].type == types[reorder[i]]);
        }
        return true;
    }

    void resolve() {
        for (Name n : this.names) {
            n.resolve();
        }
    }

    public static char basicType(Class<?> type) {
        char c = Wrapper.basicTypeChar(type);
        if ("ZBSC".indexOf(c) >= 0) {
            c = 'I';
        }
        assert ("LIJFDV".indexOf(c) >= 0);
        return c;
    }

    public static char[] basicTypes(List<Class<?>> types) {
        char[] btypes = new char[types.size()];
        for (int i = 0; i < btypes.length; ++i) {
            btypes[i] = LambdaForm.basicType(types.get(i));
        }
        return btypes;
    }

    public static String basicTypeSignature(MethodType type) {
        char[] sig = new char[type.parameterCount() + 2];
        int sigp = 0;
        for (Class<?> pt : type.parameterList()) {
            sig[sigp++] = LambdaForm.basicType(pt);
        }
        sig[sigp++] = 95;
        sig[sigp++] = LambdaForm.basicType(type.returnType());
        assert (sigp == sig.length);
        return String.valueOf(sig);
    }

    static Name argument(int which, char type) {
        int tn = ALL_TYPES.indexOf(type);
        if (tn < 0 || which >= 10) {
            return new Name(which, type);
        }
        return INTERNED_ARGUMENTS[tn][which];
    }

    static Name internArgument(Name n) {
        assert (n.isParam()) : "not param: " + n;
        assert (n.index < 10);
        return LambdaForm.argument(n.index, n.type);
    }

    static Name[] arguments(int extra, String types) {
        int length = types.length();
        Name[] names = new Name[length + extra];
        for (int i = 0; i < length; ++i) {
            names[i] = LambdaForm.argument(i, types.charAt(i));
        }
        return names;
    }

    static Name[] arguments(int extra, char ... types) {
        int length = types.length;
        Name[] names = new Name[length + extra];
        for (int i = 0; i < length; ++i) {
            names[i] = LambdaForm.argument(i, types[i]);
        }
        return names;
    }

    static Name[] arguments(int extra, List<Class<?>> types) {
        int length = types.size();
        Name[] names = new Name[length + extra];
        for (int i = 0; i < length; ++i) {
            names[i] = LambdaForm.argument(i, LambdaForm.basicType(types.get(i)));
        }
        return names;
    }

    static Name[] arguments(int extra, Class<?> ... types) {
        int length = types.length;
        Name[] names = new Name[length + extra];
        for (int i = 0; i < length; ++i) {
            names[i] = LambdaForm.argument(i, LambdaForm.basicType(types[i]));
        }
        return names;
    }

    static Name[] arguments(int extra, MethodType types) {
        int length = types.parameterCount();
        Name[] names = new Name[length + extra];
        for (int i = 0; i < length; ++i) {
            names[i] = LambdaForm.argument(i, LambdaForm.basicType(types.parameterType(i)));
        }
        return names;
    }

    static Name constantZero(int which, char type) {
        return CONSTANT_ZERO[ALL_TYPES.indexOf(type)].newIndex(which);
    }

    private static int zeroI() {
        return 0;
    }

    private static long zeroJ() {
        return 0L;
    }

    private static float zeroF() {
        return 0.0f;
    }

    private static double zeroD() {
        return 0.0;
    }

    private static Object zeroL() {
        return null;
    }

    static {
        int tn;
        int capacity = 512;
        float loadFactor = 0.75f;
        int writers = 1;
        PREPARED_FORMS = new ConcurrentHashMap(capacity, loadFactor, writers);
        COMPILE_THRESHOLD = MethodHandleStatics.COMPILE_THRESHOLD != null ? MethodHandleStatics.COMPILE_THRESHOLD : 30;
        INTERNED_ARGUMENTS = new Name[ALL_TYPES.length()][10];
        for (tn = 0; tn < ALL_TYPES.length(); ++tn) {
            for (int i = 0; i < INTERNED_ARGUMENTS[tn].length; ++i) {
                char type = ALL_TYPES.charAt(tn);
                LambdaForm.INTERNED_ARGUMENTS[tn][i] = new Name(i, type);
            }
        }
        IMPL_NAMES = MemberName.getFactory();
        CONSTANT_ZERO = new Name[ALL_TYPES.length()];
        for (tn = 0; tn < ALL_TYPES.length(); ++tn) {
            char bt = ALL_TYPES.charAt(tn);
            Wrapper wrap = Wrapper.forBasicType(bt);
            MemberName zmem = new MemberName(LambdaForm.class, "zero" + bt, MethodType.methodType(wrap.primitiveType()), 6);
            try {
                zmem = IMPL_NAMES.resolveOrFail((byte)6, zmem, null, NoSuchMethodException.class);
            }
            catch (IllegalAccessException | NoSuchMethodException ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
            NamedFunction zcon = new NamedFunction(zmem);
            Name n = new Name(zcon, new Object[0]).newIndex(0);
            assert (n.type == ALL_TYPES.charAt(tn));
            LambdaForm.CONSTANT_ZERO[tn] = n;
            assert (n.isConstantZero());
        }
        PREPARED_FORMS.putAll(LambdaForm.computeInitialPreparedForms());
        NamedFunction.initializeInvokers();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Hidden {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Compiled {
    }

    static final class Name {
        final char type;
        private short index;
        final NamedFunction function;
        final Object[] arguments;

        private Name(int index, char type, NamedFunction function, Object[] arguments) {
            this.index = (short)index;
            this.type = type;
            this.function = function;
            this.arguments = arguments;
            assert (this.index == index);
        }

        Name(MethodHandle function, Object ... arguments) {
            this(new NamedFunction(function), arguments);
        }

        Name(MemberName function, Object ... arguments) {
            this(new NamedFunction(function), arguments);
        }

        Name(NamedFunction function, Object ... arguments) {
            arguments = (Object[])arguments.clone();
            this(-1, function.returnType(), function, arguments);
            assert (arguments.length == function.arity()) : "arity mismatch: arguments.length=" + arguments.length + " == function.arity()=" + function.arity() + " in " + this.debugString();
            for (int i = 0; i < arguments.length; ++i) {
                assert (Name.typesMatch(function.parameterType(i), arguments[i])) : "types don't match: function.parameterType(" + i + ")=" + function.parameterType(i) + ", arguments[" + i + "]=" + arguments[i] + " in " + this.debugString();
            }
        }

        Name(int index, char type) {
            this(index, type, null, null);
        }

        Name(char type) {
            this(-1, type);
        }

        char type() {
            return this.type;
        }

        int index() {
            return this.index;
        }

        boolean initIndex(int i) {
            if (this.index != i) {
                if (this.index != -1) {
                    return false;
                }
                this.index = (short)i;
            }
            return true;
        }

        void resolve() {
            if (this.function != null) {
                this.function.resolve();
            }
        }

        Name newIndex(int i) {
            if (this.initIndex(i)) {
                return this;
            }
            return this.cloneWithIndex(i);
        }

        Name cloneWithIndex(int i) {
            Object[] newArguments = this.arguments == null ? null : (Object[])this.arguments.clone();
            return new Name(i, this.type, this.function, newArguments);
        }

        Name replaceName(Name oldName, Name newName) {
            if (oldName == newName) {
                return this;
            }
            Object[] arguments = this.arguments;
            if (arguments == null) {
                return this;
            }
            boolean replaced = false;
            for (int j = 0; j < arguments.length; ++j) {
                if (arguments[j] != oldName) continue;
                if (!replaced) {
                    replaced = true;
                    arguments = (Object[])arguments.clone();
                }
                arguments[j] = newName;
            }
            if (!replaced) {
                return this;
            }
            return new Name(this.function, arguments);
        }

        Name replaceNames(Name[] oldNames, Name[] newNames, int start, int end) {
            Object[] arguments = this.arguments;
            boolean replaced = false;
            block0: for (int j = 0; j < arguments.length; ++j) {
                if (!(arguments[j] instanceof Name)) continue;
                Name n = (Name)arguments[j];
                short check = n.index;
                if (check >= 0 && check < newNames.length && n == newNames[check]) continue;
                for (int i = start; i < end; ++i) {
                    if (n != oldNames[i]) continue;
                    if (n == newNames[i]) continue block0;
                    if (!replaced) {
                        replaced = true;
                        arguments = (Object[])arguments.clone();
                    }
                    arguments[j] = newNames[i];
                    continue block0;
                }
            }
            if (!replaced) {
                return this;
            }
            return new Name(this.function, arguments);
        }

        void internArguments() {
            Object[] arguments = this.arguments;
            for (int j = 0; j < arguments.length; ++j) {
                Name n;
                if (!(arguments[j] instanceof Name) || !(n = (Name)arguments[j]).isParam() || n.index >= 10) continue;
                arguments[j] = LambdaForm.internArgument(n);
            }
        }

        boolean isParam() {
            return this.function == null;
        }

        boolean isConstantZero() {
            return !this.isParam() && this.arguments.length == 0 && this.function.equals(LambdaForm.constantZero((int)0, (char)this.type).function);
        }

        public String toString() {
            return (this.isParam() ? "a" : "t") + (this.index >= 0 ? this.index : System.identityHashCode(this)) + ":" + this.type;
        }

        public String debugString() {
            String s = this.toString();
            return this.function == null ? s : s + "=" + this.exprString();
        }

        public String exprString() {
            if (this.function == null) {
                return "null";
            }
            StringBuilder buf = new StringBuilder(this.function.toString());
            buf.append("(");
            String cma = "";
            for (Object a : this.arguments) {
                buf.append(cma);
                cma = ",";
                if (a instanceof Name || a instanceof Integer) {
                    buf.append(a);
                    continue;
                }
                buf.append("(").append(a).append(")");
            }
            buf.append(")");
            return buf.toString();
        }

        private static boolean typesMatch(char parameterType, Object object) {
            if (object instanceof Name) {
                return ((Name)object).type == parameterType;
            }
            switch (parameterType) {
                case 'I': {
                    return object instanceof Integer;
                }
                case 'J': {
                    return object instanceof Long;
                }
                case 'F': {
                    return object instanceof Float;
                }
                case 'D': {
                    return object instanceof Double;
                }
            }
            assert (parameterType == 'L');
            return true;
        }

        boolean isSiblingBindingBefore(Name binding) {
            assert (!binding.isParam());
            if (this.isParam()) {
                return true;
            }
            if (this.function.equals(binding.function) && this.arguments.length == binding.arguments.length) {
                boolean sawInt = false;
                for (int i = 0; i < this.arguments.length; ++i) {
                    Object a1 = this.arguments[i];
                    Object a2 = binding.arguments[i];
                    if (a1.equals(a2)) continue;
                    if (a1 instanceof Integer && a2 instanceof Integer) {
                        if (sawInt) continue;
                        sawInt = true;
                        if ((Integer)a1 < (Integer)a2) continue;
                    }
                    return false;
                }
                return sawInt;
            }
            return false;
        }

        public boolean equals(Name that) {
            if (this == that) {
                return true;
            }
            if (this.isParam()) {
                return false;
            }
            return this.type == that.type && this.function.equals(that.function) && Arrays.equals(this.arguments, that.arguments);
        }

        public boolean equals(Object x) {
            return x instanceof Name && this.equals((Name)x);
        }

        public int hashCode() {
            if (this.isParam()) {
                return this.index | this.type << 8;
            }
            return this.function.hashCode() ^ Arrays.hashCode(this.arguments);
        }
    }

    static class NamedFunction {
        final MemberName member;
        MethodHandle resolvedHandle;
        MethodHandle invoker;
        static final MethodType INVOKER_METHOD_TYPE = MethodType.methodType(Object.class, MethodHandle.class, Object[].class);

        NamedFunction(MethodHandle resolvedHandle) {
            this(resolvedHandle.internalMemberName(), resolvedHandle);
        }

        NamedFunction(MemberName member, MethodHandle resolvedHandle) {
            this.member = member;
            this.resolvedHandle = resolvedHandle;
        }

        NamedFunction(Method method) {
            this(new MemberName(method));
        }

        NamedFunction(Field field) {
            this(new MemberName(field));
        }

        NamedFunction(MemberName member) {
            this.member = member;
            this.resolvedHandle = null;
        }

        MethodHandle resolvedHandle() {
            if (this.resolvedHandle == null) {
                this.resolve();
            }
            return this.resolvedHandle;
        }

        void resolve() {
            this.resolvedHandle = DirectMethodHandle.make(this.member);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof NamedFunction)) {
                return false;
            }
            NamedFunction that = (NamedFunction)other;
            return this.member != null && this.member.equals(that.member);
        }

        public int hashCode() {
            if (this.member != null) {
                return this.member.hashCode();
            }
            return super.hashCode();
        }

        static void initializeInvokers() {
            for (MemberName m : MemberName.getFactory().getMethods(NamedFunction.class, false, null, null, null)) {
                MethodType type;
                if (!m.isStatic() || !m.isPackage() || !(type = m.getMethodType()).equals((Object)INVOKER_METHOD_TYPE) || !m.getName().startsWith("invoke_")) continue;
                String sig = m.getName().substring("invoke_".length());
                int arity = LambdaForm.signatureArity(sig);
                MethodType srcType = MethodType.genericMethodType(arity);
                if (LambdaForm.signatureReturn(sig) == 'V') {
                    srcType = srcType.changeReturnType(Void.TYPE);
                }
                MethodTypeForm typeForm = srcType.form();
                typeForm.namedFunctionInvoker = DirectMethodHandle.make(m);
            }
        }

        @Hidden
        static Object invoke__V(MethodHandle mh, Object[] a) throws Throwable {
            assert (a.length == 0);
            mh.invokeBasic();
            return null;
        }

        @Hidden
        static Object invoke_L_V(MethodHandle mh, Object[] a) throws Throwable {
            assert (a.length == 1);
            mh.invokeBasic(a[0]);
            return null;
        }

        @Hidden
        static Object invoke_LL_V(MethodHandle mh, Object[] a) throws Throwable {
            assert (a.length == 2);
            mh.invokeBasic(a[0], a[1]);
            return null;
        }

        @Hidden
        static Object invoke_LLL_V(MethodHandle mh, Object[] a) throws Throwable {
            assert (a.length == 3);
            mh.invokeBasic(a[0], a[1], a[2]);
            return null;
        }

        @Hidden
        static Object invoke_LLLL_V(MethodHandle mh, Object[] a) throws Throwable {
            assert (a.length == 4);
            mh.invokeBasic(a[0], a[1], a[2], a[3]);
            return null;
        }

        @Hidden
        static Object invoke_LLLLL_V(MethodHandle mh, Object[] a) throws Throwable {
            assert (a.length == 5);
            mh.invokeBasic(a[0], a[1], a[2], a[3], a[4]);
            return null;
        }

        @Hidden
        static Object invoke__L(MethodHandle mh, Object[] a) throws Throwable {
            assert (a.length == 0);
            return mh.invokeBasic();
        }

        @Hidden
        static Object invoke_L_L(MethodHandle mh, Object[] a) throws Throwable {
            assert (a.length == 1);
            return mh.invokeBasic(a[0]);
        }

        @Hidden
        static Object invoke_LL_L(MethodHandle mh, Object[] a) throws Throwable {
            assert (a.length == 2);
            return mh.invokeBasic(a[0], a[1]);
        }

        @Hidden
        static Object invoke_LLL_L(MethodHandle mh, Object[] a) throws Throwable {
            assert (a.length == 3);
            return mh.invokeBasic(a[0], a[1], a[2]);
        }

        @Hidden
        static Object invoke_LLLL_L(MethodHandle mh, Object[] a) throws Throwable {
            assert (a.length == 4);
            return mh.invokeBasic(a[0], a[1], a[2], a[3]);
        }

        @Hidden
        static Object invoke_LLLLL_L(MethodHandle mh, Object[] a) throws Throwable {
            assert (a.length == 5);
            return mh.invokeBasic(a[0], a[1], a[2], a[3], a[4]);
        }

        private static MethodHandle computeInvoker(MethodTypeForm typeForm) {
            MethodHandle mh = typeForm.namedFunctionInvoker;
            if (mh != null) {
                return mh;
            }
            MemberName invoker = InvokerBytecodeGenerator.generateNamedFunctionInvoker(typeForm);
            mh = DirectMethodHandle.make(invoker);
            MethodHandle mh2 = typeForm.namedFunctionInvoker;
            if (mh2 != null) {
                return mh2;
            }
            if (!mh.type().equals((Object)INVOKER_METHOD_TYPE)) {
                throw new InternalError(mh.debugString());
            }
            typeForm.namedFunctionInvoker = mh;
            return typeForm.namedFunctionInvoker;
        }

        @Hidden
        Object invokeWithArguments(Object ... arguments) throws Throwable {
            if (MethodHandleStatics.TRACE_INTERPRETER) {
                return this.invokeWithArgumentsTracing(arguments);
            }
            assert (NamedFunction.checkArgumentTypes(arguments, this.methodType()));
            return this.invoker().invokeBasic(this.resolvedHandle(), arguments);
        }

        @Hidden
        Object invokeWithArgumentsTracing(Object[] arguments) throws Throwable {
            Object rval;
            try {
                LambdaForm.traceInterpreter("[ call", this, arguments);
                if (this.invoker == null) {
                    LambdaForm.traceInterpreter("| getInvoker", this);
                    this.invoker();
                }
                if (this.resolvedHandle == null) {
                    LambdaForm.traceInterpreter("| resolve", this);
                    this.resolvedHandle();
                }
                assert (NamedFunction.checkArgumentTypes(arguments, this.methodType()));
                rval = this.invoker().invokeBasic(this.resolvedHandle(), arguments);
            }
            catch (Throwable ex) {
                LambdaForm.traceInterpreter("] throw =>", ex);
                throw ex;
            }
            LambdaForm.traceInterpreter("] return =>", rval);
            return rval;
        }

        private MethodHandle invoker() {
            if (this.invoker != null) {
                return this.invoker;
            }
            this.invoker = NamedFunction.computeInvoker(this.methodType().form());
            return this.invoker;
        }

        private static boolean checkArgumentTypes(Object[] arguments, MethodType methodType) {
            return true;
        }

        String basicTypeSignature() {
            return LambdaForm.basicTypeSignature(this.methodType());
        }

        MethodType methodType() {
            if (this.resolvedHandle != null) {
                return this.resolvedHandle.type();
            }
            return this.member.getInvocationType();
        }

        MemberName member() {
            assert (this.assertMemberIsConsistent());
            return this.member;
        }

        private boolean assertMemberIsConsistent() {
            if (this.resolvedHandle instanceof DirectMethodHandle) {
                MemberName m = this.resolvedHandle.internalMemberName();
                assert (m.equals(this.member));
            }
            return true;
        }

        Class<?> memberDeclaringClassOrNull() {
            return this.member == null ? null : this.member.getDeclaringClass();
        }

        char returnType() {
            return LambdaForm.basicType(this.methodType().returnType());
        }

        char parameterType(int n) {
            return LambdaForm.basicType(this.methodType().parameterType(n));
        }

        int arity() {
            return this.methodType().parameterCount();
        }

        public String toString() {
            if (this.member == null) {
                return this.resolvedHandle.toString();
            }
            return this.member.getDeclaringClass().getSimpleName() + "." + this.member.getName();
        }
    }
}

