/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.goodness;

import net.adaptivebox.global.IUpdateCycleEngine;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.Library;

public class ACRComparator
implements IGoodnessCompareEngine,
IUpdateCycleEngine {
    private final Library socialPool;
    private double epsilon_t = 0.0;
    private final double RU = 0.75;
    private final double RL = 0.25;
    private final double BETAF = 0.618;
    private final double BETAL = 0.618;
    private final double BETAU = 1.382;
    private final double T;
    private final double TthR = 0.5;

    public ACRComparator(Library library, int n) {
        this.socialPool = library;
        this.T = n;
        this.epsilon_t = library.getExtremalVcon(true);
    }

    private static int compare(double d, double d2) {
        if (d < d2) {
            return 0;
        }
        if (d > d2) {
            return 2;
        }
        return 1;
    }

    public int compare(double[] dArray, double[] dArray2) {
        if (Math.max(dArray[0], dArray2[0]) <= Math.max(0.0, this.epsilon_t)) {
            return ACRComparator.compare(dArray[1], dArray2[1]);
        }
        return ACRComparator.compare(dArray[0], dArray2[0]);
    }

    public void updateCycle(int n) {
        double d = (double)this.socialPool.getVconThanNum(this.epsilon_t) / (double)this.socialPool.getPopSize();
        if ((double)n > 0.5 * this.T && this.T != -1.0) {
            this.epsilon_t *= 0.618;
        } else {
            if (d > 0.75) {
                this.epsilon_t *= 0.618;
            }
            if (d < 0.25) {
                this.epsilon_t *= 1.382;
            }
        }
    }
}

