/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.problem;

import net.adaptivebox.encode.EvalElement;
import net.adaptivebox.encode.EvalStruct;
import net.adaptivebox.global.BasicBound;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.space.DesignDim;
import net.adaptivebox.space.DesignSpace;

public abstract class ProblemEncoder {
    private final double[] tempResponseSet;
    private final double[] tempLocation;
    private final DesignSpace designSpace;
    private final EvalStruct evalStruct;

    protected ProblemEncoder(int n, int n2) throws Exception {
        this.designSpace = new DesignSpace(n);
        this.evalStruct = new EvalStruct(n2);
        this.tempLocation = new double[n];
        this.tempResponseSet = new double[n2];
    }

    public DesignSpace getDesignSpace() {
        return this.designSpace;
    }

    public EvalStruct getEvalStruct() {
        return this.evalStruct;
    }

    protected void setDefaultXAt(int n, double d, double d2, double d3) {
        DesignDim designDim = new DesignDim();
        designDim.grain = d3;
        designDim.paramBound = new BasicBound(d, d2);
        this.designSpace.setElemAt(designDim, n);
    }

    protected void setDefaultYAt(int n, double d, double d2) {
        EvalElement evalElement = new EvalElement();
        evalElement.targetBound = new BasicBound(d, d2);
        this.evalStruct.setElemAt(evalElement, n);
    }

    public SearchPoint getFreshSearchPoint() {
        return new SearchPoint(this.designSpace.getDimension());
    }

    public SearchPoint getEncodedSearchPoint() {
        SearchPoint searchPoint = this.getFreshSearchPoint();
        this.designSpace.initializeGene(searchPoint.getLocation());
        this.evaluate(searchPoint);
        return searchPoint;
    }

    public void evaluate(SearchPoint searchPoint) {
        System.arraycopy(searchPoint.getLocation(), 0, this.tempLocation, 0, this.tempLocation.length);
        this.designSpace.getMappingPoint(this.tempLocation);
        this.calcTargets(this.tempResponseSet, this.tempLocation);
        this.evalStruct.evaluate(searchPoint.getEncodeInfo(), this.tempResponseSet);
        searchPoint.setObjectiveValue(this.tempResponseSet[0]);
    }

    protected abstract double calcTargetAt(int var1, double[] var2);

    private void calcTargets(double[] dArray, double[] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.calcTargetAt(i, dArray2);
        }
    }
}

