/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.Calc.NLPSolver;

import com.sun.star.comp.Calc.NLPSolver.BaseEvolutionarySolver;
import com.sun.star.comp.Calc.NLPSolver.PropertyInfo;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lib.uno.helper.Factory;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.XComponentContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.adaptivebox.deps.DEPSAgent;
import net.adaptivebox.deps.behavior.DEGTBehavior;
import net.adaptivebox.deps.behavior.PSGTBehavior;
import net.adaptivebox.global.IUpdateCycleEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;

public final class DEPSSolverImpl
extends BaseEvolutionarySolver
implements XServiceInfo {
    private static final String m_implementationName = DEPSSolverImpl.class.getName();
    private static final String[] m_serviceNames = new String[]{"com.sun.star.sheet.Solver", "com.sun.star.beans.PropertySet"};
    private final PropertyInfo<Double> m_agentSwitchRate = new PropertyInfo<Double>("AgentSwitchRate", 0.5, "Agent Switch Rate (DE Probability)");
    private final PropertyInfo<Double> m_factor = new PropertyInfo<Double>("DEFactor", 0.5, "DE: Scaling Factor (0-1.2)");
    private final PropertyInfo<Double> m_CR = new PropertyInfo<Double>("DECR", 0.9, "DE: Crossover Probability (0-1)");
    private final PropertyInfo<Double> m_c1 = new PropertyInfo<Double>("PSC1", 1.494, "PS: Cognitive Constant");
    private final PropertyInfo<Double> m_c2 = new PropertyInfo<Double>("PSC2", 1.494, "PS: Social Constant");
    private final PropertyInfo<Double> m_weight = new PropertyInfo<Double>("PSWeight", 0.729, "PS: Constriction Coefficient");
    private final PropertyInfo<Double> m_CL = new PropertyInfo<Double>("PSCL", 0.0, "PS: Mutation Probability (0-0.005)");

    public DEPSSolverImpl(XComponentContext xComponentContext) {
        super(xComponentContext, "DEPS Evolutionary Algorithm");
        this.registerProperty(this.m_agentSwitchRate);
        this.registerProperty(this.m_factor);
        this.registerProperty(this.m_CR);
        this.registerProperty(this.m_c1);
        this.registerProperty(this.m_c2);
        this.registerProperty(this.m_weight);
        this.registerProperty(this.m_CL);
    }

    public static XSingleComponentFactory __getComponentFactory(String string) {
        XSingleComponentFactory xSingleComponentFactory = null;
        if (string.equals(m_implementationName)) {
            xSingleComponentFactory = Factory.createComponentFactory(DEPSSolverImpl.class, (String[])m_serviceNames);
        }
        return xSingleComponentFactory;
    }

    public static boolean __writeRegistryServiceInfo(XRegistryKey xRegistryKey) {
        return Factory.writeRegistryServiceInfo((String)m_implementationName, (String[])m_serviceNames, (XRegistryKey)xRegistryKey);
    }

    public String getImplementationName() {
        return m_implementationName;
    }

    public boolean supportsService(String string) {
        int n = m_serviceNames.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(m_serviceNames[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return m_serviceNames;
    }

    public void solve() {
        int n;
        try {
            this.m_librarySize.setValue(this.m_swarmSize.getValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(DEPSSolverImpl.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
        }
        this.initializeSolve();
        DEPSAgent[] dEPSAgentArray = new DEPSAgent[((Integer)this.m_swarmSize.getValue()).intValue()];
        for (n = 0; n < (Integer)this.m_swarmSize.getValue(); ++n) {
            dEPSAgentArray[n] = new DEPSAgent();
            dEPSAgentArray[n].setProblemEncoder(this.m_problemEncoder);
            dEPSAgentArray[n].setPbest(this.m_library.getSelectedPoint(n));
            DEGTBehavior dEGTBehavior = new DEGTBehavior();
            dEGTBehavior.FACTOR = this.m_factor.getValue();
            dEGTBehavior.CR = this.m_CR.getValue();
            PSGTBehavior pSGTBehavior = new PSGTBehavior();
            pSGTBehavior.c1 = this.m_c1.getValue();
            pSGTBehavior.c2 = this.m_c2.getValue();
            pSGTBehavior.CL = this.m_CL.getValue();
            pSGTBehavior.weight = this.m_weight.getValue();
            dEPSAgentArray[n].switchP = this.m_agentSwitchRate.getValue();
            dEPSAgentArray[n].setGTBehavior(dEGTBehavior);
            dEPSAgentArray[n].setGTBehavior(pSGTBehavior);
            dEPSAgentArray[n].setSpecComparator(this.m_specCompareEngine);
            dEPSAgentArray[n].setLibrary(this.m_library);
        }
        this.m_solverStatusDialog.setVisible(true);
        this.m_solverStatusDialog.setMaxIterations((Integer)this.m_learningCycles.getValue());
        this.m_solverStatusDialog.setMaxStagnation((Integer)this.m_required.getValue());
        n = 1;
        long l = 0L;
        do {
            long l2 = System.nanoTime();
            if (n >= (Integer)this.m_learningCycles.getValue()) {
                n = 1;
            }
            if (this.m_solverStatusDialog.getUserState() == 2) {
                this.lockDocument();
            }
            this.m_toleratedCount = 0;
            this.m_toleratedMin = -1.0 * (Double)this.m_tolerance.getValue();
            this.m_toleratedMax = (Double)this.m_tolerance.getValue();
            while (n <= (Integer)this.m_learningCycles.getValue() && this.m_toleratedCount < (Integer)this.m_required.getValue() && this.m_solverStatusDialog.getUserState() != 3) {
                int n2;
                this.m_library.refreshGbest(this.m_specCompareEngine);
                for (n2 = 0; n2 < (Integer)this.m_swarmSize.getValue(); ++n2) {
                    dEPSAgentArray[n2].generatePoint();
                }
                for (n2 = 0; n2 < (Integer)this.m_swarmSize.getValue(); ++n2) {
                    dEPSAgentArray[n2].learn();
                }
                for (n2 = 0; n2 < (Integer)this.m_swarmSize.getValue(); ++n2) {
                    boolean bl;
                    SearchPoint searchPoint = dEPSAgentArray[n2].getMGState();
                    boolean bl2 = bl = searchPoint.getObjectiveValue() >= this.m_toleratedMin && searchPoint.getObjectiveValue() <= this.m_toleratedMax;
                    if (!Library.replace(this.m_envCompareEngine, searchPoint, this.m_totalBestPoint)) continue;
                    this.m_solverStatusDialog.setBestSolution(this.m_totalBestPoint.getObjectiveValue(), this.m_totalBestPoint.isFeasible());
                    if (bl) continue;
                    this.m_toleratedMin = searchPoint.getObjectiveValue() - (Double)this.m_tolerance.getValue();
                    this.m_toleratedMax = searchPoint.getObjectiveValue() + (Double)this.m_tolerance.getValue();
                    this.m_toleratedCount = 0;
                }
                if (this.m_specCompareEngine instanceof IUpdateCycleEngine) {
                    ((IUpdateCycleEngine)((Object)this.m_specCompareEngine)).updateCycle(n);
                }
                this.m_solverStatusDialog.setIteration(n);
                this.m_solverStatusDialog.setStagnation(this.m_toleratedCount);
                this.m_solverStatusDialog.setRuntime(l + (System.nanoTime() - l2));
                this.m_xReschedule.reschedule();
                ++n;
            }
            this.applySolution();
            this.unlockDocument();
            this.m_solverStatusDialog.setRuntime(l += System.nanoTime() - l2);
        } while (this.m_solverStatusDialog.waitForUser() == 2);
        this.lockDocument();
        this.finalizeSolve();
    }
}

