/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.type;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.type.ApplicationType;
import com.sun.tools.visualvm.application.type.IntellijApplicationType;
import com.sun.tools.visualvm.application.type.MainClassApplicationTypeFactory;
import java.util.Scanner;

public class IntellijApplicationTypeFactory
extends MainClassApplicationTypeFactory {
    private static final String MAIN_CLASS = "com.intellij.idea.Main";
    private static final String PLATFORM_ID = "-Didea.paths.selector=";
    private static final String PLATFORM_PREFIX = "-Didea.platform.prefix=";
    private static final String IDEA_ID = "Idea";
    private static final String IDEA_NAME = "IntelliJ IDEA";
    private static final String PLATFORM_NAME = "IntelliJ Platform";

    public ApplicationType createApplicationTypeFor(Application app, Jvm jvm, String mainClass) {
        String args;
        if (MAIN_CLASS.equals(mainClass)) {
            return new IntellijApplicationType(app, this.getName(jvm));
        }
        if ((mainClass == null || mainClass.length() == 0) && (args = jvm.getJvmArgs()) != null && args.contains(PLATFORM_ID)) {
            return new IntellijApplicationType(app, this.getName(jvm));
        }
        return null;
    }

    private String getName(Jvm jvm) {
        String jvmArgs = jvm.getJvmArgs();
        String name = this.getValue(jvmArgs, PLATFORM_PREFIX);
        if (name != null) {
            return name;
        }
        String selector = this.getValue(jvmArgs, PLATFORM_ID);
        if (selector != null && selector.startsWith(IDEA_ID)) {
            return IDEA_NAME;
        }
        return PLATFORM_NAME;
    }

    private String getValue(String args, String key) {
        Scanner sc;
        if (args == null) {
            return null;
        }
        int index = args.indexOf(key);
        if (index >= 0 && (sc = new Scanner(args.substring(index + key.length()))).hasNext()) {
            return sc.next();
        }
        return null;
    }
}

