/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.lang.reflect.Constructor;
import java.util.concurrent.Callable;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;

public class RequestHandlerRegistry<Request extends TransportRequest> {
    private final String action;
    private final TransportRequestHandler<Request> handler;
    private final boolean forceExecution;
    private final String executor;
    private final Callable<Request> requestFactory;

    RequestHandlerRegistry(String action, Class<Request> request, TransportRequestHandler<Request> handler, String executor, boolean forceExecution) {
        this(action, new ReflectionFactory<Request>(request), handler, executor, forceExecution);
    }

    public RequestHandlerRegistry(String action, Callable<Request> requestFactory, TransportRequestHandler<Request> handler, String executor, boolean forceExecution) {
        this.action = action;
        this.requestFactory = requestFactory;
        assert (this.newRequest() != null);
        this.handler = handler;
        this.forceExecution = forceExecution;
        this.executor = executor;
    }

    public String getAction() {
        return this.action;
    }

    public Request newRequest() {
        try {
            return (Request)((TransportRequest)this.requestFactory.call());
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to instantiate request ", e);
        }
    }

    public TransportRequestHandler<Request> getHandler() {
        return this.handler;
    }

    public boolean isForceExecution() {
        return this.forceExecution;
    }

    public String getExecutor() {
        return this.executor;
    }

    private static final class ReflectionFactory<Request>
    implements Callable<Request> {
        private final Constructor<Request> requestConstructor;

        public ReflectionFactory(Class<Request> request) {
            try {
                this.requestConstructor = request.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("failed to create constructor (does it have a default constructor?) for request " + request, e);
            }
            this.requestConstructor.setAccessible(true);
        }

        @Override
        public Request call() throws Exception {
            return this.requestConstructor.newInstance(new Object[0]);
        }
    }
}

