/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.GeoUtils;
import org.apache.lucene.util.NumericUtils;

abstract class GeoPointTermsEnum
extends FilteredTermsEnum {
    protected final double minLon;
    protected final double minLat;
    protected final double maxLon;
    protected final double maxLat;
    protected Range currentRange;
    private BytesRef currentCell;
    private final List<Range> rangeBounds = new LinkedList<Range>();
    private static final short MAX_SHIFT = 36;
    protected static final short DETAIL_LEVEL = 14;

    GeoPointTermsEnum(TermsEnum tenum, double minLon, double minLat, double maxLon, double maxLat) {
        super(tenum);
        long rectMinHash = GeoUtils.mortonHash(minLon, minLat);
        long rectMaxHash = GeoUtils.mortonHash(maxLon, maxLat);
        this.minLon = GeoUtils.mortonUnhashLon(rectMinHash);
        this.minLat = GeoUtils.mortonUnhashLat(rectMinHash);
        this.maxLon = GeoUtils.mortonUnhashLon(rectMaxHash);
        this.maxLat = GeoUtils.mortonUnhashLat(rectMaxHash);
        this.computeRange(0L, (short)63);
        Collections.sort(this.rangeBounds);
    }

    private final void computeRange(long term, short shift) {
        long split = term | 1L << shift;
        assert (shift < 64);
        long upperMax = shift < 63 ? term | (1L << shift + 1) - 1L : -1L;
        long lowerMax = split - 1L;
        this.relateAndRecurse(term, lowerMax, shift);
        this.relateAndRecurse(split, upperMax, shift);
    }

    private void relateAndRecurse(long start, long end, short res) {
        boolean within;
        double minLon = GeoUtils.mortonUnhashLon(start);
        double minLat = GeoUtils.mortonUnhashLat(start);
        double maxLon = GeoUtils.mortonUnhashLon(end);
        double maxLat = GeoUtils.mortonUnhashLat(end);
        short level = (short)(64 - res >>> 1);
        boolean bl = within = res % 9 == 0 && this.cellWithin(minLon, minLat, maxLon, maxLat);
        if (within || level == 14 && this.cellIntersectsShape(minLon, minLat, maxLon, maxLat)) {
            this.rangeBounds.add(new Range(start, res, level, !within));
        } else if (level < 14 && this.cellIntersectsMBR(minLon, minLat, maxLon, maxLat)) {
            this.computeRange(start, (short)(res - 1));
        }
    }

    protected abstract boolean cellCrosses(double var1, double var3, double var5, double var7);

    protected abstract boolean cellWithin(double var1, double var3, double var5, double var7);

    protected abstract boolean cellIntersectsShape(double var1, double var3, double var5, double var7);

    protected boolean cellIntersectsMBR(double minLon, double minLat, double maxLon, double maxLat) {
        return GeoUtils.rectIntersects(minLon, minLat, maxLon, maxLat, this.minLon, this.minLat, this.maxLon, this.maxLat);
    }

    protected boolean cellContains(double minLon, double minLat, double maxLon, double maxLat) {
        return GeoUtils.rectWithin(this.minLon, this.minLat, this.maxLon, this.maxLat, minLon, minLat, maxLon, maxLat);
    }

    public boolean boundaryTerm() {
        if (this.currentRange == null) {
            throw new IllegalStateException("GeoPointTermsEnum empty or not initialized");
        }
        return this.currentRange.boundary;
    }

    private void nextRange() {
        this.currentRange = this.rangeBounds.remove(0);
        this.currentCell = this.currentRange.cell;
    }

    protected final BytesRef nextSeekTerm(BytesRef term) {
        while (!this.rangeBounds.isEmpty()) {
            if (this.currentRange == null) {
                this.nextRange();
            }
            if (term != null && term.compareTo(this.currentCell) > 0) {
                this.nextRange();
                if (!this.rangeBounds.isEmpty()) continue;
            }
            return term != null && term.compareTo(this.currentCell) > 0 ? term : this.currentCell;
        }
        assert (this.rangeBounds.isEmpty());
        this.currentCell = null;
        return null;
    }

    protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
        while (this.currentCell == null || term.compareTo(this.currentCell) > 0) {
            if (this.rangeBounds.isEmpty()) {
                return FilteredTermsEnum.AcceptStatus.END;
            }
            if (term.compareTo(this.rangeBounds.get((int)0).cell) < 0) {
                return FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
            }
            this.nextRange();
        }
        return FilteredTermsEnum.AcceptStatus.YES;
    }

    protected abstract boolean postFilter(double var1, double var3);

    protected final class Range
    implements Comparable<Range> {
        final BytesRef cell;
        final short level;
        final boolean boundary;

        Range(long lower, short res, short level, boolean boundary) {
            this.level = level;
            this.boundary = boundary;
            BytesRefBuilder brb = new BytesRefBuilder();
            NumericUtils.longToPrefixCodedBytes((long)lower, (int)res, (BytesRefBuilder)brb);
            this.cell = brb.get();
        }

        @Override
        public int compareTo(Range other) {
            return this.cell.compareTo(other.cell);
        }
    }
}

