/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.attributes;

import freemind.controller.filter.util.SortedListModel;
import freemind.main.Resources;
import freemind.modes.attributes.AttributeRegistry;
import javax.swing.table.AbstractTableModel;

public class AttributeRegistryTableModel
extends AbstractTableModel {
    private final AttributeRegistry attributeRegistry;
    private String allAttributes = Resources.getInstance().getResourceString("attributes_all");
    private static String attributeColumnName = null;
    private static String visibilityColumnName = null;
    private static String restrictionColumnName = null;
    private static String editorColumnName = null;

    AttributeRegistryTableModel(AttributeRegistry registry) {
        this.attributeRegistry = registry;
    }

    @Override
    public int getRowCount() {
        return this.attributeRegistry.size() + 1;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row == 0 && col < 2) {
            if (col == 0) {
                return this.allAttributes;
            }
            return null;
        }
        --row;
        switch (col) {
            case 0: {
                return this.attributeRegistry.getKey(row);
            }
            case 1: {
                return this.attributeRegistry.getElement(row).getVisibilityModel();
            }
            case 2: {
                return this.attributeRegistry.getRestriction(row);
            }
            case 3: {
                return this.attributeRegistry.getValues(row);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object o, int row, int col) {
        if (row == 0 && col != 2) {
            return;
        }
        if (col == 3) {
            return;
        }
        Boolean value = (Boolean)o;
        switch (col) {
            case 1: {
                this.attributeRegistry.setVisibilityModel(row - 1, value);
                break;
            }
            case 2: {
                this.attributeRegistry.setRestrictionModel(row - 1, value);
            }
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return SortedListModel.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col >= 1;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                if (attributeColumnName == null) {
                    attributeColumnName = Resources.getInstance().getResourceString("attributes_attribute");
                }
                return attributeColumnName;
            }
            case 1: {
                if (visibilityColumnName == null) {
                    visibilityColumnName = Resources.getInstance().getResourceString("attributes_visible");
                }
                return visibilityColumnName;
            }
            case 2: {
                if (restrictionColumnName == null) {
                    restrictionColumnName = Resources.getInstance().getResourceString("attributes_restriction");
                }
                return restrictionColumnName;
            }
            case 3: {
                if (editorColumnName == null) {
                    editorColumnName = Resources.getInstance().getResourceString("attributes_edit");
                }
                return editorColumnName;
            }
        }
        return null;
    }

    public void fireTableRowsDeleted() {
        if (this.getRowCount() > 1) {
            this.fireTableRowsDeleted(1, this.getRowCount() - 1);
        }
    }

    @Override
    public void fireTableCellUpdated(int row, int column) {
        super.fireTableCellUpdated(row + 1, column);
    }

    @Override
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        super.fireTableRowsDeleted(firstRow + 1, lastRow + 1);
    }

    @Override
    public void fireTableRowsInserted(int firstRow, int lastRow) {
        super.fireTableRowsInserted(firstRow + 1, lastRow + 1);
    }

    @Override
    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        super.fireTableRowsUpdated(firstRow + 1, lastRow + 1);
    }

    public void fireVisibilityUpdated(int row) {
        this.fireTableCellUpdated(row + 1, 1);
    }

    public void fireRestrictionsUpdated(int row) {
        this.fireTableRowsUpdated(row + 1, row + 1);
    }
}

