/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.ArrayOfAtoms;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.MatrixAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.VerticalBox;

public class MultlineAtom
extends Atom {
    public static SpaceAtom vsep_in = new SpaceAtom(1, 0.0f, 1.0f, 0.0f);
    public static final int MULTLINE = 0;
    public static final int GATHER = 1;
    public static final int GATHERED = 2;
    private ArrayOfAtoms column;
    private int type;
    private boolean isPartial;

    public MultlineAtom(boolean bl, ArrayOfAtoms arrayOfAtoms, int n) {
        this.isPartial = bl;
        this.column = arrayOfAtoms;
        this.type = n;
    }

    public MultlineAtom(ArrayOfAtoms arrayOfAtoms, int n) {
        this(false, arrayOfAtoms, n);
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        int n;
        float f = teXEnvironment.getTextwidth();
        if (f == Float.POSITIVE_INFINITY || this.type == 2) {
            return new MatrixAtom(this.isPartial, this.column, "").createBox(teXEnvironment);
        }
        VerticalBox verticalBox = new VerticalBox();
        Atom atom = this.column.array.get(0).get(0);
        int n2 = n = this.type == 1 ? 2 : 0;
        if (atom.alignment != -1) {
            n = atom.alignment;
        }
        verticalBox.add(new HorizontalBox(atom.createBox(teXEnvironment), f, n));
        Box box = vsep_in.createBox(teXEnvironment);
        for (int i = 1; i < this.column.row - 1; ++i) {
            atom = this.column.array.get(i).get(0);
            n = 2;
            if (atom.alignment != -1) {
                n = atom.alignment;
            }
            verticalBox.add(box);
            verticalBox.add(new HorizontalBox(atom.createBox(teXEnvironment), f, n));
        }
        if (this.column.row > 1) {
            atom = this.column.array.get(this.column.row - 1).get(0);
            int n3 = n = this.type == 1 ? 2 : 1;
            if (atom.alignment != -1) {
                n = atom.alignment;
            }
            verticalBox.add(box);
            verticalBox.add(new HorizontalBox(atom.createBox(teXEnvironment), f, n));
        }
        float f2 = verticalBox.getHeight() + verticalBox.getDepth();
        verticalBox.setHeight(f2 / 2.0f);
        verticalBox.setDepth(f2 / 2.0f);
        return verticalBox;
    }
}

