/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.application.CreateStartScripts;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.tasks.Jar;
import org.gradle.model.Defaults;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.play.PlayApplicationBinarySpec;
import org.gradle.play.distribution.PlayDistribution;
import org.gradle.play.distribution.PlayDistributionContainer;
import org.gradle.play.internal.PlayApplicationBinarySpecInternal;
import org.gradle.play.internal.distribution.DefaultPlayDistribution;
import org.gradle.play.internal.distribution.DefaultPlayDistributionContainer;
import org.gradle.play.plugins.PlayPluginConfigurations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class PlayDistributionPlugin
extends RuleSource {
    public static final String DISTRIBUTION_GROUP = "distribution";

    @Model
    PlayDistributionContainer distributions(ServiceRegistry serviceRegistry) {
        Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
        return new DefaultPlayDistributionContainer(instantiator);
    }

    @Mutate
    void createLifecycleTasks(ModelMap<Task> tasks) {
        tasks.create("dist", (Action)new Action<Task>(){

            public void execute(Task task) {
                task.setDescription("Assembles all Play distributions.");
                task.setGroup(PlayDistributionPlugin.DISTRIBUTION_GROUP);
            }
        });
        tasks.create("stage", (Action)new Action<Task>(){

            public void execute(Task task) {
                task.setDescription("Stages all Play distributions.");
                task.setGroup(PlayDistributionPlugin.DISTRIBUTION_GROUP);
            }
        });
    }

    @Defaults
    void createDistributions(@Path(value="distributions") PlayDistributionContainer distributions, ModelMap<PlayApplicationBinarySpecInternal> playBinaries, PlayPluginConfigurations configurations, ServiceRegistry serviceRegistry) {
        FileOperations fileOperations = (FileOperations)serviceRegistry.get(FileOperations.class);
        Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
        for (PlayApplicationBinarySpecInternal binary : playBinaries) {
            PlayDistribution distribution = (PlayDistribution)instantiator.newInstance(DefaultPlayDistribution.class, new Object[]{binary.getProjectScopedName(), fileOperations.copySpec(), binary});
            distribution.setBaseName(binary.getProjectScopedName());
            distributions.add(distribution);
        }
    }

    @Mutate
    void createDistributionContentTasks(ModelMap<Task> tasks, @Path(value="buildDir") File buildDir, @Path(value="distributions") PlayDistributionContainer distributions, final PlayPluginConfigurations configurations) {
        for (final PlayDistribution distribution : distributions.withType(PlayDistribution.class)) {
            final PlayApplicationBinarySpec binary = distribution.getBinary();
            if (binary == null) {
                throw new InvalidUserCodeException(String.format("Play Distribution '%s' does not have a configured Play binary.", distribution.getName()));
            }
            final File distJarDir = new File(buildDir, String.format("distributionJars/%s", distribution.getName()));
            String jarTaskName = String.format("create%sDistributionJar", StringUtils.capitalize((String)distribution.getName()));
            tasks.create(jarTaskName, Jar.class, (Action)new Action<Jar>(){

                public void execute(Jar jar) {
                    jar.setDescription("Assembles an application jar suitable for deployment for the " + binary + ".");
                    jar.dependsOn(new Object[]{binary.getTasks().withType(Jar.class)});
                    jar.from(new Object[]{jar.getProject().zipTree((Object)binary.getJarFile())});
                    jar.setDestinationDir(distJarDir);
                    jar.setArchiveName(binary.getJarFile().getName());
                    HashMap classpath = Maps.newHashMap();
                    classpath.put("Class-Path", new PlayManifestClasspath(configurations.getPlayRun(), binary.getAssetsJarFile()));
                    jar.getManifest().attributes((Map)classpath);
                }
            });
            final Task distributionJar = (Task)tasks.get(jarTaskName);
            final File scriptsDir = new File(buildDir, String.format("scripts/%s", distribution.getName()));
            String createStartScriptsTaskName = String.format("create%sStartScripts", StringUtils.capitalize((String)distribution.getName()));
            tasks.create(createStartScriptsTaskName, CreateStartScripts.class, (Action)new Action<CreateStartScripts>(){

                public void execute(CreateStartScripts createStartScripts) {
                    createStartScripts.setDescription("Creates OS specific scripts to run the " + binary + ".");
                    createStartScripts.setClasspath(distributionJar.getOutputs().getFiles());
                    createStartScripts.setMainClassName("play.core.server.NettyServer");
                    createStartScripts.setApplicationName(distribution.getName());
                    createStartScripts.setOutputDir(scriptsDir);
                }
            });
            Task createStartScripts = (Task)tasks.get(createStartScriptsTaskName);
            CopySpecInternal distSpec = (CopySpecInternal)distribution.getContents();
            CopySpec libSpec = distSpec.addChild().into((Object)"lib");
            libSpec.from(new Object[]{distributionJar});
            libSpec.from(new Object[]{binary.getAssetsJarFile()});
            libSpec.from(new Object[]{configurations.getPlayRun().getAllArtifacts()});
            CopySpec binSpec = distSpec.addChild().into((Object)"bin");
            binSpec.from(new Object[]{createStartScripts});
            binSpec.setFileMode(Integer.valueOf(493));
            CopySpec confSpec = distSpec.addChild().into((Object)"conf");
            confSpec.from(new Object[]{"conf"}).exclude(new String[]{"routes"});
            distSpec.from(new Object[]{"README"});
        }
    }

    @Mutate
    void createDistributionZipTasks(ModelMap<Task> tasks, final @Path(value="buildDir") File buildDir, PlayDistributionContainer distributions) {
        for (final PlayDistribution distribution : distributions.withType(PlayDistribution.class)) {
            final String stageTaskName = String.format("stage%sDist", StringUtils.capitalize((String)distribution.getName()));
            final File stageDir = new File(buildDir, "stage");
            final String baseName = StringUtils.isNotEmpty((String)distribution.getBaseName()) ? distribution.getBaseName() : distribution.getName();
            tasks.create(stageTaskName, Copy.class, (Action)new Action<Copy>(){

                public void execute(Copy copy) {
                    copy.setDescription("Copies the '" + distribution.getName() + "' distribution to a staging directory.");
                    copy.setDestinationDir(stageDir);
                    CopySpecInternal baseSpec = copy.getRootSpec().addChild();
                    baseSpec.into((Object)baseName);
                    baseSpec.with(new CopySpec[]{distribution.getContents()});
                }
            });
            tasks.named("stage", (Action)new Action<Task>(){

                public void execute(Task task) {
                    task.dependsOn(new Object[]{stageTaskName});
                }
            });
            final Task stageTask = (Task)tasks.get(stageTaskName);
            final String distributionTaskName = String.format("create%sDist", StringUtils.capitalize((String)distribution.getName()));
            tasks.create(distributionTaskName, Zip.class, (Action)new Action<Zip>(){

                public void execute(Zip zip) {
                    zip.setDescription("Packages the '" + distribution.getName() + "' distribution as a zip file.");
                    zip.setArchiveName(String.format("%s.zip", baseName));
                    zip.setDestinationDir(new File(buildDir, "distributions"));
                    zip.from(new Object[]{stageTask});
                }
            });
            tasks.named("dist", (Action)new Action<Task>(){

                public void execute(Task task) {
                    task.dependsOn(new Object[]{distributionTaskName});
                }
            });
        }
    }

    static class PlayManifestClasspath {
        final PlayPluginConfigurations.PlayConfiguration playConfiguration;
        final File assetsJarFile;

        public PlayManifestClasspath(PlayPluginConfigurations.PlayConfiguration playConfiguration, File assetsJarFile) {
            this.playConfiguration = playConfiguration;
            this.assetsJarFile = assetsJarFile;
        }

        public String toString() {
            return Joiner.on((String)" ").join(Iterables.transform((Iterable)Iterables.concat((Iterable)this.playConfiguration.getAllArtifacts(), Collections.singleton(this.assetsJarFile)), (Function)new Function<File, String>(){

                public String apply(File input) {
                    return input.getName();
                }
            }));
        }
    }
}

