/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jetty;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.jetty.AbstractJettyRunTask;
import org.gradle.api.plugins.jetty.ScanTargetPattern;
import org.gradle.api.plugins.jetty.internal.Jetty6PluginServer;
import org.gradle.api.plugins.jetty.internal.JettyPluginServer;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.resource.Resource;
import org.mortbay.resource.ResourceCollection;
import org.mortbay.util.Scanner;
import org.mortbay.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyRun
extends AbstractJettyRunTask {
    private static Logger logger = LoggerFactory.getLogger(JettyRun.class);
    private ContextHandler[] contextHandlers;
    private File jettyEnvXml;
    private File webXml;
    private File webAppSourceDirectory;
    private File[] scanTargets;
    private ScanTargetPattern[] scanTargetPatterns;
    private File jettyEnvXmlFile;
    private List<File> classPathFiles;
    private Set<File> extraScanTargets;
    private FileCollection classpath;

    @Override
    public void validateConfiguration() {
        try {
            if (this.getWebAppSourceDirectory() == null || !this.getWebAppSourceDirectory().exists()) {
                throw new InvalidUserDataException("Webapp source directory " + (this.getWebAppSourceDirectory() == null ? "null" : this.getWebAppSourceDirectory().getCanonicalPath()) + " does not exist");
            }
            logger.info("Webapp source directory = " + this.getWebAppSourceDirectory().getCanonicalPath());
        }
        catch (IOException e) {
            throw new InvalidUserDataException("Webapp source directory does not exist", (Throwable)e);
        }
        if (!"automatic".equalsIgnoreCase(this.reload) && !"manual".equalsIgnoreCase(this.reload)) {
            throw new InvalidUserDataException("invalid reload mechanic specified, must be 'automatic' or 'manual'");
        }
        logger.info("Reload Mechanic: " + this.reload);
        if (this.getWebXml() == null) {
            this.setWebXml(new File(new File(this.getWebAppSourceDirectory(), "WEB-INF"), "web.xml"));
        }
        logger.info("web.xml file = " + this.getWebXml());
        if (this.getJettyEnvXml() != null) {
            this.setJettyEnvXmlFile(this.jettyEnvXml);
            try {
                if (!this.getJettyEnvXmlFile().exists()) {
                    throw new InvalidUserDataException("jetty-env.xml file does not exist at location " + this.jettyEnvXml);
                }
                logger.info(" jetty-env.xml = " + this.getJettyEnvXmlFile().getCanonicalPath());
            }
            catch (IOException e) {
                throw new InvalidUserDataException("jetty-env.xml does not exist");
            }
        }
        this.setExtraScanTargets(new ArrayList<File>());
        if (this.scanTargets != null) {
            for (File scanTarget : this.scanTargets) {
                logger.info("Added extra scan target:" + scanTarget);
                this.getExtraScanTargets().add(scanTarget);
            }
        }
        if (this.scanTargetPatterns != null) {
            for (ScanTargetPattern scanTargetPattern : this.scanTargetPatterns) {
                ConfigurableFileTree files = this.getProject().fileTree((Object)scanTargetPattern.getDirectory());
                files.include(scanTargetPattern.getIncludes());
                files.exclude(scanTargetPattern.getExcludes());
                Set<File> currentTargets = this.getExtraScanTargets();
                if (currentTargets != null && !currentTargets.isEmpty()) {
                    currentTargets.addAll(files.getFiles());
                    continue;
                }
                this.setExtraScanTargets(files.getFiles());
            }
        }
    }

    @Override
    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        this.setClassPathFiles(this.setUpClassPath());
        if (this.getWebAppConfig().getWebXmlFile() == null) {
            this.getWebAppConfig().setWebXmlFile(this.getWebXml());
        }
        if (this.getWebAppConfig().getJettyEnvXmlFile() == null) {
            this.getWebAppConfig().setJettyEnvXmlFile(this.getJettyEnvXmlFile());
        }
        if (this.getWebAppConfig().getClassPathFiles() == null) {
            this.getWebAppConfig().setClassPathFiles(this.getClassPathFiles());
        }
        if (this.getWebAppConfig().getWar() == null) {
            this.getWebAppConfig().setWar(this.getWebAppSourceDirectory().getCanonicalPath());
        }
        logger.info("Webapp directory = " + this.getWebAppSourceDirectory().getCanonicalPath());
        this.getWebAppConfig().configure();
    }

    @Override
    public void configureScanner() {
        File jettyWebXmlFile;
        ArrayList<File> scanList = new ArrayList<File>();
        scanList.add(this.getWebXml());
        if (this.getJettyEnvXmlFile() != null) {
            scanList.add(this.getJettyEnvXmlFile());
        }
        if ((jettyWebXmlFile = this.findJettyWebXmlFile(new File(this.getWebAppSourceDirectory(), "WEB-INF"))) != null) {
            scanList.add(jettyWebXmlFile);
        }
        scanList.addAll(this.getExtraScanTargets());
        scanList.add(this.getProject().getBuildFile());
        scanList.addAll(this.getClassPathFiles());
        this.getScanner().setScanDirs(scanList);
        ArrayList<Scanner.Listener> listeners = new ArrayList<Scanner.Listener>();
        listeners.add((Scanner.Listener)new Scanner.BulkListener(){

            public void filesChanged(List changes) {
                try {
                    boolean reconfigure = changes.contains(JettyRun.this.getProject().getBuildFile().getCanonicalPath());
                    JettyRun.this.restartWebApp(reconfigure);
                }
                catch (Exception e) {
                    logger.error("Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
        this.setScannerListeners(listeners);
    }

    @Override
    public void restartWebApp(boolean reconfigureScanner) throws Exception {
        logger.info("restarting " + (Object)((Object)this.getWebAppConfig()));
        logger.debug("Stopping webapp ...");
        this.getWebAppConfig().stop();
        logger.debug("Reconfiguring webapp ...");
        this.validateConfiguration();
        this.configureWebApplication();
        if (reconfigureScanner) {
            logger.info("Reconfiguring scanner ...");
            ArrayList<File> scanList = new ArrayList<File>();
            scanList.add(this.getWebXml());
            if (this.getJettyEnvXmlFile() != null) {
                scanList.add(this.getJettyEnvXmlFile());
            }
            scanList.addAll(this.getExtraScanTargets());
            scanList.add(this.getProject().getBuildFile());
            scanList.addAll(this.getClassPathFiles());
            this.getScanner().setScanDirs(scanList);
        }
        logger.debug("Restarting webapp ...");
        this.getWebAppConfig().start();
        logger.info("Restart completed at " + new Date().toString());
    }

    private Set<File> getDependencyFiles() {
        ArrayList overlays = new ArrayList();
        Set dependencies = this.getClasspath().getFiles();
        logger.debug("Adding dependencies {} for WEB-INF/lib ", (Object)dependencies);
        if (!overlays.isEmpty()) {
            try {
                Resource resource = this.getWebAppConfig().getBaseResource();
                ResourceCollection rc = new ResourceCollection();
                if (resource == null) {
                    int size = overlays.size() + 1;
                    Resource[] resources = new Resource[size];
                    resources[0] = Resource.newResource((URL)this.getWebAppSourceDirectory().toURI().toURL());
                    for (int i = 1; i < size; ++i) {
                        resources[i] = (Resource)overlays.get(i - 1);
                        logger.info("Adding overlay: " + resources[i]);
                    }
                    rc.setResources(resources);
                } else if (resource instanceof ResourceCollection) {
                    Resource[] old = ((ResourceCollection)resource).getResources();
                    int size = old.length + overlays.size();
                    Resource[] resources = new Resource[size];
                    System.arraycopy(old, 0, resources, 0, old.length);
                    for (int i = old.length; i < size; ++i) {
                        resources[i] = (Resource)overlays.get(i - old.length);
                        logger.info("Adding overlay: " + resources[i]);
                    }
                    rc.setResources(resources);
                } else {
                    if (!resource.isDirectory() && String.valueOf(resource.getFile()).endsWith(".war")) {
                        resource = Resource.newResource((String)("jar:" + resource.getURL().toString() + "!/"));
                    }
                    int size = overlays.size() + 1;
                    Resource[] resources = new Resource[size];
                    resources[0] = resource;
                    for (int i = 1; i < size; ++i) {
                        resources[i] = (Resource)overlays.get(i - 1);
                        logger.info("Adding overlay: " + resources[i]);
                    }
                    rc.setResources(resources);
                }
                this.getWebAppConfig().setBaseResource((Resource)rc);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return dependencies;
    }

    private List<File> setUpClassPath() {
        ArrayList<File> classPathFiles = new ArrayList<File>();
        classPathFiles.addAll(this.getDependencyFiles());
        if (logger.isDebugEnabled()) {
            for (File classPathFile : classPathFiles) {
                logger.debug("classpath element: " + classPathFile.getName());
            }
        }
        return classPathFiles;
    }

    @Override
    public void finishConfigurationBeforeStart() throws Exception {
        ContextHandler[] handlers = this.getConfiguredContextHandlers();
        JettyPluginServer plugin = this.getServer();
        Server server = (Server)plugin.getProxiedObject();
        HandlerCollection contexts = (HandlerCollection)server.getChildHandlerByClass(ContextHandlerCollection.class);
        if (contexts == null) {
            contexts = (HandlerCollection)server.getChildHandlerByClass(HandlerCollection.class);
        }
        for (int i = 0; handlers != null && i < handlers.length; ++i) {
            contexts.addHandler((Handler)handlers[i]);
        }
    }

    @Override
    public void applyJettyXml() throws Exception {
        if (this.getJettyConfig() == null) {
            return;
        }
        logger.info("Configuring Jetty from xml configuration file = " + this.getJettyConfig());
        XmlConfiguration xmlConfiguration = new XmlConfiguration(this.getJettyConfig().toURI().toURL());
        xmlConfiguration.configure(this.getServer().getProxiedObject());
    }

    @Override
    public JettyPluginServer createServer() {
        return new Jetty6PluginServer();
    }

    @InputFile
    @Optional
    public File getJettyEnvXml() {
        return this.jettyEnvXml;
    }

    public void setJettyEnvXml(File jettyEnvXml) {
        this.jettyEnvXml = jettyEnvXml;
    }

    public File getWebXml() {
        return this.webXml;
    }

    public void setWebXml(File webXml) {
        this.webXml = webXml;
    }

    @InputDirectory
    public File getWebAppSourceDirectory() {
        return this.webAppSourceDirectory;
    }

    public void setWebAppSourceDirectory(File webAppSourceDirectory) {
        this.webAppSourceDirectory = webAppSourceDirectory;
    }

    public File[] getScanTargets() {
        return this.scanTargets;
    }

    public void setScanTargets(File[] scanTargets) {
        this.scanTargets = scanTargets;
    }

    public Set<File> getExtraScanTargets() {
        return this.extraScanTargets;
    }

    public void setExtraScanTargets(Iterable<File> extraScanTargets) {
        this.extraScanTargets = Sets.newLinkedHashSet(extraScanTargets);
    }

    @InputFile
    @Optional
    public File getJettyEnvXmlFile() {
        return this.jettyEnvXmlFile;
    }

    public void setJettyEnvXmlFile(File jettyEnvXmlFile) {
        this.jettyEnvXmlFile = jettyEnvXmlFile;
    }

    public List<File> getClassPathFiles() {
        return this.classPathFiles;
    }

    public void setClassPathFiles(List<File> classPathFiles) {
        this.classPathFiles = classPathFiles;
    }

    public ScanTargetPattern[] getScanTargetPatterns() {
        return this.scanTargetPatterns;
    }

    public void setScanTargetPatterns(ScanTargetPattern[] scanTargetPatterns) {
        this.scanTargetPatterns = scanTargetPatterns;
    }

    public ContextHandler[] getConfiguredContextHandlers() {
        return this.contextHandlers;
    }

    public void setContextHandlers(ContextHandler[] contextHandlers) {
        this.contextHandlers = contextHandlers;
    }

    @InputFiles
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }
}

