/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.method;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.gradle.api.GradleException;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeaklyTypeReferencingMethod<T, R> {
    private final ModelType<T> declaringType;
    private final ModelType<R> returnType;
    private final String name;
    private final ImmutableList<ModelType<?>> paramTypes;
    private final int modifiers;

    private WeaklyTypeReferencingMethod(ModelType<T> declaringType, ModelType<R> returnType, Method method) {
        if (declaringType.getRawClass() != method.getDeclaringClass()) {
            throw new IllegalArgumentException("Unexpected target class.");
        }
        this.declaringType = declaringType;
        this.returnType = returnType;
        this.name = method.getName();
        this.paramTypes = ImmutableList.copyOf((Iterable)Iterables.transform(Arrays.asList(method.getGenericParameterTypes()), (Function)new Function<Type, ModelType<?>>(){

            public ModelType<?> apply(Type type) {
                return ModelType.of(type);
            }
        }));
        this.modifiers = method.getModifiers();
    }

    public static <T, R> WeaklyTypeReferencingMethod<T, R> of(ModelType<T> target, ModelType<R> returnType, Method method) {
        return new WeaklyTypeReferencingMethod<T, R>(target, returnType, method);
    }

    public ModelType<T> getDeclaringType() {
        return this.declaringType;
    }

    public ModelType<R> getReturnType() {
        return this.returnType;
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Annotation[] getAnnotations() {
        return this.getMethod().getAnnotations();
    }

    public Type[] getGenericParameterTypes() {
        return (Type[])Iterables.toArray((Iterable)Iterables.transform(this.paramTypes, (Function)new Function<ModelType<?>, Type>(){

            public Type apply(ModelType<?> modelType) {
                return modelType.getType();
            }
        }), Type.class);
    }

    public R invoke(T target, Object ... args) {
        Method method = this.getMethod();
        method.setAccessible(true);
        try {
            Object result = method.invoke(target, args);
            return this.returnType.getConcreteClass().cast(result);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not call %s.%s() on %s", method.getDeclaringClass().getSimpleName(), method.getName(), target), (Throwable)e);
        }
    }

    public Method getMethod() {
        Class[] paramTypesArray = (Class[])Iterables.toArray((Iterable)Iterables.transform(this.paramTypes, (Function)new Function<ModelType<?>, Class<?>>(){

            public Class<?> apply(ModelType<?> modelType) {
                return modelType.getRawClass();
            }
        }), Class.class);
        try {
            return this.declaringType.getRawClass().getDeclaredMethod(this.name, paramTypesArray);
        }
        catch (NoSuchMethodException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.declaringType).append(this.returnType).append((Object)this.name).append(this.paramTypes).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WeaklyTypeReferencingMethod)) {
            return false;
        }
        WeaklyTypeReferencingMethod other = (WeaklyTypeReferencingMethod)Cast.uncheckedCast((Object)obj);
        return new EqualsBuilder().append(this.declaringType, other.declaringType).append(this.returnType, other.returnType).append((Object)this.name, (Object)other.name).append(this.paramTypes, other.paramTypes).isEquals();
    }
}

