/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UnGlueAction
extends JosmAction {
    private transient Node selectedNode;
    private transient Way selectedWay;
    private transient Set<Node> selectedNodes;

    public UnGlueAction() {
        super(I18n.tr("UnGlue Ways", new Object[0]), "unglueways", I18n.tr("Duplicate nodes that are used by multiple ways.", new Object[0]), Shortcut.registerShortcut("tools:unglue", I18n.tr("Tool: {0}", I18n.tr("UnGlue Ways", new Object[0])), 71, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/UnGlue"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Collection<OsmPrimitive> collection = UnGlueAction.getCurrentDataSet().getSelected();
        String string = null;
        int n = Notification.TIME_DEFAULT;
        if (this.checkSelection(collection)) {
            if (!this.checkAndConfirmOutlyingUnglue()) {
                return;
            }
            int n2 = 0;
            for (Way way : OsmPrimitive.getFilteredList(this.selectedNode.getReferrers(), Way.class)) {
                if (!way.isUsable() || way.getNodesCount() < 1) continue;
                ++n2;
            }
            if (n2 < 2) {
                boolean bl = false;
                if (n2 == 1) {
                    bl = this.unglueSelfCrossingWay();
                }
                if (!bl) {
                    if (this.checkForUnglueNode(collection)) {
                        this.unglueNode(actionEvent);
                    } else {
                        n = Notification.TIME_SHORT;
                        string = I18n.tr("This node is not glued to anything else.", new Object[0]);
                    }
                }
            } else {
                this.unglueWays();
            }
        } else if (this.checkSelection2(collection)) {
            if (!this.checkAndConfirmOutlyingUnglue()) {
                return;
            }
            HashSet<Node> hashSet = new HashSet<Node>();
            for (Node node : this.selectedNodes) {
                int n3 = 0;
                for (Way way : OsmPrimitive.getFilteredList(node.getReferrers(), Way.class)) {
                    if (!way.isUsable()) continue;
                    ++n3;
                }
                if (n3 < 2) continue;
                hashSet.add(node);
            }
            if (hashSet.isEmpty()) {
                string = collection.size() > 1 ? I18n.tr("None of these nodes are glued to anything else.", new Object[0]) : I18n.tr("None of this way''s nodes are glued to anything else.", new Object[0]);
            } else {
                this.selectedNodes = hashSet;
                this.unglueWays2();
            }
        } else {
            n = Notification.TIME_VERY_LONG;
            string = I18n.tr("The current selection cannot be used for unglueing.", new Object[0]) + '\n' + '\n' + I18n.tr("Select either:", new Object[0]) + '\n' + I18n.tr("* One tagged node, or", new Object[0]) + '\n' + I18n.tr("* One node that is used by more than one way, or", new Object[0]) + '\n' + I18n.tr("* One node that is used by more than one way and one of those ways, or", new Object[0]) + '\n' + I18n.tr("* One way that has one or more nodes that are used by more than one way, or", new Object[0]) + '\n' + I18n.tr("* One way and one or more of its nodes that are used by more than one way.", new Object[0]) + '\n' + '\n' + I18n.tr("Note: If a way is selected, this way will get fresh copies of the unglued\nnodes and the new nodes will be selected. Otherwise, all ways will get their\nown copy and all nodes will be selected.", new Object[0]);
        }
        if (string != null) {
            new Notification(string).setIcon(0).setDuration(n).show();
        }
        this.selectedNode = null;
        this.selectedWay = null;
        this.selectedNodes = null;
    }

    private void unglueNode(ActionEvent actionEvent) {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        Node node = new Node(this.selectedNode);
        node.removeAll();
        UnGlueAction.getCurrentDataSet().clearSelection(node);
        linkedList.add(new ChangeCommand(this.selectedNode, node));
        Node node2 = new Node(this.selectedNode, true);
        if (actionEvent.getSource() instanceof JPanel) {
            MapView mapView = Main.map.mapView;
            node2.setCoor(mapView.getLatLon(mapView.lastMEvent.getX(), mapView.lastMEvent.getY()));
        }
        linkedList.add(new AddCommand(node2));
        this.fixRelations(this.selectedNode, linkedList, Collections.singletonList(node2));
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Unglued Node", new Object[0]), linkedList));
        UnGlueAction.getCurrentDataSet().setSelected(node2);
        Main.map.mapView.repaint();
    }

    private boolean checkForUnglueNode(Collection<? extends OsmPrimitive> collection) {
        if (collection.size() != 1) {
            return false;
        }
        OsmPrimitive osmPrimitive = (OsmPrimitive)collection.toArray()[0];
        if (!(osmPrimitive instanceof Node)) {
            return false;
        }
        if (OsmPrimitive.getFilteredList(osmPrimitive.getReferrers(), Way.class).isEmpty()) {
            return false;
        }
        this.selectedNode = (Node)osmPrimitive;
        return this.selectedNode.isTagged();
    }

    private boolean checkSelection(Collection<? extends OsmPrimitive> collection) {
        int n = collection.size();
        if (n < 1 || n > 2) {
            return false;
        }
        this.selectedNode = null;
        this.selectedWay = null;
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Node) {
                this.selectedNode = (Node)osmPrimitive;
                if (n != 1 && this.selectedWay == null) continue;
                return n == 1 || this.selectedWay.containsNode(this.selectedNode);
            }
            if (!(osmPrimitive instanceof Way)) continue;
            this.selectedWay = (Way)osmPrimitive;
            if (n != 2 || this.selectedNode == null) continue;
            return this.selectedWay.containsNode(this.selectedNode);
        }
        return false;
    }

    private boolean checkSelection2(Collection<? extends OsmPrimitive> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        this.selectedWay = null;
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Way)) continue;
            if (this.selectedWay != null) {
                return false;
            }
            this.selectedWay = (Way)osmPrimitive;
        }
        if (this.selectedWay == null) {
            return false;
        }
        this.selectedNodes = new HashSet<Node>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Node)) continue;
            Node node = (Node)osmPrimitive;
            if (!this.selectedWay.containsNode(node)) {
                return false;
            }
            this.selectedNodes.add(node);
        }
        if (this.selectedNodes.isEmpty()) {
            this.selectedNodes.addAll(this.selectedWay.getNodes());
        }
        return true;
    }

    private static Way modifyWay(Node node, Way way, List<Command> list, List<Node> list2) {
        Node node2 = new Node(node, true);
        list2.add(node2);
        list.add(new AddCommand(node2));
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node3 : way.getNodes()) {
            if (node == node3) {
                node3 = node2;
            }
            arrayList.add(node3);
        }
        Way way2 = new Way(way);
        way2.setNodes(arrayList);
        return way2;
    }

    private void fixRelations(Node node, List<Command> list, List<Node> list2) {
        for (Relation relation : OsmPrimitive.getFilteredList(node.getReferrers(), Relation.class)) {
            if (relation.isDeleted()) continue;
            Relation relation2 = null;
            HashMap<String, Integer> hashMap = null;
            int n = 0;
            for (RelationMember relationMember : relation.getMembers()) {
                if (relationMember.isNode() && relationMember.getMember() == node) {
                    if (relation2 == null) {
                        relation2 = new Relation(relation);
                        hashMap = new HashMap<String, Integer>();
                    }
                    hashMap.put(relationMember.getRole(), n);
                }
                ++n;
            }
            if (relation2 == null) continue;
            for (Node node2 : list2) {
                for (Map.Entry entry : hashMap.entrySet()) {
                    relation2.addMember((Integer)entry.getValue() + 1, new RelationMember((String)entry.getKey(), node2));
                }
            }
            list.add(new ChangeCommand(relation, relation2));
        }
    }

    private void unglueWays() {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        LinkedList<Node> linkedList2 = new LinkedList<Node>();
        if (this.selectedWay == null) {
            Way way = null;
            LinkedList<Way> linkedList3 = new LinkedList<Way>();
            for (OsmPrimitive osmPrimitive : this.selectedNode.getReferrers()) {
                if (!osmPrimitive.isUsable() || !(osmPrimitive instanceof Way)) continue;
                Way way2 = (Way)osmPrimitive;
                if (way == null && !way2.isFirstLastNode(this.selectedNode)) {
                    way = way2;
                    continue;
                }
                linkedList3.add(way2);
            }
            if (way == null) {
                linkedList3.removeFirst();
            }
            for (Way way3 : linkedList3) {
                linkedList.add(new ChangeCommand(way3, UnGlueAction.modifyWay(this.selectedNode, way3, linkedList, linkedList2)));
            }
        } else {
            linkedList.add(new ChangeCommand(this.selectedWay, UnGlueAction.modifyWay(this.selectedNode, this.selectedWay, linkedList, linkedList2)));
        }
        this.fixRelations(this.selectedNode, linkedList, linkedList2);
        UnGlueAction.execCommands(linkedList, linkedList2);
    }

    private static void execCommands(List<Command> list, List<Node> list2) {
        Main.main.undoRedo.add(new SequenceCommand(I18n.trn("Dupe into {0} node", "Dupe into {0} nodes", list2.size() + 1, list2.size() + 1), list));
        UnGlueAction.getCurrentDataSet().setSelected(list2.get(0));
    }

    private boolean unglueSelfCrossingWay() {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        Way object2 = null;
        for (Way object3 : OsmPrimitive.getFilteredList(this.selectedNode.getReferrers(), Way.class)) {
            if (!object3.isUsable() || object3.getNodesCount() < 1) continue;
            object2 = object3;
        }
        if (object2 == null) {
            return false;
        }
        List<Node> list = object2.getNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>(list.size());
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node == this.selectedNode) {
                if (bl) {
                    Node node2 = new Node(node, true);
                    arrayList.add(node2);
                    linkedList.add(new AddCommand(node2));
                    arrayList.add(node2);
                    arrayList2.add(node2);
                    continue;
                }
                arrayList.add(node);
                bl = true;
                continue;
            }
            arrayList.add(node);
        }
        if (arrayList2.isEmpty()) {
            return false;
        }
        linkedList.add(new ChangeNodesCommand(object2, arrayList));
        this.fixRelations(this.selectedNode, linkedList, arrayList2);
        UnGlueAction.execCommands(linkedList, arrayList2);
        return true;
    }

    private void unglueWays2() {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        LinkedList<Node> linkedList2 = new LinkedList<Node>();
        Way way = this.selectedWay;
        for (Node node : this.selectedNodes) {
            LinkedList<Node> linkedList3 = new LinkedList<Node>();
            way = UnGlueAction.modifyWay(node, way, linkedList, linkedList3);
            this.fixRelations(node, linkedList, linkedList3);
            linkedList2.addAll(linkedList3);
        }
        linkedList.add(new ChangeCommand(this.selectedWay, way));
        Main.main.undoRedo.add(new SequenceCommand(I18n.trn("Dupe {0} node into {1} nodes", "Dupe {0} nodes into {1} nodes", this.selectedNodes.size(), this.selectedNodes.size(), this.selectedNodes.size() + linkedList2.size()), linkedList));
        UnGlueAction.getCurrentDataSet().setSelected(linkedList2);
    }

    @Override
    protected void updateEnabledState() {
        if (UnGlueAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(UnGlueAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    protected boolean checkAndConfirmOutlyingUnglue() {
        ArrayList<Node> arrayList = new ArrayList<Node>(2 + (this.selectedNodes == null ? 0 : this.selectedNodes.size()));
        if (this.selectedNodes != null) {
            arrayList.addAll(this.selectedNodes);
        }
        if (this.selectedNode != null) {
            arrayList.add(this.selectedNode);
        }
        return Command.checkAndConfirmOutlyingOperation("unglue", I18n.tr("Unglue confirmation", new Object[0]), I18n.tr("You are about to unglue nodes outside of the area you have downloaded.<br>This can cause problems because other objects (that you do not see) might use them.<br>Do you really want to unglue?", new Object[0]), I18n.tr("You are about to unglue incomplete objects.<br>This will cause problems because you don''t see the real object.<br>Do you really want to unglue?", new Object[0]), arrayList, null);
    }
}

