/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.jdesktop.swinghelper.debug.CheckThreadViolationRepaintManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.PreferencesAction;
import org.openstreetmap.josm.data.AutosaveTask;
import org.openstreetmap.josm.data.CustomConfigurator;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.SplashScreen;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreference;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.DefaultProxySelector;
import org.openstreetmap.josm.io.MessageNotifier;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.DefaultAuthenticator;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.FontsManager;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.Utils;

public class MainApplication
extends Main {
    public MainApplication() {
    }

    public MainApplication(JFrame jFrame) {
        MainApplication.addListener();
        jFrame.setContentPane(contentPanePrivate);
        jFrame.setJMenuBar(this.menu);
        geometry.applySafe(jFrame);
        LinkedList<Image> linkedList = new LinkedList<Image>();
        linkedList.add(ImageProvider.get("logo_16x16x32").getImage());
        linkedList.add(ImageProvider.get("logo_16x16x8").getImage());
        linkedList.add(ImageProvider.get("logo_32x32x32").getImage());
        linkedList.add(ImageProvider.get("logo_32x32x8").getImage());
        linkedList.add(ImageProvider.get("logo_48x48x32").getImage());
        linkedList.add(ImageProvider.get("logo_48x48x8").getImage());
        linkedList.add(ImageProvider.get("logo").getImage());
        jFrame.setIconImages(linkedList);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Main.exitJosm(true, 0);
            }
        });
        jFrame.setDefaultCloseOperation(0);
    }

    public static void showHelp() {
        System.out.println(I18n.tr("Java OpenStreetMap Editor", new Object[0]) + " [" + Version.getInstance().getAgentString() + "]\n\n" + I18n.tr("usage", new Object[0]) + ":\n" + "\tjava -jar josm.jar <options>...\n\n" + I18n.tr("options", new Object[0]) + ":\n" + "\t--help|-h                                 " + I18n.tr("Show this help", new Object[0]) + '\n' + "\t--geometry=widthxheight(+|-)x(+|-)y       " + I18n.tr("Standard unix geometry argument", new Object[0]) + '\n' + "\t[--download=]minlat,minlon,maxlat,maxlon  " + I18n.tr("Download the bounding box", new Object[0]) + '\n' + "\t[--download=]<URL>                        " + I18n.tr("Download the location at the URL (with lat=x&lon=y&zoom=z)", new Object[0]) + '\n' + "\t[--download=]<filename>                   " + I18n.tr("Open a file (any file type that can be opened with File/Open)", new Object[0]) + '\n' + "\t--downloadgps=minlat,minlon,maxlat,maxlon " + I18n.tr("Download the bounding box as raw GPS", new Object[0]) + '\n' + "\t--downloadgps=<URL>                       " + I18n.tr("Download the location at the URL (with lat=x&lon=y&zoom=z) as raw GPS", new Object[0]) + '\n' + "\t--selection=<searchstring>                " + I18n.tr("Select with the given search", new Object[0]) + '\n' + "\t--[no-]maximize                           " + I18n.tr("Launch in maximized mode", new Object[0]) + '\n' + "\t--reset-preferences                       " + I18n.tr("Reset the preferences to default", new Object[0]) + "\n\n" + "\t--load-preferences=<url-to-xml>           " + I18n.tr("Changes preferences according to the XML file", new Object[0]) + "\n\n" + "\t--set=<key>=<value>                       " + I18n.tr("Set preference key to value", new Object[0]) + "\n\n" + "\t--language=<language>                     " + I18n.tr("Set the language", new Object[0]) + "\n\n" + "\t--version                                 " + I18n.tr("Displays the JOSM version and exits", new Object[0]) + "\n\n" + "\t--debug                                   " + I18n.tr("Print debugging messages to console", new Object[0]) + "\n\n" + "\t--skip-plugins                            " + I18n.tr("Skip loading plugins", new Object[0]) + "\n\n" + "\t--offline=<osm_api|josm_website|all>      " + I18n.tr("Disable access to the given resource(s), separated by comma", new Object[0]) + "\n\n" + I18n.tr("options provided as Java system properties", new Object[0]) + ":\n" + "\t-Djosm.pref=" + I18n.tr("/PATH/TO/JOSM/PREF    ", new Object[0]) + I18n.tr("Set the preferences directory", new Object[0]) + "\n\n" + "\t-Djosm.userdata=" + I18n.tr("/PATH/TO/JOSM/USERDATA", new Object[0]) + I18n.tr("Set the user data directory", new Object[0]) + "\n\n" + "\t-Djosm.cache=" + I18n.tr("/PATH/TO/JOSM/CACHE   ", new Object[0]) + I18n.tr("Set the cache directory", new Object[0]) + "\n\n" + "\t-Djosm.home=" + I18n.tr("/PATH/TO/JOSM/HOMEDIR ", new Object[0]) + I18n.tr("Relocate all 3 directories to homedir. Cache directory will be in homedir/cache", new Object[0]) + "\n\n" + I18n.tr("-Djosm.home has lower precedence, i.e. the specific setting overrides the general one", new Object[0]) + "\n\n" + I18n.tr("note: For some tasks, JOSM needs a lot of memory. It can be necessary to add the following\n      Java option to specify the maximum size of allocated memory in megabytes", new Object[0]) + ":\n" + "\t-Xmx...m\n\n" + I18n.tr("examples", new Object[0]) + ":\n" + "\tjava -jar josm.jar track1.gpx track2.gpx london.osm\n" + "\tjava -jar josm.jar " + OsmUrlToBounds.getURL(43.2, 11.1, 13) + '\n' + "\tjava -jar josm.jar london.osm --selection=http://www.ostertag.name/osm/OSM_errors_node-duplicate.xml\n" + "\tjava -jar josm.jar 43.2,11.1,43.4,11.4\n" + "\tjava -Djosm.pref=$XDG_CONFIG_HOME -Djosm.userdata=$XDG_DATA_HOME -Djosm.cache=$XDG_CACHE_HOME -jar josm.jar\n" + "\tjava -Djosm.home=/home/user/.josm_dev -jar josm.jar\n" + "\tjava -Xmx1024m -jar josm.jar\n\n" + I18n.tr("Parameters --download, --downloadgps, and --selection are processed in this order.", new Object[0]) + '\n' + I18n.tr("Make sure you load some data if you use --selection.", new Object[0]) + '\n');
    }

    private static Map<Option, Collection<String>> buildCommandLineArgumentMap(String[] stringArray) {
        Collection<String> collection;
        int n;
        ArrayList<LongOpt> arrayList = new ArrayList<LongOpt>();
        for (Option option : Option.values()) {
            arrayList.add(new LongOpt(option.getName(), option.requiresArgument() ? 1 : 0, null, 0));
        }
        Getopt getopt = new Getopt("JOSM", stringArray, "hv", arrayList.toArray(new LongOpt[arrayList.size()]));
        EnumMap<Option, Collection<String>> enumMap = new EnumMap<Option, Collection<String>>(Option.class);
        while ((n = getopt.getopt()) != -1) {
            Option option;
            option = null;
            switch (n) {
                case 104: {
                    option = Option.HELP;
                    break;
                }
                case 118: {
                    option = Option.VERSION;
                    break;
                }
                case 0: {
                    option = Option.values()[getopt.getLongind()];
                }
            }
            if (option != null) {
                collection = (ArrayList<String>)enumMap.get((Object)option);
                if (collection == null) {
                    collection = new ArrayList<String>();
                    enumMap.put(option, collection);
                }
                collection.add(getopt.getOptarg());
                continue;
            }
            throw new IllegalArgumentException("Invalid option: " + n);
        }
        for (int i = getopt.getOptind(); i < stringArray.length; ++i) {
            collection = (Collection)enumMap.get((Object)Option.DOWNLOAD);
            if (collection == null) {
                collection = new ArrayList();
                enumMap.put(Option.DOWNLOAD, collection);
            }
            collection.add(stringArray[i]);
        }
        return enumMap;
    }

    public static void main(String[] stringArray) {
        Object object;
        Collection<PluginInformation> exception;
        Object object3;
        Object object4;
        Object object5;
        I18n.init();
        Main.checkJavaVersion();
        Map<Option, Collection<String>> map = null;
        try {
            map = MainApplication.buildCommandLineArgumentMap(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.exit(1);
            return;
        }
        boolean bl = map.containsKey((Object)Option.LANGUAGE);
        if (bl) {
            I18n.set(map.get((Object)Option.LANGUAGE).iterator().next());
        }
        MainApplication.initApplicationPreferences();
        Policy.setPolicy(new Policy(){
            private PermissionCollection pc = new Permissions();
            {
                this.pc.add(new AllPermission());
            }

            @Override
            public PermissionCollection getPermissions(CodeSource codeSource) {
                return this.pc;
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(new BugReportExceptionHandler());
        Main.determinePlatformHook();
        Main.platform.preStartupHook();
        Main.COMMAND_LINE_ARGS.addAll(Arrays.asList(stringArray));
        if (map.containsKey((Object)Option.VERSION)) {
            System.out.println(Version.getInstance().getAgentString());
            System.exit(0);
        }
        if (map.containsKey((Object)Option.DEBUG) || map.containsKey((Object)Option.TRACE)) {
            logLevel = 4;
            Main.info(I18n.tr("Printing debugging messages to console", new Object[0]));
        }
        boolean bl2 = false;
        if (map.containsKey((Object)Option.SKIP_PLUGINS)) {
            bl2 = true;
            Main.info(I18n.tr("Plugin loading skipped", new Object[0]));
        }
        if (map.containsKey((Object)Option.TRACE)) {
            logLevel = 5;
            Utils.updateSystemProperty("debug", "true");
            Main.info(I18n.tr("Enabled detailed debug level (trace)", new Object[0]));
        }
        Main.pref.init(map.containsKey((Object)Option.RESET_PREFERENCES));
        if (map.containsKey((Object)Option.SET)) {
            object5 = map.get((Object)Option.SET).iterator();
            while (object5.hasNext()) {
                object4 = object5.next();
                object3 = ((String)object4).split("=", 2);
                Main.pref.put(object3[0], "null".equals(object3[1]) ? null : object3[1]);
            }
        }
        if (!bl) {
            I18n.set(Main.pref.get("language", null));
        }
        Main.pref.updateSystemProperties();
        MainApplication.checkIPv6();
        if (map.containsKey((Object)Option.HELP)) {
            MainApplication.showHelp();
            System.exit(0);
        }
        MainApplication.processOffline(map);
        Main.platform.afterPrefStartupHook();
        FontsManager.initialize();
        I18n.setupLanguageFonts();
        Main.parent = object5 = new JFrame(I18n.tr("Java OpenStreetMap Editor", new Object[0]));
        if (map.containsKey((Object)Option.LOAD_PREFERENCES)) {
            object4 = new CustomConfigurator.XMLCommandProcessor(Main.pref);
            for (String object22 : map.get((Object)Option.LOAD_PREFERENCES)) {
                MainApplication.info("Reading preferences from " + object22);
                try {
                    exception = HttpClient.create(new URL(object22)).connect().getContent();
                    object = null;
                    try {
                        ((CustomConfigurator.XMLCommandProcessor)object4).openAndReadXML((InputStream)((Object)exception));
                    }
                    catch (Throwable bl3) {
                        object = bl3;
                        throw bl3;
                    }
                    finally {
                        if (exception == null) continue;
                        if (object != null) {
                            try {
                                ((InputStream)((Object)exception)).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            continue;
                        }
                        ((InputStream)((Object)exception)).close();
                    }
                }
                catch (Exception exception2) {
                    throw new RuntimeException(exception2);
                }
            }
        }
        DefaultAuthenticator.createInstance();
        Authenticator.setDefault(DefaultAuthenticator.getInstance());
        object4 = new DefaultProxySelector(ProxySelector.getDefault());
        ProxySelector.setDefault((ProxySelector)object4);
        OAuthAccessTokenHolder.getInstance().init(Main.pref, CredentialsManager.getInstance());
        object3 = GuiHelper.runInEDTAndWaitAndReturn(new Callable<SplashScreen>(){

            @Override
            public SplashScreen call() {
                return new SplashScreen();
            }
        });
        final SplashScreen.SplashProgressMonitor splashProgressMonitor = ((SplashScreen)object3).getProgressMonitor();
        splashProgressMonitor.beginTask(I18n.tr("Initializing", new Object[0]));
        GuiHelper.runInEDT(new Runnable((SplashScreen)object3){
            final /* synthetic */ SplashScreen val$splash;
            {
                this.val$splash = splashScreen;
            }

            @Override
            public void run() {
                this.val$splash.setVisible(Main.pref.getBoolean("draw.splashscreen", true));
            }
        });
        Main.setInitStatusListener(new Main.InitStatusListener(){

            @Override
            public Object updateStatus(String string) {
                splashProgressMonitor.beginTask(string);
                return string;
            }

            @Override
            public void finish(Object object) {
                if (object instanceof String) {
                    splashProgressMonitor.finishTask((String)object);
                }
            }
        });
        exception = null;
        if (!bl2) {
            exception = PluginHandler.buildListOfPluginsToLoad((Component)object3, splashProgressMonitor.createSubTaskMonitor(1, false));
            if (!exception.isEmpty() && PluginHandler.checkAndConfirmPluginUpdate((Component)object3)) {
                splashProgressMonitor.subTask(I18n.tr("Updating plugins", new Object[0]));
                exception = PluginHandler.updatePlugins((Component)object3, null, splashProgressMonitor.createSubTaskMonitor(1, false), false);
            }
            splashProgressMonitor.indeterminateSubTask(I18n.tr("Installing updated plugins", new Object[0]));
            PluginHandler.installDownloadedPlugins(true);
            splashProgressMonitor.indeterminateSubTask(I18n.tr("Loading early plugins", new Object[0]));
            PluginHandler.loadEarlyPlugins((Component)object3, exception, splashProgressMonitor.createSubTaskMonitor(1, false));
        }
        splashProgressMonitor.indeterminateSubTask(I18n.tr("Setting defaults", new Object[0]));
        MainApplication.preConstructorInit(map);
        splashProgressMonitor.indeterminateSubTask(I18n.tr("Creating main GUI", new Object[0]));
        object = new MainApplication((JFrame)object5);
        if (!bl2) {
            splashProgressMonitor.indeterminateSubTask(I18n.tr("Loading plugins", new Object[0]));
            PluginHandler.loadLatePlugins((Component)object3, exception, splashProgressMonitor.createSubTaskMonitor(1, false));
            toolbar.refreshToolbarControl();
        }
        GuiHelper.runInEDTAndWait(new Runnable((SplashScreen)object3, (JFrame)object5, (Main)object){
            final /* synthetic */ SplashScreen val$splash;
            final /* synthetic */ JFrame val$mainFrame;
            final /* synthetic */ Main val$main;
            {
                this.val$splash = splashScreen;
                this.val$mainFrame = jFrame;
                this.val$main = main;
            }

            @Override
            public void run() {
                this.val$splash.setVisible(false);
                this.val$splash.dispose();
                this.val$mainFrame.setVisible(true);
                this.val$main.gettingStarted.requestFocusInWindow();
            }
        });
        Main.MasterWindowListener.setup();
        boolean bl3 = Main.pref.getBoolean("gui.maximized", false);
        if (!map.containsKey((Object)Option.NO_MAXIMIZE) && bl3 || map.containsKey((Object)Option.MAXIMIZE)) {
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                Main.windowState = 6;
                ((Frame)object5).setExtendedState(Main.windowState);
            } else {
                Main.debug("Main window: maximizing not supported");
            }
        }
        if (((Main)object).menu.fullscreenToggleAction != null) {
            ((Main)object).menu.fullscreenToggleAction.initial();
        }
        SwingUtilities.invokeLater(new GuiFinalizationWorker(map, (DefaultProxySelector)object4));
        if (Main.isPlatformWindows()) {
            try {
                PlatformHookWindows.removeInsecureCertificates();
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception3) {
                MainApplication.error(exception3);
            }
        }
        if (RemoteControl.PROP_REMOTECONTROL_ENABLED.get().booleanValue()) {
            RemoteControl.start();
        }
        if (MessageNotifier.PROP_NOTIFIER_ENABLED.get().booleanValue()) {
            MessageNotifier.start();
        }
        if (Main.pref.getBoolean("debug.edt-checker.enable", Version.getInstance().isLocalBuild())) {
            MainApplication.info("Enabled EDT checker, wrongful access to gui from non EDT thread will be printed to console");
            RepaintManager.setCurrentManager(new CheckThreadViolationRepaintManager());
        }
    }

    private static void processOffline(Map<Option, Collection<String>> map) {
        if (map.containsKey((Object)Option.OFFLINE)) {
            for (String string : map.get((Object)Option.OFFLINE).iterator().next().split(",")) {
                try {
                    Main.setOffline(OnlineResource.valueOf(string.toUpperCase(Locale.ENGLISH)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Main.error(I18n.tr("''{0}'' is not a valid value for argument ''{1}''. Possible values are {2}, possibly delimited by commas.", string.toUpperCase(Locale.ENGLISH), Option.OFFLINE.getName(), Arrays.toString((Object[])OnlineResource.values())));
                    System.exit(1);
                    return;
                }
            }
            Set<OnlineResource> set = Main.getOfflineResources();
            if (!set.isEmpty()) {
                Main.warn(I18n.trn("JOSM is running in offline mode. This resource will not be available: {0}", "JOSM is running in offline mode. These resources will not be available: {0}", set.size(), set.size() == 1 ? (Serializable)set.iterator().next() : Arrays.toString(set.toArray())));
            }
        }
    }

    private static void checkIPv6() {
        if ("auto".equals(Main.pref.get("prefer.ipv6", "auto"))) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean bl;
                    boolean bl2;
                    block8: {
                        bl2 = false;
                        bl = Main.pref.getBoolean("validated.ipv6", false);
                        try {
                            if (bl) {
                                Utils.updateSystemProperty("java.net.preferIPv6Addresses", "true");
                            }
                            for (InetAddress inetAddress : InetAddress.getAllByName("josm.openstreetmap.de")) {
                                if (!(inetAddress instanceof Inet6Address)) continue;
                                if (inetAddress.isReachable(1000)) {
                                    Socket socket = new Socket();
                                    socket.connect(new InetSocketAddress(inetAddress, 80), 1000);
                                    socket.close();
                                    Utils.updateSystemProperty("java.net.preferIPv6Addresses", "true");
                                    if (!bl) {
                                        Main.info(I18n.tr("Detected useable IPv6 network, prefering IPv6 over IPv4 after next restart.", new Object[0]));
                                    } else {
                                        Main.info(I18n.tr("Detected useable IPv6 network, prefering IPv6 over IPv4.", new Object[0]));
                                    }
                                    bl2 = true;
                                }
                                break;
                            }
                        }
                        catch (IOException | SecurityException exception) {
                            if (!Main.isDebugEnabled()) break block8;
                            Main.debug("Exception while checking IPv6 connectivity: " + exception);
                        }
                    }
                    if (bl && !bl2) {
                        Main.info(I18n.tr("Detected no useable IPv6 network, prefering IPv4 over IPv6 after next restart.", new Object[0]));
                    }
                    Main.pref.put("validated.ipv6", bl2);
                }
            }, "IPv6-checker").start();
        }
    }

    private static class GuiFinalizationWorker
    implements Runnable {
        private final Map<Option, Collection<String>> args;
        private final DefaultProxySelector proxySelector;

        GuiFinalizationWorker(Map<Option, Collection<String>> map, DefaultProxySelector defaultProxySelector) {
            this.args = map;
            this.proxySelector = defaultProxySelector;
        }

        @Override
        public void run() {
            if (!this.handleProxyErrors()) {
                this.handleNetworkErrors();
            }
            GuiFinalizationWorker.handleAutosave();
            MainApplication.postConstructorProcessCmdLine(this.args);
            DownloadDialog.autostartIfNeeded();
        }

        private static void handleAutosave() {
            if (AutosaveTask.PROP_AUTOSAVE_ENABLED.get().booleanValue()) {
                AutosaveTask autosaveTask = new AutosaveTask();
                List<File> list = autosaveTask.getUnsavedLayersFiles();
                if (!list.isEmpty()) {
                    ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Unsaved osm data", new Object[0]), new String[]{I18n.tr("Restore", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Discard", new Object[0])});
                    extendedDialog.setContent(I18n.trn("JOSM found {0} unsaved osm data layer. ", "JOSM found {0} unsaved osm data layers. ", list.size(), list.size()) + I18n.tr("It looks like JOSM crashed last time. Would you like to restore the data?", new Object[0]));
                    extendedDialog.setButtonIcons(new String[]{"ok", "cancel", "dialogs/delete"});
                    int n = extendedDialog.showDialog().getValue();
                    if (n == 1) {
                        autosaveTask.recoverUnsavedLayers();
                    } else if (n == 3) {
                        autosaveTask.discardUnsavedLayers();
                    }
                }
                autosaveTask.schedule();
            }
        }

        private boolean handleNetworkOrProxyErrors(boolean bl, String string, String string2) {
            if (bl) {
                ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, string, new String[]{I18n.tr("Change proxy settings", new Object[0]), I18n.tr("Cancel", new Object[0])});
                extendedDialog.setButtonIcons(new String[]{"dialogs/settings", "cancel"}).setCancelButton(2);
                extendedDialog.setMinimumSize(new Dimension(460, 260));
                extendedDialog.setIcon(2);
                extendedDialog.setContent(string2);
                if (extendedDialog.showDialog().getValue() == 1) {
                    PreferencesAction.forPreferenceSubTab(null, null, ProxyPreference.class).run();
                }
            }
            return bl;
        }

        private boolean handleProxyErrors() {
            return this.handleNetworkOrProxyErrors(this.proxySelector.hasErrors(), I18n.tr("Proxy errors occurred", new Object[0]), I18n.tr("JOSM tried to access the following resources:<br>{0}but <b>failed</b> to do so, because of the following proxy errors:<br>{1}Would you like to change your proxy settings now?", Utils.joinAsHtmlUnorderedList(this.proxySelector.getErrorResources()), Utils.joinAsHtmlUnorderedList(this.proxySelector.getErrorMessages())));
        }

        private boolean handleNetworkErrors() {
            boolean bl;
            boolean bl2 = bl = !NETWORK_ERRORS.isEmpty();
            if (bl) {
                TreeSet<String> treeSet = new TreeSet<String>();
                for (Throwable throwable : NETWORK_ERRORS.values()) {
                    treeSet.add(throwable.toString());
                }
                return this.handleNetworkOrProxyErrors(bl, I18n.tr("Network errors occurred", new Object[0]), I18n.tr("JOSM tried to access the following resources:<br>{0}but <b>failed</b> to do so, because of the following network errors:<br>{1}It may be due to a missing proxy configuration.<br>Would you like to change your proxy settings now?", Utils.joinAsHtmlUnorderedList(NETWORK_ERRORS.keySet()), Utils.joinAsHtmlUnorderedList(treeSet)));
            }
            return false;
        }
    }

    public static enum Option {
        HELP(false),
        VERSION(false),
        DEBUG(false),
        TRACE(false),
        LANGUAGE(true),
        RESET_PREFERENCES(false),
        LOAD_PREFERENCES(true),
        SET(true),
        GEOMETRY(true),
        NO_MAXIMIZE(false),
        MAXIMIZE(false),
        DOWNLOAD(true),
        DOWNLOADGPS(true),
        SELECTION(true),
        OFFLINE(true),
        SKIP_PLUGINS(false);

        private final String name = this.name().toLowerCase(Locale.ENGLISH).replace('_', '-');
        private final boolean requiresArg;

        private Option(boolean bl) {
            this.requiresArg = bl;
        }

        public String getName() {
            return this.name;
        }

        public boolean requiresArgument() {
            return this.requiresArg;
        }
    }
}

