/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveComparator;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.xml.XmlStyleSource;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.WindowGeometry;
import org.openstreetmap.josm.tools.date.DateUtils;

public class InspectPrimitiveDialog
extends ExtendedDialog {
    protected transient List<OsmPrimitive> primitives;
    protected transient OsmDataLayer layer;
    private boolean mappaintTabLoaded;
    private boolean editcountTabLoaded;

    public InspectPrimitiveDialog(Collection<OsmPrimitive> collection, OsmDataLayer osmDataLayer) {
        super(Main.parent, I18n.tr("Advanced object info", new Object[0]), new String[]{I18n.tr("Close", new Object[0])});
        this.primitives = new ArrayList<OsmPrimitive>(collection);
        this.layer = osmDataLayer;
        this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(750, 550)));
        this.setButtonIcons(new String[]{"ok.png"});
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(I18n.tr("data", new Object[0]), this.genericMonospacePanel(new JPanel(), this.buildDataText()));
        final JPanel jPanel = new JPanel();
        jTabbedPane.addTab(I18n.tr("map style", new Object[0]), jPanel);
        jTabbedPane.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!InspectPrimitiveDialog.this.mappaintTabLoaded && ((SingleSelectionModel)changeEvent.getSource()).getSelectedIndex() == 1) {
                    InspectPrimitiveDialog.this.mappaintTabLoaded = true;
                    InspectPrimitiveDialog.this.genericMonospacePanel(jPanel, InspectPrimitiveDialog.this.buildMapPaintText());
                }
            }
        });
        final JPanel jPanel2 = new JPanel();
        jTabbedPane.addTab(I18n.tr("edit counts", new Object[0]), jPanel2);
        jTabbedPane.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!InspectPrimitiveDialog.this.editcountTabLoaded && ((SingleSelectionModel)changeEvent.getSource()).getSelectedIndex() == 2) {
                    InspectPrimitiveDialog.this.editcountTabLoaded = true;
                    InspectPrimitiveDialog.this.genericMonospacePanel(jPanel2, InspectPrimitiveDialog.this.buildListOfEditorsText());
                }
            }
        });
        this.setContent(jTabbedPane, false);
    }

    protected JPanel genericMonospacePanel(JPanel jPanel, String string) {
        jPanel.setLayout(new GridBagLayout());
        JosmTextArea josmTextArea = new JosmTextArea();
        josmTextArea.setFont(GuiHelper.getMonospacedFont(josmTextArea));
        josmTextArea.setEditable(false);
        josmTextArea.append(string);
        jPanel.add((Component)new JScrollPane(josmTextArea), GBC.std().fill());
        return jPanel;
    }

    protected String buildDataText() {
        DataText dataText = new DataText();
        Collections.sort(this.primitives, new OsmPrimitiveComparator());
        for (OsmPrimitive osmPrimitive : this.primitives) {
            dataText.addPrimitive(osmPrimitive);
        }
        return dataText.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String buildMapPaintText() {
        Object object;
        Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getAllSelected();
        ElemStyles elemStyles = MapPaintStyles.getStyles();
        MapView mapView = Main.map.mapView;
        double d = mapView.getDist100Pixel();
        StringBuilder stringBuilder = new StringBuilder();
        MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
        try {
            for (OsmPrimitive object2 : collection) {
                stringBuilder.append(I18n.tr("Styles Cache for \"{0}\":", object2.getDisplayName(DefaultNameFormatter.getInstance())));
                object = new MultiCascade();
                for (StyleSource styleSource : elemStyles.getStyleSources()) {
                    if (styleSource.active) {
                        stringBuilder.append(I18n.tr("\n\n> applying {0} style \"{1}\"\n", InspectPrimitiveDialog.getSort(styleSource), styleSource.getDisplayString()));
                        styleSource.apply((MultiCascade)object, object2, d, false);
                        stringBuilder.append(I18n.tr("\nRange:{0}", ((MultiCascade)object).range));
                        for (Map.Entry entry : ((MultiCascade)object).getLayers()) {
                            stringBuilder.append("\n ").append((String)entry.getKey()).append(": \n").append(entry.getValue());
                        }
                        continue;
                    }
                    stringBuilder.append(I18n.tr("\n\n> skipping \"{0}\" (not active)", styleSource.getDisplayString()));
                }
                stringBuilder.append(I18n.tr("\n\nList of generated Styles:\n", new Object[0]));
                StyleCache.StyleList styleList = elemStyles.get(object2, d, mapView);
                Iterator<ElemStyle> iterator = styleList.iterator();
                while (iterator.hasNext()) {
                    ElemStyle elemStyle = iterator.next();
                    stringBuilder.append(" * ").append(elemStyle).append('\n');
                }
                stringBuilder.append("\n\n");
            }
        }
        finally {
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
        }
        if (collection.size() == 2) {
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(collection);
            StyleCache styleCache = ((OsmPrimitive)arrayList.get((int)0)).mappaintStyle;
            object = ((OsmPrimitive)arrayList.get((int)1)).mappaintStyle;
            if (styleCache == object) {
                stringBuilder.append(I18n.tr("The 2 selected objects have identical style caches.", new Object[0]));
            }
            if (!styleCache.equals(object)) {
                stringBuilder.append(I18n.tr("The 2 selected objects have different style caches.", new Object[0]));
            }
            if (styleCache.equals(object) && styleCache != object) {
                stringBuilder.append(I18n.tr("Warning: The 2 selected objects have equal, but not identical style caches.", new Object[0]));
            }
        }
        return stringBuilder.toString();
    }

    protected String buildListOfEditorsText() {
        Integer n;
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        TreeMap<Object, Integer> treeMap = new TreeMap<Object, Integer>(Collator.getInstance(Locale.getDefault()));
        for (OsmPrimitive object : this.primitives) {
            if (object.getUser() == null) continue;
            string = object.getUser().getName();
            n = (Integer)treeMap.get(string);
            if (n == null) {
                treeMap.put(string, 1);
                continue;
            }
            treeMap.put(string, n + 1);
        }
        stringBuilder.append(I18n.trn("{0} user last edited the selection:", "{0} users last edited the selection:", treeMap.size(), treeMap.size()));
        stringBuilder.append("\n\n");
        for (Map.Entry entry : treeMap.entrySet()) {
            string = (String)entry.getKey();
            n = (Integer)entry.getValue();
            stringBuilder.append(String.format("%6d  %s%n", n, string));
        }
        return stringBuilder.toString();
    }

    private static String getSort(StyleSource styleSource) {
        if (styleSource instanceof XmlStyleSource) {
            return I18n.tr("xml", new Object[0]);
        }
        if (styleSource instanceof MapCSSStyleSource) {
            return I18n.tr("mapcss", new Object[0]);
        }
        return I18n.tr("unknown", new Object[0]);
    }

    class DataText {
        private static final String INDENT = "  ";
        private static final char NL = '\n';
        private final StringBuilder s = new StringBuilder();

        DataText() {
        }

        private DataText add(String string, String ... stringArray) {
            this.s.append(INDENT).append(string);
            for (String string2 : stringArray) {
                this.s.append(string2);
            }
            this.s.append('\n');
            return this;
        }

        private String getNameAndId(String string, long l) {
            if (string != null) {
                return string + I18n.tr(" ({0})", Long.toString(l));
            }
            return Long.toString(l);
        }

        public void addPrimitive(OsmPrimitive osmPrimitive) {
            this.addHeadline(osmPrimitive);
            if (osmPrimitive.getDataSet() == null || osmPrimitive.getDataSet().getPrimitiveById(osmPrimitive) == null) {
                this.s.append('\n').append(INDENT).append(I18n.tr("not in data set", new Object[0])).append('\n');
                return;
            }
            if (osmPrimitive.isIncomplete()) {
                this.s.append('\n').append(INDENT).append(I18n.tr("incomplete", new Object[0])).append('\n');
                return;
            }
            this.s.append('\n');
            this.addState(osmPrimitive);
            this.addCommon(osmPrimitive);
            this.addAttributes(osmPrimitive);
            this.addSpecial(osmPrimitive);
            this.addReferrers(this.s, osmPrimitive);
            this.addConflicts(osmPrimitive);
            this.s.append('\n');
        }

        void addHeadline(OsmPrimitive osmPrimitive) {
            this.addType(osmPrimitive);
            this.addNameAndId(osmPrimitive);
        }

        void addType(OsmPrimitive osmPrimitive) {
            if (osmPrimitive instanceof Node) {
                this.s.append(I18n.tr("Node: ", new Object[0]));
            } else if (osmPrimitive instanceof Way) {
                this.s.append(I18n.tr("Way: ", new Object[0]));
            } else if (osmPrimitive instanceof Relation) {
                this.s.append(I18n.tr("Relation: ", new Object[0]));
            }
        }

        void addNameAndId(OsmPrimitive osmPrimitive) {
            String string = osmPrimitive.get("name");
            if (string == null) {
                this.s.append(osmPrimitive.getUniqueId());
            } else {
                this.s.append(this.getNameAndId(string, osmPrimitive.getUniqueId()));
            }
        }

        void addState(OsmPrimitive osmPrimitive) {
            String string;
            StringBuilder stringBuilder = new StringBuilder(INDENT);
            if (osmPrimitive.isDeleted()) {
                stringBuilder.append(I18n.tr("deleted", new Object[0])).append(INDENT);
            }
            if (!osmPrimitive.isVisible()) {
                stringBuilder.append(I18n.tr("deleted-on-server", new Object[0])).append(INDENT);
            }
            if (osmPrimitive.isModified()) {
                stringBuilder.append(I18n.tr("modified", new Object[0])).append(INDENT);
            }
            if (osmPrimitive.isDisabledAndHidden()) {
                stringBuilder.append(I18n.tr("filtered/hidden", new Object[0])).append(INDENT);
            }
            if (osmPrimitive.isDisabled()) {
                stringBuilder.append(I18n.tr("filtered/disabled", new Object[0])).append(INDENT);
            }
            if (osmPrimitive.hasDirectionKeys()) {
                if (osmPrimitive.reversedDirection()) {
                    stringBuilder.append(I18n.tr("has direction keys (reversed)", new Object[0])).append(INDENT);
                } else {
                    stringBuilder.append(I18n.tr("has direction keys", new Object[0])).append(INDENT);
                }
            }
            if (!(string = stringBuilder.toString().trim()).isEmpty()) {
                this.add(I18n.tr("State: ", new Object[0]), stringBuilder.toString().trim());
            }
        }

        void addCommon(OsmPrimitive osmPrimitive) {
            this.add(I18n.tr("Data Set: ", new Object[0]), Integer.toHexString(osmPrimitive.getDataSet().hashCode()));
            this.add(I18n.tr("Edited at: ", new Object[0]), osmPrimitive.isTimestampEmpty() ? I18n.tr("<new object>", new Object[0]) : DateUtils.fromTimestamp(osmPrimitive.getRawTimestamp()));
            this.add(I18n.tr("Edited by: ", new Object[0]), osmPrimitive.getUser() == null ? I18n.tr("<new object>", new Object[0]) : this.getNameAndId(osmPrimitive.getUser().getName(), osmPrimitive.getUser().getId()));
            this.add(I18n.tr("Version: ", new Object[0]), Integer.toString(osmPrimitive.getVersion()));
            this.add(I18n.tr("In changeset: ", new Object[0]), Integer.toString(osmPrimitive.getChangesetId()));
        }

        void addAttributes(OsmPrimitive osmPrimitive) {
            if (osmPrimitive.hasKeys()) {
                this.add(I18n.tr("Tags: ", new Object[0]), new String[0]);
                for (String string : osmPrimitive.keySet()) {
                    this.s.append(INDENT).append(INDENT);
                    this.s.append(String.format("\"%s\"=\"%s\"%n", string, osmPrimitive.get(string)));
                }
            }
        }

        void addSpecial(OsmPrimitive osmPrimitive) {
            if (osmPrimitive instanceof Node) {
                this.addCoordinates((Node)osmPrimitive);
            } else if (osmPrimitive instanceof Way) {
                this.addBbox(osmPrimitive);
                this.add(I18n.tr("Centroid: ", new Object[0]), Main.getProjection().eastNorth2latlon(Geometry.getCentroid(((Way)osmPrimitive).getNodes())).toStringCSV(", "));
                this.addWayNodes((Way)osmPrimitive);
            } else if (osmPrimitive instanceof Relation) {
                this.addBbox(osmPrimitive);
                this.addRelationMembers((Relation)osmPrimitive);
            }
        }

        void addRelationMembers(Relation relation) {
            this.add(I18n.trn("{0} Member: ", "{0} Members: ", relation.getMembersCount(), relation.getMembersCount()), new String[0]);
            for (RelationMember relationMember : relation.getMembers()) {
                this.s.append(INDENT).append(INDENT);
                this.addHeadline(relationMember.getMember());
                this.s.append(I18n.tr(" as \"{0}\"", relationMember.getRole()));
                this.s.append('\n');
            }
        }

        void addWayNodes(Way way) {
            this.add(I18n.tr("{0} Nodes: ", way.getNodesCount()), new String[0]);
            for (Node node : way.getNodes()) {
                this.s.append(INDENT).append(INDENT);
                this.addNameAndId(node);
                this.s.append('\n');
            }
        }

        void addBbox(OsmPrimitive osmPrimitive) {
            BBox bBox = osmPrimitive.getBBox();
            if (bBox != null) {
                this.add(I18n.tr("Bounding box: ", new Object[0]), bBox.toStringCSV(", "));
                EastNorth eastNorth = Main.getProjection().latlon2eastNorth(bBox.getBottomRight());
                EastNorth eastNorth2 = Main.getProjection().latlon2eastNorth(bBox.getTopLeft());
                this.add(I18n.tr("Bounding box (projected): ", new Object[0]), Double.toString(eastNorth2.east()), ", ", Double.toString(eastNorth.north()), ", ", Double.toString(eastNorth.east()), ", ", Double.toString(eastNorth2.north()));
                this.add(I18n.tr("Center of bounding box: ", new Object[0]), bBox.getCenter().toStringCSV(", "));
            }
        }

        void addCoordinates(Node node) {
            if (node.getCoor() != null) {
                this.add(I18n.tr("Coordinates: ", new Object[0]), Double.toString(node.getCoor().lat()), ", ", Double.toString(node.getCoor().lon()));
                this.add(I18n.tr("Coordinates (projected): ", new Object[0]), Double.toString(node.getEastNorth().east()), ", ", Double.toString(node.getEastNorth().north()));
            }
        }

        void addReferrers(StringBuilder stringBuilder, OsmPrimitive osmPrimitive) {
            List<OsmPrimitive> list = osmPrimitive.getReferrers();
            if (!list.isEmpty()) {
                this.add(I18n.tr("Part of: ", new Object[0]), new String[0]);
                for (OsmPrimitive osmPrimitive2 : list) {
                    stringBuilder.append(INDENT).append(INDENT);
                    this.addHeadline(osmPrimitive2);
                    stringBuilder.append('\n');
                }
            }
        }

        void addConflicts(OsmPrimitive osmPrimitive) {
            Conflict<?> conflict = InspectPrimitiveDialog.this.layer.getConflicts().getConflictForMy(osmPrimitive);
            if (conflict != null) {
                this.add(I18n.tr("In conflict with: ", new Object[0]), new String[0]);
                this.addNameAndId((OsmPrimitive)conflict.getTheir());
            }
        }

        public String toString() {
            return this.s.toString();
        }
    }
}

