/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.PreferencesAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSetting;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.util.FileFilterAllFiles;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.FileChooserManager;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class MapPaintDialog
extends ToggleDialog {
    protected StylesTable tblStyles;
    protected StylesModel model;
    protected DefaultListSelectionModel selectionModel;
    protected OnOffAction onoffAction;
    protected ReloadAction reloadAction;
    protected MoveUpDownAction upAction;
    protected MoveUpDownAction downAction;
    protected JCheckBox cbWireframe;
    public static final JosmAction PREFERENCE_ACTION = PreferencesAction.forPreferenceSubTab(I18n.tr("Map paint preferences", new Object[0]), null, MapPaintPreference.class, "dialogs/mappaintpreference");

    public MapPaintDialog() {
        super(I18n.tr("Map Paint Styles", new Object[0]), "mapstyle", I18n.tr("configure the map painting style", new Object[0]), Shortcut.registerShortcut("subwindow:mappaint", I18n.tr("Toggle: {0}", I18n.tr("MapPaint", new Object[0])), 77, 5007), 150, false, MapPaintPreference.class);
        this.build();
    }

    protected void build() {
        this.model = new StylesModel();
        this.cbWireframe = new JCheckBox();
        JLabel jLabel = new JLabel(I18n.tr("Wireframe View", new Object[0]), ImageProvider.get("dialogs/mappaint", "wireframe_small"), 0);
        jLabel.setFont(jLabel.getFont().deriveFont(0));
        jLabel.setLabelFor(this.cbWireframe);
        this.cbWireframe.setModel(new DefaultButtonModel(){

            @Override
            public void setSelected(boolean bl) {
                super.setSelected(bl);
                MapPaintDialog.this.tblStyles.setEnabled(!bl);
                MapPaintDialog.this.onoffAction.updateEnabledState();
                MapPaintDialog.this.upAction.updateEnabledState();
                MapPaintDialog.this.downAction.updateEnabledState();
            }
        });
        this.cbWireframe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.main.menu.wireFrameToggleAction.actionPerformed(null);
            }
        });
        this.cbWireframe.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.tblStyles = new StylesTable(this.model);
        this.selectionModel = new DefaultListSelectionModel();
        this.tblStyles.setSelectionModel(this.selectionModel);
        this.tblStyles.addMouseListener(new PopupMenuHandler());
        this.tblStyles.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tblStyles.setBackground(UIManager.getColor("Panel.background"));
        this.tblStyles.setSelectionMode(2);
        this.tblStyles.setTableHeader(null);
        this.tblStyles.getColumnModel().getColumn(0).setMaxWidth(1);
        this.tblStyles.getColumnModel().getColumn(0).setResizable(false);
        this.tblStyles.getColumnModel().getColumn(0).setCellRenderer(new MyCheckBoxRenderer());
        this.tblStyles.getColumnModel().getColumn(1).setCellRenderer(new StyleSourceRenderer());
        this.tblStyles.setShowGrid(false);
        this.tblStyles.setIntercellSpacing(new Dimension(0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.cbWireframe, GBC.std(0, 0));
        jPanel.add((Component)jLabel, GBC.std(1, 0).weight(1.0, 0.0));
        jPanel.add((Component)this.tblStyles, GBC.std(0, 1).span(2).fill());
        this.reloadAction = new ReloadAction();
        this.onoffAction = new OnOffAction();
        this.upAction = new MoveUpDownAction(false);
        this.downAction = new MoveUpDownAction(true);
        this.selectionModel.addListSelectionListener(this.onoffAction);
        this.selectionModel.addListSelectionListener(this.reloadAction);
        this.selectionModel.addListSelectionListener(this.upAction);
        this.selectionModel.addListSelectionListener(this.downAction);
        InputMapUtils.addEnterAction(this.tblStyles, this.onoffAction);
        InputMapUtils.addSpacebarAction(this.tblStyles, this.onoffAction);
        this.createLayout(jPanel, true, Arrays.asList(new SideButton((Action)this.onoffAction, false), new SideButton((Action)this.upAction, false), new SideButton((Action)this.downAction, false), new SideButton((Action)PREFERENCE_ACTION, false)));
    }

    @Override
    public void showNotify() {
        MapPaintStyles.addMapPaintSylesUpdateListener(this.model);
        Main.main.menu.wireFrameToggleAction.addButtonModel(this.cbWireframe.getModel());
    }

    @Override
    public void hideNotify() {
        Main.main.menu.wireFrameToggleAction.removeButtonModel(this.cbWireframe.getModel());
        MapPaintStyles.removeMapPaintSylesUpdateListener(this.model);
    }

    public class MapPaintPopup
    extends JPopupMenu {
        public MapPaintPopup() {
            this.add(MapPaintDialog.this.reloadAction);
            this.add(new SaveAsAction());
            JMenu jMenu = new JMenu(I18n.tr("Style settings", new Object[0]));
            jMenu.setIcon(new ImageProvider("preference").setMaxSize(ImageProvider.ImageSizes.POPUPMENU).addOverlay(new ImageOverlay(new ImageProvider("dialogs/mappaint", "pencil"), 0.5, 0.5, 1.0, 1.0)).get());
            jMenu.setToolTipText(I18n.tr("Customize the style", new Object[0]));
            this.add(jMenu);
            int n = MapPaintDialog.this.tblStyles.getSelectionModel().getLeadSelectionIndex();
            StyleSource styleSource = null;
            if (n >= 0 && n < MapPaintDialog.this.model.getRowCount()) {
                styleSource = MapPaintDialog.this.model.getRow(n);
            }
            if (styleSource == null || styleSource.settings.isEmpty()) {
                jMenu.setEnabled(false);
            } else {
                for (StyleSetting styleSetting : styleSource.settings) {
                    styleSetting.addMenuEntry(jMenu);
                }
            }
            this.addSeparator();
            this.add(new InfoAction());
        }
    }

    class PopupMenuHandler
    extends PopupMenuLauncher {
        PopupMenuHandler() {
        }

        @Override
        public void launch(MouseEvent mouseEvent) {
            if (MapPaintDialog.this.cbWireframe.isSelected()) {
                return;
            }
            super.launch(mouseEvent);
        }

        @Override
        protected void showMenu(MouseEvent mouseEvent) {
            this.menu = new MapPaintPopup();
            super.showMenu(mouseEvent);
        }
    }

    protected class InfoAction
    extends AbstractAction {
        private boolean errorsTabLoaded;
        private boolean sourceTabLoaded;

        public InfoAction() {
            this.putValue("Name", I18n.tr("Info", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("view meta information, error log and source definition", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("info"));
            this.setEnabled(MapPaintDialog.this.tblStyles.getSelectedRows().length == 1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = MapPaintDialog.this.tblStyles.getSelectionModel().getLeadSelectionIndex();
            if (n < 0 || n >= MapPaintDialog.this.model.getRowCount()) {
                return;
            }
            final StyleSource styleSource = MapPaintDialog.this.model.getRow(n);
            ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Map Style info", new Object[0]), new String[]{I18n.tr("Close", new Object[0])});
            extendedDialog.setPreferredSize(new Dimension(600, 400));
            extendedDialog.setButtonIcons(new String[]{"ok.png"});
            JTabbedPane jTabbedPane = new JTabbedPane();
            jTabbedPane.add("Info", this.buildInfoPanel(styleSource));
            JLabel jLabel = new JLabel(I18n.tr("Info", new Object[0]));
            jLabel.setFont(jLabel.getFont().deriveFont(0));
            jTabbedPane.setTabComponentAt(0, jLabel);
            final JPanel jPanel = new JPanel(new GridBagLayout());
            jTabbedPane.add("Errors", jPanel);
            if (styleSource.getErrors().isEmpty()) {
                JLabel jLabel2 = new JLabel(I18n.tr("Errors", new Object[0]));
                jLabel2.setFont(jLabel.getFont().deriveFont(0));
                jLabel2.setEnabled(false);
                jTabbedPane.setTabComponentAt(1, jLabel2);
                jTabbedPane.setEnabledAt(1, false);
            } else {
                JLabel jLabel3 = new JLabel(I18n.tr("Errors", new Object[0]), ImageProvider.get("misc", "error"), 0);
                jTabbedPane.setTabComponentAt(1, jLabel3);
            }
            final JPanel jPanel2 = new JPanel(new GridBagLayout());
            jTabbedPane.addTab("Source", jPanel2);
            JLabel jLabel4 = new JLabel(I18n.tr("Source", new Object[0]));
            jLabel4.setFont(jLabel4.getFont().deriveFont(0));
            jTabbedPane.setTabComponentAt(2, jLabel4);
            jTabbedPane.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (!InfoAction.this.errorsTabLoaded && ((SingleSelectionModel)changeEvent.getSource()).getSelectedIndex() == 1) {
                        InfoAction.this.errorsTabLoaded = true;
                        InfoAction.this.buildErrorsPanel(styleSource, jPanel);
                    }
                    if (!InfoAction.this.sourceTabLoaded && ((SingleSelectionModel)changeEvent.getSource()).getSelectedIndex() == 2) {
                        InfoAction.this.sourceTabLoaded = true;
                        InfoAction.this.buildSourcePanel(styleSource, jPanel2);
                    }
                }
            });
            extendedDialog.setContent(jTabbedPane, false);
            extendedDialog.showDialog();
        }

        private JPanel buildInfoPanel(StyleSource styleSource) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            StringBuilder stringBuilder = new StringBuilder("<table cellpadding=3>");
            stringBuilder.append(this.tableRow(I18n.tr("Title:", new Object[0]), styleSource.getDisplayString()));
            if (styleSource.url.startsWith("http://") || styleSource.url.startsWith("https://")) {
                stringBuilder.append(this.tableRow(I18n.tr("URL:", new Object[0]), styleSource.url));
            } else if (styleSource.url.startsWith("resource://")) {
                stringBuilder.append(this.tableRow(I18n.tr("Built-in Style, internal path:", new Object[0]), styleSource.url));
            } else {
                stringBuilder.append(this.tableRow(I18n.tr("Path:", new Object[0]), styleSource.url));
            }
            if (styleSource.icon != null) {
                stringBuilder.append(this.tableRow(I18n.tr("Icon:", new Object[0]), styleSource.icon));
            }
            if (styleSource.getBackgroundColorOverride() != null) {
                stringBuilder.append(this.tableRow(I18n.tr("Background:", new Object[0]), Utils.toString(styleSource.getBackgroundColorOverride())));
            }
            stringBuilder.append(this.tableRow(I18n.tr("Style is currently active?", new Object[0]), styleSource.active ? I18n.tr("Yes", new Object[0]) : I18n.tr("No", new Object[0]))).append("</table>");
            jPanel.add((Component)new JScrollPane(new HtmlPanel(stringBuilder.toString())), GBC.eol().fill(1));
            return jPanel;
        }

        private String tableRow(String string, String string2) {
            return "<tr><td><b>" + string + "</b></td><td>" + string2 + "</td></tr>";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildSourcePanel(StyleSource styleSource, JPanel jPanel) {
            JosmTextArea josmTextArea = new JosmTextArea();
            josmTextArea.setFont(GuiHelper.getMonospacedFont(josmTextArea));
            josmTextArea.setEditable(false);
            jPanel.add((Component)new JScrollPane(josmTextArea), GBC.std().fill());
            try {
                InputStream inputStream = styleSource.getSourceInputStream();
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        josmTextArea.append(string + '\n');
                    }
                }
                finally {
                    styleSource.closeSourceInputStream(inputStream);
                }
            }
            catch (IOException iOException) {
                josmTextArea.append("<ERROR: failed to read file!>");
            }
        }

        private void buildErrorsPanel(StyleSource styleSource, JPanel jPanel) {
            JosmTextArea josmTextArea = new JosmTextArea();
            josmTextArea.setFont(GuiHelper.getMonospacedFont(josmTextArea));
            josmTextArea.setEditable(false);
            jPanel.add((Component)new JScrollPane(josmTextArea), GBC.std().fill());
            for (Throwable throwable : styleSource.getErrors()) {
                josmTextArea.append(throwable + "\n");
            }
        }
    }

    protected class SaveAsAction
    extends AbstractAction {
        public SaveAsAction() {
            this.putValue("Name", I18n.tr("Save as...", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Save a copy of this Style to file and add it to the list", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("copy"));
            this.setEnabled(MapPaintDialog.this.tblStyles.getSelectedRows().length == 1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = MapPaintDialog.this.tblStyles.getSelectionModel().getLeadSelectionIndex();
            if (n < 0 || n >= MapPaintDialog.this.model.getRowCount()) {
                return;
            }
            StyleSource styleSource = MapPaintDialog.this.model.getRow(n);
            FileChooserManager fileChooserManager = new FileChooserManager(false, "mappaint.clone-style.lastDirectory", System.getProperty("user.home"));
            String string = fileChooserManager.getInitialDirectory() + File.separator + styleSource.getFileNamePart();
            ExtensionFileFilter extensionFileFilter = styleSource instanceof MapCSSStyleSource ? new ExtensionFileFilter("mapcss,css,zip", "mapcss", I18n.tr("Map paint style file (*.mapcss, *.zip)", new Object[0])) : new ExtensionFileFilter("xml,zip", "xml", I18n.tr("Map paint style file (*.xml, *.zip)", new Object[0]));
            fileChooserManager.createFileChooser(false, null, Arrays.asList(extensionFileFilter, FileFilterAllFiles.getInstance()), extensionFileFilter, 0).getFileChooser().setSelectedFile(new File(string));
            AbstractFileChooser abstractFileChooser = fileChooserManager.openFileChooser();
            if (abstractFileChooser == null) {
                return;
            }
            Main.worker.submit(new SaveToFileTask(styleSource, abstractFileChooser.getSelectedFile()));
        }

        private class SaveToFileTask
        extends PleaseWaitRunnable {
            private final StyleSource s;
            private final File file;
            private boolean canceled;
            private boolean error;

            SaveToFileTask(StyleSource styleSource, File file) {
                super(I18n.tr("Reloading style sources", new Object[0]));
                this.s = styleSource;
                this.file = file;
            }

            @Override
            protected void cancel() {
                this.canceled = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void realRun() {
                this.getProgressMonitor().indeterminateSubTask(I18n.tr("Save style ''{0}'' as ''{1}''", this.s.getDisplayString(), this.file.getPath()));
                try {
                    InputStream inputStream = this.s.getSourceInputStream();
                    try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                         BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.file));){
                        int n;
                        byte[] byArray = new byte[4096];
                        while ((n = ((InputStream)bufferedInputStream).read(byArray)) > -1 && !this.canceled) {
                            ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                        }
                    }
                    finally {
                        this.s.closeSourceInputStream(inputStream);
                    }
                }
                catch (IOException iOException) {
                    this.error = true;
                }
            }

            @Override
            protected void finish() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!SaveToFileTask.this.error && !SaveToFileTask.this.canceled) {
                            SourceEntry sourceEntry = new SourceEntry(SaveToFileTask.this.s);
                            sourceEntry.url = SaveToFileTask.this.file.getPath();
                            MapPaintStyles.addStyle(sourceEntry);
                            MapPaintDialog.this.tblStyles.getSelectionModel().setSelectionInterval(MapPaintDialog.this.model.getRowCount() - 1, MapPaintDialog.this.model.getRowCount() - 1);
                            MapPaintDialog.this.model.ensureSelectedIsVisible();
                        }
                    }
                });
            }
        }
    }

    protected class ReloadAction
    extends AbstractAction
    implements ListSelectionListener {
        public ReloadAction() {
            this.putValue("Name", I18n.tr("Reload from file", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("reload selected styles from file", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
            this.setEnabled(this.getEnabledState());
        }

        protected boolean getEnabledState() {
            if (MapPaintDialog.this.cbWireframe.isSelected()) {
                return false;
            }
            int[] nArray = MapPaintDialog.this.tblStyles.getSelectedRows();
            if (nArray.length == 0) {
                return false;
            }
            for (int n : nArray) {
                if (MapPaintDialog.this.model.getRow(n).isLocal()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(this.getEnabledState());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            final int[] nArray = MapPaintDialog.this.tblStyles.getSelectedRows();
            MapPaintStyles.reloadStyles(nArray);
            Main.worker.submit(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MapPaintDialog.this.selectionModel.clearSelection();
                            for (int n : nArray) {
                                MapPaintDialog.this.selectionModel.addSelectionInterval(n, n);
                            }
                        }
                    });
                }
            });
        }
    }

    protected class MoveUpDownAction
    extends AbstractAction
    implements ListSelectionListener {
        private final int increment;

        public MoveUpDownAction(boolean bl) {
            this.increment = bl ? 1 : -1;
            this.putValue("Name", bl ? I18n.tr("Down", new Object[0]) : I18n.tr("Up", new Object[0]));
            this.putValue("SmallIcon", bl ? ImageProvider.get("dialogs", "down") : ImageProvider.get("dialogs", "up"));
            this.putValue("ShortDescription", bl ? I18n.tr("Move the selected entry one row down.", new Object[0]) : I18n.tr("Move the selected entry one row up.", new Object[0]));
            this.updateEnabledState();
        }

        public void updateEnabledState() {
            int[] nArray = MapPaintDialog.this.tblStyles.getSelectedRows();
            this.setEnabled(!MapPaintDialog.this.cbWireframe.isSelected() && MapPaintStyles.canMoveStyles(nArray, this.increment));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = MapPaintDialog.this.tblStyles.getSelectedRows();
            MapPaintStyles.moveStyles(nArray, this.increment);
            MapPaintDialog.this.selectionModel.clearSelection();
            for (int n : nArray) {
                MapPaintDialog.this.selectionModel.addSelectionInterval(n + this.increment, n + this.increment);
            }
            MapPaintDialog.this.model.ensureSelectedIsVisible();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    protected class OnOffAction
    extends AbstractAction
    implements ListSelectionListener {
        public OnOffAction() {
            this.putValue("Name", I18n.tr("On/Off", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Turn selected styles on or off", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("apply"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(!MapPaintDialog.this.cbWireframe.isSelected() && MapPaintDialog.this.tblStyles.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = MapPaintDialog.this.tblStyles.getSelectedRows();
            MapPaintStyles.toggleStyleActive(nArray);
            MapPaintDialog.this.selectionModel.clearSelection();
            for (int n : nArray) {
                MapPaintDialog.this.selectionModel.addSelectionInterval(n, n);
            }
        }
    }

    private class StyleSourceRenderer
    extends DefaultTableCellRenderer {
        private StyleSourceRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            StyleSource styleSource = (StyleSource)object;
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, styleSource.getDisplayString(), bl, bl2, n, n2);
            jLabel.setIcon(styleSource.getIcon());
            jLabel.setToolTipText(styleSource.getToolTipText());
            jLabel.setEnabled(!MapPaintDialog.this.cbWireframe.isSelected());
            return jLabel;
        }
    }

    private class MyCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        MyCheckBoxRenderer() {
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            boolean bl3 = (Boolean)object;
            this.setSelected(bl3);
            this.setEnabled(!MapPaintDialog.this.cbWireframe.isSelected());
            return this;
        }
    }

    protected class StylesModel
    extends AbstractTableModel
    implements MapPaintStyles.MapPaintSylesUpdateListener {
        private final Class<?>[] columnClasses = new Class[]{Boolean.class, StyleSource.class};
        private transient List<StyleSource> data = new ArrayList<StyleSource>(MapPaintStyles.getStyles().getStyleSources());

        private StyleSource getRow(int n) {
            return this.data.get(n);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.getRow((int)n).active;
            }
            return this.getRow(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.columnClasses[n];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n < 0 || n >= this.getRowCount() || object == null) {
                return;
            }
            if (n2 == 0) {
                MapPaintStyles.toggleStyleActive(n);
            }
        }

        public void ensureSelectedIsVisible() {
            int n = MapPaintDialog.this.selectionModel.getMinSelectionIndex();
            if (n < 0) {
                return;
            }
            if (n >= this.getRowCount()) {
                return;
            }
            MapPaintDialog.this.tblStyles.scrollToVisible(n, 0);
            MapPaintDialog.this.tblStyles.repaint();
        }

        @Override
        public void mapPaintStylesUpdated() {
            this.data = new ArrayList<StyleSource>(MapPaintStyles.getStyles().getStyleSources());
            this.fireTableDataChanged();
            MapPaintDialog.this.tblStyles.repaint();
        }

        @Override
        public void mapPaintStyleEntryUpdated(int n) {
            this.data = new ArrayList<StyleSource>(MapPaintStyles.getStyles().getStyleSources());
            this.fireTableRowsUpdated(n, n);
            MapPaintDialog.this.tblStyles.repaint();
        }
    }

    protected static class StylesTable
    extends JTable {
        public StylesTable(TableModel tableModel) {
            super(tableModel);
        }

        public void scrollToVisible(int n, int n2) {
            if (!(this.getParent() instanceof JViewport)) {
                return;
            }
            JViewport jViewport = (JViewport)this.getParent();
            Rectangle rectangle = this.getCellRect(n, n2, true);
            Point point = jViewport.getViewPosition();
            rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
            jViewport.scrollRectToVisible(rectangle);
        }
    }
}

