/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.CopyAction;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.mapmode.DeleteAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.conflict.ConflictAddCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.relation.ChildRelationBrowser;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.MemberRoleCellEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.ReferringRelationsBrowser;
import org.openstreetmap.josm.gui.dialogs.relation.ReferringRelationsBrowserModel;
import org.openstreetmap.josm.gui.dialogs.relation.RelationDialogManager;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTable;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableModel;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetHandler;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.WindowGeometry;

public class GenericRelationEditor
extends RelationEditor {
    private final TagEditorPanel tagEditorPanel;
    private final ReferringRelationsBrowser referrerBrowser;
    private final ReferringRelationsBrowserModel referrerModel;
    private MemberTable memberTable;
    private final MemberTableModel memberTableModel;
    private SelectionTable selectionTable;
    private final SelectionTableModel selectionTableModel;
    private AutoCompletingTextField tfRole;
    private JMenuItem windowMenuItem;
    private JButton sortBelowButton;

    public GenericRelationEditor(OsmDataLayer osmDataLayer, Relation relation, Collection<RelationMember> collection) {
        super(osmDataLayer, relation, collection);
        this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(700, 650)));
        TaggingPresetHandler taggingPresetHandler = new TaggingPresetHandler(){

            @Override
            public void updateTags(List<Tag> list) {
                GenericRelationEditor.this.tagEditorPanel.getModel().updateTags(list);
            }

            @Override
            public Collection<OsmPrimitive> getSelection() {
                Relation relation = new Relation();
                GenericRelationEditor.this.tagEditorPanel.getModel().applyToPrimitive(relation);
                return Collections.singletonList(relation);
            }
        };
        this.memberTableModel = new MemberTableModel(this.getLayer(), taggingPresetHandler);
        this.memberTableModel.register();
        this.selectionTableModel = new SelectionTableModel(this.getLayer());
        this.selectionTableModel.register();
        this.referrerModel = new ReferringRelationsBrowserModel(relation);
        this.tagEditorPanel = new TagEditorPanel(taggingPresetHandler);
        if (relation != null) {
            this.tagEditorPanel.getModel().initFromPrimitive(relation);
            this.memberTableModel.populate(relation);
            if (!this.getLayer().data.getRelations().contains(relation)) {
                this.setRelation(null);
            }
        } else {
            this.tagEditorPanel.getModel().clear();
            this.memberTableModel.populate(null);
        }
        this.tagEditorPanel.getModel().ensureOneTag();
        JSplitPane jSplitPane = this.buildSplitPane();
        jSplitPane.setPreferredSize(new Dimension(100, 100));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jSplitPane, "Center");
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.getContentPane().setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(I18n.tr("Tags and Members", new Object[0]), jPanel);
        this.referrerBrowser = new ReferringRelationsBrowser(this.getLayer(), this.referrerModel);
        jTabbedPane.add(I18n.tr("Parent Relations", new Object[0]), this.referrerBrowser);
        jTabbedPane.add(I18n.tr("Child Relations", new Object[0]), new ChildRelationBrowser(this.getLayer(), relation));
        jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n;
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                String string = jTabbedPane.getTitleAt(n = jTabbedPane.getSelectedIndex());
                if (string.equals(I18n.tr("Parent Relations", new Object[0]))) {
                    GenericRelationEditor.this.referrerBrowser.init();
                }
            }
        });
        this.getContentPane().add((Component)this.buildToolBar(), "North");
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.getContentPane().add((Component)this.buildOkCancelButtonPanel(), "South");
        this.setSize(this.findMaxDialogSize());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                GenericRelationEditor.this.cleanSelfReferences();
            }
        });
        this.registerCopyPasteAction(this.tagEditorPanel.getPasteAction(), "PASTE_TAGS", Shortcut.registerShortcut("system:pastestyle", I18n.tr("Edit: {0}", I18n.tr("Paste Tags", new Object[0])), 86, 5009).getKeyStroke());
        this.registerCopyPasteAction(new PasteMembersAction(), "PASTE_MEMBERS", Shortcut.getPasteKeyStroke());
        this.registerCopyPasteAction(new CopyMembersAction(), "COPY_MEMBERS", Shortcut.getCopyKeyStroke());
        this.tagEditorPanel.setNextFocusComponent(this.memberTable);
        this.selectionTable.setFocusable(false);
        this.memberTableModel.setSelectedMembers(collection);
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/RelationEditor"));
    }

    protected JToolBar buildToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(new ApplyAction());
        jToolBar.add(new DuplicateRelationAction());
        DeleteCurrentRelationAction deleteCurrentRelationAction = new DeleteCurrentRelationAction();
        this.addPropertyChangeListener(deleteCurrentRelationAction);
        jToolBar.add(deleteCurrentRelationAction);
        return jToolBar;
    }

    protected JPanel buildOkCancelButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(new SideButton(new OKAction()));
        jPanel.add(new SideButton(new CancelAction()));
        jPanel.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/RelationEditor"))));
        return jPanel;
    }

    protected JPanel buildTagEditorPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("Tags", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.tagEditorPanel, gridBagConstraints);
        return jPanel;
    }

    protected JPanel buildMemberEditorPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.memberTable = new MemberTable(this.getLayer(), this.getRelation(), this.memberTableModel);
        this.memberTable.addMouseListener(new MemberTableDblClickAdapter());
        this.memberTableModel.addMemberModelListener(this.memberTable);
        JScrollPane jScrollPane = new JScrollPane(this.memberTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("Members", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.buildLeftButtonPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel(I18n.tr("Apply Role:", new Object[0])));
        this.tfRole = new AutoCompletingTextField(10);
        this.tfRole.setToolTipText(I18n.tr("Enter a role and apply it to the selected relation members", new Object[0]));
        this.tfRole.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                GenericRelationEditor.this.tfRole.selectAll();
            }
        });
        this.tfRole.setAutoCompletionList(new AutoCompletionList());
        this.tfRole.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AutoCompletionList autoCompletionList = GenericRelationEditor.this.tfRole.getAutoCompletionList();
                if (autoCompletionList != null) {
                    autoCompletionList.clear();
                    GenericRelationEditor.this.getLayer().data.getAutoCompletionManager().populateWithMemberRoles(autoCompletionList, GenericRelationEditor.this.getRelation());
                }
            }
        });
        this.tfRole.setText(Main.pref.get("relation.editor.generic.lastrole", ""));
        jPanel2.add(this.tfRole);
        SetRoleAction setRoleAction = new SetRoleAction();
        this.memberTableModel.getSelectionModel().addListSelectionListener(setRoleAction);
        this.tfRole.getDocument().addDocumentListener(setRoleAction);
        this.tfRole.addActionListener(setRoleAction);
        this.memberTableModel.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                GenericRelationEditor.this.tfRole.setEnabled(GenericRelationEditor.this.memberTable.getSelectedRowCount() > 0);
            }
        });
        this.tfRole.setEnabled(this.memberTable.getSelectedRowCount() > 0);
        SideButton sideButton = new SideButton(setRoleAction);
        sideButton.setPreferredSize(new Dimension(20, 20));
        sideButton.setText("");
        jPanel2.add(sideButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 25;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel3.add((Component)new JLabel(I18n.tr("Selection", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)this.buildSelectionControlButtonPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel3.add((Component)this.buildSelectionTablePanel(), gridBagConstraints);
        final JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(jPanel);
        jSplitPane.setRightComponent(jPanel3);
        jSplitPane.setOneTouchExpandable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                jSplitPane.setDividerLocation(0.6);
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jSplitPane, "Center");
        return jPanel4;
    }

    protected JPanel buildSelectionTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        MemberRoleCellEditor memberRoleCellEditor = (MemberRoleCellEditor)this.memberTable.getColumnModel().getColumn(0).getCellEditor();
        this.selectionTable = new SelectionTable(this.selectionTableModel, new SelectionTableColumnModel(this.memberTableModel));
        this.selectionTable.setMemberTableModel(this.memberTableModel);
        this.selectionTable.setRowHeight(memberRoleCellEditor.getEditor().getPreferredSize().height);
        jPanel.add((Component)new JScrollPane(this.selectionTable), "Center");
        return jPanel;
    }

    protected JSplitPane buildSplitPane() {
        final JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent(this.buildTagEditorPanel());
        jSplitPane.setBottomComponent(this.buildMemberEditorPanel());
        jSplitPane.setOneTouchExpandable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                jSplitPane.setDividerLocation(0.3);
            }
        });
        return jSplitPane;
    }

    protected JToolBar buildLeftButtonPanel() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOrientation(1);
        jToolBar.setFloatable(false);
        MoveUpAction moveUpAction = new MoveUpAction();
        this.memberTableModel.getSelectionModel().addListSelectionListener(moveUpAction);
        jToolBar.add(moveUpAction);
        this.memberTable.getActionMap().put("moveUp", moveUpAction);
        MoveDownAction moveDownAction = new MoveDownAction();
        this.memberTableModel.getSelectionModel().addListSelectionListener(moveDownAction);
        jToolBar.add(moveDownAction);
        this.memberTable.getActionMap().put("moveDown", moveDownAction);
        jToolBar.addSeparator();
        EditAction editAction = new EditAction();
        this.memberTableModel.getSelectionModel().addListSelectionListener(editAction);
        jToolBar.add(editAction);
        RemoveAction removeAction = new RemoveAction();
        this.memberTable.getSelectionModel().addListSelectionListener(removeAction);
        jToolBar.add(removeAction);
        this.memberTable.getActionMap().put("removeSelected", removeAction);
        jToolBar.addSeparator();
        SortAction sortAction = new SortAction();
        this.memberTableModel.addTableModelListener(sortAction);
        jToolBar.add(sortAction);
        SortBelowAction sortBelowAction = new SortBelowAction();
        this.memberTableModel.addTableModelListener(sortBelowAction);
        this.memberTableModel.getSelectionModel().addListSelectionListener(sortBelowAction);
        this.sortBelowButton = jToolBar.add(sortBelowAction);
        ReverseAction reverseAction = new ReverseAction();
        this.memberTableModel.addTableModelListener(reverseAction);
        jToolBar.add(reverseAction);
        jToolBar.addSeparator();
        DownloadIncompleteMembersAction downloadIncompleteMembersAction = new DownloadIncompleteMembersAction();
        this.memberTable.getModel().addTableModelListener(downloadIncompleteMembersAction);
        jToolBar.add(downloadIncompleteMembersAction);
        this.memberTable.getActionMap().put("downloadIncomplete", downloadIncompleteMembersAction);
        DownloadSelectedIncompleteMembersAction downloadSelectedIncompleteMembersAction = new DownloadSelectedIncompleteMembersAction();
        this.memberTable.getModel().addTableModelListener(downloadSelectedIncompleteMembersAction);
        this.memberTable.getSelectionModel().addListSelectionListener(downloadSelectedIncompleteMembersAction);
        jToolBar.add(downloadSelectedIncompleteMembersAction);
        InputMap inputMap = this.memberTable.getInputMap(1);
        inputMap.put((KeyStroke)removeAction.getValue("AcceleratorKey"), "removeSelected");
        inputMap.put((KeyStroke)moveUpAction.getValue("AcceleratorKey"), "moveUp");
        inputMap.put((KeyStroke)moveDownAction.getValue("AcceleratorKey"), "moveDown");
        inputMap.put((KeyStroke)downloadIncompleteMembersAction.getValue("AcceleratorKey"), "downloadIncomplete");
        return jToolBar;
    }

    protected JToolBar buildSelectionControlButtonPanel() {
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        AddSelectedAtStartAction addSelectedAtStartAction = new AddSelectedAtStartAction();
        this.selectionTableModel.addTableModelListener(addSelectedAtStartAction);
        jToolBar.add(addSelectedAtStartAction);
        AddSelectedBeforeSelection addSelectedBeforeSelection = new AddSelectedBeforeSelection();
        this.selectionTableModel.addTableModelListener(addSelectedBeforeSelection);
        this.memberTableModel.getSelectionModel().addListSelectionListener(addSelectedBeforeSelection);
        jToolBar.add(addSelectedBeforeSelection);
        AddSelectedAfterSelection addSelectedAfterSelection = new AddSelectedAfterSelection();
        this.selectionTableModel.addTableModelListener(addSelectedAfterSelection);
        this.memberTableModel.getSelectionModel().addListSelectionListener(addSelectedAfterSelection);
        jToolBar.add(addSelectedAfterSelection);
        AddSelectedAtEndAction addSelectedAtEndAction = new AddSelectedAtEndAction();
        this.selectionTableModel.addTableModelListener(addSelectedAtEndAction);
        jToolBar.add(addSelectedAtEndAction);
        jToolBar.addSeparator();
        SelectedMembersForSelectionAction selectedMembersForSelectionAction = new SelectedMembersForSelectionAction();
        this.selectionTableModel.addTableModelListener(selectedMembersForSelectionAction);
        this.memberTableModel.addTableModelListener(selectedMembersForSelectionAction);
        jToolBar.add(selectedMembersForSelectionAction);
        SelectPrimitivesForSelectedMembersAction selectPrimitivesForSelectedMembersAction = new SelectPrimitivesForSelectedMembersAction();
        this.memberTable.getSelectionModel().addListSelectionListener(selectPrimitivesForSelectedMembersAction);
        jToolBar.add(selectPrimitivesForSelectedMembersAction);
        jToolBar.addSeparator();
        RemoveSelectedAction removeSelectedAction = new RemoveSelectedAction();
        this.selectionTableModel.addTableModelListener(removeSelectedAction);
        jToolBar.add(removeSelectedAction);
        return jToolBar;
    }

    @Override
    protected Dimension findMaxDialogSize() {
        return new Dimension(700, 650);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.tagEditorPanel.initAutoCompletion(this.getLayer());
        }
        super.setVisible(bl);
        if (bl) {
            this.sortBelowButton.setVisible(ExpertToggleAction.isExpert());
            RelationDialogManager.getRelationDialogManager().positionOnScreen(this);
            if (this.windowMenuItem == null) {
                this.addToWindowMenu();
            }
            this.tagEditorPanel.requestFocusInWindow();
        } else {
            this.memberTable.stopHighlighting();
            this.selectionTableModel.unregister();
            this.memberTableModel.unregister();
            this.memberTable.unlinkAsListener();
            if (this.windowMenuItem != null) {
                Main.main.menu.windowMenu.remove(this.windowMenuItem);
                this.windowMenuItem = null;
            }
            this.dispose();
        }
    }

    protected void addToWindowMenu() {
        String string = this.getRelation() == null ? I18n.tr("New Relation", new Object[0]) : this.getRelation().getLocalName();
        String string2 = I18n.tr("Focus Relation Editor with relation ''{0}'' in layer ''{1}''", string, this.getLayer().getName());
        string = I18n.tr("Relation Editor: {0}", string == null ? Long.valueOf(this.getRelation().getId()) : string);
        JMenu jMenu = Main.main.menu.windowMenu;
        JosmAction josmAction = new JosmAction(string, "dialogs/relationlist", string2, null, false, false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RelationEditor relationEditor = (RelationEditor)this.getValue("relationEditor");
                relationEditor.setVisible(true);
            }
        };
        josmAction.putValue("relationEditor", this);
        this.windowMenuItem = MainMenu.add(jMenu, josmAction, MainMenu.WINDOW_MENU_GROUP.VOLATILE);
    }

    protected void cleanSelfReferences() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        arrayList.add(this.getRelation());
        if (this.memberTableModel.hasMembersReferringTo(arrayList)) {
            int n = ConditionalOptionPaneUtil.showOptionDialog("clean_relation_self_references", Main.parent, I18n.tr("<html>There is at least one member in this relation referring<br>to the relation itself.<br>This creates circular dependencies and is discouraged.<br>How do you want to proceed with circular dependencies?</html>", new Object[0]), I18n.tr("Warning", new Object[0]), 0, 2, new String[]{I18n.tr("Remove them, clean up relation", new Object[0]), I18n.tr("Ignore them, leave relation as is", new Object[0])}, I18n.tr("Remove them, clean up relation", new Object[0]));
            switch (n) {
                case -2147483648: 
                case -1: 
                case 1: {
                    return;
                }
                case 0: {
                    this.memberTableModel.removeMembersReferringTo(arrayList);
                }
            }
        }
    }

    private void registerCopyPasteAction(AbstractAction abstractAction, Object object, KeyStroke keyStroke) {
        int n = keyStroke.getModifiers();
        int n2 = keyStroke.getKeyCode();
        if (n2 != 155 && (n == 0 || n == 64)) {
            Main.info(I18n.tr("Sorry, shortcut \"{0}\" can not be enabled in Relation editor dialog", new Object[0]), keyStroke);
            return;
        }
        this.getRootPane().getActionMap().put(object, abstractAction);
        this.getRootPane().getInputMap(2).put(keyStroke, object);
        this.memberTable.getInputMap(0).put(keyStroke, object);
        this.memberTable.getInputMap(1).put(keyStroke, object);
        this.memberTable.getInputMap(2).put(keyStroke, object);
        this.selectionTable.getInputMap(0).put(keyStroke, object);
        this.selectionTable.getInputMap(1).put(keyStroke, object);
        this.selectionTable.getInputMap(2).put(keyStroke, object);
    }

    static boolean confirmAddingPrimitive(OsmPrimitive osmPrimitive) throws AddAbortException {
        String string = I18n.tr("<html>This relation already has one or more members referring to<br>the object ''{0}''<br><br>Do you really want to add another relation member?</html>", osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
        int n = ConditionalOptionPaneUtil.showOptionDialog("add_primitive_to_relation", Main.parent, string, I18n.tr("Multiple members referring to same object.", new Object[0]), 1, 2, null, null);
        switch (n) {
            case -2147483648: 
            case 0: {
                return true;
            }
            case -1: 
            case 1: {
                return false;
            }
            case 2: {
                throw new AddAbortException();
            }
        }
        return false;
    }

    static void warnOfCircularReferences(OsmPrimitive osmPrimitive) {
        String string = I18n.tr("<html>You are trying to add a relation to itself.<br><br>This creates circular references and is therefore discouraged.<br>Skipping relation ''{0}''.</html>", osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
        JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Warning", new Object[0]), 2);
    }

    public static Command addPrimitivesToRelation(Relation relation, Collection<? extends OsmPrimitive> collection) {
        CheckParameterUtil.ensureParameterNotNull(relation, "orig");
        try {
            Collection<TaggingPreset> collection2 = TaggingPreset.getMatchingPresets(EnumSet.of(TaggingPresetType.RELATION), relation.getKeys(), false);
            Relation relation2 = new Relation(relation);
            boolean bl = false;
            for (OsmPrimitive osmPrimitive : collection) {
                if (osmPrimitive instanceof Relation && relation.equals(osmPrimitive)) {
                    GenericRelationEditor.warnOfCircularReferences(osmPrimitive);
                    continue;
                }
                if (MemberTableModel.hasMembersReferringTo(relation2.getMembers(), Collections.singleton(osmPrimitive)) && !GenericRelationEditor.confirmAddingPrimitive(osmPrimitive)) continue;
                Set<String> set = GenericRelationEditor.findSuggestedRoles(collection2, osmPrimitive);
                relation2.addMember(new RelationMember(set.size() == 1 ? set.iterator().next() : "", osmPrimitive));
                bl = true;
            }
            return bl ? new ChangeCommand(relation, relation2) : null;
        }
        catch (AddAbortException addAbortException) {
            return null;
        }
    }

    protected static Set<String> findSuggestedRoles(Collection<TaggingPreset> collection, OsmPrimitive osmPrimitive) {
        HashSet<String> hashSet = new HashSet<String>();
        for (TaggingPreset taggingPreset : collection) {
            String string = taggingPreset.suggestRoleForOsmPrimitive(osmPrimitive);
            if (string == null || string.isEmpty()) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    class MemberTableDblClickAdapter
    extends MouseAdapter {
        MemberTableDblClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                new EditAction().run();
            }
        }
    }

    class CopyMembersAction
    extends AbstractAction {
        CopyMembersAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (RelationMember relationMember : GenericRelationEditor.this.memberTableModel.getSelectedMembers()) {
                hashSet.add(relationMember.getMember());
            }
            if (!hashSet.isEmpty()) {
                CopyAction.copy(GenericRelationEditor.this.getLayer(), hashSet);
            }
        }
    }

    class PasteMembersAction
    extends AddFromSelectionAction {
        PasteMembersAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block7: {
                try {
                    List<PrimitiveData> list = Main.pasteBuffer.getDirectlyAdded();
                    DataSet dataSet = GenericRelationEditor.this.getLayer().data;
                    List<OsmPrimitive> list2 = new ArrayList<OsmPrimitive>();
                    boolean bl = false;
                    for (PrimitiveData primitiveData : list) {
                        OsmPrimitive osmPrimitive = dataSet.getPrimitiveById(primitiveData);
                        if (osmPrimitive != null) {
                            list2.add(osmPrimitive);
                            continue;
                        }
                        if (!primitiveData.isNew()) {
                            OsmPrimitive osmPrimitive2 = primitiveData.getType().newInstance(primitiveData.getUniqueId(), true);
                            dataSet.addPrimitive(osmPrimitive2);
                            list2.add(osmPrimitive2);
                            continue;
                        }
                        bl = true;
                        break;
                    }
                    if (bl) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Members from paste buffer cannot be added because they are not included in current layer", new Object[0]));
                        return;
                    }
                    list2 = this.filterConfirmedPrimitives(list2);
                    int n = GenericRelationEditor.this.memberTableModel.getSelectionModel().getMaxSelectionIndex();
                    if (n == -1) {
                        n = GenericRelationEditor.this.memberTableModel.getRowCount() - 1;
                    }
                    GenericRelationEditor.this.memberTableModel.addMembersAfterIdx(list2, n);
                    GenericRelationEditor.this.tfRole.requestFocusInWindow();
                }
                catch (AddAbortException addAbortException) {
                    if (!Main.isTraceEnabled()) break block7;
                    Main.trace(addAbortException.getMessage());
                }
            }
        }
    }

    class EditAction
    extends AbstractAction
    implements ListSelectionListener {
        EditAction() {
            this.putValue("ShortDescription", I18n.tr("Edit the relation the currently selected relation member refers to", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.memberTable.getSelectedRowCount() == 1 && GenericRelationEditor.this.memberTableModel.isEditableRelation(GenericRelationEditor.this.memberTable.getSelectedRow()));
        }

        protected Collection<RelationMember> getMembersForCurrentSelection(Relation relation) {
            HashSet<RelationMember> hashSet = new HashSet<RelationMember>();
            Collection<OsmPrimitive> collection = GenericRelationEditor.this.getLayer().data.getSelected();
            for (RelationMember relationMember : relation.getMembers()) {
                if (!collection.contains(relationMember.getMember())) continue;
                hashSet.add(relationMember);
            }
            return hashSet;
        }

        public void run() {
            int n = GenericRelationEditor.this.memberTable.getSelectedRow();
            if (n < 0) {
                return;
            }
            OsmPrimitive osmPrimitive = GenericRelationEditor.this.memberTableModel.getReferredPrimitive(n);
            if (!(osmPrimitive instanceof Relation)) {
                return;
            }
            Relation relation = (Relation)osmPrimitive;
            if (relation.isIncomplete()) {
                return;
            }
            RelationEditor relationEditor = RelationEditor.getEditor(GenericRelationEditor.this.getLayer(), relation, this.getMembersForCurrentSelection(relation));
            relationEditor.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.run();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.refreshEnabled();
        }
    }

    class DuplicateRelationAction
    extends AbstractAction {
        DuplicateRelationAction() {
            this.putValue("ShortDescription", I18n.tr("Create a copy of this relation and open it in another editor window", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("duplicate"));
            this.putValue("Name", I18n.tr("Duplicate", new Object[0]));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Relation relation = new Relation();
            GenericRelationEditor.this.tagEditorPanel.getModel().applyToPrimitive(relation);
            GenericRelationEditor.this.memberTableModel.applyToRelation(relation);
            RelationEditor relationEditor = RelationEditor.getEditor(GenericRelationEditor.this.getLayer(), relation, GenericRelationEditor.this.memberTableModel.getSelectedMembers());
            relationEditor.setVisible(true);
        }
    }

    class SetRoleAction
    extends AbstractAction
    implements ListSelectionListener,
    DocumentListener {
        SetRoleAction() {
            this.putValue("ShortDescription", I18n.tr("Sets a role for the selected members", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("apply"));
            this.putValue("Name", I18n.tr("Apply Role", new Object[0]));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.memberTable.getSelectedRowCount() > 0);
        }

        protected boolean isEmptyRole() {
            return GenericRelationEditor.this.tfRole.getText() == null || GenericRelationEditor.this.tfRole.getText().trim().isEmpty();
        }

        protected boolean confirmSettingEmptyRole(int n) {
            String string = "<html>" + I18n.trn("You are setting an empty role on {0} object.", "You are setting an empty role on {0} objects.", n, n) + "<br>" + I18n.tr("This is equal to deleting the roles of these objects.", new Object[0]) + "<br>" + I18n.tr("Do you really want to apply the new role?", new Object[0]) + "</html>";
            Object[] objectArray = new String[]{I18n.tr("Yes, apply it", new Object[0]), I18n.tr("No, do not apply", new Object[0])};
            int n2 = ConditionalOptionPaneUtil.showOptionDialog("relation_editor.confirm_applying_empty_role", Main.parent, string, I18n.tr("Confirm empty role", new Object[0]), 0, 2, objectArray, objectArray[0]);
            switch (n2) {
                case -2147483648: 
                case 0: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isEmptyRole() && !this.confirmSettingEmptyRole(GenericRelationEditor.this.memberTable.getSelectedRowCount())) {
                return;
            }
            GenericRelationEditor.this.memberTableModel.updateRole(GenericRelationEditor.this.memberTable.getSelectedRows(), GenericRelationEditor.this.tfRole.getText());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.refreshEnabled();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.refreshEnabled();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.refreshEnabled();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.refreshEnabled();
        }
    }

    class DownloadSelectedIncompleteMembersAction
    extends AbstractAction
    implements ListSelectionListener,
    TableModelListener {
        DownloadSelectedIncompleteMembersAction() {
            this.putValue("ShortDescription", I18n.tr("Download selected incomplete members", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "downloadincompleteselected"));
            this.putValue("Name", I18n.tr("Download Members", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            Main.worker.submit(new DownloadRelationMemberTask(GenericRelationEditor.this.getRelation(), GenericRelationEditor.this.memberTableModel.getSelectedIncompleteMemberPrimitives(), GenericRelationEditor.this.getLayer(), GenericRelationEditor.this));
        }

        protected void updateEnabledState() {
            this.setEnabled(GenericRelationEditor.this.memberTableModel.hasIncompleteSelectedMembers() && !Main.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.updateEnabledState();
        }
    }

    class DownloadIncompleteMembersAction
    extends AbstractAction
    implements TableModelListener {
        DownloadIncompleteMembersAction() {
            String string = I18n.tr("Download all incomplete members", new Object[0]);
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "downloadincomplete"));
            this.putValue("Name", I18n.tr("Download Members", new Object[0]));
            Shortcut shortcut = Shortcut.registerShortcut("relationeditor:downloadincomplete", I18n.tr("Relation Editor: Download Members", new Object[0]), 36, 5004);
            shortcut.setAccelerator(this);
            this.putValue("ShortDescription", Main.platform.makeTooltip(string, shortcut));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            Main.worker.submit(new DownloadRelationMemberTask(GenericRelationEditor.this.getRelation(), GenericRelationEditor.this.memberTableModel.getIncompleteMemberPrimitives(), GenericRelationEditor.this.getLayer(), GenericRelationEditor.this));
        }

        protected void updateEnabledState() {
            this.setEnabled(GenericRelationEditor.this.memberTableModel.hasIncompleteMembers() && !Main.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.updateEnabledState();
        }
    }

    class AddTagAction
    extends AbstractAction {
        AddTagAction() {
            this.putValue("ShortDescription", I18n.tr("Add an empty tag", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.tagEditorPanel.getModel().appendNewTag();
        }
    }

    class CancelAction
    extends SavingAction {
        CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel the updates and close the dialog", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            GenericRelationEditor.this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
            GenericRelationEditor.this.getRootPane().getActionMap().put("ESCAPE", this);
            this.setEnabled(true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.memberTable.stopHighlighting();
            TagEditorModel tagEditorModel = GenericRelationEditor.this.tagEditorPanel.getModel();
            Relation relation = GenericRelationEditor.this.getRelationSnapshot();
            if (!(GenericRelationEditor.this.memberTableModel.hasSameMembersAs(relation) && !tagEditorModel.isDirty() || relation == null && tagEditorModel.getTags().isEmpty())) {
                int n = this.confirmClosingByCancel();
                if (n == 0) {
                    Main.pref.put("relation.editor.generic.lastrole", GenericRelationEditor.this.tfRole.getText());
                    if (GenericRelationEditor.this.getRelation() == null) {
                        this.applyNewRelation();
                    } else if (!GenericRelationEditor.this.memberTableModel.hasSameMembersAs(relation) || tagEditorModel.isDirty()) {
                        if (GenericRelationEditor.this.isDirtyRelation()) {
                            if (!this.confirmClosingBecauseOfDirtyState()) return;
                            if (GenericRelationEditor.this.getLayer().getConflicts().hasConflictForMy(GenericRelationEditor.this.getRelation())) {
                                this.warnDoubleConflict();
                                return;
                            }
                            this.applyExistingConflictingRelation();
                        } else {
                            this.applyExistingNonConflictingRelation();
                        }
                    }
                } else if (n == 2) {
                    return;
                }
            }
            GenericRelationEditor.this.setVisible(false);
        }

        protected int confirmClosingByCancel() {
            HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Yes, save the changes and close", new Object[0]), ImageProvider.get("ok"), I18n.tr("Click to save the changes and close this relation editor", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("No, discard the changes and close", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to discard the changes and close this relation editor", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel, continue editing", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to return to the relation editor and to resume relation editing", new Object[0]), null)};
            return HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>The relation has been changed.<br><br>Do you want to save your changes?</html>", new Object[0]), I18n.tr("Unsaved changes", new Object[0]), 2, null, buttonSpecArray, buttonSpecArray[0], "/Dialog/RelationEditor#DiscardChanges");
        }
    }

    class OKAction
    extends SavingAction {
        OKAction() {
            this.putValue("ShortDescription", I18n.tr("Apply the updates and close the dialog", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.putValue("Name", I18n.tr("OK", new Object[0]));
            this.setEnabled(true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            Main.pref.put("relation.editor.generic.lastrole", GenericRelationEditor.this.tfRole.getText());
            GenericRelationEditor.this.memberTable.stopHighlighting();
            if (GenericRelationEditor.this.getRelation() == null) {
                this.applyNewRelation();
            } else if (!GenericRelationEditor.this.memberTableModel.hasSameMembersAs(GenericRelationEditor.this.getRelationSnapshot()) || GenericRelationEditor.this.tagEditorPanel.getModel().isDirty()) {
                if (GenericRelationEditor.this.isDirtyRelation()) {
                    if (!this.confirmClosingBecauseOfDirtyState()) return;
                    if (GenericRelationEditor.this.getLayer().getConflicts().hasConflictForMy(GenericRelationEditor.this.getRelation())) {
                        this.warnDoubleConflict();
                        return;
                    }
                    this.applyExistingConflictingRelation();
                } else {
                    this.applyExistingNonConflictingRelation();
                }
            }
            GenericRelationEditor.this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }
    }

    class ApplyAction
    extends SavingAction {
        ApplyAction() {
            this.putValue("ShortDescription", I18n.tr("Apply the current updates", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("save"));
            this.putValue("Name", I18n.tr("Apply", new Object[0]));
            this.setEnabled(true);
        }

        public void run() {
            if (GenericRelationEditor.this.getRelation() == null) {
                this.applyNewRelation();
            } else if (!GenericRelationEditor.this.memberTableModel.hasSameMembersAs(GenericRelationEditor.this.getRelationSnapshot()) || GenericRelationEditor.this.tagEditorPanel.getModel().isDirty()) {
                if (GenericRelationEditor.this.isDirtyRelation()) {
                    if (this.confirmClosingBecauseOfDirtyState()) {
                        if (GenericRelationEditor.this.getLayer().getConflicts().hasConflictForMy(GenericRelationEditor.this.getRelation())) {
                            this.warnDoubleConflict();
                            return;
                        }
                        this.applyExistingConflictingRelation();
                        GenericRelationEditor.this.setVisible(false);
                    }
                } else {
                    this.applyExistingNonConflictingRelation();
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }
    }

    abstract class SavingAction
    extends AbstractAction {
        SavingAction() {
        }

        protected void applyNewRelation() {
            final Relation relation = new Relation();
            GenericRelationEditor.this.tagEditorPanel.getModel().applyToPrimitive(relation);
            GenericRelationEditor.this.memberTableModel.applyToRelation(relation);
            ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
            for (RelationMember relationMember : relation.getMembers()) {
                if (relationMember.getMember().isDeleted()) continue;
                arrayList.add(relationMember);
            }
            if (relation.getMembersCount() != arrayList.size()) {
                relation.setMembers(arrayList);
                String string = I18n.tr("One or more members of this new relation have been deleted while the relation editor\nwas open. They have been removed from the relation members list.", new Object[0]);
                JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Warning", new Object[0]), 2);
            }
            if (relation.getMembersCount() == 0 && !relation.hasKeys()) {
                return;
            }
            Main.main.undoRedo.add(new AddCommand(GenericRelationEditor.this.getLayer(), relation));
            GenericRelationEditor.this.getLayer().data.fireSelectionChanged();
            GenericRelationEditor.this.setRelation(relation);
            RelationDialogManager.getRelationDialogManager().updateContext(GenericRelationEditor.this.getLayer(), GenericRelationEditor.this.getRelation(), GenericRelationEditor.this);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Main.map.relationListDialog.selectRelation(relation);
                }
            });
        }

        protected void applyExistingConflictingRelation() {
            Relation relation = new Relation(GenericRelationEditor.this.getRelation());
            GenericRelationEditor.this.tagEditorPanel.getModel().applyToPrimitive(relation);
            GenericRelationEditor.this.memberTableModel.applyToRelation(relation);
            Conflict<Relation> conflict = new Conflict<Relation>(GenericRelationEditor.this.getRelation(), relation);
            Main.main.undoRedo.add(new ConflictAddCommand(GenericRelationEditor.this.getLayer(), conflict));
        }

        protected void applyExistingNonConflictingRelation() {
            Relation relation = new Relation(GenericRelationEditor.this.getRelation());
            GenericRelationEditor.this.tagEditorPanel.getModel().applyToPrimitive(relation);
            GenericRelationEditor.this.memberTableModel.applyToRelation(relation);
            Main.main.undoRedo.add(new ChangeCommand(GenericRelationEditor.this.getRelation(), relation));
            GenericRelationEditor.this.getLayer().data.fireSelectionChanged();
            GenericRelationEditor.this.setRelation(GenericRelationEditor.this.getRelation());
        }

        protected boolean confirmClosingBecauseOfDirtyState() {
            HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Yes, create a conflict and close", new Object[0]), ImageProvider.get("ok"), I18n.tr("Click to create a conflict and close this relation editor", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("No, continue editing", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to return to the relation editor and to resume relation editing", new Object[0]), null)};
            int n = HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>This relation has been changed outside of the editor.<br>You cannot apply your changes and continue editing.<br><br>Do you want to create a conflict and close the editor?</html>", new Object[0]), I18n.tr("Conflict in data", new Object[0]), 2, null, buttonSpecArray, buttonSpecArray[0], "/Dialog/RelationEditor#RelationChangedOutsideOfEditor");
            return n == 0;
        }

        protected void warnDoubleConflict() {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Layer ''{0}'' already has a conflict for object<br>''{1}''.<br>Please resolve this conflict first, then try again.</html>", GenericRelationEditor.this.getLayer().getName(), GenericRelationEditor.this.getRelation().getDisplayName(DefaultNameFormatter.getInstance())), I18n.tr("Double conflict", new Object[0]), 2);
        }
    }

    class DeleteCurrentRelationAction
    extends AbstractAction
    implements PropertyChangeListener {
        DeleteCurrentRelationAction() {
            this.putValue("ShortDescription", I18n.tr("Delete the currently edited relation", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("Name", I18n.tr("Delete", new Object[0]));
            this.updateEnabledState();
        }

        public void run() {
            Relation relation = GenericRelationEditor.this.getRelation();
            if (relation == null) {
                return;
            }
            DeleteAction.deleteRelation(GenericRelationEditor.this.getLayer(), relation);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        protected void updateEnabledState() {
            this.setEnabled(GenericRelationEditor.this.getRelationSnapshot() != null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(RelationEditor.RELATION_SNAPSHOT_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    class RemoveAction
    extends AbstractAction
    implements ListSelectionListener {
        RemoveAction() {
            String string = I18n.tr("Remove the currently selected members from this relation", new Object[0]);
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("Name", I18n.tr("Remove", new Object[0]));
            Shortcut shortcut = Shortcut.registerShortcut("relationeditor:remove", I18n.tr("Relation Editor: Remove", new Object[0]), 127, 5004);
            shortcut.setAccelerator(this);
            this.putValue("ShortDescription", Main.platform.makeTooltip(string, shortcut));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.memberTableModel.remove(GenericRelationEditor.this.memberTable.getSelectedRows());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(GenericRelationEditor.this.memberTableModel.canRemove(GenericRelationEditor.this.memberTable.getSelectedRows()));
        }
    }

    class MoveDownAction
    extends AbstractAction
    implements ListSelectionListener {
        MoveDownAction() {
            String string = I18n.tr("Move the currently selected members down", new Object[0]);
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "movedown"));
            Shortcut shortcut = Shortcut.registerShortcut("relationeditor:movedown", I18n.tr("Relation Editor: Move Down", new Object[0]), 40, 5004);
            shortcut.setAccelerator(this);
            this.putValue("ShortDescription", Main.platform.makeTooltip(string, shortcut));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.memberTableModel.moveDown(GenericRelationEditor.this.memberTable.getSelectedRows());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(GenericRelationEditor.this.memberTableModel.canMoveDown(GenericRelationEditor.this.memberTable.getSelectedRows()));
        }
    }

    class MoveUpAction
    extends AbstractAction
    implements ListSelectionListener {
        MoveUpAction() {
            String string = I18n.tr("Move the currently selected members up", new Object[0]);
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "moveup"));
            Shortcut shortcut = Shortcut.registerShortcut("relationeditor:moveup", I18n.tr("Relation Editor: Move Up", new Object[0]), 38, 5004);
            shortcut.setAccelerator(this);
            this.putValue("ShortDescription", Main.platform.makeTooltip(string, shortcut));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.memberTableModel.moveUp(GenericRelationEditor.this.memberTable.getSelectedRows());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(GenericRelationEditor.this.memberTableModel.canMoveUp(GenericRelationEditor.this.memberTable.getSelectedRows()));
        }
    }

    class ReverseAction
    extends AbstractAction
    implements TableModelListener {
        ReverseAction() {
            this.putValue("ShortDescription", I18n.tr("Reverse the order of the relation members", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "reverse"));
            this.putValue("Name", I18n.tr("Reverse", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.memberTableModel.reverse();
        }

        protected void updateEnabledState() {
            this.setEnabled(GenericRelationEditor.this.memberTableModel.getRowCount() > 0);
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.updateEnabledState();
        }
    }

    class SortBelowAction
    extends AbstractAction
    implements TableModelListener,
    ListSelectionListener {
        SortBelowAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "sort_below"));
            this.putValue("Name", I18n.tr("Sort below", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Sort the selected relation members and all members below", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.memberTableModel.sortBelow();
        }

        protected void updateEnabledState() {
            this.setEnabled(GenericRelationEditor.this.memberTableModel.getRowCount() > 0 && !GenericRelationEditor.this.memberTableModel.getSelectionModel().isSelectionEmpty());
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.updateEnabledState();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class SortAction
    extends AbstractAction
    implements TableModelListener {
        SortAction() {
            String string = I18n.tr("Sort the relation members", new Object[0]);
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "sort"));
            this.putValue("Name", I18n.tr("Sort", new Object[0]));
            Shortcut shortcut = Shortcut.registerShortcut("relationeditor:sort", I18n.tr("Relation Editor: Sort", new Object[0]), 35, 5004);
            shortcut.setAccelerator(this);
            this.putValue("ShortDescription", Main.platform.makeTooltip(string, shortcut));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.memberTableModel.sort();
        }

        protected void updateEnabledState() {
            this.setEnabled(GenericRelationEditor.this.memberTableModel.getRowCount() > 0);
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.updateEnabledState();
        }
    }

    class SelectPrimitivesForSelectedMembersAction
    extends AbstractAction
    implements ListSelectionListener {
        SelectPrimitivesForSelectedMembersAction() {
            this.putValue("ShortDescription", I18n.tr("Select objects for selected relation members", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "selectprimitives"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(GenericRelationEditor.this.memberTable.getSelectedRowCount() > 0);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.getLayer().data.setSelected(GenericRelationEditor.this.memberTableModel.getSelectedChildPrimitives());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class SelectedMembersForSelectionAction
    extends AbstractAction
    implements TableModelListener {
        SelectedMembersForSelectionAction() {
            this.putValue("ShortDescription", I18n.tr("Select relation members which refer to objects in the current selection", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "selectmembers"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            boolean bl;
            boolean bl2 = bl = GenericRelationEditor.this.selectionTableModel.getRowCount() > 0 && !GenericRelationEditor.this.memberTableModel.getChildPrimitives(GenericRelationEditor.this.getLayer().data.getSelected()).isEmpty();
            if (bl) {
                this.putValue("ShortDescription", I18n.tr("Select relation members which refer to {0} objects in the current selection", GenericRelationEditor.this.memberTableModel.getChildPrimitives(GenericRelationEditor.this.getLayer().data.getSelected()).size()));
            } else {
                this.putValue("ShortDescription", I18n.tr("Select relation members which refer to objects in the current selection", new Object[0]));
            }
            this.setEnabled(bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.memberTableModel.selectMembersReferringTo(GenericRelationEditor.this.getLayer().data.getSelected());
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.updateEnabledState();
        }
    }

    class RemoveSelectedAction
    extends AbstractAction
    implements TableModelListener {
        RemoveSelectedAction() {
            this.putValue("ShortDescription", I18n.tr("Remove all members referring to one of the selected objects", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "deletemembers"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            DataSet dataSet = GenericRelationEditor.this.getLayer().data;
            if (dataSet == null || dataSet.getSelected().isEmpty()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(GenericRelationEditor.this.memberTableModel.hasMembersReferringTo(dataSet.getSelected()));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.memberTableModel.removeMembersReferringTo(GenericRelationEditor.this.selectionTableModel.getSelection());
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.updateEnabledState();
        }
    }

    class AddSelectedAfterSelection
    extends AddFromSelectionAction
    implements TableModelListener,
    ListSelectionListener {
        AddSelectedAfterSelection() {
            this.putValue("ShortDescription", I18n.tr("Add all objects selected in the current dataset after the last selected member", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "copyaftercurrentright"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.selectionTableModel.getRowCount() > 0 && GenericRelationEditor.this.memberTableModel.getSelectionModel().getMinSelectionIndex() >= 0);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block2: {
                try {
                    List<OsmPrimitive> list = this.filterConfirmedPrimitives(GenericRelationEditor.this.selectionTableModel.getSelection());
                    GenericRelationEditor.this.memberTableModel.addMembersAfterIdx(list, GenericRelationEditor.this.memberTableModel.getSelectionModel().getMaxSelectionIndex());
                }
                catch (AddAbortException addAbortException) {
                    if (!Main.isTraceEnabled()) break block2;
                    Main.trace(addAbortException.getMessage());
                }
            }
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.refreshEnabled();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.refreshEnabled();
        }
    }

    class AddSelectedBeforeSelection
    extends AddFromSelectionAction
    implements TableModelListener,
    ListSelectionListener {
        AddSelectedBeforeSelection() {
            this.putValue("ShortDescription", I18n.tr("Add all objects selected in the current dataset before the first selected member", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "copybeforecurrentright"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.selectionTableModel.getRowCount() > 0 && GenericRelationEditor.this.memberTableModel.getSelectionModel().getMinSelectionIndex() >= 0);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block2: {
                try {
                    List<OsmPrimitive> list = this.filterConfirmedPrimitives(GenericRelationEditor.this.selectionTableModel.getSelection());
                    GenericRelationEditor.this.memberTableModel.addMembersBeforeIdx(list, GenericRelationEditor.this.memberTableModel.getSelectionModel().getMinSelectionIndex());
                }
                catch (AddAbortException addAbortException) {
                    if (!Main.isTraceEnabled()) break block2;
                    Main.trace(addAbortException.getMessage());
                }
            }
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.refreshEnabled();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.refreshEnabled();
        }
    }

    class AddSelectedAtEndAction
    extends AddFromSelectionAction
    implements TableModelListener {
        AddSelectedAtEndAction() {
            this.putValue("ShortDescription", I18n.tr("Add all objects selected in the current dataset after the last member", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "copyendright"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.selectionTableModel.getRowCount() > 0);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block2: {
                try {
                    List<OsmPrimitive> list = this.filterConfirmedPrimitives(GenericRelationEditor.this.selectionTableModel.getSelection());
                    GenericRelationEditor.this.memberTableModel.addMembersAtEnd(list);
                }
                catch (AddAbortException addAbortException) {
                    if (!Main.isTraceEnabled()) break block2;
                    Main.trace(addAbortException.getMessage());
                }
            }
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.refreshEnabled();
        }
    }

    class AddSelectedAtStartAction
    extends AddFromSelectionAction
    implements TableModelListener {
        AddSelectedAtStartAction() {
            this.putValue("ShortDescription", I18n.tr("Add all objects selected in the current dataset before the first member", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "copystartright"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.selectionTableModel.getRowCount() > 0);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block2: {
                try {
                    List<OsmPrimitive> list = this.filterConfirmedPrimitives(GenericRelationEditor.this.selectionTableModel.getSelection());
                    GenericRelationEditor.this.memberTableModel.addMembersAtBeginning(list);
                }
                catch (AddAbortException addAbortException) {
                    if (!Main.isTraceEnabled()) break block2;
                    Main.trace(addAbortException.getMessage());
                }
            }
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.refreshEnabled();
        }
    }

    abstract class AddFromSelectionAction
    extends AbstractAction {
        AddFromSelectionAction() {
        }

        protected boolean isPotentialDuplicate(OsmPrimitive osmPrimitive) {
            return GenericRelationEditor.this.memberTableModel.hasMembersReferringTo(Collections.singleton(osmPrimitive));
        }

        protected List<OsmPrimitive> filterConfirmedPrimitives(List<OsmPrimitive> list) throws AddAbortException {
            if (list == null || list.isEmpty()) {
                return list;
            }
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
            ConditionalOptionPaneUtil.startBulkOperation("add_primitive_to_relation");
            for (OsmPrimitive osmPrimitive : list) {
                if (osmPrimitive instanceof Relation && GenericRelationEditor.this.getRelation() != null && GenericRelationEditor.this.getRelation().equals(osmPrimitive)) {
                    GenericRelationEditor.warnOfCircularReferences(osmPrimitive);
                    continue;
                }
                if (this.isPotentialDuplicate(osmPrimitive)) {
                    if (!GenericRelationEditor.confirmAddingPrimitive(osmPrimitive)) continue;
                    arrayList.add(osmPrimitive);
                    continue;
                }
                arrayList.add(osmPrimitive);
            }
            ConditionalOptionPaneUtil.endBulkOperation("add_primitive_to_relation");
            return arrayList;
        }
    }

    static class AddAbortException
    extends Exception {
        AddAbortException() {
        }
    }
}

