/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.dialogs.relation.IMemberModelListener;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSorter;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetHandler;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.OsmPrimitivesTableModel;

public class MemberTableModel
extends AbstractTableModel
implements TableModelListener,
SelectionChangedListener,
DataSetListener,
OsmPrimitivesTableModel {
    private final transient List<RelationMember> members;
    private transient List<WayConnectionType> connectionType;
    private DefaultListSelectionModel listSelectionModel;
    private final CopyOnWriteArrayList<IMemberModelListener> listeners;
    private final transient OsmDataLayer layer;
    private final transient TaggingPresetHandler presetHandler;
    private final transient WayConnectionTypeCalculator wayConnectionTypeCalculator = new WayConnectionTypeCalculator();
    private final transient RelationSorter relationSorter = new RelationSorter();

    public MemberTableModel(OsmDataLayer osmDataLayer, TaggingPresetHandler taggingPresetHandler) {
        this.members = new ArrayList<RelationMember>();
        this.listeners = new CopyOnWriteArrayList();
        this.layer = osmDataLayer;
        this.presetHandler = taggingPresetHandler;
        this.addTableModelListener(this);
    }

    public OsmDataLayer getLayer() {
        return this.layer;
    }

    public void register() {
        DataSet.addSelectionListener(this);
        this.getLayer().data.addDataSetListener(this);
    }

    public void unregister() {
        DataSet.removeSelectionListener(this);
        this.getLayer().data.removeDataSetListener(this);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        if (Main.main.getEditLayer() != this.layer) {
            return;
        }
        Collection<RelationMember> collection2 = this.getSelectedMembers();
        this.fireTableDataChanged();
        this.setSelectedMembers(collection2);
    }

    @Override
    public void dataChanged(DataChangedEvent dataChangedEvent) {
        Collection<RelationMember> collection = this.getSelectedMembers();
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                MemberTableModel.this.fireTableDataChanged();
            }
        });
        this.setSelectedMembers(collection);
    }

    @Override
    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
    }

    @Override
    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
        Collection<RelationMember> collection = this.getSelectedMembers();
        for (int i = 0; i < this.members.size(); ++i) {
            if (this.members.get(i).getMember() != tagsChangedEvent.getPrimitive()) continue;
            this.fireTableCellUpdated(i, 1);
        }
        this.setSelectedMembers(collection);
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
    }

    public void addMemberModelListener(IMemberModelListener iMemberModelListener) {
        if (iMemberModelListener != null) {
            this.listeners.addIfAbsent(iMemberModelListener);
        }
    }

    public void removeMemberModelListener(IMemberModelListener iMemberModelListener) {
        this.listeners.remove(iMemberModelListener);
    }

    protected void fireMakeMemberVisible(int n) {
        for (IMemberModelListener iMemberModelListener : this.listeners) {
            iMemberModelListener.makeMemberVisible(n);
        }
    }

    public void populate(Relation relation) {
        this.members.clear();
        if (relation != null) {
            this.members.addAll(new Relation(relation).getMembers());
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.members.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.members.get(n).getRole();
            }
            case 1: {
                return this.members.get(n).getMember();
            }
            case 2: {
                return this.getWayConnection(n);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n >= this.members.size()) {
            return;
        }
        RelationMember relationMember = this.members.get(n);
        RelationMember relationMember2 = new RelationMember(object.toString(), relationMember.getMember());
        this.members.remove(n);
        this.members.add(n, relationMember2);
    }

    @Override
    public OsmPrimitive getReferredPrimitive(int n) {
        return this.members.get(n).getMember();
    }

    public void moveUp(int[] nArray) {
        if (!this.canMoveUp(nArray)) {
            return;
        }
        for (int n : nArray) {
            RelationMember relationMember = this.members.get(n);
            RelationMember relationMember2 = this.members.get(n - 1);
            this.members.set(n, relationMember2);
            this.members.set(n - 1, relationMember);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int n : nArray) {
            this.getSelectionModel().addSelectionInterval(--n, n);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(nArray[0] - 1);
    }

    public void moveDown(int[] nArray) {
        if (!this.canMoveDown(nArray)) {
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            RelationMember relationMember = this.members.get(n);
            RelationMember relationMember2 = this.members.get(n + 1);
            this.members.set(n, relationMember2);
            this.members.set(n + 1, relationMember);
        }
        this.fireTableDataChanged();
        this.getSelectionModel();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int n : nArray) {
            this.getSelectionModel().addSelectionInterval(++n, n);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(nArray[0] + 1);
    }

    public void remove(int[] nArray) {
        if (!this.canRemove(nArray)) {
            return;
        }
        int n = 0;
        for (int n2 : nArray) {
            if (this.members.size() <= (n2 -= n)) continue;
            this.members.remove(n2);
            ++n;
        }
        this.fireTableDataChanged();
    }

    public boolean canMoveUp(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        Arrays.sort(nArray);
        return nArray[0] > 0 && !this.members.isEmpty();
    }

    public boolean canMoveDown(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        Arrays.sort(nArray);
        return !this.members.isEmpty() && nArray[nArray.length - 1] < this.members.size() - 1;
    }

    public boolean canRemove(int[] nArray) {
        return nArray != null && nArray.length != 0;
    }

    public DefaultListSelectionModel getSelectionModel() {
        if (this.listSelectionModel == null) {
            this.listSelectionModel = new DefaultListSelectionModel();
            this.listSelectionModel.setSelectionMode(2);
        }
        return this.listSelectionModel;
    }

    public void removeMembersReferringTo(List<? extends OsmPrimitive> list) {
        if (list == null) {
            return;
        }
        Iterator<RelationMember> iterator = this.members.iterator();
        while (iterator.hasNext()) {
            RelationMember relationMember = iterator.next();
            if (!list.contains(relationMember.getMember())) continue;
            iterator.remove();
        }
        this.fireTableDataChanged();
    }

    public void applyToRelation(Relation relation) {
        relation.setMembers(this.members);
    }

    public boolean hasSameMembersAs(Relation relation) {
        if (relation == null) {
            return false;
        }
        if (relation.getMembersCount() != this.members.size()) {
            return false;
        }
        for (int i = 0; i < relation.getMembersCount(); ++i) {
            if (relation.getMember(i).equals(this.members.get(i))) continue;
            return false;
        }
        return true;
    }

    public Set<OsmPrimitive> getIncompleteMemberPrimitives() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (RelationMember relationMember : this.members) {
            if (!relationMember.getMember().isIncomplete()) continue;
            hashSet.add(relationMember.getMember());
        }
        return hashSet;
    }

    public Set<OsmPrimitive> getSelectedIncompleteMemberPrimitives() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (RelationMember relationMember : this.getSelectedMembers()) {
            if (!relationMember.getMember().isIncomplete()) continue;
            hashSet.add(relationMember.getMember());
        }
        return hashSet;
    }

    public boolean hasIncompleteMembers() {
        for (RelationMember relationMember : this.members) {
            if (!relationMember.getMember().isIncomplete()) continue;
            return true;
        }
        return false;
    }

    public boolean hasIncompleteSelectedMembers() {
        for (RelationMember relationMember : this.getSelectedMembers()) {
            if (!relationMember.getMember().isIncomplete()) continue;
            return true;
        }
        return false;
    }

    protected List<Integer> getSelectedIndices() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.members.size(); ++i) {
            if (!this.getSelectionModel().isSelectedIndex(i)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    private void addMembersAtIndex(List<? extends OsmPrimitive> list, int n) {
        Collection<TaggingPreset> collection = TaggingPreset.getMatchingPresets(EnumSet.of(TaggingPresetType.RELATION), this.presetHandler.getSelection().iterator().next().getKeys(), false);
        if (list == null) {
            return;
        }
        int n2 = n;
        for (OsmPrimitive osmPrimitive : list) {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (TaggingPreset taggingPreset : collection) {
                String string = taggingPreset.suggestRoleForOsmPrimitive(osmPrimitive);
                if (string == null) continue;
                treeSet.add(string);
            }
            Iterator<TaggingPreset> iterator = treeSet.isEmpty() ? null : (String)treeSet.iterator().next();
            RelationMember object2 = new RelationMember((String)(iterator == null ? "" : iterator), osmPrimitive);
            this.members.add(n2++, object2);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().clearSelection();
        this.getSelectionModel().addSelectionInterval(n, n + list.size() - 1);
        this.fireMakeMemberVisible(n);
    }

    public void addMembersAtBeginning(List<? extends OsmPrimitive> list) {
        this.addMembersAtIndex(list, 0);
    }

    public void addMembersAtEnd(List<? extends OsmPrimitive> list) {
        this.addMembersAtIndex(list, this.members.size());
    }

    public void addMembersBeforeIdx(List<? extends OsmPrimitive> list, int n) {
        this.addMembersAtIndex(list, n);
    }

    public void addMembersAfterIdx(List<? extends OsmPrimitive> list, int n) {
        this.addMembersAtIndex(list, n + 1);
    }

    public int getNumMembersWithPrimitive(OsmPrimitive osmPrimitive) {
        int n = 0;
        for (RelationMember relationMember : this.members) {
            if (!relationMember.getMember().equals(osmPrimitive)) continue;
            ++n;
        }
        return n;
    }

    public void updateRole(int[] nArray, String string) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        for (int n : nArray) {
            if (n >= this.members.size()) continue;
            RelationMember relationMember = this.members.get(n);
            RelationMember relationMember2 = new RelationMember(string, relationMember.getMember());
            this.members.remove(n);
            this.members.add(n, relationMember2);
        }
        this.fireTableDataChanged();
        for (int n : nArray) {
            this.getSelectionModel().addSelectionInterval(n, n);
        }
    }

    public Collection<RelationMember> getSelectedMembers() {
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
        for (int n : this.getSelectedIndices()) {
            arrayList.add(this.members.get(n));
        }
        return arrayList;
    }

    public Collection<OsmPrimitive> getSelectedChildPrimitives() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        for (RelationMember relationMember : this.getSelectedMembers()) {
            arrayList.add(relationMember.getMember());
        }
        return arrayList;
    }

    public Set<OsmPrimitive> getChildPrimitives(Collection<? extends OsmPrimitive> collection) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        if (collection == null) {
            return null;
        }
        for (RelationMember relationMember : this.members) {
            if (!collection.contains(relationMember.getMember())) continue;
            hashSet.add(relationMember.getMember());
        }
        return hashSet;
    }

    public void setSelectedMembers(Collection<RelationMember> collection) {
        if (collection == null || collection.isEmpty()) {
            this.getSelectionModel().clearSelection();
            return;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (RelationMember relationMember : collection) {
            for (int i = 0; i < this.members.size(); ++i) {
                if (!relationMember.equals(this.members.get(i))) continue;
                hashSet.add(i);
            }
        }
        this.setSelectedMembersIdx(hashSet);
    }

    public void setSelectedMembersIdx(Collection<Integer> collection) {
        if (collection == null || collection.isEmpty()) {
            this.getSelectionModel().clearSelection();
            return;
        }
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int n : collection) {
            this.getSelectionModel().addSelectionInterval(n, n);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        if (!collection.isEmpty()) {
            this.fireMakeMemberVisible(Collections.min(collection));
        }
    }

    public boolean isEditableRelation(int n) {
        if (n < 0 || n >= this.members.size()) {
            return false;
        }
        RelationMember relationMember = this.members.get(n);
        if (!relationMember.isRelation()) {
            return false;
        }
        Relation relation = relationMember.getRelation();
        return !relation.isIncomplete();
    }

    public static boolean hasMembersReferringTo(Collection<RelationMember> collection, Collection<OsmPrimitive> collection2) {
        if (collection2 == null || collection2.isEmpty()) {
            return false;
        }
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (RelationMember primitiveId : collection) {
            hashSet.add(primitiveId.getMember());
        }
        for (OsmPrimitive osmPrimitive : collection2) {
            if (!hashSet.contains(osmPrimitive)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMembersReferringTo(Collection<OsmPrimitive> collection) {
        return MemberTableModel.hasMembersReferringTo(this.members, collection);
    }

    public void selectMembersReferringTo(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            return;
        }
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < this.members.size(); ++i) {
            RelationMember relationMember = this.members.get(i);
            if (!collection.contains(relationMember.getMember())) continue;
            this.getSelectionModel().addSelectionInterval(i, i);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        if (!this.getSelectedIndices().isEmpty()) {
            this.fireMakeMemberVisible(this.getSelectedIndices().get(0));
        }
    }

    public boolean isInJosmSelection(OsmPrimitive osmPrimitive) {
        return this.layer.data.isSelected(osmPrimitive);
    }

    void sort() {
        List<RelationMember> list;
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>(this.getSelectedMembers());
        List<RelationMember> list2 = null;
        if (arrayList.size() <= 1) {
            list2 = list = this.relationSorter.sortMembers(this.members);
        } else {
            list2 = this.relationSorter.sortMembers(arrayList);
            List<Integer> list3 = this.getSelectedIndices();
            list = new ArrayList<RelationMember>();
            boolean bl = false;
            for (int i = 0; i < this.members.size(); ++i) {
                if (list3.contains(i)) {
                    if (bl) continue;
                    list.addAll(list2);
                    bl = true;
                    continue;
                }
                list.add(this.members.get(i));
            }
        }
        if (this.members.size() != list.size()) {
            throw new AssertionError();
        }
        this.members.clear();
        this.members.addAll(list);
        this.fireTableDataChanged();
        this.setSelectedMembers(list2);
    }

    void sortBelow() {
        List<RelationMember> list = this.members.subList(this.getSelectionModel().getMinSelectionIndex(), this.members.size());
        List<RelationMember> list2 = this.relationSorter.sortMembers(list);
        list.clear();
        list.addAll(list2);
        this.fireTableDataChanged();
        this.setSelectedMembers(list2);
    }

    WayConnectionType getWayConnection(int n) {
        if (this.connectionType == null) {
            this.connectionType = this.wayConnectionTypeCalculator.updateLinks(this.members);
        }
        return this.connectionType.get(n);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.connectionType = null;
    }

    void reverse() {
        List<Integer> list = this.getSelectedIndices();
        List<Integer> list2 = this.getSelectedIndices();
        if (list.size() <= 1) {
            Collections.reverse(this.members);
            this.fireTableDataChanged();
            this.setSelectedMembers(this.members);
        } else {
            Collections.reverse(list2);
            ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>(this.members);
            for (int i = 0; i < list.size(); ++i) {
                arrayList.set(list.get(i), this.members.get(list2.get(i)));
            }
            if (this.members.size() != arrayList.size()) {
                throw new AssertionError();
            }
            this.members.clear();
            this.members.addAll(arrayList);
            this.fireTableDataChanged();
            this.setSelectedMembersIdx(list);
        }
    }
}

