/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.awt.Rectangle;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.NodeElemStyle;
import org.openstreetmap.josm.gui.mappaint.TextElement;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class BoxTextElemStyle
extends ElemStyle {
    public static final Rectangle ZERO_BOX = new Rectangle(0, 0, 0, 0);
    public TextElement text;
    protected BoxProvider boxProvider;
    protected Rectangle box;
    public HorizontalTextAlignment hAlign;
    public VerticalTextAlignment vAlign;
    public static final BoxTextElemStyle SIMPLE_NODE_TEXT_ELEMSTYLE;
    private static volatile Color DEFAULT_TEXT_COLOR;

    public BoxTextElemStyle(Cascade cascade, TextElement textElement, BoxProvider boxProvider, Rectangle rectangle, HorizontalTextAlignment horizontalTextAlignment, VerticalTextAlignment verticalTextAlignment) {
        super(cascade, 5.0f);
        CheckParameterUtil.ensureParameterNotNull(textElement);
        CheckParameterUtil.ensureParameterNotNull((Object)horizontalTextAlignment);
        CheckParameterUtil.ensureParameterNotNull((Object)verticalTextAlignment);
        this.text = textElement;
        this.boxProvider = boxProvider;
        this.box = rectangle == null ? ZERO_BOX : rectangle;
        this.hAlign = horizontalTextAlignment;
        this.vAlign = verticalTextAlignment;
    }

    public static BoxTextElemStyle create(Environment environment, BoxProvider boxProvider) {
        return BoxTextElemStyle.create(environment, boxProvider, null);
    }

    public static BoxTextElemStyle create(Environment environment, Rectangle rectangle) {
        return BoxTextElemStyle.create(environment, null, rectangle);
    }

    public static BoxTextElemStyle create(Environment environment, BoxProvider boxProvider, Rectangle rectangle) {
        BoxTextElemStyle.initDefaultParameters();
        Cascade cascade = environment.mc.getCascade(environment.layer);
        TextElement textElement = TextElement.create(environment, DEFAULT_TEXT_COLOR, false);
        if (textElement == null) {
            return null;
        }
        if (textElement.labelCompositionStrategy.compose(environment.osm) == null) {
            return null;
        }
        HorizontalTextAlignment horizontalTextAlignment = HorizontalTextAlignment.RIGHT;
        Keyword keyword = cascade.get("text-anchor-horizontal", Keyword.RIGHT, Keyword.class);
        switch (keyword.val) {
            case "left": {
                horizontalTextAlignment = HorizontalTextAlignment.LEFT;
                break;
            }
            case "center": {
                horizontalTextAlignment = HorizontalTextAlignment.CENTER;
            }
        }
        Object object = VerticalTextAlignment.BOTTOM;
        Keyword keyword2 = cascade.get("text-anchor-vertical", Keyword.BOTTOM, Keyword.class);
        switch (keyword2.val) {
            case "bottom": {
                object = VerticalTextAlignment.BOTTOM;
                break;
            }
            case "above": {
                object = VerticalTextAlignment.ABOVE;
                break;
            }
            case "top": {
                object = VerticalTextAlignment.TOP;
                break;
            }
            case "center": {
                object = VerticalTextAlignment.CENTER;
                break;
            }
            case "below": {
                object = VerticalTextAlignment.BELOW;
            }
        }
        return new BoxTextElemStyle(cascade, textElement, boxProvider, rectangle, horizontalTextAlignment, (VerticalTextAlignment)((Object)object));
    }

    public Rectangle getBox() {
        if (this.boxProvider != null) {
            BoxProviderResult boxProviderResult = this.boxProvider.get();
            if (!boxProviderResult.isTemporary()) {
                this.box = boxProviderResult.getBox();
                this.boxProvider = null;
            }
            return boxProviderResult.getBox();
        }
        return this.box;
    }

    private static void initDefaultParameters() {
        if (DEFAULT_TEXT_COLOR != null) {
            return;
        }
        DEFAULT_TEXT_COLOR = PaintColors.TEXT.get();
    }

    @Override
    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, StyledMapRenderer styledMapRenderer, boolean bl, boolean bl2, boolean bl3) {
        if (osmPrimitive instanceof Node) {
            styledMapRenderer.drawBoxText((Node)osmPrimitive, this);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BoxTextElemStyle boxTextElemStyle = (BoxTextElemStyle)object;
        if (!this.text.equals(boxTextElemStyle.text)) {
            return false;
        }
        if (this.boxProvider != null) {
            if (!this.boxProvider.equals(boxTextElemStyle.boxProvider)) {
                return false;
            }
        } else {
            if (boxTextElemStyle.boxProvider != null) {
                return false;
            }
            if (!this.box.equals(boxTextElemStyle.box)) {
                return false;
            }
        }
        if (this.hAlign != boxTextElemStyle.hAlign) {
            return false;
        }
        return this.vAlign == boxTextElemStyle.vAlign;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 97 * n + this.text.hashCode();
        n = this.boxProvider != null ? 97 * n + this.boxProvider.hashCode() : 97 * n + this.box.hashCode();
        n = 97 * n + this.hAlign.hashCode();
        n = 97 * n + this.vAlign.hashCode();
        return n;
    }

    @Override
    public String toString() {
        return "BoxTextElemStyle{" + super.toString() + ' ' + this.text.toStringImpl() + " box=" + this.box + " hAlign=" + (Object)((Object)this.hAlign) + " vAlign=" + (Object)((Object)this.vAlign) + '}';
    }

    static {
        MultiCascade multiCascade = new MultiCascade();
        Cascade cascade = multiCascade.getOrCreateCascade("default");
        cascade.put("text", Keyword.AUTO);
        Node node = new Node();
        node.put("name", "dummy");
        SIMPLE_NODE_TEXT_ELEMSTYLE = BoxTextElemStyle.create(new Environment(node, multiCascade, "default", null), NodeElemStyle.SIMPLE_NODE_ELEMSTYLE.getBoxProvider());
        if (SIMPLE_NODE_TEXT_ELEMSTYLE == null) {
            throw new AssertionError();
        }
    }

    public static class SimpleBoxProvider
    implements BoxProvider {
        private final Rectangle box;

        public SimpleBoxProvider(Rectangle rectangle) {
            this.box = rectangle;
        }

        @Override
        public BoxProviderResult get() {
            return new BoxProviderResult(this.box, false);
        }

        public int hashCode() {
            return this.box.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof BoxProvider)) {
                return false;
            }
            BoxProvider boxProvider = (BoxProvider)object;
            BoxProviderResult boxProviderResult = boxProvider.get();
            if (boxProviderResult.isTemporary()) {
                return false;
            }
            return this.box.equals(boxProviderResult.getBox());
        }
    }

    public static class BoxProviderResult {
        private final Rectangle box;
        private final boolean temporary;

        public BoxProviderResult(Rectangle rectangle, boolean bl) {
            this.box = rectangle;
            this.temporary = bl;
        }

        public Rectangle getBox() {
            return this.box;
        }

        public boolean isTemporary() {
            return this.temporary;
        }
    }

    public static interface BoxProvider {
        public BoxProviderResult get();
    }

    public static enum VerticalTextAlignment {
        ABOVE,
        TOP,
        CENTER,
        BOTTOM,
        BELOW;

    }

    public static enum HorizontalTextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

