/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.Objects;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.TextElement;

public class LineTextElemStyle
extends ElemStyle {
    private final TextElement text;

    protected LineTextElemStyle(Cascade cascade, TextElement textElement) {
        super(cascade, 4.9f);
        this.text = textElement;
    }

    public static LineTextElemStyle create(Environment environment) {
        Cascade cascade = environment.mc.getCascade(environment.layer);
        Keyword keyword = cascade.get("text-position", null, Keyword.class);
        if (keyword != null && !"line".equals(keyword.val)) {
            return null;
        }
        TextElement textElement = TextElement.create(environment, PaintColors.TEXT.get(), false);
        if (textElement == null) {
            return null;
        }
        return new LineTextElemStyle(cascade, textElement);
    }

    @Override
    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, StyledMapRenderer styledMapRenderer, boolean bl, boolean bl2, boolean bl3) {
        Way way = (Way)osmPrimitive;
        styledMapRenderer.drawTextOnPath(way, this.text);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        LineTextElemStyle lineTextElemStyle = (LineTextElemStyle)object;
        return Objects.equals(this.text, lineTextElemStyle.text);
    }

    @Override
    public int hashCode() {
        return this.text.hashCode();
    }

    @Override
    public String toString() {
        return "LineTextElemStyle{" + super.toString() + "text=" + this.text + '}';
    }
}

