/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.advanced.PrefEntry;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ListListEditor
extends ExtendedDialog {
    private EntryListModel entryModel;
    private final List<List<String>> data;
    private final transient PrefEntry entry;
    private JList<String> entryList;
    private Integer entryIdx;
    private JTable table;
    private ListTableModel tableModel;

    public ListListEditor(JComponent jComponent, PrefEntry prefEntry, Preferences.ListListSetting listListSetting) {
        super(jComponent, I18n.tr("Change list of lists setting", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])});
        this.entry = prefEntry;
        List list = (List)listListSetting.getValue();
        this.data = new ArrayList<List<String>>();
        if (list != null) {
            for (List list2 : list) {
                this.data.add(new ArrayList(list2));
            }
        }
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(jComponent, new Dimension(500, 350)));
        this.setContent(this.build(), false);
    }

    public List<List<String>> getData() {
        return this.data;
    }

    protected final JPanel build() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Key: {0}", this.entry.getKey())), GBC.std(0, 0).span(2).weight(1.0, 0.0).insets(0, 0, 5, 10));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.entryModel = new EntryListModel();
        this.entryList = new JList<String>(this.entryModel);
        this.entryList.getSelectionModel().addListSelectionListener(new EntryListener());
        JScrollPane jScrollPane = new JScrollPane(this.entryList);
        jPanel2.add((Component)jScrollPane, GBC.eol().fill());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setBorderPainted(false);
        jToolBar.setOpaque(false);
        jToolBar.add(new NewEntryAction());
        RemoveEntryAction removeEntryAction = new RemoveEntryAction();
        this.entryList.getSelectionModel().addListSelectionListener(removeEntryAction);
        jToolBar.add(removeEntryAction);
        jPanel2.add((Component)jToolBar, GBC.eol());
        jPanel2.setPreferredSize(new Dimension(80, 0));
        jPanel.add((Component)jPanel2, GBC.std(0, 1).fill().weight(0.3, 1.0));
        this.tableModel = new ListTableModel();
        this.table = new JTable(this.tableModel);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setTableHeader(null);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JosmTextField());
        defaultCellEditor.setClickCountToStart(1);
        this.table.setDefaultEditor(this.table.getColumnClass(0), defaultCellEditor);
        JScrollPane jScrollPane2 = new JScrollPane(this.table);
        jScrollPane2.setPreferredSize(new Dimension(140, 0));
        jPanel.add((Component)jScrollPane2, GBC.std(1, 1).insets(5, 0, 0, 0).fill().weight(0.7, 1.0));
        return jPanel;
    }

    class ListTableModel
    extends AbstractTableModel {
        ListTableModel() {
        }

        private List<String> data() {
            if (ListListEditor.this.entryIdx == null) {
                return Collections.emptyList();
            }
            return (List)ListListEditor.this.data.get(ListListEditor.this.entryIdx);
        }

        @Override
        public int getRowCount() {
            return ListListEditor.this.entryIdx == null ? 0 : this.data().size() + 1;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data().size() == n ? "" : this.data().get(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String string = (String)object;
            if (n == this.data().size()) {
                this.data().add(string);
                this.fireTableRowsInserted(n + 1, n + 1);
            } else {
                this.data().set(n, string);
            }
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }

    class EntryListener
    implements ListSelectionListener {
        EntryListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            TableCellEditor tableCellEditor = ListListEditor.this.table.getCellEditor();
            if (tableCellEditor != null) {
                ((DefaultCellEditor)tableCellEditor).stopCellEditing();
            }
            if (ListListEditor.this.entryList.getSelectedIndices().length != 1) {
                ListListEditor.this.entryIdx = null;
                ListListEditor.this.table.setEnabled(false);
            } else {
                ListListEditor.this.entryIdx = ListListEditor.this.entryList.getSelectedIndices()[0];
                ListListEditor.this.table.setEnabled(true);
            }
            ListListEditor.this.tableModel.fireTableStructureChanged();
        }
    }

    class RemoveEntryAction
    extends AbstractAction
    implements ListSelectionListener {
        RemoveEntryAction() {
            this.putValue("Name", I18n.tr("Remove", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Remove the selected entry", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(ListListEditor.this.entryList.getSelectedIndices().length == 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ListListEditor.this.entryList.getSelectedIndices()[0];
            ListListEditor.this.entryModel.remove(n);
        }
    }

    class NewEntryAction
    extends AbstractAction {
        NewEntryAction() {
            this.putValue("Name", I18n.tr("New", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("add entry", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ListListEditor.this.entryModel.add(new ArrayList<String>());
        }
    }

    class EntryListModel
    extends AbstractListModel<String> {
        EntryListModel() {
        }

        @Override
        public String getElementAt(int n) {
            return n + 1 + ": " + ListListEditor.this.data.get(n);
        }

        @Override
        public int getSize() {
            return ListListEditor.this.data.size();
        }

        public void add(List<String> list) {
            ListListEditor.this.data.add(list);
            this.fireIntervalAdded(this, ListListEditor.this.data.size() - 1, ListListEditor.this.data.size() - 1);
        }

        public void remove(int n) {
            ListListEditor.this.data.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }
    }
}

