/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.advanced.ListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.ListListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.MapListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.PrefEntry;
import org.openstreetmap.josm.gui.preferences.advanced.StringEditor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class PreferencesTable
extends JTable {
    private final AllSettingsTableModel model;
    private final transient List<PrefEntry> displayData;

    public PreferencesTable(List<PrefEntry> list) {
        this.displayData = list;
        this.model = new AllSettingsTableModel();
        this.setModel(this.model);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.getColumnModel().getColumn(1).setCellRenderer(new SettingCellRenderer());
        this.getColumnModel().getColumn(1).setCellEditor(new SettingCellEditor());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PreferencesTable.this.editPreference(PreferencesTable.this);
                }
            }
        });
    }

    public void fireDataChanged() {
        this.model.fireTableDataChanged();
    }

    public List<PrefEntry> getSelectedItems() {
        ArrayList<PrefEntry> arrayList = new ArrayList<PrefEntry>();
        for (int n : this.getSelectedRows()) {
            PrefEntry prefEntry = (PrefEntry)this.model.getValueAt(n, -1);
            arrayList.add(prefEntry);
        }
        return arrayList;
    }

    public boolean editPreference(JComponent jComponent) {
        if (this.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(jComponent, I18n.tr("Please select the row to edit.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return false;
        }
        PrefEntry prefEntry = (PrefEntry)this.model.getValueAt(this.getSelectedRow(), 1);
        Preferences.Setting<?> setting = prefEntry.getValue();
        if (setting instanceof Preferences.StringSetting) {
            this.editCellAt(this.getSelectedRow(), 1);
            Component component = this.getEditorComponent();
            if (component != null) {
                component.requestFocus();
            }
        } else if (setting instanceof Preferences.ListSetting) {
            List<String> list;
            Preferences.ListSetting listSetting = (Preferences.ListSetting)setting;
            ListEditor listEditor = new ListEditor(jComponent, prefEntry, listSetting);
            listEditor.showDialog();
            if (listEditor.getValue() == 1 && !listSetting.equalVal(list = listEditor.getData())) {
                prefEntry.setValue(new Preferences.ListSetting(list));
                return true;
            }
        } else if (setting instanceof Preferences.ListListSetting) {
            List<List<String>> list;
            Preferences.ListListSetting listListSetting = (Preferences.ListListSetting)setting;
            ListListEditor listListEditor = new ListListEditor(jComponent, prefEntry, listListSetting);
            listListEditor.showDialog();
            if (listListEditor.getValue() == 1 && !listListSetting.equalVal(list = listListEditor.getData())) {
                prefEntry.setValue(new Preferences.ListListSetting(list));
                return true;
            }
        } else if (setting instanceof Preferences.MapListSetting) {
            List<Map<String, String>> list;
            Preferences.MapListSetting mapListSetting = (Preferences.MapListSetting)setting;
            MapListEditor mapListEditor = new MapListEditor(jComponent, prefEntry, mapListSetting);
            mapListEditor.showDialog();
            if (mapListEditor.getValue() == 1 && !mapListSetting.equalVal(list = mapListEditor.getData())) {
                prefEntry.setValue(new Preferences.MapListSetting(list));
                return true;
            }
        }
        return false;
    }

    public PrefEntry addPreference(JComponent jComponent) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Key", new Object[0])), GBC.std().insets(0, 0, 5, 0));
        JosmTextField josmTextField = new JosmTextField("", 50);
        jPanel.add((Component)josmTextField, GBC.eop().insets(5, 0, 0, 0).fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("Select Setting Type:", new Object[0])), GBC.eol().insets(5, 15, 5, 0));
        JRadioButton jRadioButton = new JRadioButton(I18n.tr("Simple", new Object[0]));
        JRadioButton jRadioButton2 = new JRadioButton(I18n.tr("List", new Object[0]));
        JRadioButton jRadioButton3 = new JRadioButton(I18n.tr("List of lists", new Object[0]));
        JRadioButton jRadioButton4 = new JRadioButton(I18n.tr("List of maps", new Object[0]));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        jPanel.add((Component)jRadioButton, GBC.eol());
        jPanel.add((Component)jRadioButton2, GBC.eol());
        jPanel.add((Component)jRadioButton3, GBC.eol());
        jPanel.add((Component)jRadioButton4, GBC.eol());
        jRadioButton.setSelected(true);
        ExtendedDialog extendedDialog = new ExtendedDialog(jComponent, I18n.tr("Add setting", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        extendedDialog.setContent(jPanel);
        extendedDialog.showDialog();
        PrefEntry prefEntry = null;
        boolean bl = false;
        if (extendedDialog.getValue() == 1) {
            if (jRadioButton.isSelected()) {
                Preferences.StringSetting stringSetting = new Preferences.StringSetting(null);
                prefEntry = new PrefEntry(josmTextField.getText(), stringSetting, stringSetting, false);
                StringEditor stringEditor = new StringEditor(jComponent, prefEntry, stringSetting);
                stringEditor.showDialog();
                if (stringEditor.getValue() == 1) {
                    String string = stringEditor.getData();
                    if (!Objects.equals(stringSetting.getValue(), string)) {
                        prefEntry.setValue(new Preferences.StringSetting(string));
                        bl = true;
                    }
                }
            } else if (jRadioButton2.isSelected()) {
                List<String> list;
                Preferences.ListSetting listSetting = new Preferences.ListSetting(null);
                prefEntry = new PrefEntry(josmTextField.getText(), listSetting, listSetting, false);
                ListEditor listEditor = new ListEditor(jComponent, prefEntry, listSetting);
                listEditor.showDialog();
                if (listEditor.getValue() == 1 && !listSetting.equalVal(list = listEditor.getData())) {
                    prefEntry.setValue(new Preferences.ListSetting(list));
                    bl = true;
                }
            } else if (jRadioButton3.isSelected()) {
                List<List<String>> list;
                Preferences.ListListSetting listListSetting = new Preferences.ListListSetting(null);
                prefEntry = new PrefEntry(josmTextField.getText(), listListSetting, listListSetting, false);
                ListListEditor listListEditor = new ListListEditor(jComponent, prefEntry, listListSetting);
                listListEditor.showDialog();
                if (listListEditor.getValue() == 1 && !listListSetting.equalVal(list = listListEditor.getData())) {
                    prefEntry.setValue(new Preferences.ListListSetting(list));
                    bl = true;
                }
            } else if (jRadioButton4.isSelected()) {
                List<Map<String, String>> list;
                Preferences.MapListSetting mapListSetting = new Preferences.MapListSetting(null);
                prefEntry = new PrefEntry(josmTextField.getText(), mapListSetting, mapListSetting, false);
                MapListEditor mapListEditor = new MapListEditor(jComponent, prefEntry, mapListSetting);
                mapListEditor.showDialog();
                if (mapListEditor.getValue() == 1 && !mapListSetting.equalVal(list = mapListEditor.getData())) {
                    prefEntry.setValue(new Preferences.MapListSetting(list));
                    bl = true;
                }
            }
        }
        if (bl) {
            return prefEntry;
        }
        return null;
    }

    public void resetPreferences(JComponent jComponent) {
        if (this.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(jComponent, I18n.tr("Please select the row to delete.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        for (int n : this.getSelectedRows()) {
            PrefEntry prefEntry = this.displayData.get(n);
            prefEntry.reset();
        }
        this.fireDataChanged();
    }

    private static class SettingCellEditor
    extends DefaultCellEditor {
        SettingCellEditor() {
            super(new JosmTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            PrefEntry prefEntry = (PrefEntry)object;
            Preferences.StringSetting stringSetting = (Preferences.StringSetting)prefEntry.getValue();
            String string = stringSetting.getValue() == null ? "" : (String)stringSetting.getValue();
            return super.getTableCellEditorComponent(jTable, string, bl, n, n2);
        }
    }

    private static class SettingCellRenderer
    extends DefaultTableCellRenderer {
        private final Color backgroundColor = UIManager.getColor("Table.background");
        private final Color changedColor = Main.pref.getColor(I18n.marktr("Advanced Background: Changed"), new Color(200, 255, 200));
        private final Color nonDefaultColor = Main.pref.getColor(I18n.marktr("Advanced Background: NonDefault"), new Color(255, 255, 200));

        private SettingCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            PrefEntry prefEntry = (PrefEntry)object;
            Preferences.Setting<?> setting = prefEntry.getValue();
            Object obj = setting.getValue();
            String string = obj != null ? obj.toString() : "<html><i>&lt;" + I18n.tr("unset", new Object[0]) + "&gt;</i></html>";
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            GuiHelper.setBackgroundReadable(jLabel, this.backgroundColor);
            if (prefEntry.isChanged()) {
                GuiHelper.setBackgroundReadable(jLabel, this.changedColor);
            } else if (!prefEntry.isDefault()) {
                GuiHelper.setBackgroundReadable(jLabel, this.nonDefaultColor);
            }
            if (!prefEntry.isDefault()) {
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            }
            if ((obj = prefEntry.getDefaultValue().getValue()) != null) {
                if (prefEntry.isDefault()) {
                    jLabel.setToolTipText(I18n.tr("Current value is default.", new Object[0]));
                } else {
                    jLabel.setToolTipText(I18n.tr("Default value is ''{0}''.", obj));
                }
            } else {
                jLabel.setToolTipText(I18n.tr("Default value currently unknown (setting has not been used yet).", new Object[0]));
            }
            return jLabel;
        }
    }

    private class AllSettingsTableModel
    extends DefaultTableModel {
        AllSettingsTableModel() {
            this.setColumnIdentifiers(new String[]{I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])});
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 && ((PrefEntry)PreferencesTable.this.displayData.get(n)).getValue() instanceof Preferences.StringSetting;
        }

        @Override
        public int getRowCount() {
            return PreferencesTable.this.displayData.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ((PrefEntry)PreferencesTable.this.displayData.get(n)).getKey();
            }
            return PreferencesTable.this.displayData.get(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String string = (String)object;
            PrefEntry prefEntry = (PrefEntry)PreferencesTable.this.displayData.get(n);
            if (!string.equals(prefEntry.getValue().getValue())) {
                prefEntry.setValue(new Preferences.StringSetting(string));
                this.fireTableCellUpdated(n, n2);
            }
        }
    }
}

