/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class MultiFetchServerObjectReader
extends OsmServerReader {
    private static final int MAX_IDS_PER_REQUEST = 200;
    private final Set<Long> nodes = new LinkedHashSet<Long>();
    private final Set<Long> ways = new LinkedHashSet<Long>();
    private final Set<Long> relations = new LinkedHashSet<Long>();
    private Set<PrimitiveId> missingPrimitives;
    private final DataSet outputDataSet = new DataSet();

    public MultiFetchServerObjectReader() {
        this.missingPrimitives = new LinkedHashSet<PrimitiveId>();
    }

    protected void remember(PrimitiveId primitiveId) {
        if (primitiveId.isNew()) {
            return;
        }
        switch (primitiveId.getType()) {
            case NODE: {
                this.nodes.add(primitiveId.getUniqueId());
                break;
            }
            case WAY: {
                this.ways.add(primitiveId.getUniqueId());
                break;
            }
            case RELATION: {
                this.relations.add(primitiveId.getUniqueId());
            }
        }
    }

    public MultiFetchServerObjectReader append(DataSet dataSet, long l, OsmPrimitiveType osmPrimitiveType) {
        OsmPrimitive osmPrimitive = dataSet.getPrimitiveById(l, osmPrimitiveType);
        switch (osmPrimitiveType) {
            case NODE: {
                return this.appendNode((Node)osmPrimitive);
            }
            case WAY: {
                return this.appendWay((Way)osmPrimitive);
            }
            case RELATION: {
                return this.appendRelation((Relation)osmPrimitive);
            }
        }
        return this;
    }

    public MultiFetchServerObjectReader appendNode(Node node) {
        if (node == null) {
            return this;
        }
        this.remember(node.getPrimitiveId());
        return this;
    }

    public MultiFetchServerObjectReader appendWay(Way way) {
        if (way == null) {
            return this;
        }
        if (way.isNew()) {
            return this;
        }
        for (Node node : way.getNodes()) {
            if (node.isNew()) continue;
            this.remember(node.getPrimitiveId());
        }
        this.remember(way.getPrimitiveId());
        return this;
    }

    protected MultiFetchServerObjectReader appendRelation(Relation relation) {
        if (relation == null) {
            return this;
        }
        if (relation.isNew()) {
            return this;
        }
        this.remember(relation.getPrimitiveId());
        for (RelationMember relationMember : relation.getMembers()) {
            if (OsmPrimitiveType.from(relationMember.getMember()).equals((Object)OsmPrimitiveType.RELATION) && this.relations.contains(relationMember.getMember().getId()) || relationMember.getMember().isIncomplete()) continue;
            this.append(relationMember.getMember());
        }
        return this;
    }

    public MultiFetchServerObjectReader append(OsmPrimitive osmPrimitive) {
        if (osmPrimitive != null) {
            switch (OsmPrimitiveType.from(osmPrimitive)) {
                case NODE: {
                    return this.appendNode((Node)osmPrimitive);
                }
                case WAY: {
                    return this.appendWay((Way)osmPrimitive);
                }
                case RELATION: {
                    return this.appendRelation((Relation)osmPrimitive);
                }
            }
        }
        return this;
    }

    public MultiFetchServerObjectReader append(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            return this;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            this.append(osmPrimitive);
        }
        return this;
    }

    protected Set<Long> extractIdPackage(Set<Long> set) {
        HashSet<Long> hashSet = new HashSet<Long>();
        if (set.isEmpty()) {
            return hashSet;
        }
        if (set.size() > 200) {
            Iterator<Long> iterator = set.iterator();
            for (int i = 0; i < 200; ++i) {
                hashSet.add(iterator.next());
            }
            set.removeAll(hashSet);
        } else {
            hashSet.addAll(set);
            set.clear();
        }
        return hashSet;
    }

    protected static String buildRequestString(OsmPrimitiveType osmPrimitiveType, Set<Long> set) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(osmPrimitiveType.getAPIName()).append("s?").append(osmPrimitiveType.getAPIName()).append("s=");
        Iterator<Long> iterator = set.iterator();
        for (int i = 0; i < set.size(); ++i) {
            stringBuilder.append(iterator.next());
            if (i >= set.size() - 1) continue;
            stringBuilder.append(',');
        }
        return stringBuilder.toString();
    }

    protected static String buildRequestString(OsmPrimitiveType osmPrimitiveType, long l) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(osmPrimitiveType.getAPIName()).append("s?").append(osmPrimitiveType.getAPIName()).append("s=").append(l);
        return stringBuilder.toString();
    }

    protected void rememberNodesOfIncompleteWaysToLoad(DataSet dataSet) {
        for (Way way : dataSet.getWays()) {
            if (!way.hasIncompleteNodes()) continue;
            for (Node node : way.getNodes()) {
                if (!node.isIncomplete()) continue;
                this.nodes.add(node.getId());
            }
        }
    }

    protected void merge(DataSet dataSet) {
        DataSetMerger dataSetMerger = new DataSetMerger(this.outputDataSet, dataSet);
        dataSetMerger.merge();
    }

    protected void fetchPrimitives(Set<Long> set, OsmPrimitiveType osmPrimitiveType, ProgressMonitor progressMonitor) throws OsmTransferException {
        String string = "";
        String string2 = OsmApi.getOsmApi().getBaseUrl();
        switch (osmPrimitiveType) {
            case NODE: {
                string = I18n.tr("Fetching a package of nodes from ''{0}''", string2);
                break;
            }
            case WAY: {
                string = I18n.tr("Fetching a package of ways from ''{0}''", string2);
                break;
            }
            case RELATION: {
                string = I18n.tr("Fetching a package of relations from ''{0}''", string2);
            }
        }
        progressMonitor.setTicksCount(set.size());
        progressMonitor.setTicks(0);
        HashSet<Long> hashSet = new HashSet<Long>(set);
        int n = Main.pref.getInteger("osm.download.threads", 2);
        n = Math.min(Math.max(n, 1), 2);
        ExecutorService executorService = Executors.newFixedThreadPool(n, Utils.newThreadFactory(this.getClass() + "-%d", 5));
        ExecutorCompletionService<FetchResult> executorCompletionService = new ExecutorCompletionService<FetchResult>(executorService);
        ArrayList<Future<FetchResult>> arrayList = new ArrayList<Future<FetchResult>>();
        while (!hashSet.isEmpty()) {
            arrayList.add(executorCompletionService.submit(new Fetcher(osmPrimitiveType, this.extractIdPackage(hashSet), progressMonitor)));
        }
        for (int i = 0; i < arrayList.size() && !this.isCanceled(); ++i) {
            progressMonitor.subTask(string + "... " + progressMonitor.getTicks() + '/' + progressMonitor.getTicksCount());
            try {
                FetchResult exception = (FetchResult)executorCompletionService.take().get();
                if (exception.missingPrimitives != null) {
                    this.missingPrimitives.addAll(exception.missingPrimitives);
                }
                if (exception.dataSet == null || this.isCanceled()) continue;
                this.rememberNodesOfIncompleteWaysToLoad(exception.dataSet);
                this.merge(exception.dataSet);
                continue;
            }
            catch (InterruptedException | ExecutionException exception) {
                Main.error(exception);
            }
        }
        if (this.isCanceled()) {
            for (Future future : arrayList) {
                future.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        int n = this.nodes.size() + this.ways.size() + this.relations.size();
        progressMonitor.beginTask(I18n.trn("Downloading {0} object from ''{1}''", "Downloading {0} objects from ''{1}''", n, n, OsmApi.getOsmApi().getBaseUrl()));
        try {
            this.missingPrimitives = new HashSet<PrimitiveId>();
            if (this.isCanceled()) {
                DataSet dataSet = null;
                return dataSet;
            }
            this.fetchPrimitives(this.ways, OsmPrimitiveType.WAY, progressMonitor);
            if (this.isCanceled()) {
                DataSet dataSet = null;
                return dataSet;
            }
            this.fetchPrimitives(this.nodes, OsmPrimitiveType.NODE, progressMonitor);
            if (this.isCanceled()) {
                DataSet dataSet = null;
                return dataSet;
            }
            this.fetchPrimitives(this.relations, OsmPrimitiveType.RELATION, progressMonitor);
            if (this.outputDataSet != null) {
                this.outputDataSet.deleteInvisible();
            }
            DataSet dataSet = this.outputDataSet;
            return dataSet;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public Set<PrimitiveId> getMissingPrimitives() {
        return this.missingPrimitives;
    }

    protected static class Fetcher
    extends OsmServerReader
    implements Callable<FetchResult> {
        private final Set<Long> pkg;
        private final OsmPrimitiveType type;
        private final ProgressMonitor progressMonitor;

        public Fetcher(OsmPrimitiveType osmPrimitiveType, Set<Long> set, ProgressMonitor progressMonitor) {
            this.pkg = set;
            this.type = osmPrimitiveType;
            this.progressMonitor = progressMonitor;
        }

        @Override
        public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
            return this.fetch((ProgressMonitor)progressMonitor).dataSet;
        }

        @Override
        public FetchResult call() throws Exception {
            return this.fetch(this.progressMonitor);
        }

        protected FetchResult fetch(ProgressMonitor progressMonitor) throws OsmTransferException {
            try {
                return this.multiGetIdPackage(this.type, this.pkg, progressMonitor);
            }
            catch (OsmApiException osmApiException) {
                if (osmApiException.getResponseCode() == 404) {
                    Main.info(I18n.tr("Server replied with response code 404, retrying with an individual request for each object.", new Object[0]));
                    return this.singleGetIdPackage(this.type, this.pkg, progressMonitor);
                }
                throw osmApiException;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected FetchResult multiGetIdPackage(OsmPrimitiveType osmPrimitiveType, Set<Long> set, ProgressMonitor progressMonitor) throws OsmTransferException {
            String string = MultiFetchServerObjectReader.buildRequestString(osmPrimitiveType, set);
            FetchResult fetchResult = null;
            try (InputStream inputStream = this.getInputStream(string, NullProgressMonitor.INSTANCE);){
                if (inputStream == null) {
                    FetchResult fetchResult2 = null;
                    return fetchResult2;
                }
                progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
                try {
                    fetchResult = new FetchResult(OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(set.size(), false)), null);
                    return fetchResult;
                }
                catch (Exception exception) {
                    throw new OsmTransferException(exception);
                }
            }
            catch (IOException iOException) {
                Main.warn(iOException);
            }
            return fetchResult;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected DataSet singleGetId(OsmPrimitiveType osmPrimitiveType, long l, ProgressMonitor progressMonitor) throws OsmTransferException {
            String string = MultiFetchServerObjectReader.buildRequestString(osmPrimitiveType, l);
            DataSet dataSet = null;
            try (InputStream inputStream = this.getInputStream(string, NullProgressMonitor.INSTANCE);){
                if (inputStream == null) {
                    DataSet dataSet2 = null;
                    return dataSet2;
                }
                progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
                try {
                    dataSet = OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(1, false));
                    return dataSet;
                }
                catch (Exception exception) {
                    throw new OsmTransferException(exception);
                }
            }
            catch (IOException iOException) {
                Main.warn(iOException);
            }
            return dataSet;
        }

        protected FetchResult singleGetIdPackage(OsmPrimitiveType osmPrimitiveType, Set<Long> set, ProgressMonitor progressMonitor) throws OsmTransferException {
            FetchResult fetchResult = new FetchResult(new DataSet(), new HashSet<PrimitiveId>());
            String string = OsmApi.getOsmApi().getBaseUrl();
            for (long l : set) {
                try {
                    String string2 = "";
                    switch (osmPrimitiveType) {
                        case NODE: {
                            string2 = I18n.tr("Fetching node with id {0} from ''{1}''", l, string);
                            break;
                        }
                        case WAY: {
                            string2 = I18n.tr("Fetching way with id {0} from ''{1}''", l, string);
                            break;
                        }
                        case RELATION: {
                            string2 = I18n.tr("Fetching relation with id {0} from ''{1}''", l, string);
                        }
                    }
                    progressMonitor.setCustomText(string2);
                    fetchResult.dataSet.mergeFrom(this.singleGetId(osmPrimitiveType, l, progressMonitor));
                }
                catch (OsmApiException osmApiException) {
                    if (osmApiException.getResponseCode() == 404) {
                        Main.info(I18n.tr("Server replied with response code 404 for id {0}. Skipping.", Long.toString(l)));
                        fetchResult.missingPrimitives.add(new SimplePrimitiveId(l, osmPrimitiveType));
                        continue;
                    }
                    throw osmApiException;
                }
            }
            return fetchResult;
        }
    }

    protected static class FetchResult {
        public final DataSet dataSet;
        public final Set<PrimitiveId> missingPrimitives;

        public FetchResult(DataSet dataSet, Set<PrimitiveId> set) {
            this.dataSet = dataSet;
            this.missingPrimitives = set;
        }
    }
}

