/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.actions.SaveAction;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.io.session.SessionLayerExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.w3c.dom.Element;

public class OsmDataSessionExporter
implements SessionLayerExporter {
    private final OsmDataLayer layer;
    private JRadioButton link;
    private JRadioButton include;
    private JCheckBox export;

    public OsmDataSessionExporter(OsmDataLayer osmDataLayer) {
        this.layer = osmDataLayer;
    }

    @Override
    public Collection<Layer> getDependencies() {
        return Collections.emptySet();
    }

    @Override
    public JPanel getExportPanel() {
        JComponent jComponent;
        final JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.export = new JCheckBox();
        this.export.setSelected(true);
        JLabel jLabel = new JLabel(this.layer.getName(), this.layer.getIcon(), 2);
        jLabel.setToolTipText(this.layer.getToolTipText());
        jLabel.setLabelFor(this.export);
        JLabel jLabel2 = new JLabel(I18n.tr("Data:", new Object[0]));
        this.link = new JRadioButton(I18n.tr("local file", new Object[0]));
        this.link.putClientProperty("actionname", "link");
        this.link.setToolTipText(I18n.tr("Link to a OSM data file on your local disk.", new Object[0]));
        this.include = new JRadioButton(I18n.tr("include", new Object[0]));
        this.include.setToolTipText(I18n.tr("Include OSM data in the .joz session file.", new Object[0]));
        this.include.putClientProperty("actionname", "include");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.link);
        buttonGroup.add(this.include);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        final File file = this.layer.getAssociatedFile();
        final LayerSaveAction layerSaveAction = new LayerSaveAction();
        final JButton jButton = new JButton(layerSaveAction);
        if (file != null && file.exists()) {
            jComponent = new JosmTextField();
            ((JTextComponent)jComponent).setText(file.getPath());
            ((JTextComponent)jComponent).setEditable(false);
            jPanel3.add((Component)jComponent, GBC.std());
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jPanel3.add((Component)jButton, GBC.eol().insets(2, 0, 0, 0));
        } else {
            jPanel3.add((Component)new JLabel(I18n.tr("No file association", new Object[0])), GBC.eol());
        }
        jComponent = new JPanel(new GridBagLayout());
        JLabel jLabel3 = new JLabel(I18n.tr("OSM data will be included in the session file.", new Object[0]));
        jLabel3.setFont(jLabel3.getFont().deriveFont(0));
        jComponent.add((Component)jLabel3, GBC.eol().fill(2));
        final CardLayout cardLayout = new CardLayout();
        final JPanel jPanel4 = new JPanel(cardLayout);
        jPanel4.add((Component)jPanel3, "link");
        jPanel4.add((Component)jComponent, "include");
        if (file != null && file.exists()) {
            this.link.setSelected(true);
        } else {
            this.link.setEnabled(false);
            this.link.setToolTipText(I18n.tr("No file association", new Object[0]));
            this.include.setSelected(true);
            cardLayout.show(jPanel4, "include");
        }
        this.link.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cardLayout.show(jPanel4, "link");
            }
        });
        this.include.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cardLayout.show(jPanel4, "include");
            }
        });
        jPanel2.add((Component)this.export, GBC.std());
        jPanel2.add((Component)jLabel, GBC.std());
        jPanel2.add(GBC.glue(1, 0), GBC.std().fill(2));
        jPanel.add((Component)jPanel2, GBC.eol().fill(2));
        jPanel.add((Component)jLabel2, GBC.std().insets(10, 0, 0, 0));
        jPanel.add((Component)this.link, GBC.std());
        jPanel.add((Component)this.include, GBC.eol());
        jPanel.add((Component)jPanel4, GBC.eol().insets(15, 0, 3, 3));
        this.export.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    GuiHelper.setEnabledRec(jPanel, false);
                    OsmDataSessionExporter.this.export.setEnabled(true);
                } else {
                    GuiHelper.setEnabledRec(jPanel, true);
                    jButton.setEnabled(layerSaveAction.isEnabled());
                    OsmDataSessionExporter.this.link.setEnabled(file != null && file.exists());
                }
            }
        });
        return jPanel;
    }

    @Override
    public boolean shallExport() {
        return this.export.isSelected();
    }

    @Override
    public boolean requiresZip() {
        return this.include.isSelected();
    }

    @Override
    public Element export(SessionWriter.ExportSupport exportSupport) throws IOException {
        Element element = exportSupport.createElement("layer");
        element.setAttribute("type", "osm-data");
        element.setAttribute("version", "0.1");
        Element element2 = exportSupport.createElement("file");
        element.appendChild(element2);
        if (this.requiresZip()) {
            String string = "layers/" + String.format("%02d", exportSupport.getLayerIndex()) + "/data.osm";
            element2.appendChild(exportSupport.createTextNode(string));
            this.addDataFile(exportSupport.getOutputStreamZip(string));
        } else {
            URI uRI = this.layer.getAssociatedFile().toURI();
            URL uRL = null;
            try {
                uRL = uRI.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new IOException(malformedURLException);
            }
            element2.appendChild(exportSupport.createTextNode(uRL.toString()));
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDataFile(OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        OsmWriter osmWriter = OsmWriterFactory.createOsmWriter(new PrintWriter(outputStreamWriter), false, this.layer.data.getVersion());
        this.layer.data.getReadLock().lock();
        try {
            osmWriter.writeLayer(this.layer);
            osmWriter.flush();
        }
        finally {
            this.layer.data.getReadLock().unlock();
        }
    }

    private class LayerSaveAction
    extends AbstractAction {
        LayerSaveAction() {
            this.putValue("SmallIcon", new ImageProvider("save").setWidth(16).get());
            this.putValue("ShortDescription", OsmDataSessionExporter.this.layer.requiresSaveToFile() ? I18n.tr("Layer contains unsaved data - save to file.", new Object[0]) : I18n.tr("Layer does not contain unsaved data.", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SaveAction.getInstance().doSave(OsmDataSessionExporter.this.layer);
            this.updateEnabledState();
        }

        public final void updateEnabledState() {
            this.setEnabled(OsmDataSessionExporter.this.layer.requiresSaveToFile());
        }
    }
}

