/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGUniverse;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.xml.bind.DatatypeConverter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.MapImage;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.NodeElemStyle;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageResource;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ImageProvider {
    private static final String HTTP_PROTOCOL = "http://";
    private static final String HTTPS_PROTOCOL = "https://";
    private static final String WIKI_PROTOCOL = "wiki://";
    public static final String PROP_TRANSPARENCY_FORCED = "josm.transparency.forced";
    public static final String PROP_TRANSPARENCY_COLOR = "josm.transparency.color";
    protected Collection<String> dirs;
    protected String id;
    protected String subdir;
    protected String name;
    protected File archive;
    protected String inArchiveDir;
    protected int width = -1;
    protected int height = -1;
    protected int maxWidth = -1;
    protected int maxHeight = -1;
    protected boolean optional;
    protected boolean suppressWarnings;
    protected Collection<ClassLoader> additionalClassLoaders;
    protected List<ImageOverlay> overlayInfo;
    private static SVGUniverse svgUniverse;
    private static final Map<String, ImageResource> cache;
    private static final Map<Image, Map<Long, ImageResource>> ROTATE_CACHE;
    private static final ExecutorService IMAGE_FETCHER;
    private static final Pattern dataUrlPattern;
    private static final double DEGREE_90 = 1.5707963267948966;

    public ImageProvider(String string, String string2) {
        this.subdir = string;
        this.name = string2;
    }

    public ImageProvider(String string) {
        this.name = string;
    }

    public ImageProvider(ImageProvider imageProvider) {
        this.dirs = imageProvider.dirs;
        this.id = imageProvider.id;
        this.subdir = imageProvider.subdir;
        this.name = imageProvider.name;
        this.archive = imageProvider.archive;
        this.inArchiveDir = imageProvider.inArchiveDir;
        this.width = imageProvider.width;
        this.height = imageProvider.height;
        this.maxWidth = imageProvider.maxWidth;
        this.maxHeight = imageProvider.maxHeight;
        this.optional = imageProvider.optional;
        this.suppressWarnings = imageProvider.suppressWarnings;
        this.additionalClassLoaders = imageProvider.additionalClassLoaders;
        this.overlayInfo = imageProvider.overlayInfo;
    }

    public ImageProvider setDirs(Collection<String> collection) {
        this.dirs = collection;
        return this;
    }

    public ImageProvider setId(String string) {
        this.id = string;
        return this;
    }

    public ImageProvider setArchive(File file) {
        this.archive = file;
        return this;
    }

    public ImageProvider setInArchiveDir(String string) {
        this.inArchiveDir = string;
        return this;
    }

    public ImageProvider addOverlay(ImageOverlay imageOverlay) {
        if (this.overlayInfo == null) {
            this.overlayInfo = new LinkedList<ImageOverlay>();
        }
        this.overlayInfo.add(imageOverlay);
        return this;
    }

    public static Dimension getImageSizes(ImageSizes imageSizes) {
        int n;
        switch (imageSizes) {
            case MAPMAX: {
                n = Main.pref.getInteger("iconsize.mapmax", 48);
                break;
            }
            case MAP: {
                n = Main.pref.getInteger("iconsize.mapmax", 16);
                break;
            }
            case POPUPMENU: 
            case LARGEICON: {
                n = Main.pref.getInteger("iconsize.largeicon", 24);
                break;
            }
            case MENU: 
            case SMALLICON: {
                n = Main.pref.getInteger("iconsize.smallicon", 16);
                break;
            }
            case CURSOROVERLAY: 
            case CURSOR: {
                n = Main.pref.getInteger("iconsize.cursor", 32);
                break;
            }
            case LAYER: {
                n = Main.pref.getInteger("iconsize.layer", 16);
                break;
            }
            default: {
                n = Main.pref.getInteger("iconsize.default", 24);
            }
        }
        return new Dimension(n, n);
    }

    public ImageProvider setSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
        return this;
    }

    public ImageProvider setSize(ImageSizes imageSizes) {
        return this.setSize(ImageProvider.getImageSizes(imageSizes));
    }

    public ImageProvider setWidth(int n) {
        this.width = n;
        return this;
    }

    public ImageProvider setHeight(int n) {
        this.height = n;
        return this;
    }

    public ImageProvider setMaxSize(Dimension dimension) {
        this.maxWidth = dimension.width;
        this.maxHeight = dimension.height;
        return this;
    }

    public ImageProvider resetMaxSize(Dimension dimension) {
        if (this.maxWidth == -1 || dimension.width < this.maxWidth) {
            this.maxWidth = dimension.width;
        }
        if (this.maxHeight == -1 || dimension.height < this.maxHeight) {
            this.maxHeight = dimension.height;
        }
        return this;
    }

    public ImageProvider setMaxSize(ImageSizes imageSizes) {
        return this.setMaxSize(ImageProvider.getImageSizes(imageSizes));
    }

    public ImageProvider setMaxSize(int n) {
        return this.setMaxSize(new Dimension(n, n));
    }

    public ImageProvider setMaxWidth(int n) {
        this.maxWidth = n;
        return this;
    }

    public ImageProvider setMaxHeight(int n) {
        this.maxHeight = n;
        return this;
    }

    public ImageProvider setOptional(boolean bl) {
        this.optional = bl;
        return this;
    }

    public ImageProvider setSuppressWarnings(boolean bl) {
        this.suppressWarnings = bl;
        return this;
    }

    public ImageProvider setAdditionalClassLoaders(Collection<ClassLoader> collection) {
        this.additionalClassLoaders = collection;
        return this;
    }

    public ImageIcon get() {
        ImageResource imageResource = this.getResource();
        if (imageResource == null) {
            return null;
        }
        if (this.maxWidth != -1 || this.maxHeight != -1) {
            return imageResource.getImageIconBounded(new Dimension(this.maxWidth, this.maxHeight));
        }
        return imageResource.getImageIcon(new Dimension(this.width, this.height));
    }

    public ImageResource getResource() {
        ImageResource imageResource = this.getIfAvailableImpl(this.additionalClassLoaders);
        if (imageResource == null) {
            if (!this.optional) {
                String string = this.name.indexOf(46) != -1 ? "" : ".???";
                throw new RuntimeException(I18n.tr("Fatal: failed to locate image ''{0}''. This is a serious configuration problem. JOSM will stop working.", this.name + string));
            }
            if (!this.suppressWarnings) {
                Main.error(I18n.tr("Failed to locate image ''{0}''", this.name));
            }
            return null;
        }
        if (this.overlayInfo != null) {
            imageResource = new ImageResource(imageResource, this.overlayInfo);
        }
        return imageResource;
    }

    public void getInBackground(final ImageCallback imageCallback) {
        if (this.name.startsWith(HTTP_PROTOCOL) || this.name.startsWith(WIKI_PROTOCOL)) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ImageIcon imageIcon = ImageProvider.this.get();
                    imageCallback.finished(imageIcon);
                }
            };
            IMAGE_FETCHER.submit(runnable);
        } else {
            ImageIcon imageIcon = this.get();
            imageCallback.finished(imageIcon);
        }
    }

    public void getInBackground(final ImageResourceCallback imageResourceCallback) {
        if (this.name.startsWith(HTTP_PROTOCOL) || this.name.startsWith(WIKI_PROTOCOL)) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    imageResourceCallback.finished(ImageProvider.this.getResource());
                }
            };
            IMAGE_FETCHER.submit(runnable);
        } else {
            imageResourceCallback.finished(this.getResource());
        }
    }

    public static ImageIcon get(String string, String string2) {
        return new ImageProvider(string, string2).get();
    }

    public static ImageIcon get(String string) {
        return new ImageProvider(string).get();
    }

    public static ImageIcon getIfAvailable(String string, String string2) {
        return new ImageProvider(string, string2).setOptional(true).get();
    }

    public static ImageIcon getIfAvailable(String string) {
        return new ImageProvider(string).setOptional(true).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageResource getIfAvailableImpl(Collection<ClassLoader> collection) {
        Map<String, ImageResource> map = cache;
        synchronized (map) {
            ImageType imageType;
            if (this.name == null) {
                return null;
            }
            if (this.name.startsWith("data:")) {
                String string = this.name;
                ImageResource imageResource = cache.get(string);
                if (imageResource != null) {
                    return imageResource;
                }
                imageResource = ImageProvider.getIfAvailableDataUrl(string);
                if (imageResource != null) {
                    cache.put(string, imageResource);
                }
                return imageResource;
            }
            ImageType imageType2 = imageType = Utils.hasExtension(this.name, "svg") ? ImageType.SVG : ImageType.OTHER;
            if (this.name.startsWith(HTTP_PROTOCOL) || this.name.startsWith(HTTPS_PROTOCOL)) {
                String string = this.name;
                ImageResource imageResource = cache.get(string);
                if (imageResource != null) {
                    return imageResource;
                }
                imageResource = ImageProvider.getIfAvailableHttp(string, imageType);
                if (imageResource != null) {
                    cache.put(string, imageResource);
                }
                return imageResource;
            }
            if (this.name.startsWith(WIKI_PROTOCOL)) {
                ImageResource imageResource = cache.get(this.name);
                if (imageResource != null) {
                    return imageResource;
                }
                imageResource = ImageProvider.getIfAvailableWiki(this.name, imageType);
                if (imageResource != null) {
                    cache.put(this.name, imageResource);
                }
                return imageResource;
            }
            if (this.subdir == null) {
                this.subdir = "";
            } else if (!this.subdir.isEmpty() && !this.subdir.endsWith("/")) {
                this.subdir = this.subdir + '/';
            }
            String[] stringArray = this.name.indexOf(46) != -1 ? new String[]{""} : new String[]{".png", ".svg"};
            Integer[] integerArray = new Integer[]{0, 1};
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = integerArray[i];
                block8: for (String string : stringArray) {
                    ImageResource imageResource;
                    String string2;
                    if (".svg".equals(string)) {
                        imageType = ImageType.SVG;
                    } else if (".png".equals(string)) {
                        imageType = ImageType.OTHER;
                    }
                    String string3 = string2 = this.subdir + this.name + string;
                    if (this.dirs != null && !this.dirs.isEmpty()) {
                        string3 = "id:" + this.id + ':' + string2;
                        if (this.archive != null) {
                            string3 = string3 + ':' + this.archive.getName();
                        }
                    }
                    if ((imageResource = cache.get(string3)) != null) {
                        return imageResource;
                    }
                    switch (n2) {
                        case 0: {
                            if (this.archive == null || (imageResource = ImageProvider.getIfAvailableZip(string2, this.archive, this.inArchiveDir, imageType)) == null) continue block8;
                            cache.put(string3, imageResource);
                            return imageResource;
                        }
                        case 1: {
                            URL uRL = ImageProvider.getImageUrl(string2, this.dirs, collection);
                            if (uRL == null || (imageResource = ImageProvider.getIfAvailableLocalURL(uRL, imageType)) == null) continue block8;
                            cache.put(string3, imageResource);
                            return imageResource;
                        }
                    }
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ImageResource getIfAvailableHttp(String string, ImageType imageType) {
        CachedFile cachedFile = new CachedFile(string).setDestDir(new File(Main.pref.getCacheDirectory(), "images").getPath());
        try (InputStream inputStream = cachedFile.getInputStream();){
            switch (imageType) {
                case SVG: {
                    SVGDiagram sVGDiagram = null;
                    Object object = ImageProvider.getSvgUniverse();
                    synchronized (object) {
                        URI uRI = ImageProvider.getSvgUniverse().loadSVG(inputStream, Utils.fileToURL(cachedFile.getFile()).toString());
                        sVGDiagram = ImageProvider.getSvgUniverse().getDiagram(uRI);
                    }
                    object = sVGDiagram == null ? null : new ImageResource(sVGDiagram);
                    return object;
                }
                case OTHER: {
                    BufferedImage bufferedImage = null;
                    try {
                        bufferedImage = ImageProvider.read(Utils.fileToURL(cachedFile.getFile()), false, false);
                    }
                    catch (IOException iOException) {
                        Main.warn("IOException while reading HTTP image: " + iOException.getMessage());
                    }
                    ImageResource imageResource = bufferedImage == null ? null : new ImageResource(bufferedImage);
                    return imageResource;
                }
            }
            throw new AssertionError();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageResource getIfAvailableDataUrl(String string) {
        Matcher matcher = dataUrlPattern.matcher(string);
        if (matcher.matches()) {
            byte[] byArray;
            String string2 = matcher.group(2);
            String string3 = matcher.group(3);
            if (";base64".equals(string2)) {
                byArray = DatatypeConverter.parseBase64Binary((String)string3);
            } else {
                try {
                    byArray = Utils.decodeUrl(string3).getBytes(StandardCharsets.UTF_8);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Main.warn("Unable to decode URL data part: " + illegalArgumentException.getMessage() + " (" + string3 + ')');
                    return null;
                }
            }
            String string4 = matcher.group(1);
            if ("image/svg+xml".equals(string4)) {
                String string5 = new String(byArray, StandardCharsets.UTF_8);
                SVGDiagram sVGDiagram = null;
                SVGUniverse sVGUniverse = ImageProvider.getSvgUniverse();
                synchronized (sVGUniverse) {
                    URI uRI = ImageProvider.getSvgUniverse().loadSVG(new StringReader(string5), Utils.encodeUrl(string5));
                    sVGDiagram = ImageProvider.getSvgUniverse().getDiagram(uRI);
                }
                if (sVGDiagram == null) {
                    Main.warn("Unable to process svg: " + string5);
                    return null;
                }
                return new ImageResource(sVGDiagram);
            }
            try {
                BufferedImage bufferedImage = ImageProvider.read(new ByteArrayInputStream(byArray), false, true);
                return bufferedImage == null ? null : new ImageResource(bufferedImage);
            }
            catch (IOException iOException) {
                Main.warn("IOException while reading image: " + iOException.getMessage());
            }
        }
        return null;
    }

    private static ImageResource getIfAvailableWiki(String string, ImageType imageType) {
        List<String> list = Arrays.asList("https://wiki.openstreetmap.org/w/images/", "https://upload.wikimedia.org/wikipedia/commons/", "https://wiki.openstreetmap.org/wiki/File:");
        Collection<String> collection = Main.pref.getCollection("image-provider.wiki.urls", list);
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        ImageResource imageResource = null;
        for (String string3 : collection) {
            String string4;
            if (string3.endsWith(":")) {
                string4 = ImageProvider.getImgUrlFromWikiInfoPage(string3, string2);
                if (string4 == null) {
                    continue;
                }
            } else {
                String string5 = Utils.md5Hex(string2);
                string4 = string3 + string5.substring(0, 1) + '/' + string5.substring(0, 2) + "/" + string2;
            }
            if ((imageResource = ImageProvider.getIfAvailableHttp(string4, imageType)) == null) continue;
            break;
        }
        return imageResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ImageResource getIfAvailableZip(String string, File file, String string2, ImageType imageType) {
        try (ZipFile zipFile = new ZipFile(file, StandardCharsets.UTF_8);){
            int n;
            if (string2 == null || ".".equals(string2)) {
                string2 = "";
            } else if (!string2.isEmpty()) {
                string2 = string2 + '/';
            }
            String string3 = string2 + string;
            ZipEntry zipEntry = zipFile.getEntry(string3);
            if (zipEntry == null) return null;
            int n2 = 0;
            byte[] byArray = new byte[n];
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                switch (imageType) {
                    case SVG: {
                        SVGDiagram sVGDiagram = null;
                        Object object = ImageProvider.getSvgUniverse();
                        synchronized (object) {
                            URI uRI = ImageProvider.getSvgUniverse().loadSVG(inputStream, string3);
                            sVGDiagram = ImageProvider.getSvgUniverse().getDiagram(uRI);
                        }
                        object = sVGDiagram == null ? null : new ImageResource(sVGDiagram);
                        return object;
                    }
                    case OTHER: {
                        int n3;
                        for (n = (int)zipEntry.getSize(); n > 0; n2 += n3, n -= n3) {
                            n3 = inputStream.read(byArray, n2, n);
                        }
                        BufferedImage bufferedImage = null;
                        try {
                            bufferedImage = ImageProvider.read(new ByteArrayInputStream(byArray), false, false);
                        }
                        catch (IOException iOException) {
                            Main.warn(iOException);
                        }
                        ImageResource imageResource = bufferedImage == null ? null : new ImageResource(bufferedImage);
                        return imageResource;
                    }
                }
                throw new AssertionError((Object)("Unknown ImageType: " + (Object)((Object)imageType)));
            }
        }
        catch (Exception exception) {
            Main.warn(I18n.tr("Failed to handle zip file ''{0}''. Exception was: {1}", file.getName(), exception.toString()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageResource getIfAvailableLocalURL(URL uRL, ImageType imageType) {
        switch (imageType) {
            case SVG: {
                SVGDiagram sVGDiagram = null;
                SVGUniverse sVGUniverse = ImageProvider.getSvgUniverse();
                synchronized (sVGUniverse) {
                    URI uRI = ImageProvider.getSvgUniverse().loadSVG(uRL);
                    sVGDiagram = ImageProvider.getSvgUniverse().getDiagram(uRI);
                }
                return sVGDiagram == null ? null : new ImageResource(sVGDiagram);
            }
            case OTHER: {
                BufferedImage bufferedImage = null;
                try {
                    bufferedImage = ImageProvider.read(uRL, false, true);
                    if (Main.isDebugEnabled() && ImageProvider.isTransparencyForced(bufferedImage)) {
                        Main.debug("Transparency has been forced for image " + uRL.toExternalForm());
                    }
                }
                catch (IOException iOException) {
                    Main.warn(iOException);
                }
                return bufferedImage == null ? null : new ImageResource(bufferedImage);
            }
        }
        throw new AssertionError();
    }

    private static URL getImageUrl(String string, String string2, Collection<ClassLoader> collection) {
        if (string != null && string.startsWith("resource://")) {
            String string3 = string.substring("resource://".length());
            ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(PluginHandler.getResourceClassLoaders());
            if (collection != null) {
                arrayList.addAll(collection);
            }
            for (ClassLoader classLoader : arrayList) {
                URL uRL = classLoader.getResource(string3 + string2);
                if (uRL == null) continue;
                return uRL;
            }
        } else {
            File file = new File(string, string2);
            if ((string != null || file.isAbsolute()) && file.exists()) {
                return Utils.fileToURL(file);
            }
        }
        return null;
    }

    private static URL getImageUrl(String string, Collection<String> collection, Collection<ClassLoader> collection2) {
        URL uRL = null;
        if (collection != null) {
            for (String object : collection) {
                try {
                    uRL = ImageProvider.getImageUrl(object, string, collection2);
                    if (uRL == null) continue;
                    return uRL;
                }
                catch (SecurityException securityException) {
                    Main.warn(I18n.tr("Failed to access directory ''{0}'' for security reasons. Exception was: {1}", object, securityException.toString()));
                }
            }
        }
        String string2 = new File(Main.pref.getUserDataDirectory(), "images").getAbsolutePath();
        try {
            uRL = ImageProvider.getImageUrl(string2, string, collection2);
            if (uRL != null) {
                return uRL;
            }
        }
        catch (SecurityException securityException) {
            Main.warn(I18n.tr("Failed to access directory ''{0}'' for security reasons. Exception was: {1}", string2, securityException.toString()));
        }
        uRL = ImageProvider.getImageUrl(null, string, collection2);
        if (uRL != null) {
            return uRL;
        }
        uRL = ImageProvider.getImageUrl("resource://images/", string, collection2);
        if (uRL != null) {
            return uRL;
        }
        for (String string3 : Main.pref.getAllPossiblePreferenceDirs()) {
            uRL = ImageProvider.getImageUrl(string3 + "images", string, collection2);
            if (uRL != null) {
                return uRL;
            }
            uRL = ImageProvider.getImageUrl(string3, string, collection2);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    private static String getImgUrlFromWikiInfoPage(String string, final String string2) {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(new DefaultHandler(){

                @Override
                public void startElement(String string, String string22, String string3, Attributes attributes) throws SAXException {
                    String string4;
                    if ("img".equalsIgnoreCase(string22) && (string4 = attributes.getValue("src")).endsWith(string2)) {
                        throw new SAXReturnException(string4);
                    }
                }
            });
            xMLReader.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String string, String string2) {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
            });
            CachedFile cachedFile = new CachedFile(string + string2).setDestDir(new File(Main.pref.getUserDataDirectory(), "images").getPath());
            try (InputStream inputStream = cachedFile.getInputStream();){
                xMLReader.parse(new InputSource(inputStream));
            }
        }
        catch (SAXReturnException sAXReturnException) {
            return sAXReturnException.getResult();
        }
        catch (Exception exception) {
            Main.warn("Parsing " + string + string2 + " failed:\n" + exception);
            return null;
        }
        Main.warn("Parsing " + string + string2 + " failed: Unexpected content.");
        return null;
    }

    public static Cursor getCursor(String string, String string2) {
        ImageIcon imageIcon = ImageProvider.get("cursor", string);
        if (string2 != null) {
            imageIcon = new ImageProvider("cursor", string).setMaxSize(ImageSizes.CURSOR).addOverlay(new ImageOverlay(new ImageProvider("cursor/modifier/" + string2).setMaxSize(ImageSizes.CURSOROVERLAY))).get();
        }
        if (GraphicsEnvironment.isHeadless()) {
            if (Main.isDebugEnabled()) {
                Main.debug("Cursors are not available in headless mode. Returning null for '" + string + '\'');
            }
            return null;
        }
        return Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), "crosshair".equals(string) ? new Point(10, 10) : new Point(3, 2), "Cursor");
    }

    public static Image createRotatedImage(Image image, double d) {
        return ImageProvider.createRotatedImage(image, d, ImageResource.DEFAULT_DIMENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image createRotatedImage(Image image, double d, Dimension dimension) {
        CheckParameterUtil.ensureParameterNotNull(image, "img");
        Long l = Math.round(d % 360.0);
        if (d != 0.0 && l == 0L) {
            l = 360L;
        }
        ImageResource imageResource = null;
        Map<Image, Map<Long, ImageResource>> map = ROTATE_CACHE;
        synchronized (map) {
            Map<Long, ImageResource> map2 = ROTATE_CACHE.get(image);
            if (map2 == null) {
                map2 = new HashMap<Long, ImageResource>();
                ROTATE_CACHE.put(image, map2);
            }
            if ((imageResource = map2.get(l)) == null) {
                int n;
                int n2;
                double d2 = l % 90L;
                if (l != 0L && d2 == 0.0) {
                    d2 = 90.0;
                }
                double d3 = Math.toRadians(d2);
                new ImageIcon(image);
                int n3 = image.getWidth(null);
                int n4 = image.getHeight(null);
                if (l >= 0L && l <= 90L || l > 180L && l <= 270L) {
                    n2 = (int)((double)n3 * Math.sin(1.5707963267948966 - d3) + (double)n4 * Math.sin(d3));
                    n = (int)((double)n3 * Math.sin(d3) + (double)n4 * Math.sin(1.5707963267948966 - d3));
                } else {
                    n2 = (int)((double)n4 * Math.sin(1.5707963267948966 - d3) + (double)n3 * Math.sin(d3));
                    n = (int)((double)n4 * Math.sin(d3) + (double)n3 * Math.sin(1.5707963267948966 - d3));
                }
                BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
                imageResource = new ImageResource(bufferedImage);
                map2.put(l, imageResource);
                Graphics graphics = ((Image)bufferedImage).getGraphics();
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                int n5 = n3 / 2;
                int n6 = n4 / 2;
                graphics2D.translate(n2 / 2, n / 2);
                graphics2D.rotate(Math.toRadians(l.longValue()));
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics2D.drawImage(image, -n5, -n6, null);
                graphics2D.dispose();
                new ImageIcon(bufferedImage);
            }
            return imageResource.getImageIcon(dimension).getImage();
        }
    }

    public static Image createBoundedImage(Image image, int n) {
        return new ImageResource(image).getImageIconBounded(new Dimension(n, n)).getImage();
    }

    public static ImageIcon get(OsmPrimitiveType osmPrimitiveType) {
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        return ImageProvider.get("data", osmPrimitiveType.getAPIName());
    }

    public static ImageIcon getPadded(OsmPrimitive osmPrimitive, Rectangle rectangle) {
        if (osmPrimitive instanceof Node) {
            Pair<StyleCache.StyleList, Range> pair = MapPaintStyles.getStyles().generateStyles(osmPrimitive, 100.0, false);
            for (ElemStyle elemStyle : (StyleCache.StyleList)pair.a) {
                Image image;
                int n;
                int n2;
                if (!(elemStyle instanceof NodeElemStyle)) continue;
                NodeElemStyle nodeElemStyle = (NodeElemStyle)elemStyle;
                MapImage mapImage = nodeElemStyle.mapImage;
                if (mapImage == null) continue;
                int n3 = rectangle.height;
                int n4 = rectangle.height;
                int n5 = mapImage.getWidth();
                int n6 = mapImage.getHeight();
                BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
                double d = Math.min((double)n3 / (double)n5, (double)n4 / (double)n6);
                BufferedImage bufferedImage2 = mapImage.getImage(false);
                if (d < 1.0) {
                    n2 = (int)((double)n5 * d);
                    n = (int)((double)n6 * d);
                    image = bufferedImage2.getScaledInstance(n2, n, 4);
                } else {
                    n2 = n5;
                    n = n6;
                    image = bufferedImage2;
                }
                bufferedImage.getGraphics().drawImage(image, (n3 - n2) / 2, (n4 - n) / 2, null);
                return new ImageIcon(bufferedImage);
            }
        }
        return ImageProvider.get(osmPrimitive.getDisplayType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createImageFromSvg(SVGDiagram sVGDiagram, Dimension dimension) {
        float f = sVGDiagram.getWidth();
        float f2 = sVGDiagram.getHeight();
        int n = Math.round(f);
        int n2 = Math.round(f2);
        Double d = null;
        Double d2 = null;
        if (dimension.width != -1) {
            n = dimension.width;
            d = (double)n / (double)f;
            if (dimension.height == -1) {
                d2 = d;
                n2 = (int)Math.round((double)f2 * d2);
            } else {
                n2 = dimension.height;
                d2 = (double)n2 / (double)f2;
            }
        } else if (dimension.height != -1) {
            n2 = dimension.height;
            d = d2 = Double.valueOf((double)n2 / (double)f2);
            n = (int)Math.round((double)f * d);
        }
        if (n == 0 || n2 == 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(0, 0, n, n2);
        if (d != null && d2 != null) {
            graphics2D.scale(d, d2);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            SVGUniverse sVGUniverse = ImageProvider.getSvgUniverse();
            synchronized (sVGUniverse) {
                sVGDiagram.render(graphics2D);
            }
        }
        catch (Exception exception) {
            Main.error("Unable to load svg: {0}", exception.getMessage());
            return null;
        }
        return bufferedImage;
    }

    private static synchronized SVGUniverse getSvgUniverse() {
        if (svgUniverse == null) {
            svgUniverse = new SVGUniverse();
        }
        return svgUniverse;
    }

    public static BufferedImage read(File file, boolean bl, boolean bl2) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(file, "input");
        if (!file.canRead()) {
            throw new IIOException("Can't read input file!");
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
        if (imageInputStream == null) {
            throw new IIOException("Can't create an ImageInputStream!");
        }
        BufferedImage bufferedImage = ImageProvider.read(imageInputStream, bl, bl2);
        if (bufferedImage == null) {
            imageInputStream.close();
        }
        return bufferedImage;
    }

    public static BufferedImage read(InputStream inputStream, boolean bl, boolean bl2) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(inputStream, "input");
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        BufferedImage bufferedImage = ImageProvider.read(imageInputStream, bl, bl2);
        if (bufferedImage == null) {
            imageInputStream.close();
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(URL uRL, boolean bl, boolean bl2) throws IOException {
        BufferedImage bufferedImage;
        CheckParameterUtil.ensureParameterNotNull(uRL, "input");
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            throw new IIOException("Can't get input stream from URL!", iOException);
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        try {
            bufferedImage = ImageProvider.read(imageInputStream, bl, bl2);
            if (bufferedImage == null) {
                imageInputStream.close();
            }
        }
        finally {
            inputStream.close();
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(ImageInputStream imageInputStream, boolean bl, boolean bl2) throws IOException {
        BufferedImage bufferedImage;
        CheckParameterUtil.ensureParameterNotNull(imageInputStream, "stream");
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (!iterator.hasNext()) {
            return null;
        }
        ImageReader imageReader = iterator.next();
        ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
        imageReader.setInput(imageInputStream, true, !bl && !bl2);
        try {
            Color color;
            bufferedImage = imageReader.read(0, imageReadParam);
            if (bufferedImage.getTransparency() != 3 && (bl || bl2) && (color = ImageProvider.getTransparentColor(bufferedImage.getColorModel(), imageReader)) != null) {
                Hashtable<String, Color> hashtable = new Hashtable<String, Color>(1);
                hashtable.put(PROP_TRANSPARENCY_COLOR, color);
                bufferedImage = new BufferedImage(bufferedImage.getColorModel(), bufferedImage.getRaster(), bufferedImage.isAlphaPremultiplied(), hashtable);
                if (bl2) {
                    if (Main.isTraceEnabled()) {
                        Main.trace("Enforcing image transparency of " + imageInputStream + " for " + color);
                    }
                    bufferedImage = ImageProvider.makeImageTransparent(bufferedImage, color);
                }
            }
        }
        finally {
            imageReader.dispose();
            imageInputStream.close();
        }
        return bufferedImage;
    }

    public static Color getTransparentColor(ColorModel colorModel, ImageReader imageReader) throws IOException {
        block6: {
            try {
                String[] stringArray;
                IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
                if (iIOMetadata == null || (stringArray = iIOMetadata.getMetadataFormatNames()) == null) break block6;
                for (String string : stringArray) {
                    String string2;
                    org.w3c.dom.Node node;
                    NodeList nodeList;
                    if (!"javax_imageio_1.0".equals(string)) continue;
                    org.w3c.dom.Node node2 = iIOMetadata.getAsTree(string);
                    if (node2 instanceof Element && (nodeList = ((Element)node2).getElementsByTagName("TransparentColor")).getLength() > 0 && (node = nodeList.item(0)) instanceof Element && !(string2 = ((Element)node).getAttribute("value")).isEmpty()) {
                        String[] stringArray2 = string2.split(" ");
                        if (stringArray2.length == 3) {
                            return ImageProvider.parseRGB(stringArray2);
                        }
                        if (stringArray2.length == 1) {
                            int n = Integer.parseInt(stringArray2[0]);
                            int n2 = colorModel.getRed(n);
                            int n3 = colorModel.getGreen(n);
                            int n4 = colorModel.getBlue(n);
                            return new Color(n2, n3, n4);
                        }
                        Main.warn("Unable to translate TransparentColor '" + string2 + "' with color model " + colorModel);
                    }
                    break;
                }
            }
            catch (NumberFormatException | IIOException exception) {
                Main.warn(exception);
            }
        }
        return null;
    }

    private static Color parseRGB(String[] stringArray) {
        int[] nArray = new int[3];
        try {
            for (int i = 0; i < 3; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
            return new Color(nArray[0], nArray[1], nArray[2]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Main.error(illegalArgumentException);
            return null;
        }
    }

    public static BufferedImage makeImageTransparent(BufferedImage bufferedImage, Color color) {
        final int n = color.getRGB() | 0xFF000000;
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){

            @Override
            public int filterRGB(int n4, int n2, int n3) {
                if ((n3 | 0xFF000000) == n) {
                    return 0xFFFFFF & n3;
                }
                return n3;
            }
        };
        FilteredImageSource filteredImageSource = new FilteredImageSource(bufferedImage.getSource(), rGBImageFilter);
        Image image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        ColorModel colorModel = ColorModel.getRGBdefault();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(image.getWidth(null), image.getHeight(null));
        String[] stringArray = bufferedImage.getPropertyNames();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(1 + (stringArray != null ? stringArray.length : 0));
        if (stringArray != null) {
            for (String string : stringArray) {
                hashtable.put(string, bufferedImage.getProperty(string));
            }
        }
        hashtable.put(PROP_TRANSPARENCY_FORCED, Boolean.TRUE);
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster, false, hashtable);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static boolean isTransparencyForced(BufferedImage bufferedImage) {
        return bufferedImage != null && !bufferedImage.getProperty(PROP_TRANSPARENCY_FORCED).equals(Image.UndefinedProperty);
    }

    public static boolean hasTransparentColor(BufferedImage bufferedImage) {
        return bufferedImage != null && !bufferedImage.getProperty(PROP_TRANSPARENCY_COLOR).equals(Image.UndefinedProperty);
    }

    public static void shutdown(boolean bl) {
        if (bl) {
            IMAGE_FETCHER.shutdownNow();
        } else {
            IMAGE_FETCHER.shutdown();
        }
    }

    static {
        cache = new HashMap<String, ImageResource>();
        ROTATE_CACHE = new HashMap<Image, Map<Long, ImageResource>>();
        IMAGE_FETCHER = Executors.newSingleThreadExecutor(Utils.newThreadFactory("image-fetcher-%d", 5));
        dataUrlPattern = Pattern.compile("^data:([a-zA-Z]+/[a-zA-Z+]+)?(;base64)?,(.+)$");
    }

    private static class SAXReturnException
    extends SAXException {
        private final String result;

        SAXReturnException(String string) {
            this.result = string;
        }

        public String getResult() {
            return this.result;
        }
    }

    public static interface ImageResourceCallback {
        public void finished(ImageResource var1);
    }

    public static interface ImageCallback {
        public void finished(ImageIcon var1);
    }

    public static enum ImageSizes {
        SMALLICON,
        LARGEICON,
        MAP,
        MAPMAX,
        CURSOR,
        CURSOROVERLAY,
        MENU,
        POPUPMENU,
        LAYER;

    }

    public static enum ImageType {
        SVG,
        OTHER;

    }

    public static enum OverlayPosition {
        NORTHWEST,
        NORTHEAST,
        SOUTHWEST,
        SOUTHEAST;

    }
}

