/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.kitfox.svg.SVGDiagram;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageResource {
    private final Map<Dimension, Image> imgCache = new HashMap<Dimension, Image>();
    private SVGDiagram svg;
    public static final Dimension DEFAULT_DIMENSION = new Dimension(-1, -1);
    protected List<ImageOverlay> overlayInfo;
    private Image baseImage;

    public ImageResource(Image image) {
        CheckParameterUtil.ensureParameterNotNull(image);
        this.baseImage = image;
        this.imgCache.put(DEFAULT_DIMENSION, image);
    }

    public ImageResource(SVGDiagram sVGDiagram) {
        CheckParameterUtil.ensureParameterNotNull(sVGDiagram);
        this.svg = sVGDiagram;
    }

    public ImageResource(ImageResource imageResource, List<ImageOverlay> list) {
        this.svg = imageResource.svg;
        this.baseImage = imageResource.baseImage;
        this.overlayInfo = list;
    }

    public ImageIcon getImageIcon() {
        return this.getImageIcon(DEFAULT_DIMENSION);
    }

    public void getImageIcon(AbstractAction abstractAction) {
        ImageIcon imageIcon = this.getImageIconBounded(ImageProvider.getImageSizes(ImageProvider.ImageSizes.SMALLICON));
        abstractAction.putValue("SmallIcon", imageIcon);
        imageIcon = this.getImageIconBounded(ImageProvider.getImageSizes(ImageProvider.ImageSizes.LARGEICON));
        abstractAction.putValue("SwingLargeIconKey", imageIcon);
    }

    public ImageIcon getImageIcon(Dimension dimension) {
        if (dimension.width < -1 || dimension.width == 0 || dimension.height < -1 || dimension.height == 0) {
            throw new IllegalArgumentException(dimension + " is invalid");
        }
        Image image = this.imgCache.get(dimension);
        if (image != null) {
            return new ImageIcon(image);
        }
        if (this.svg != null) {
            BufferedImage bufferedImage = ImageProvider.createImageFromSvg(this.svg, dimension);
            if (bufferedImage == null) {
                return null;
            }
            if (this.overlayInfo != null) {
                for (ImageOverlay imageOverlay : this.overlayInfo) {
                    imageOverlay.process(bufferedImage);
                }
            }
            this.imgCache.put(dimension, bufferedImage);
            return new ImageIcon(bufferedImage);
        }
        if (this.baseImage == null) {
            throw new AssertionError();
        }
        int n = dimension.width;
        int n2 = dimension.height;
        ImageIcon imageIcon = new ImageIcon(this.baseImage);
        if (n == -1 && n2 == -1) {
            n = imageIcon.getIconWidth();
            n2 = imageIcon.getIconHeight();
        } else if (n == -1) {
            n = Math.max(1, imageIcon.getIconWidth() * n2 / imageIcon.getIconHeight());
        } else if (n2 == -1) {
            n2 = Math.max(1, imageIcon.getIconHeight() * n / imageIcon.getIconWidth());
        }
        Image image2 = imageIcon.getImage().getScaledInstance(n, n2, 4);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.getGraphics().drawImage(image2, 0, 0, null);
        if (this.overlayInfo != null) {
            for (ImageOverlay imageOverlay : this.overlayInfo) {
                imageOverlay.process(bufferedImage);
            }
        }
        this.imgCache.put(dimension, bufferedImage);
        return new ImageIcon(bufferedImage);
    }

    public ImageIcon getImageIconBounded(Dimension dimension) {
        float f;
        float f2;
        if (dimension.width < -1 || dimension.width == 0 || dimension.height < -1 || dimension.height == 0) {
            throw new IllegalArgumentException(dimension + " is invalid");
        }
        if (this.svg != null) {
            f2 = this.svg.getWidth();
            f = this.svg.getHeight();
        } else {
            if (this.baseImage == null) {
                throw new AssertionError();
            }
            ImageIcon imageIcon = new ImageIcon(this.baseImage);
            f2 = imageIcon.getIconWidth();
            f = imageIcon.getIconHeight();
        }
        int n = dimension.width;
        int n2 = dimension.height;
        if (f2 <= (float)n) {
            n = -1;
        }
        if (f <= (float)n2) {
            n2 = -1;
        }
        if (n == -1 && n2 == -1) {
            return this.getImageIcon(DEFAULT_DIMENSION);
        }
        if (n == -1) {
            return this.getImageIcon(new Dimension(-1, n2));
        }
        if (n2 == -1) {
            return this.getImageIcon(new Dimension(n, -1));
        }
        if (f2 / (float)n > f / (float)n2) {
            return this.getImageIcon(new Dimension(n, -1));
        }
        return this.getImageIcon(new Dimension(-1, n2));
    }
}

