/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.date;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.openstreetmap.josm.tools.date.FallbackDateParser;

public class PrimaryDateParser {
    private DatatypeFactory datatypeFactory;
    private final FallbackDateParser fallbackDateParser;
    private final Calendar calendar;

    public PrimaryDateParser() {
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new RuntimeException("Unable to instantiate xml datatype factory.", datatypeConfigurationException);
        }
        this.fallbackDateParser = new FallbackDateParser();
        this.calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    }

    private static boolean isDateInShortStandardFormat(String string) {
        int n;
        if (string.length() != 20) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (cArray[4] != '-') {
            return false;
        }
        if (cArray[7] != '-') {
            return false;
        }
        if (cArray[10] != 'T') {
            return false;
        }
        if (cArray[13] != ':') {
            return false;
        }
        if (cArray[16] != ':') {
            return false;
        }
        if (cArray[19] != 'Z') {
            return false;
        }
        for (n = 0; n < 4; ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9') continue;
            return false;
        }
        for (n = 5; n < 7; ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9') continue;
            return false;
        }
        for (n = 8; n < 10; ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9') continue;
            return false;
        }
        for (n = 11; n < 13; ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9') continue;
            return false;
        }
        for (n = 14; n < 16; ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9') continue;
            return false;
        }
        for (n = 17; n < 19; ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean isDateInLongStandardFormat(String string) {
        int n;
        if (string.length() != 24) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (cArray[4] != '-') {
            return false;
        }
        if (cArray[7] != '-') {
            return false;
        }
        if (cArray[10] != 'T') {
            return false;
        }
        if (cArray[13] != ':') {
            return false;
        }
        if (cArray[16] != ':') {
            return false;
        }
        if (cArray[19] != '.') {
            return false;
        }
        if (cArray[23] != 'Z') {
            return false;
        }
        for (n = 0; n < 4; ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9') continue;
            return false;
        }
        for (n = 5; n < 7; ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9') continue;
            return false;
        }
        for (n = 8; n < 10; ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9') continue;
            return false;
        }
        for (n = 11; n < 13; ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9') continue;
            return false;
        }
        for (n = 14; n < 16; ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9') continue;
            return false;
        }
        for (n = 17; n < 19; ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9') continue;
            return false;
        }
        for (n = 20; n < 23; ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9') continue;
            return false;
        }
        return true;
    }

    private Date parseShortStandardDate(String string) {
        int n = Integer.parseInt(string.substring(0, 4));
        int n2 = Integer.parseInt(string.substring(5, 7));
        int n3 = Integer.parseInt(string.substring(8, 10));
        int n4 = Integer.parseInt(string.substring(11, 13));
        int n5 = Integer.parseInt(string.substring(14, 16));
        int n6 = Integer.parseInt(string.substring(17, 19));
        this.calendar.clear();
        this.calendar.set(1, n);
        this.calendar.set(2, n2 - 1);
        this.calendar.set(5, n3);
        this.calendar.set(11, n4);
        this.calendar.set(12, n5);
        this.calendar.set(13, n6);
        return this.calendar.getTime();
    }

    private Date parseLongStandardDate(String string) {
        int n = Integer.parseInt(string.substring(0, 4));
        int n2 = Integer.parseInt(string.substring(5, 7));
        int n3 = Integer.parseInt(string.substring(8, 10));
        int n4 = Integer.parseInt(string.substring(11, 13));
        int n5 = Integer.parseInt(string.substring(14, 16));
        int n6 = Integer.parseInt(string.substring(17, 19));
        int n7 = Integer.parseInt(string.substring(20, 23));
        this.calendar.clear();
        this.calendar.set(1, n);
        this.calendar.set(2, n2 - 1);
        this.calendar.set(5, n3);
        this.calendar.set(11, n4);
        this.calendar.set(12, n5);
        this.calendar.set(13, n6);
        this.calendar.set(14, n7);
        return this.calendar.getTime();
    }

    public Date parse(String string) throws ParseException {
        try {
            if (PrimaryDateParser.isDateInShortStandardFormat(string)) {
                return this.parseShortStandardDate(string);
            }
            if (PrimaryDateParser.isDateInLongStandardFormat(string)) {
                return this.parseLongStandardDate(string);
            }
            return this.datatypeFactory.newXMLGregorianCalendar(string).toGregorianCalendar().getTime();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.fallbackDateParser.parse(string);
        }
    }
}

