/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCloneable;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import com.oracle.truffle.api.nodes.NodeInterface;
import com.oracle.truffle.api.nodes.NodeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;

public final class NodeClass {
    private static final ClassValue<NodeClass> nodeClasses = new ClassValue<NodeClass>(){

        @Override
        protected NodeClass computeValue(final Class<?> clazz) {
            if (!$assertionsDisabled && !Node.class.isAssignableFrom(clazz)) {
                throw new AssertionError();
            }
            return AccessController.doPrivileged(new PrivilegedAction<NodeClass>(){

                @Override
                public NodeClass run() {
                    return new NodeClass(clazz);
                }
            });
        }
    };
    private final NodeFieldAccessor[] fields;
    private final NodeFieldAccessor parentField;
    private final NodeFieldAccessor nodeClassField;
    private final NodeFieldAccessor[] childFields;
    private final NodeFieldAccessor[] childrenFields;
    private final NodeFieldAccessor[] cloneableFields;
    private final Class<? extends Node> clazz;

    public static NodeClass get(Class<? extends Node> clazz) {
        return nodeClasses.get(clazz);
    }

    public static NodeClass get(Node clazz) {
        return clazz.getNodeClass();
    }

    public NodeClass(Class<? extends Node> clazz) {
        ArrayList<NodeFieldAccessor> fieldsList = new ArrayList<NodeFieldAccessor>();
        NodeFieldAccessor parentFieldTmp = null;
        NodeFieldAccessor nodeClassFieldTmp = null;
        ArrayList<NodeFieldAccessor> childFieldList = new ArrayList<NodeFieldAccessor>();
        ArrayList<NodeFieldAccessor> childrenFieldList = new ArrayList<NodeFieldAccessor>();
        ArrayList<NodeFieldAccessor> cloneableFieldList = new ArrayList<NodeFieldAccessor>();
        Field[] fieldArray = NodeUtil.getAllFields(clazz);
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!Modifier.isStatic(field.getModifiers()) && !field.isSynthetic()) {
                NodeFieldAccessor nodeField;
                if (field.getDeclaringClass() == Node.class && field.getName().equals("parent")) {
                    assert (Node.class.isAssignableFrom(field.getType()));
                    parentFieldTmp = nodeField = NodeFieldAccessor.create(NodeFieldAccessor.NodeFieldKind.PARENT, field);
                } else if (field.getDeclaringClass() == Node.class && field.getName().equals("nodeClass")) {
                    assert (NodeClass.class.isAssignableFrom(field.getType()));
                    nodeClassFieldTmp = nodeField = NodeFieldAccessor.create(NodeFieldAccessor.NodeFieldKind.NODE_CLASS, field);
                } else if (field.getAnnotation(Node.Child.class) != null) {
                    NodeClass.checkChildField(field);
                    nodeField = NodeFieldAccessor.create(NodeFieldAccessor.NodeFieldKind.CHILD, field);
                    childFieldList.add(nodeField);
                } else if (field.getAnnotation(Node.Children.class) != null) {
                    NodeClass.checkChildrenField(field);
                    nodeField = NodeFieldAccessor.create(NodeFieldAccessor.NodeFieldKind.CHILDREN, field);
                    childrenFieldList.add(nodeField);
                } else {
                    nodeField = NodeFieldAccessor.create(NodeFieldAccessor.NodeFieldKind.DATA, field);
                    if (NodeCloneable.class.isAssignableFrom(field.getType())) {
                        cloneableFieldList.add(nodeField);
                    }
                }
                fieldsList.add(nodeField);
            }
            ++n2;
        }
        if (parentFieldTmp == null) {
            throw new AssertionError((Object)"parent field not found");
        }
        this.fields = fieldsList.toArray(new NodeFieldAccessor[fieldsList.size()]);
        this.nodeClassField = nodeClassFieldTmp;
        this.parentField = parentFieldTmp;
        this.childFields = childFieldList.toArray(new NodeFieldAccessor[childFieldList.size()]);
        this.childrenFields = childrenFieldList.toArray(new NodeFieldAccessor[childrenFieldList.size()]);
        this.cloneableFields = cloneableFieldList.toArray(new NodeFieldAccessor[cloneableFieldList.size()]);
        this.clazz = clazz;
    }

    public NodeFieldAccessor getNodeClassField() {
        return this.nodeClassField;
    }

    public NodeFieldAccessor[] getCloneableFields() {
        return this.cloneableFields;
    }

    private static boolean isNodeType(Class<?> clazz) {
        return Node.class.isAssignableFrom(clazz) || clazz.isInterface() && NodeInterface.class.isAssignableFrom(clazz);
    }

    private static void checkChildField(Field field) {
        if (!NodeClass.isNodeType(field.getType())) {
            throw new AssertionError((Object)("@Child field type must be a subclass of Node or an interface extending NodeInterface (" + field + ")"));
        }
        if (Modifier.isFinal(field.getModifiers())) {
            throw new AssertionError((Object)("@Child field must not be final (" + field + ")"));
        }
    }

    private static void checkChildrenField(Field field) {
        if (!field.getType().isArray() || !NodeClass.isNodeType(field.getType().getComponentType())) {
            throw new AssertionError((Object)("@Children field type must be an array of a subclass of Node or an interface extending NodeInterface (" + field + ")"));
        }
        if (!Modifier.isFinal(field.getModifiers())) {
            throw new AssertionError((Object)("@Children field must be final (" + field + ")"));
        }
    }

    public NodeFieldAccessor[] getFields() {
        return this.fields;
    }

    public NodeFieldAccessor getParentField() {
        return this.parentField;
    }

    public NodeFieldAccessor[] getChildFields() {
        return this.childFields;
    }

    public NodeFieldAccessor[] getChildrenFields() {
        return this.childrenFields;
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof NodeClass) {
            NodeClass other = (NodeClass)obj;
            return this.clazz.equals(other.clazz);
        }
        return false;
    }

    public Iterator<Node> makeIterator(Node node) {
        assert (this.clazz.isInstance(node));
        return new NodeIterator(this, node);
    }

    private static final class NodeIterator
    implements Iterator<Node> {
        private final NodeFieldAccessor[] childFields;
        private final NodeFieldAccessor[] childrenFields;
        private final Node node;
        private final int childrenCount;
        private int index;

        protected NodeIterator(NodeClass nodeClass, Node node) {
            this.childFields = nodeClass.getChildFields();
            this.childrenFields = nodeClass.getChildrenFields();
            this.node = node;
            this.childrenCount = this.childrenCount();
            this.index = 0;
        }

        private int childrenCount() {
            int nodeCount = this.childFields.length;
            NodeFieldAccessor[] nodeFieldAccessorArray = this.childrenFields;
            int n = this.childrenFields.length;
            int n2 = 0;
            while (n2 < n) {
                NodeFieldAccessor childrenField = nodeFieldAccessorArray[n2];
                Object[] children = (Object[])childrenField.getObject(this.node);
                if (children != null) {
                    nodeCount += children.length;
                }
                ++n2;
            }
            return nodeCount;
        }

        private Node nodeAt(int idx) {
            int nodeCount = this.childFields.length;
            if (idx < nodeCount) {
                return (Node)this.childFields[idx].getObject(this.node);
            }
            NodeFieldAccessor[] nodeFieldAccessorArray = this.childrenFields;
            int n = this.childrenFields.length;
            int n2 = 0;
            while (n2 < n) {
                NodeFieldAccessor childrenField = nodeFieldAccessorArray[n2];
                Object[] nodeArray = (Object[])childrenField.getObject(this.node);
                if (idx < nodeCount + nodeArray.length) {
                    return (Node)nodeArray[idx - nodeCount];
                }
                nodeCount += nodeArray.length;
                ++n2;
            }
            return null;
        }

        private void forward() {
            if (this.index < this.childrenCount) {
                ++this.index;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < this.childrenCount;
        }

        @Override
        public Node next() {
            try {
                Node node = this.nodeAt(this.index);
                return node;
            }
            finally {
                this.forward();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

