/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.LayoutBuilder;
import com.oracle.truffle.api.object.LayoutFactory;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import java.util.ServiceLoader;

public abstract class Layout {
    public static final EnumSet<ImplicitCast> NONE = EnumSet.noneOf(ImplicitCast.class);
    public static final EnumSet<ImplicitCast> INT_TO_DOUBLE = EnumSet.of(ImplicitCast.IntToDouble);
    public static final EnumSet<ImplicitCast> INT_TO_LONG = EnumSet.of(ImplicitCast.IntToLong);
    public static final String OPTION_PREFIX = "truffle.object.";
    private static final LayoutFactory LAYOUT_FACTORY = Layout.loadLayoutFactory();

    public static Layout createLayout() {
        return Layout.createLayout(NONE);
    }

    public static Layout createLayout(EnumSet<ImplicitCast> allowedImplicitCasts) {
        return new LayoutBuilder().setAllowedImplicitCasts(allowedImplicitCasts).build();
    }

    public static Layout createLayout(EnumSet<ImplicitCast> allowedImplicitCasts, NodeUtil.FieldOffsetProvider fieldOffsetProvider) {
        return new LayoutBuilder().setAllowedImplicitCasts(allowedImplicitCasts).setFieldOffsetProvider(fieldOffsetProvider).build();
    }

    public abstract DynamicObject newInstance(Shape var1);

    public abstract Class<? extends DynamicObject> getType();

    public abstract Shape createShape(ObjectType var1);

    public abstract Shape createShape(ObjectType var1, Object var2);

    public abstract Shape createShape(ObjectType var1, Object var2, int var3);

    public abstract Shape.Allocator createAllocator();

    protected static LayoutFactory getFactory() {
        return LAYOUT_FACTORY;
    }

    private static LayoutFactory loadLayoutFactory() {
        LayoutFactory bestLayoutFactory = null;
        String layoutFactoryImplClassName = System.getProperty("truffle.object.LayoutFactory");
        if (layoutFactoryImplClassName != null) {
            Class<?> clazz;
            try {
                clazz = Class.forName(layoutFactoryImplClassName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            try {
                bestLayoutFactory = (LayoutFactory)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new AssertionError((Object)e);
            }
        }
        ServiceLoader<LayoutFactory> serviceLoader = ServiceLoader.load(LayoutFactory.class, Layout.class.getClassLoader());
        for (LayoutFactory currentLayoutFactory : serviceLoader) {
            if (bestLayoutFactory == null) {
                bestLayoutFactory = currentLayoutFactory;
                continue;
            }
            if (currentLayoutFactory.getPriority() < bestLayoutFactory.getPriority()) continue;
            assert (currentLayoutFactory.getPriority() != bestLayoutFactory.getPriority());
            bestLayoutFactory = currentLayoutFactory;
        }
        if (bestLayoutFactory == null) {
            throw new AssertionError((Object)"LayoutFactory not found");
        }
        return bestLayoutFactory;
    }

    public static enum ImplicitCast {
        IntToDouble,
        IntToLong;

    }
}

