/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.literal.LiteralNode;
import org.jruby.truffle.nodes.literal.NilNode;
import org.jruby.truffle.runtime.RubyContext;

@NodeInfo(cost=NodeCost.NONE)
public final class SequenceNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] body;

    public static RubyNode sequenceNoFlatten(RubyContext context, SourceSection sourceSection, RubyNode ... sequence) {
        return new SequenceNode(context, sourceSection, sequence);
    }

    public static RubyNode sequenceNoFlatten(RubyContext context, SourceSection sourceSection, List<RubyNode> sequence) {
        return SequenceNode.sequenceNoFlatten(context, sourceSection, sequence.toArray(new RubyNode[sequence.size()]));
    }

    public static RubyNode sequence(RubyContext context, SourceSection sourceSection, RubyNode ... sequence) {
        return SequenceNode.sequence(context, sourceSection, Arrays.asList(sequence));
    }

    public static RubyNode sequence(RubyContext context, SourceSection sourceSection, List<RubyNode> sequence) {
        List<RubyNode> flattened = SequenceNode.flatten(context, sequence, true);
        if (flattened.isEmpty()) {
            return new NilNode(context, sourceSection);
        }
        if (flattened.size() == 1) {
            return flattened.get(0);
        }
        return new SequenceNode(context, sourceSection, flattened.toArray(new RubyNode[flattened.size()]));
    }

    private static List<RubyNode> flatten(RubyContext context, List<RubyNode> sequence, boolean allowTrailingNil) {
        ArrayList<RubyNode> flattened = new ArrayList<RubyNode>();
        for (int n = 0; n < sequence.size(); ++n) {
            boolean lastNode = n == sequence.size() - 1;
            RubyNode node = sequence.get(n);
            if (node instanceof LiteralNode && ((LiteralNode)node).getObject() == context.getCoreLibrary().getNilObject()) {
                if (!allowTrailingNil || !lastNode) continue;
                flattened.add(node);
                continue;
            }
            if (node instanceof SequenceNode) {
                flattened.addAll(SequenceNode.flatten(context, Arrays.asList(((SequenceNode)node).body), lastNode));
                continue;
            }
            flattened.add(node);
        }
        return flattened;
    }

    protected SequenceNode(RubyContext context, SourceSection sourceSection, RubyNode ... body) {
        super(context, sourceSection);
        this.body = body;
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        for (int n = 0; n < this.body.length - 1; ++n) {
            this.body[n].executeVoid(frame);
        }
        return this.body[this.body.length - 1].execute(frame);
    }

    @Override
    @ExplodeLoop
    public void executeVoid(VirtualFrame frame) {
        for (int n = 0; n < this.body.length; ++n) {
            this.body[n].executeVoid(frame);
        }
    }

    public RubyNode[] getSequence() {
        return this.body;
    }
}

