/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objectstorage;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.BooleanLocation;
import com.oracle.truffle.api.object.DoubleLocation;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.IntLocation;
import com.oracle.truffle.api.object.LongLocation;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.runtime.Options;

public abstract class ReadHeadObjectFieldNode
extends Node {
    private final Object defaultValue;
    protected final Object name;

    public ReadHeadObjectFieldNode(Object name, Object defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public Object getName() {
        return this.name;
    }

    public abstract boolean executeBoolean(DynamicObject var1) throws UnexpectedResultException;

    public abstract int executeInteger(DynamicObject var1) throws UnexpectedResultException;

    public abstract long executeLong(DynamicObject var1) throws UnexpectedResultException;

    public abstract double executeDouble(DynamicObject var1) throws UnexpectedResultException;

    public abstract Object execute(DynamicObject var1);

    @Specialization(guards={"location != null", "receiver.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="getCacheLimit()")
    protected boolean readBooleanObjectFieldCached(DynamicObject receiver, @Cached(value="receiver.getShape()") Shape cachedShape, @Cached(value="getBooleanLocation(cachedShape)") BooleanLocation location) {
        return location.getBoolean(receiver, cachedShape);
    }

    @Specialization(guards={"location != null", "receiver.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="getCacheLimit()")
    protected int readIntObjectFieldCached(DynamicObject receiver, @Cached(value="receiver.getShape()") Shape cachedShape, @Cached(value="getIntLocation(cachedShape)") IntLocation location) {
        return location.getInt(receiver, cachedShape);
    }

    @Specialization(guards={"location != null", "receiver.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="getCacheLimit()")
    protected long readLongObjectFieldCached(DynamicObject receiver, @Cached(value="receiver.getShape()") Shape cachedShape, @Cached(value="getLongLocation(cachedShape)") LongLocation location) {
        return location.getLong(receiver, cachedShape);
    }

    @Specialization(guards={"location != null", "receiver.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="getCacheLimit()")
    protected double readDoubleObjectFieldCached(DynamicObject receiver, @Cached(value="receiver.getShape()") Shape cachedShape, @Cached(value="getDoubleLocation(cachedShape)") DoubleLocation location) {
        return location.getDouble(receiver, cachedShape);
    }

    @Specialization(guards={"receiver.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="getCacheLimit()", contains={"readBooleanObjectFieldCached", "readIntObjectFieldCached", "readLongObjectFieldCached", "readDoubleObjectFieldCached"})
    protected Object readObjectFieldCached(DynamicObject receiver, @Cached(value="receiver.getShape()") Shape cachedShape, @Cached(value="cachedShape.getProperty(name)") Property property) {
        if (property != null) {
            return property.get(receiver, cachedShape);
        }
        return this.defaultValue;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    protected Object readObjectFieldUncached(DynamicObject receiver) {
        Shape shape = receiver.getShape();
        Property property = shape.getProperty(this.name);
        if (property != null) {
            return property.get(receiver, shape);
        }
        return this.defaultValue;
    }

    protected BooleanLocation getBooleanLocation(Shape shape) {
        Property property = shape.getProperty(this.name);
        if (property != null && property.getLocation() instanceof BooleanLocation) {
            return (BooleanLocation)((Object)property.getLocation());
        }
        return null;
    }

    protected IntLocation getIntLocation(Shape shape) {
        Property property = shape.getProperty(this.name);
        if (property != null && property.getLocation() instanceof IntLocation) {
            return (IntLocation)((Object)property.getLocation());
        }
        return null;
    }

    protected LongLocation getLongLocation(Shape shape) {
        Property property = shape.getProperty(this.name);
        if (property != null && property.getLocation() instanceof LongLocation) {
            return (LongLocation)((Object)property.getLocation());
        }
        return null;
    }

    protected DoubleLocation getDoubleLocation(Shape shape) {
        Property property = shape.getProperty(this.name);
        if (property != null && property.getLocation() instanceof DoubleLocation) {
            return (DoubleLocation)((Object)property.getLocation());
        }
        return null;
    }

    protected int getCacheLimit() {
        return Options.FIELD_LOOKUP_CACHE;
    }
}

