/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import java.util.concurrent.LinkedBlockingQueue;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.QueueLayout;

public class QueueLayoutImpl
extends BasicObjectLayoutImpl
implements QueueLayout {
    public static final QueueLayout INSTANCE = new QueueLayoutImpl();
    protected static final Shape.Allocator QUEUE_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey QUEUE_IDENTIFIER = new HiddenKey("queue");
    protected static final Property QUEUE_PROPERTY = Property.create(QUEUE_IDENTIFIER, QUEUE_ALLOCATOR.locationForType(LinkedBlockingQueue.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);

    protected QueueLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createQueueShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new QueueType(logicalClass, metaClass)).addProperty(QUEUE_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createQueue(DynamicObjectFactory factory, LinkedBlockingQueue<Object> queue) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsQueue(factory));
        assert (factory.getShape().hasProperty(QUEUE_IDENTIFIER));
        assert (queue != null);
        return factory.newInstance(queue);
    }

    @Override
    public boolean isQueue(DynamicObject object) {
        return this.isQueue(object.getShape().getObjectType());
    }

    private boolean isQueue(ObjectType objectType) {
        return objectType instanceof QueueType;
    }

    private boolean createsQueue(DynamicObjectFactory factory) {
        return this.isQueue(factory.getShape().getObjectType());
    }

    @Override
    public LinkedBlockingQueue<Object> getQueue(DynamicObject object) {
        assert (this.isQueue(object));
        assert (object.getShape().hasProperty(QUEUE_IDENTIFIER));
        return (LinkedBlockingQueue)QUEUE_PROPERTY.get(object, true);
    }

    protected static class QueueType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public QueueType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public QueueType setLogicalClass(DynamicObject logicalClass) {
            return new QueueType(logicalClass, this.metaClass);
        }

        @Override
        public QueueType setMetaClass(DynamicObject metaClass) {
            return new QueueType(this.logicalClass, metaClass);
        }
    }
}

