/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.loader;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import java.io.File;
import java.io.IOException;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyFile;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayReflector;
import org.jruby.truffle.runtime.array.ObjectArrayMirror;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.ArrayOperations;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

public class FeatureLoader {
    private final RubyContext context;
    private Source mainScriptSource = null;
    private String mainScriptFullPath = null;

    public FeatureLoader(RubyContext context) {
        this.context = context;
    }

    public boolean require(String feature, Node currentNode) throws IOException {
        String cwd;
        RubyConstant dataConstantBefore = ModuleOperations.lookupConstant(this.context, this.context.getCoreLibrary().getObjectClass(), "DATA");
        if (feature.startsWith("./")) {
            cwd = this.context.getRuntime().getCurrentDirectory();
            feature = cwd + "/" + feature.substring(2);
        } else if (feature.startsWith("../")) {
            cwd = this.context.getRuntime().getCurrentDirectory();
            feature = cwd.substring(0, cwd.lastIndexOf(47)) + "/" + feature.substring(3);
        }
        try {
            if (this.isAbsolutePath(feature)) {
                RequireResult result = this.tryToRequireFileInPath(null, feature, currentNode);
                if (result.success) {
                    boolean bl = result.firstRequire;
                    return bl;
                }
            } else {
                for (Object pathObject : ArrayOperations.toIterable(this.context.getCoreLibrary().getLoadPath())) {
                    String loadPath = pathObject.toString();
                    if (!this.isAbsolutePath(loadPath)) {
                        loadPath = FeatureLoader.expandPath(this.context, loadPath);
                    }
                    RequireResult result = this.tryToRequireFileInPath(loadPath, feature, currentNode);
                    if (!result.success) continue;
                    boolean bl = result.firstRequire;
                    return bl;
                }
            }
            throw new RaiseException(this.context.getCoreLibrary().loadErrorCannotLoad(feature, currentNode));
        }
        finally {
            if (dataConstantBefore == null) {
                Layouts.MODULE.getFields(this.context.getCoreLibrary().getObjectClass()).removeConstant(this.context, currentNode, "DATA");
            } else {
                Layouts.MODULE.getFields(this.context.getCoreLibrary().getObjectClass()).setConstant(this.context, currentNode, "DATA", dataConstantBefore.getValue());
            }
        }
    }

    private RequireResult tryToRequireFileInPath(String path, String feature, Node currentNode) throws IOException {
        String fullPath = new File(path, feature).getPath();
        RequireResult firstAttempt = this.tryToRequireFile(fullPath + ".rb", currentNode);
        if (firstAttempt.success) {
            return firstAttempt;
        }
        return this.tryToRequireFile(fullPath, currentNode);
    }

    private RequireResult tryToRequireFile(String path, Node currentNode) throws IOException {
        String expandedPath;
        path = path.replace('\\', '/');
        DynamicObject loadedFeatures = this.context.getCoreLibrary().getLoadedFeatures();
        if (!path.startsWith("truffle:") && !path.startsWith("jruby:")) {
            File file = new File(path);
            assert (file.isAbsolute());
            if (!file.isFile()) {
                return RequireResult.FAILED;
            }
            expandedPath = new File(FeatureLoader.expandPath(this.context, path)).getCanonicalPath();
        } else {
            expandedPath = path;
        }
        for (Object loaded : ArrayOperations.toIterable(loadedFeatures)) {
            if (!loaded.toString().equals(expandedPath)) continue;
            return RequireResult.ALREADY_REQUIRED;
        }
        DynamicObject pathString = StringOperations.createString(this.context, StringOperations.encodeByteList(expandedPath, (Encoding)UTF8Encoding.INSTANCE));
        ArrayOperations.append(loadedFeatures, pathString);
        try {
            this.context.loadFile(expandedPath, currentNode);
        }
        catch (RaiseException e) {
            ObjectArrayMirror mirror = ArrayReflector.reflect((Object[])Layouts.ARRAY.getStore(loadedFeatures));
            int length = Layouts.ARRAY.getSize(loadedFeatures);
            for (int i = length - 1; i >= 0; --i) {
                if (mirror.get(i) != pathString) continue;
                for (int j = length - 1; j > i; --j) {
                    mirror.set(i - 1, mirror.get(i));
                }
                Layouts.ARRAY.setSize(loadedFeatures, length - 1);
                break;
            }
            throw e;
        }
        catch (IOException e) {
            return RequireResult.FAILED;
        }
        return RequireResult.REQUIRED;
    }

    public void setMainScriptSource(Source source) {
        this.mainScriptSource = source;
        if (!source.getPath().equals("-e")) {
            this.mainScriptFullPath = FeatureLoader.expandPath(this.context, source.getPath());
        }
    }

    public String getSourcePath(Source source) {
        if (source == this.mainScriptSource) {
            return this.mainScriptFullPath;
        }
        return source.getPath();
    }

    public boolean isAbsolutePath(String path) {
        return path.startsWith("truffle:") || path.startsWith("jruby:") || new File(path).isAbsolute();
    }

    public static String expandPath(RubyContext context, String fileName) {
        if (context.isRunningOnWindows()) {
            RubyString path = context.toJRubyString(StringOperations.createString(context, StringOperations.encodeByteList(fileName, (Encoding)UTF8Encoding.INSTANCE)));
            RubyString expanded = (RubyString)RubyFile.expand_path19((ThreadContext)context.getRuntime().getCurrentContext(), null, (IRubyObject[])new IRubyObject[]{path});
            return expanded.asJavaString();
        }
        return FeatureLoader.expandPath(fileName, null);
    }

    public static String expandPath(String fileName, String dir) {
        return RubyFile.canonicalize((String)new File(dir, fileName).getAbsolutePath());
    }

    private static enum RequireResult {
        REQUIRED(true, true),
        ALREADY_REQUIRED(true, false),
        FAILED(false, false);

        public final boolean success;
        public final boolean firstRequire;

        private RequireResult(boolean success, boolean firstRequire) {
            this.success = success;
            this.firstRequire = firstRequire;
        }
    }
}

