/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.translator.TranslatorDriver;

public class SimpleShell {
    private int currentFrameIndex;
    private MaterializedFrame currentFrame;
    private final RubyContext context;

    public SimpleShell(RubyContext context) {
        this.context = context;
    }

    public void run(MaterializedFrame frame, Node currentNode) {
        this.currentFrameIndex = 0;
        this.currentFrame = frame;
        block16: while (true) {
            String shellLine;
            StringTokenizer tokenizer;
            if (!(tokenizer = new StringTokenizer(shellLine = System.console().readLine("> ", new Object[0]))).hasMoreElements()) {
                continue;
            }
            switch (tokenizer.nextToken()) {
                case "backtrace": {
                    this.backtrace(currentNode);
                    continue block16;
                }
                case "continue": {
                    return;
                }
                case "exit": {
                    System.exit(0);
                    continue block16;
                }
                case "frame": {
                    this.currentFrameIndex = Integer.parseInt(tokenizer.nextToken());
                    this.currentFrame = RubyCallStack.getBacktrace(currentNode).getActivations().get(this.currentFrameIndex).getMaterializedFrame();
                    continue block16;
                }
            }
            try {
                String inspected;
                Object result = this.context.parseAndExecute(Source.fromText(shellLine, "shell"), (Encoding)UTF8Encoding.INSTANCE, TranslatorDriver.ParserContext.EVAL, RubyArguments.getSelf(this.currentFrame.getArguments()), this.currentFrame, false, RubyArguments.getDeclarationContext(this.currentFrame.getArguments()), currentNode);
                try {
                    inspected = this.context.send(result, "inspect", null, new Object[0]).toString();
                }
                catch (Exception e) {
                    inspected = String.format("(error inspecting %s@%x %s)", result.getClass().getSimpleName(), result.hashCode(), e.toString());
                }
                System.console().writer().println(inspected);
                continue;
            }
            catch (RaiseException e) {
                DynamicObject rubyException = e.getRubyException();
                BacktraceFormatter.createDefaultFormatter(this.context).printBacktrace(rubyException, Layouts.EXCEPTION.getBacktrace(rubyException), System.console().writer());
                continue;
            }
            break;
        }
    }

    private void backtrace(Node currentNode) {
        int n = 0;
        for (Activation activation : RubyCallStack.getBacktrace(currentNode).getActivations()) {
            if (n == this.currentFrameIndex) {
                System.console().writer().print("  \u25b6");
            } else {
                System.console().writer().printf("%3d", n);
            }
            System.console().writer().println(BacktraceFormatter.createDefaultFormatter(this.context).formatLine(Arrays.asList(activation), 0));
            ++n;
        }
    }
}

