/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.color.swt;

import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDCSIndexed;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpaceFactory;
import de.intarsys.pdf.platform.cwt.color.swt.SwtCSSpecial;
import java.awt.color.ColorSpace;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class SwtCSIndexed
extends SwtCSSpecial {
    public SwtCSIndexed(PDColorSpace pDColorSpace) {
        super(pDColorSpace);
    }

    protected RGB[] extractRGBs() {
        if (this.myPDColorSpace().getBaseColorSpace() instanceof PDCSDeviceRGB) {
            return this.extractRGBsDirect();
        }
        return this.extractRGBsOther();
    }

    protected RGB[] extractRGBsDirect() {
        RGB[] rGBArray = new RGB[this.myPDColorSpace().getColorCount()];
        int n = 0;
        while (n < rGBArray.length) {
            rGBArray[n] = new RGB(this.myPDColorSpace().getColorBytes()[n * 3] & 0xFF, this.myPDColorSpace().getColorBytes()[n * 3 + 1] & 0xFF, this.myPDColorSpace().getColorBytes()[n * 3 + 2] & 0xFF);
            ++n;
        }
        return rGBArray;
    }

    protected RGB[] extractRGBsOther() {
        PDColorSpace pDColorSpace = this.myPDColorSpace().getBaseColorSpace();
        ColorSpace colorSpace = AwtColorSpaceFactory.get().createColorSpace(pDColorSpace).getColorSpace();
        int n = colorSpace.getNumComponents();
        RGB[] rGBArray = new RGB[this.myPDColorSpace().getColorCount()];
        int n2 = 0;
        while (n2 < rGBArray.length) {
            float[] fArray = new float[n];
            int n3 = 0;
            while (n3 < n) {
                fArray[n3] = (float)(0xFF & this.myPDColorSpace().getColorBytes()[n2 * n + n3]) / 255.0f;
                ++n3;
            }
            float[] fArray2 = colorSpace.toRGB(fArray);
            rGBArray[n2] = new RGB((int)(fArray2[0] * 255.0f), (int)(fArray2[1] * 255.0f), (int)(fArray2[2] * 255.0f));
            ++n2;
        }
        return rGBArray;
    }

    @Override
    public int getNumComponents() {
        return 1;
    }

    @Override
    public PaletteData getPalette(PDImage pDImage) {
        return new PaletteData(this.extractRGBs());
    }

    protected PDCSIndexed myPDColorSpace() {
        return (PDCSIndexed)this.getPDColorSpace();
    }
}

