/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.tag;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.tag.TaggedDocument;

public class TagState
implements Serializable {
    private static final long serialVersionUID = 1511020842437155686L;
    private List documents = new ArrayList(128);
    private transient HashMap origin2document = new HashMap(128);
    private transient TaggedDocument currentDocument = null;

    TagState() {
    }

    void setCurrentDocument(Document doc) {
        String origin = doc.getDocumentOrigin();
        TaggedDocument td = (TaggedDocument)this.origin2document.get(origin);
        if (td != null) {
            this.currentDocument = td;
        } else {
            this.currentDocument = new TaggedDocument(origin);
            this.documents.add(this.currentDocument);
        }
    }

    void setCurrentPageIndex(int currentPageIndex) {
        if (this.currentDocument != null) {
            this.currentDocument.setCurrentPageIndex(currentPageIndex);
        }
    }

    void beginImage(Reference ref, boolean inlineImage) {
        if (this.currentDocument != null) {
            this.currentDocument.beginImage(ref, inlineImage);
        }
    }

    void endImage(Reference ref) {
        if (this.currentDocument != null) {
            this.currentDocument.endImage(ref);
        }
    }

    void tagImage(String tag) {
        if (this.currentDocument != null) {
            this.currentDocument.tagImage(tag);
        }
    }

    String describe() {
        StringBuilder sb = new StringBuilder(4096);
        for (TaggedDocument td : this.documents) {
            sb.append(td.describe());
            sb.append("=================================\n");
        }
        return sb.toString();
    }

    public List getDocuments() {
        return this.documents;
    }
}

