/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jcmdline.FileParam;
import jcmdline.Parameter;
import jcmdline.PdfFileParam;
import jcmdline.StringParam;
import org.pdfsam.console.business.parser.handlers.interfaces.AbstractCmdHandler;

public class PageLabelsCmdHandler
extends AbstractCmdHandler {
    private static final String COMMAND_DESCRIPTION = "Set page labels for a pdf document.";
    private final List pageLabelsOptions = new ArrayList<Parameter>(Arrays.asList(new FileParam("o", "pdf output file: if it doesn't exist it's created, if it exists it must be writeable", 65535, false, false), new PdfFileParam("f", "pdf files to set page labels", 65519, false, false), new StringParam("l", "labels. You can set page labels. Accepted string is \"pageindex:style:logicalnumber\" where pageindex is the index of the starting page within the document, style is the label style and logicalnumber (optional) is the first logical page number ", 7, -1, false, true), new StringParam("lp", "label prefix. You can set page a label prefix. Accepted string is \"pageindex:prefix\" where pageindex is a page index that match a page index set with the l parameter and prefix is the prefix for this numbering ", 1, -1, true, true)));
    private final List pageLabelsArguments = new ArrayList<Parameter>(Arrays.asList(new StringParam("command", "command to execute {[pagelabels]}", new String[]{"pagelabels"}, false)));
    private static final String PAGE_LABELS_HELP_TEXT = "Set page labels for a pdf file. \nYou must specify '-f /home/user/infile.pdf' option to set the input file you want to set page labels (use filename:password if the file is password protected).\nYou must specify '-o /home/user/out.pdf' to set the output file.\nYou must specify '-l 1:arabic' to set pages labels. (EX. -l 1:arabic -l 5:uroman:1  will number the document pages starting from the first page with arabic numbers and starting from the fifth page (first logical page) with upper case roman numbers\nPossible style values { arabic, empty, lletter, lroman, uletter, uroman} \n'-p prefix_' to specify a prefix for output names of files. If it contains \"[TIMESTAMP]\" it performs variable substitution. (Ex. [BASENAME]_prefix_[TIMESTAMP] generates FileName_prefix_20070517_113423471.pdf)\n'-lp 1:AP' to specify a prefix for the labal numbering that starts at page 1. This parameter is ignored if there is no -l option that starts at page 1\n(EX. -lp 1:AP -lp 5:X will set prefix \"AP\" for the numbering starting at page 1 and the prefix \"X\" for the one starting at page 5)";
    private static final String PAGE_LABELS_EXAMPLE = "Example: java -jar pdfsam-console-2.4.3e.jar -f /tmp/1.pdf -o /tmp -r odd:180 -overwrite rotate\n";

    public Collection getArguments() {
        return this.pageLabelsArguments;
    }

    public String getCommandDescription() {
        return COMMAND_DESCRIPTION;
    }

    public String getHelpExamples() {
        return PAGE_LABELS_EXAMPLE;
    }

    public Collection getOptions() {
        return this.pageLabelsOptions;
    }

    public String getHelpMessage() {
        return PAGE_LABELS_HELP_TEXT;
    }
}

