/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.ContainerResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MessageBundleMessageResolver;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.MessageBundle;
import de.intarsys.tools.message.MessageBundleTools;
import java.util.HashMap;
import java.util.Map;

public class NLSMessageResolver
extends ContainerResolver {
    private final ClassLoader classLoader;
    private Map<String, IStringEvaluator> resolvers = new HashMap<String, IStringEvaluator>();

    public NLSMessageResolver() {
        this(NLSMessageResolver.class.getClassLoader());
    }

    public NLSMessageResolver(ClassLoader classLoader) {
        super('#');
        this.classLoader = classLoader;
    }

    @Override
    protected Object basicEvaluate(String string, IArgs iArgs) throws EvaluationException {
        IStringEvaluator iStringEvaluator = this.resolvers.get(string);
        if (iStringEvaluator == null) {
            MessageBundle messageBundle = MessageBundleTools.getMessageBundle(string, this.getClassLoader());
            iStringEvaluator = new MessageBundleMessageResolver(messageBundle);
            this.resolvers.put(string, iStringEvaluator);
        }
        return iStringEvaluator;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

