/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.system.SystemTools;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class SystemResolver
implements IStringEvaluator {
    private static int COUNTER = 0;
    private static long UNIQUETIME = 0L;
    private static final Map<String, Integer> counters = new HashMap<String, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(String string, IArgs iArgs) throws EvaluationException {
        if (string != null) {
            String[] stringArray;
            if ("millis".equals(string)) {
                return System.currentTimeMillis();
            }
            if ("time".equals(string)) {
                return System.currentTimeMillis();
            }
            if ("uniquetime".equals(string)) {
                Class<SystemResolver> clazz = SystemResolver.class;
                synchronized (SystemResolver.class) {
                    long l = System.currentTimeMillis();
                    if (l <= UNIQUETIME) {
                        l = UNIQUETIME + 1L;
                    }
                    UNIQUETIME = l;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return l;
                }
            }
            if ("uuid".equals(string)) {
                return UUID.randomUUID().toString();
            }
            if ("counter".equals(string)) {
                Class<SystemResolver> clazz = SystemResolver.class;
                synchronized (SystemResolver.class) {
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    return COUNTER++;
                }
            }
            if (string.startsWith("counters.") && (stringArray = string.split("\\.", 2)).length == 2) {
                Class<SystemResolver> clazz = SystemResolver.class;
                synchronized (SystemResolver.class) {
                    Integer n = counters.get(stringArray[1]);
                    if (n == null) {
                        n = 0;
                    }
                    counters.put(stringArray[1], n + 1);
                    // ** MonitorExit[var4_7] (shouldn't be in output)
                    return n;
                }
            }
            if (string.startsWith("getenv.") && (stringArray = string.split("\\.", 2)).length == 2) {
                return System.getenv(stringArray[1]);
            }
            if (string.startsWith("properties.") && (stringArray = string.split("\\.", 2)).length == 2) {
                return System.getProperty(stringArray[1]);
            }
            if ("architecture".equals(string)) {
                return this.getArchitecture();
            }
        }
        throw new EvaluationException("can't evaluate '" + string + "'");
    }

    protected String getArchitecture() {
        String string = SystemTools.getOSArch();
        if (string != null && string.indexOf("64") > -1) {
            return "64-bit";
        }
        return "32-bit";
    }
}

