/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.charset.ICharsetAccess;
import de.intarsys.tools.charset.ICharsetSupport;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.digest.DigestEnvironment;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.locator.RenamedLocator;
import de.intarsys.tools.locator.StringLocator;
import de.intarsys.tools.reader.ReaderTools;
import de.intarsys.tools.reader.TaggedReader;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class LocatorTools {
    public static final String PATH_SEPARATOR = ";";

    public static void checkHash(ILocator iLocator, Object object) throws IOException {
        IDigest iDigest = DigestTools.createDigest(object);
        if (iDigest == null) {
            return;
        }
        IDigest iDigest2 = LocatorTools.digest(iLocator, iDigest.getAlgorithmName());
        if (!iDigest2.equals(iDigest)) {
            throw new IOException("document digest validation failed (" + iLocator.getFullName() + ")");
        }
    }

    @Deprecated
    public static void checkHash(ILocator iLocator, String string, Object object) throws IOException {
        LocatorTools.checkHash(iLocator, object);
    }

    public static void copy(ILocator iLocator, ILocator iLocator2) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = iLocator.getInputStream();
            outputStream = iLocator2.getOutputStream();
            StreamTools.copyStream(inputStream, false, outputStream, false);
        }
        finally {
            StreamTools.close(inputStream);
            StreamTools.close(outputStream);
        }
    }

    public static ILocator createLocator(Object object, ILocatorFactory iLocatorFactory, ILocator iLocator) {
        if (object == null) {
            return iLocator;
        }
        if (object instanceof ILocator) {
            return (ILocator)object;
        }
        if (object instanceof ILocatorSupport) {
            return ((ILocatorSupport)object).getLocator();
        }
        if (object instanceof IArgs) {
            Object object2;
            ILocator iLocator2 = null;
            IArgs iArgs = (IArgs)object;
            String string = ArgTools.getString(iArgs, "charset", null);
            Object object3 = iArgs.get("locator");
            if (object3 == null) {
                object3 = iArgs.get("path");
            }
            if (object3 != null && (iLocator2 = LocatorTools.createLocator(object3, iLocatorFactory, null)) instanceof ICharsetAccess && string != null) {
                ((ICharsetAccess)((Object)iLocator2)).setCharset(string);
            }
            if (iLocator2 == null) {
                object2 = ArgTools.getString(iArgs, "name", "locator.bytes");
                object2 = FileTools.getFileName((String)object2);
                Object object4 = iArgs.get("content");
                if (object4 instanceof ILocator) {
                    iLocator2 = (ILocator)object4;
                } else if (object4 instanceof byte[]) {
                    iLocator2 = new ByteArrayLocator((byte[])object4, (String)object2);
                } else if (object4 instanceof String) {
                    byte[] byArray = Base64.decode((String)object4);
                    iLocator2 = new ByteArrayLocator(byArray, (String)object2);
                } else {
                    try {
                        byte[] byArray = ConverterRegistry.get().convert(object4, byte[].class);
                        iLocator2 = new ByteArrayLocator(byArray, (String)object2);
                    }
                    catch (ConversionException conversionException) {
                        try {
                            String string2 = ConverterRegistry.get().convert(object4, String.class);
                            byte[] byArray = Base64.decode(string2);
                            iLocator2 = new ByteArrayLocator(byArray, (String)object2);
                        }
                        catch (ConversionException conversionException2) {
                            // empty catch block
                        }
                    }
                    if (iLocator2 == null) {
                        iLocator2 = new ByteArrayLocator(null, (String)object2);
                    }
                }
                if (iLocator2 instanceof ICharsetAccess && string != null) {
                    ((ICharsetAccess)((Object)iLocator2)).setCharset(string);
                }
            }
            try {
                object2 = ArgTools.getDigest(iArgs, "hash");
                LocatorTools.checkHash(iLocator2, object2);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("hash", iOException);
            }
            return iLocator2;
        }
        if (iLocatorFactory == null) {
            iLocatorFactory = LocatorFactory.get();
        }
        if (object instanceof File) {
            try {
                return iLocatorFactory.createLocator(((File)object).getAbsolutePath());
            }
            catch (IOException iOException) {
                return iLocator;
            }
        }
        if (object instanceof String) {
            if (StringTools.isEmpty((String)object)) {
                return iLocator;
            }
            try {
                return iLocatorFactory.createLocator((String)object);
            }
            catch (IOException iOException) {
                return iLocator;
            }
        }
        try {
            return ConverterRegistry.get().convert(object, ILocator.class);
        }
        catch (ConversionException conversionException) {
            return iLocator;
        }
    }

    public static ILocator[] createLocators(String string, ILocatorFactory iLocatorFactory) throws IOException {
        if (iLocatorFactory == null) {
            iLocatorFactory = LocatorFactory.get();
        }
        ArrayList<ILocator> arrayList = new ArrayList<ILocator>();
        ILocator[] iLocatorArray = new StringTokenizer(string, PATH_SEPARATOR);
        while (iLocatorArray.hasMoreTokens()) {
            String string2 = iLocatorArray.nextToken();
            arrayList.add(iLocatorFactory.createLocator(string2));
        }
        iLocatorArray = new ILocator[arrayList.size()];
        return arrayList.toArray(iLocatorArray);
    }

    public static File createTempFile(ILocator iLocator) throws IOException {
        File file = FileTools.createTempFile(iLocator.getTypedName());
        LocatorTools.save(iLocator, file);
        return file;
    }

    public static ILocator createTempLocator(ILocator iLocator) throws IOException {
        return LocatorTools.createTempLocator(iLocator, false);
    }

    public static ILocator createTempLocator(ILocator iLocator, boolean bl) throws IOException {
        if (iLocator.getLength() != -1L && iLocator.getLength() < 5000L) {
            byte[] byArray = LocatorTools.getBytes(iLocator);
            return new ByteArrayLocator(byArray, iLocator.getTypedName());
        }
        File file = FileTools.createTempFile(iLocator.getTypedName());
        LocatorTools.save(iLocator, file);
        if (bl) {
            return new RenamedLocator(new FileLocator(file), iLocator.getFullName());
        }
        return new FileLocator(file);
    }

    public static IDigest digest(ILocator iLocator, String string) throws IOException {
        InputStream inputStream = iLocator.getInputStream();
        try {
            IDigester iDigester = DigestEnvironment.get().createDigester(string);
            int n = DigestTools.suggestBufferSize(iLocator.getLength());
            IDigest iDigest = DigestTools.digest(iDigester, inputStream, n);
            return iDigest;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw ExceptionTools.createIOException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        finally {
            StreamTools.close(inputStream);
        }
    }

    public static byte[] getBytes(ILocator iLocator) throws IOException {
        if (iLocator == null) {
            return null;
        }
        if (iLocator instanceof ByteArrayLocator) {
            return ((ByteArrayLocator)iLocator).getBytes();
        }
        InputStream inputStream = null;
        try {
            inputStream = iLocator.getInputStream();
            byte[] byArray = StreamTools.toByteArray(inputStream);
            return byArray;
        }
        finally {
            StreamTools.close(inputStream);
        }
    }

    public static File getFile(ILocator iLocator) throws IOException {
        if (iLocator instanceof FileLocator) {
            return ((FileLocator)iLocator).getFile();
        }
        throw new IOException("can't create file for '" + iLocator.getFullName() + "'");
    }

    public static String getString(ILocator iLocator) throws IOException {
        if (iLocator instanceof StringLocator) {
            return ((StringLocator)iLocator).getContent();
        }
        Reader reader = null;
        try {
            reader = iLocator.getReader();
            String string = StreamTools.toString(reader);
            return string;
        }
        finally {
            StreamTools.close(reader);
        }
    }

    public static String getString(ILocator iLocator, String string, int n) throws IOException {
        String string2;
        if (iLocator instanceof StringLocator) {
            return ((StringLocator)iLocator).getContent();
        }
        BufferedInputStream bufferedInputStream = null;
        TaggedReader taggedReader = null;
        try {
            bufferedInputStream = new BufferedInputStream(iLocator.getInputStream(), n);
            if (string == null && iLocator instanceof ICharsetSupport) {
                string = ((ICharsetSupport)((Object)iLocator)).getCharset();
            }
            taggedReader = ReaderTools.createTaggedReader(bufferedInputStream, string, n);
            string2 = StreamTools.toString(taggedReader);
        }
        catch (Throwable throwable) {
            StreamTools.close(taggedReader);
            StreamTools.close(bufferedInputStream);
            throw throwable;
        }
        StreamTools.close(taggedReader);
        StreamTools.close(bufferedInputStream);
        return string2;
    }

    public static void putBytes(ILocator iLocator, byte[] byArray) throws IOException {
        if (iLocator == null) {
            return;
        }
        OutputStream outputStream = null;
        try {
            outputStream = iLocator.getOutputStream();
            StreamTools.putBytes(outputStream, byArray);
        }
        finally {
            StreamTools.close(outputStream);
        }
    }

    public static void save(ILocator iLocator, File file) throws IOException {
        if (file.isDirectory()) {
            file = new File(file, iLocator.getTypedName());
        }
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = iLocator.getInputStream();
            fileOutputStream = new FileOutputStream(file);
            StreamTools.copyStream(inputStream, false, fileOutputStream, false);
        }
        catch (Throwable throwable) {
            StreamTools.close(inputStream);
            StreamTools.close(fileOutputStream);
            throw throwable;
        }
        StreamTools.close(inputStream);
        StreamTools.close(fileOutputStream);
    }

    private LocatorTools() {
    }
}

