/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.randomaccess;

import de.intarsys.tools.randomaccess.AbstractRandomAccess;
import de.intarsys.tools.randomaccess.PACKAGE;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;

public class RandomAccessFile
extends AbstractRandomAccess {
    private static Logger Log = PACKAGE.Log;
    private java.io.RandomAccessFile fileAccess;
    private boolean readOnly = false;
    private File file;

    public RandomAccessFile(File file) throws IOException {
        this(file, true);
    }

    public RandomAccessFile(File file, boolean bl) throws IOException {
        this.file = file;
        if (bl && !file.exists()) {
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists()) {
                file2.mkdirs();
            }
            file.createNewFile();
        }
        if (!file.exists()) {
            throw new FileNotFoundException("file does not exist or can't be created");
        }
        if (file.canWrite()) {
            try {
                this.fileAccess = new java.io.RandomAccessFile(file, "rw");
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fileAccess = new java.io.RandomAccessFile(file, "r");
        this.readOnly = true;
    }

    @Override
    public void close() throws IOException {
        if (this.fileAccess != null) {
            this.fileAccess.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.fileAccess.getChannel().force(true);
    }

    @Override
    public long getLength() throws IOException {
        return this.fileAccess.length();
    }

    @Override
    public long getOffset() throws IOException {
        return this.fileAccess.getFilePointer();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public int read() throws IOException {
        return this.fileAccess.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.fileAccess.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.fileAccess.read(byArray, n, n2);
    }

    @Override
    public void seek(long l) throws IOException {
        this.fileAccess.seek(l);
    }

    @Override
    public void seekBy(long l) throws IOException {
        this.seek(this.fileAccess.getFilePointer() + l);
    }

    @Override
    public void setLength(long l) throws IOException {
        this.fileAccess.setLength(l);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.fileAccess.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.fileAccess.write(byArray, n, n2);
    }

    @Override
    public void write(int n) throws IOException {
        this.fileAccess.write(n);
    }
}

