/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.randomaccess;

import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessFilter;
import java.io.IOException;

public class RandomAccessViewport
extends RandomAccessFilter {
    private final long viewOffset;
    private long viewLength;
    private long viewEnd;

    public RandomAccessViewport(IRandomAccess iRandomAccess, long l, long l2) throws IOException {
        super(iRandomAccess);
        this.viewLength = l2;
        this.viewOffset = l;
        this.viewEnd = this.viewOffset + this.viewLength;
    }

    @Override
    public long getLength() throws IOException {
        long l = this.getRandom().getLength();
        if (this.getViewLength() == -1L) {
            return l - this.getViewOffset();
        }
        return Math.min(this.getViewLength(), l - this.getViewOffset());
    }

    @Override
    public long getOffset() throws IOException {
        return this.getRandom().getOffset() - this.getViewOffset();
    }

    protected long getViewEnd() {
        return this.viewEnd;
    }

    protected long getViewLength() {
        return this.viewLength;
    }

    protected long getViewOffset() {
        return this.viewOffset;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.getViewLength() != -1L && this.getOffset() >= this.getViewEnd()) {
            return -1;
        }
        return super.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.getViewLength() != -1L && this.getOffset() >= this.getViewEnd()) {
            return -1;
        }
        if (this.getViewLength() != -1L) {
            n2 = Math.min(n2, (int)(this.getViewEnd() - this.getOffset()));
        }
        return super.read(byArray, n, n2);
    }

    @Override
    public void seek(long l) throws IOException {
        super.seek(this.getViewOffset() + l);
    }

    @Override
    public void seekBy(long l) throws IOException {
        super.seekBy(l);
    }

    @Override
    public void setLength(long l) throws IOException {
        throw new IOException("not yet supported");
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        super.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
    }
}

