/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reader;

import de.intarsys.tools.reader.ILocationProvider;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class LocationAwareReader
extends FilterReader
implements ILocationProvider {
    private boolean open = true;
    private int line = 1;
    private int column = 1;
    private int position = 0;

    public LocationAwareReader(Reader reader) {
        super(reader);
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        this.in.close();
    }

    public void ensureOpen() throws IOException {
        if (!this.open) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            int n = this.in.read();
            if (n != -1) {
                ++this.position;
                if (n == 10) {
                    ++this.line;
                    this.column = 1;
                } else {
                    ++this.column;
                }
            }
            return n;
        }
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = n;
        int n4 = this.read();
        while (n3 < n + n2 && n4 != -1) {
            cArray[n3] = (char)n4;
            ++n3;
            n4 = this.read();
        }
        if (n4 == -1 && n3 == n) {
            return -1;
        }
        return n3 - n;
    }

    public void setColumn(int n) {
        this.column = n;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public void setLocation(int n, int n2) {
        this.line = n;
        this.column = n2;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    @Override
    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IOException("parameter is negative");
        }
        long l2 = 0L;
        int n = 0;
        while (l2 < l && n != -1) {
            n = this.read();
            ++l2;
        }
        return l2;
    }
}

