/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reflect;

import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.IMethodHandler;
import de.intarsys.tools.reflect.MethodInvocationException;

public class Predicates {
    public static final IMethodHandler FALSE = new IMethodHandler(){

        @Override
        public Object invoke(Object object, IArgs iArgs) throws MethodInvocationException {
            return false;
        }
    };
    public static final IMethodHandler TRUE = new IMethodHandler(){

        @Override
        public Object invoke(Object object, IArgs iArgs) throws MethodInvocationException {
            return true;
        }
    };

    public static IMethodHandler and(IMethodHandler ... iMethodHandlerArray) {
        if (iMethodHandlerArray == null || iMethodHandlerArray.length == 0) {
            return FALSE;
        }
        if (iMethodHandlerArray.length == 1) {
            return iMethodHandlerArray[0];
        }
        return new And(iMethodHandlerArray);
    }

    public static IMethodHandler or(IMethodHandler ... iMethodHandlerArray) {
        if (iMethodHandlerArray == null || iMethodHandlerArray.length == 0) {
            return TRUE;
        }
        if (iMethodHandlerArray.length == 1) {
            return iMethodHandlerArray[0];
        }
        return new Or(iMethodHandlerArray);
    }

    public static IMethodHandler not(IMethodHandler iMethodHandler) {
        return new Not(iMethodHandler);
    }

    public static class And
    implements IMethodHandler {
        private final IMethodHandler[] operators;

        public And(IMethodHandler[] iMethodHandlerArray) {
            this.operators = iMethodHandlerArray;
        }

        @Override
        public Object invoke(Object object, IArgs iArgs) throws MethodInvocationException {
            IMethodHandler[] iMethodHandlerArray = this.operators;
            int n = this.operators.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodHandler iMethodHandler = iMethodHandlerArray[n2];
                if (iMethodHandler.invoke(object, iArgs) != Boolean.TRUE) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    public static class Not
    implements IMethodHandler {
        private final IMethodHandler operator;

        public Not(IMethodHandler iMethodHandler) {
            this.operator = iMethodHandler;
        }

        @Override
        public Object invoke(Object object, IArgs iArgs) throws MethodInvocationException {
            if (this.operator.invoke(object, iArgs) == Boolean.FALSE) {
                return true;
            }
            return false;
        }
    }

    public static class Or
    implements IMethodHandler {
        private final IMethodHandler[] operators;

        public Or(IMethodHandler[] iMethodHandlerArray) {
            this.operators = iMethodHandlerArray;
        }

        @Override
        public Object invoke(Object object, IArgs iArgs) throws MethodInvocationException {
            IMethodHandler[] iMethodHandlerArray = this.operators;
            int n = this.operators.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodHandler iMethodHandler = iMethodHandlerArray[n2];
                if (iMethodHandler.invoke(object, iArgs) == Boolean.TRUE) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

